/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.vagrant;

import com.intellij.openapi.project.Project;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.VagrantBasedCredentialsHolder;
import com.intellij.remote.ext.CredentialsCase;
import com.intellij.remote.ext.PathMappingProviderEx;
import com.intellij.remote.ext.PathMappingType;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.plugins.vagrant.VagrantInstance;
import com.jetbrains.plugins.vagrant.VagrantService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VagrantMappingProvider
extends PathMappingProviderEx {
    @NotNull
    public PathMappingType getMappingType() {
        PathMappingType pathMappingType = PathMappingType.REPLICATED_FOLDER;
        if (pathMappingType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/vagrant/VagrantMappingProvider", "getMappingType"));
        }
        return pathMappingType;
    }

    @NotNull
    public String getProviderPresentableName(@NotNull RemoteSdkAdditionalData data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/plugins/vagrant/VagrantMappingProvider", "getProviderPresentableName"));
        }
        if ("VagrantFile" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/vagrant/VagrantMappingProvider", "getProviderPresentableName"));
        }
        return "VagrantFile";
    }

    public boolean accepts(@Nullable RemoteSdkAdditionalData data) {
        return data != null && data.connectionCredentials().getRemoteConnectionType() == CredentialsType.VAGRANT;
    }

    @NotNull
    public PathMappingSettings getPathMappingSettings(@NotNull Project project, @NotNull RemoteSdkAdditionalData data) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/vagrant/VagrantMappingProvider", "getPathMappingSettings"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/plugins/vagrant/VagrantMappingProvider", "getPathMappingSettings"));
        }
        final PathMappingSettings mappingSettings = new PathMappingSettings();
        data.switchOnConnectionType(new CredentialsCase[]{new CredentialsCase.Vagrant(){

            public void process(VagrantBasedCredentialsHolder cred) {
                VagrantInstance instance = VagrantService.getInstance().getVagrantInstance(cred.getVagrantFolder());
                mappingSettings.addAll(instance.getPathMapping(cred.getMachineName()));
            }
        }});
        PathMappingSettings pathMappingSettings = mappingSettings;
        if (pathMappingSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/vagrant/VagrantMappingProvider", "getPathMappingSettings"));
        }
        return pathMappingSettings;
    }
}

