/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.vagrant;

import com.intellij.execution.process.CapturingAnsiEscapesAwareProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.concurrency.FutureResult;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.vagrant.AbstractVagrantItemManager;
import com.jetbrains.plugins.vagrant.VagrantItem;
import com.jetbrains.plugins.vagrant.VagrantPlugin;
import com.jetbrains.plugins.vagrant.actions.VagrantTask;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VagrantPluginManager
extends AbstractVagrantItemManager<VagrantPlugin> {
    private static final Logger LOG = Logger.getInstance(VagrantPluginManager.class);

    public VagrantPluginManager(Project project) {
        super(project);
    }

    @Override
    protected VagrantPlugin createItem(String line) {
        return new VagrantPlugin(line);
    }

    @Override
    protected String emptyListText() {
        return "No plugins installed.";
    }

    @Override
    protected String[] listItemsArguments() {
        return new String[]{"plugin", "list"};
    }

    @Override
    protected String getItemName() {
        return "Plugin";
    }

    @Override
    protected String[] removeItemArguments(VagrantItem plugin) {
        return new String[]{"plugin", "uninstall", plugin.getName()};
    }

    @NotNull
    public FutureResult<VagrantPlugin> add(final String ... args) {
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/jetbrains/plugins/vagrant/VagrantPluginManager", "add"));
        }
        final FutureResult futurePlugin = new FutureResult();
        final VagrantTask task = this.createTask(ArrayUtil.mergeArrays((String[])new String[]{"plugin", "install"}, (String[])args));
        if (task != null) {
            Task.Backgroundable backgroundableTask = new Task.Backgroundable(this.myProject, "Installing '" + StringUtil.join((String[])args) + "' plugin. This can take a few minutes...", true, new PerformInBackgroundOption(){

                public void processSentToBackground() {
                }

                public boolean shouldStartInBackground() {
                    return false;
                }
            }){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/plugins/vagrant/VagrantPluginManager$2", "run"));
                    }
                    indicator.setFraction(0.0);
                    indicator.isIndeterminate();
                    try {
                        CapturingAnsiEscapesAwareProcessHandler handler = new CapturingAnsiEscapesAwareProcessHandler(task.createCommandLine());
                        ProcessOutput output = handler.runProcess();
                        if (output.getExitCode() != 0) {
                            UIUtil.invokeLaterIfNeeded(() -> {
                                Messages.showErrorDialog((Project)this.myProject, (String)output.getStderr(), (String)"Error Installing Plugin");
                                futurePlugin.set(null);
                            });
                        } else {
                            VagrantPluginManager.this.dropCache();
                            futurePlugin.set((Object)new VagrantPlugin(args[0]));
                            VagrantPluginManager.this.fireEvent();
                        }
                    }
                    catch (Exception e) {
                        String message = e.getMessage();
                        UIUtil.invokeLaterIfNeeded(() -> {
                            if (args == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/jetbrains/plugins/vagrant/VagrantPluginManager$2", "lambda$run$1"));
                            }
                            Messages.showErrorDialog((Project)this.myProject, (String)("Can't install plugin '" + StringUtil.join((String[])args) + "':" + message), (String)"Error Installing Plugin");
                        });
                        futurePlugin.set(null);
                    }
                }
            };
            ProgressManager.getInstance().run((Task)backgroundableTask);
        } else {
            futurePlugin.set(null);
        }
        FutureResult futureResult = futurePlugin;
        if (futureResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/vagrant/VagrantPluginManager", "add"));
        }
        return futureResult;
    }

    @Override
    @Nullable
    public FutureResult<VagrantPlugin> add() {
        String pluginName = Messages.showInputDialog((Project)this.myProject, (String)"Enter plugin name:", (String)"Install Vagrant Plugin", (Icon)Messages.getQuestionIcon());
        if (!StringUtil.isEmpty((String)pluginName)) {
            String[] args = pluginName.split("\\s+");
            return this.add(args);
        }
        return null;
    }

    public void update(@NotNull VagrantPlugin plugin) {
        if (plugin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "plugin", "com/jetbrains/plugins/vagrant/VagrantPluginManager", "update"));
        }
        VagrantTask task = this.createTask("plugin", "update", plugin.getName());
        if (task != null) {
            this.runTask(task, "Upgrading plugin " + plugin.getName(), true);
        }
    }

    public void attachLicense(@NotNull VagrantPlugin plugin) {
        if (plugin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "plugin", "com/jetbrains/plugins/vagrant/VagrantPluginManager", "attachLicense"));
        }
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor().withTitle("Choose License File");
        FileChooserDialog fc = FileChooserFactory.getInstance().createFileChooser(descriptor, this.myProject, null);
        VirtualFile[] files = fc.choose(this.myProject, new VirtualFile[0]);
        if (files.length == 1) {
            String licensePath = files[0].getPath();
            VagrantTask task = this.createTask("plugin", "license", plugin.getName(), licensePath);
            if (task != null) {
                this.runTask(task, "Attaching License To Plugin", true);
            }
        }
    }
}

