/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.vagrant;

import com.google.common.collect.Maps;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="VagrantProjectSettings", storages={@Storage(value="vagrant.xml")})
public class VagrantProjectSettings
implements PersistentStateComponent<VagrantProjectSettings> {
    private String myInstanceFolder;
    private String myProvider;
    private Map<String, String> myEnvs;
    private String myVagrantPath;

    @Nullable
    public static String getVagrantExecutableFallback() {
        for (Project p : ProjectManager.getInstance().getOpenProjects()) {
            String path = VagrantProjectSettings.getInstance(p).getVagrantExecutable();
            if (StringUtil.isEmpty((String)path)) continue;
            return path;
        }
        return null;
    }

    public VagrantProjectSettings getState() {
        return this;
    }

    public void loadState(VagrantProjectSettings state) {
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
    }

    @NotNull
    public static VagrantProjectSettings getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/vagrant/VagrantProjectSettings", "getInstance"));
        }
        VagrantProjectSettings vagrantProjectSettings = (VagrantProjectSettings)ServiceManager.getService((Project)project, VagrantProjectSettings.class);
        if (vagrantProjectSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/vagrant/VagrantProjectSettings", "getInstance"));
        }
        return vagrantProjectSettings;
    }

    public String getInstanceFolder() {
        return this.myInstanceFolder;
    }

    public void setInstanceFolder(@Nullable String instanceFolder) {
        this.myInstanceFolder = instanceFolder;
    }

    @Nullable
    public String getProvider() {
        return this.myProvider;
    }

    public void setProvider(@Nullable String provider) {
        this.myProvider = provider;
    }

    public String toString() {
        return "vagrant folder: " + this.myInstanceFolder;
    }

    public void setEnvs(Map<String, String> envs) {
        this.myEnvs = envs;
    }

    @NotNull
    public Map<String, String> getEnvs() {
        Map<Object, Object> map = this.myEnvs != null ? this.myEnvs : Maps.newHashMap();
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/vagrant/VagrantProjectSettings", "getEnvs"));
        }
        return map;
    }

    @Deprecated
    @Nullable
    public String getVagrantExecutable() {
        return this.myVagrantPath;
    }

    @Deprecated
    public void setVagrantExecutable(@Nullable String vagrantPath) {
        this.myVagrantPath = vagrantPath;
    }
}

