/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.vagrant;

import com.google.common.collect.Lists;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.plugins.vagrant.VagrantInstance;
import com.jetbrains.plugins.vagrant.VagrantSettings;
import com.jetbrains.plugins.vagrant.VagrantUtil;
import com.jetbrains.plugins.vagrant.cli.VagrantCli;
import com.jetbrains.plugins.vagrant.state.global.GlobalStatus;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VagrantService {
    private static final Logger LOG = Logger.getInstance(VagrantService.class);
    private final GlobalStatus myGlobalStatus = new GlobalStatus();
    private final Map<String, VagrantInstance> myVagrantInstances = new ConcurrentHashMap<String, VagrantInstance>();
    private String myCheckedVagrantExecutable = null;
    private final Object myLock = new Object();

    @NotNull
    public String getVagrantExecutable() {
        VagrantSettings settings = VagrantSettings.getInstance();
        String vagrantPath = settings.getVagrantExecutable();
        if (StringUtil.isEmpty((String)vagrantPath)) {
            vagrantPath = this.detectVagrantExecutable();
        }
        settings.setVagrantExecutable(vagrantPath);
        String string = vagrantPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/vagrant/VagrantService", "getVagrantExecutable"));
        }
        return string;
    }

    @Nullable
    public String getVagrantExecutable(@NotNull Project project, boolean askIfNotSet) {
        String askedVagrantPath;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/vagrant/VagrantService", "getVagrantExecutable"));
        }
        VagrantSettings settings = VagrantSettings.getInstance();
        String vagrantPath = settings.getVagrantExecutable();
        if (StringUtil.isEmpty((String)vagrantPath)) {
            vagrantPath = this.detectVagrantExecutable();
        }
        if (askIfNotSet && !this.checkVersion(vagrantPath) && (askedVagrantPath = VagrantUtil.askVagrantExecutablePath(project)) == null) {
            return null;
        }
        settings.setVagrantExecutable(vagrantPath);
        return vagrantPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkVersion(@NotNull String vagrantPath) {
        if (vagrantPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vagrantPath", "com/jetbrains/plugins/vagrant/VagrantService", "checkVersion"));
        }
        Object object = this.myLock;
        synchronized (object) {
            if (vagrantPath.equals(this.myCheckedVagrantExecutable)) {
                return true;
            }
            LOG.debug("Checking Vagrant executable: " + vagrantPath);
            String vagrantVersion = VagrantCli.execVagrantVersion(vagrantPath);
            boolean success = StringUtil.isNotEmpty((String)vagrantVersion);
            this.myCheckedVagrantExecutable = success ? vagrantPath : null;
            return success;
        }
    }

    @NotNull
    public String detectVagrantExecutable() {
        for (String path : VagrantService.suggestPaths()) {
            File f = new File(path);
            if (!f.exists()) continue;
            String string = f.getPath();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/vagrant/VagrantService", "detectVagrantExecutable"));
            }
            return string;
        }
        if (SystemInfo.isWindows) {
            if ("vagrant.bat" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/vagrant/VagrantService", "detectVagrantExecutable"));
            }
            return "vagrant.bat";
        }
        if ("vagrant" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/vagrant/VagrantService", "detectVagrantExecutable"));
        }
        return "vagrant";
    }

    @NotNull
    public VagrantInstance getVagrantInstance(@NotNull String instanceFolder) {
        if (instanceFolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instanceFolder", "com/jetbrains/plugins/vagrant/VagrantService", "getVagrantInstance"));
        }
        VagrantInstance vagrantInstance = this.myVagrantInstances.computeIfAbsent(instanceFolder, folder -> new VagrantInstance((String)folder));
        if (vagrantInstance == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/vagrant/VagrantService", "getVagrantInstance"));
        }
        return vagrantInstance;
    }

    @NotNull
    private static List<String> suggestPaths() {
        ArrayList arrayList = Lists.newArrayList((Object[])new String[]{"/usr/bin/vagrant", "/usr/local/bin/vagrant"});
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/vagrant/VagrantService", "suggestPaths"));
        }
        return arrayList;
    }

    @NotNull
    public GlobalStatus getGlobalStatus() {
        GlobalStatus globalStatus = this.myGlobalStatus;
        if (globalStatus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/vagrant/VagrantService", "getGlobalStatus"));
        }
        return globalStatus;
    }

    @NotNull
    public static VagrantService getInstance() {
        VagrantService vagrantService = (VagrantService)ServiceManager.getService(VagrantService.class);
        if (vagrantService == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/vagrant/VagrantService", "getInstance"));
        }
        return vagrantService;
    }
}

