/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.vagrant;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.plugins.vagrant.VagrantProjectSettings;
import org.jetbrains.annotations.NotNull;

@State(name="VagrantSettings", storages={@Storage(value="vagrant.xml")})
public class VagrantSettings
implements PersistentStateComponent<VagrantSettings> {
    private String myVagrantPath = VagrantSettings.detectVagrantExecutable();
    private boolean myVagrantPathMigrated = false;

    private static String detectVagrantExecutable() {
        return "vagrant";
    }

    public VagrantSettings getState() {
        return this;
    }

    public void loadState(VagrantSettings state) {
        if (!StringUtil.isEmpty((String)state.getVagrantExecutable())) {
            this.setVagrantExecutable(state.getVagrantExecutable());
        }
    }

    @NotNull
    public static VagrantSettings getInstance() {
        VagrantSettings vagrantSettings = (VagrantSettings)ServiceManager.getService(VagrantSettings.class);
        if (vagrantSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/vagrant/VagrantSettings", "getInstance"));
        }
        return vagrantSettings;
    }

    @NotNull
    public String getVagrantExecutable() {
        String fallback;
        if (!this.myVagrantPathMigrated && !StringUtil.isEmpty((String)(fallback = VagrantProjectSettings.getVagrantExecutableFallback()))) {
            String string = fallback;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/vagrant/VagrantSettings", "getVagrantExecutable"));
            }
            return string;
        }
        String string = this.myVagrantPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/vagrant/VagrantSettings", "getVagrantExecutable"));
        }
        return string;
    }

    public void setVagrantExecutable(@NotNull String vagrantPath) {
        if (vagrantPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vagrantPath", "com/jetbrains/plugins/vagrant/VagrantSettings", "setVagrantExecutable"));
        }
        this.myVagrantPath = vagrantPath;
        this.myVagrantPathMigrated = true;
    }

    public String toString() {
        return "path: " + this.myVagrantPath;
    }
}

