/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.vagrant;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remote.RemoteConnector;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.VagrantSupport;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.plugins.vagrant.VagrantFileConfig;
import com.jetbrains.plugins.vagrant.VagrantInstance;
import com.jetbrains.plugins.vagrant.VagrantManager;
import com.jetbrains.plugins.vagrant.VagrantService;
import com.jetbrains.plugins.vagrant.VagrantSshConfig;
import com.jetbrains.plugins.vagrant.VagrantUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VagrantSupportImpl
extends VagrantSupport {
    public ListenableFuture<RemoteCredentials> computeVagrantSettings(@Nullable Project project, @NotNull String vagrantFolder, @Nullable String machineName) {
        if (vagrantFolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vagrantFolder", "com/jetbrains/plugins/vagrant/VagrantSupportImpl", "computeVagrantSettings"));
        }
        return VagrantSupportImpl.compute(() -> {
            if (vagrantFolder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vagrantFolder", "com/jetbrains/plugins/vagrant/VagrantSupportImpl", "lambda$computeVagrantSettings$0"));
            }
            VagrantInstance vagrantInstance = VagrantService.getInstance().getVagrantInstance(vagrantFolder);
            VagrantSshConfig config = vagrantInstance.getSshConfig(machineName);
            return VagrantSshConfig.createRemoteCredentials(config);
        });
    }

    @NotNull
    public RemoteCredentials getCredentials(@NotNull String vagrantFolder, @Nullable String machineName) throws IOException {
        if (vagrantFolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vagrantFolder", "com/jetbrains/plugins/vagrant/VagrantSupportImpl", "getCredentials"));
        }
        RemoteCredentials remoteCredentials = VagrantUtil.getVagrantCredentials(vagrantFolder, machineName);
        if (remoteCredentials == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/vagrant/VagrantSupportImpl", "getCredentials"));
        }
        return remoteCredentials;
    }

    public boolean checkVagrantRunning(@NotNull String vagrantFolder, @Nullable String machineName, boolean askToRunIfDown) {
        if (vagrantFolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vagrantFolder", "com/jetbrains/plugins/vagrant/VagrantSupportImpl", "checkVagrantRunning"));
        }
        return VagrantUtil.checkVagrantRunning(vagrantFolder, machineName, askToRunIfDown);
    }

    public void runVagrant(@NotNull String vagrantFolder, @Nullable String machineName) throws ExecutionException {
        if (vagrantFolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vagrantFolder", "com/jetbrains/plugins/vagrant/VagrantSupportImpl", "runVagrant"));
        }
        VagrantUtil.runVagrant(vagrantFolder, machineName);
    }

    @Nullable
    public final PathMappingSettings getMappedFolders(@NotNull String vagrantFolder) {
        if (vagrantFolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vagrantFolder", "com/jetbrains/plugins/vagrant/VagrantSupportImpl", "getMappedFolders"));
        }
        VagrantFileConfig config = VagrantFileConfig.findInFolder(vagrantFolder);
        if (config == null) {
            return null;
        }
        return config.getCustomMappings();
    }

    public Collection<? extends RemoteConnector> getVagrantInstancesConnectors(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/vagrant/VagrantSupportImpl", "getVagrantInstancesConnectors"));
        }
        ArrayList result = Lists.newArrayList();
        for (VagrantInstance vi : VagrantManager.getInstance(project).listInstances()) {
            result.add(vi.toRemoteConnector(project));
        }
        return result;
    }

    public boolean isVagrantInstance(@Nullable VirtualFile dir) {
        return dir != null && dir.findChild("Vagrantfile") != null;
    }

    public List<String> getMachineNames(@NotNull String instanceFolder) {
        if (instanceFolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instanceFolder", "com/jetbrains/plugins/vagrant/VagrantSupportImpl", "getMachineNames"));
        }
        return VagrantService.getInstance().getVagrantInstance(instanceFolder).getVagrantMachines();
    }

    @Nullable
    public String findVagrantFolder(@NotNull Project project) {
        VagrantFileConfig config;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/vagrant/VagrantSupportImpl", "findVagrantFolder"));
        }
        VagrantInstance instance = VagrantManager.getInstance(project).currentInstance();
        if (instance != null && (config = instance.getVagrantFile()) != null) {
            return instance.getFolder();
        }
        for (VirtualFile file : ProjectRootManager.getInstance((Project)project).getContentRoots()) {
            if (!this.isVagrantInstance(file)) continue;
            return file.getPath();
        }
        return null;
    }

    private static <T> ListenableFuture<T> compute(Callable<T> callable) {
        return ExecutorServiceHolder.ourThreadExecutorsService.submit(callable);
    }

    private static class ExecutorServiceHolder {
        private static final ListeningExecutorService ourThreadExecutorsService = MoreExecutors.listeningDecorator((ExecutorService)ConcurrencyUtil.newSingleThreadExecutor((String)"Vagrant support"));

        private ExecutorServiceHolder() {
        }
    }
}

