/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.vagrant;

import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingAnsiEscapesAwareProcessHandler;
import com.intellij.execution.process.CapturingProcessAdapter;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.VagrantSupport;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.vagrant.VagrantFileConfig;
import com.jetbrains.plugins.vagrant.VagrantInstance;
import com.jetbrains.plugins.vagrant.VagrantManager;
import com.jetbrains.plugins.vagrant.VagrantService;
import com.jetbrains.plugins.vagrant.VagrantSettings;
import com.jetbrains.plugins.vagrant.VagrantSshConfig;
import com.jetbrains.plugins.vagrant.cli.VagrantCli;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VagrantUtil {
    @NotNull
    public static RemoteCredentials getVagrantCredentials(@NotNull String instanceFolder, @Nullable String machineName) throws IOException {
        RemoteCredentials remoteCredentials;
        if (instanceFolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instanceFolder", "com/jetbrains/plugins/vagrant/VagrantUtil", "getVagrantCredentials"));
        }
        try {
            VagrantInstance vagrantInstance = VagrantService.getInstance().getVagrantInstance(instanceFolder);
            VagrantSshConfig config = vagrantInstance.getSshConfig(machineName);
            remoteCredentials = config.toRemoteCredentials();
        }
        catch (VagrantSupport.MultipleMachinesException e) {
            throw new IllegalStateException("Interpreter should be configured as a multiple machines Vagrant based", e);
        }
        if (remoteCredentials == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/vagrant/VagrantUtil", "getVagrantCredentials"));
        }
        return remoteCredentials;
    }

    public static Pair<String, String> getInstanceParameters(Project project) {
        VagrantManager vagrantManager = VagrantManager.getInstance(project);
        List<VagrantInstance> instanceList = vagrantManager.listInstances();
        if (instanceList.size() > 0) {
            VagrantInstance instance = instanceList.get(0);
            return Pair.create((Object)vagrantManager.getVagrantExecutable(false), (Object)instance.getFolder());
        }
        return null;
    }

    @Nullable
    public static String askVagrantExecutablePath(final @Nullable Project project) {
        final Ref path = Ref.create();
        ApplicationManager.getApplication().invokeAndWait(new Runnable(){

            @Override
            public void run() {
                FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, false, false, false, false);
                descriptor.setTitle("Select Vagrant Executable");
                FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)project, null, files -> {
                    VirtualFile file = (VirtualFile)files.get(0);
                    if (file != null) {
                        path.set((Object)file.getPath());
                    }
                });
            }
        });
        return (String)path.get();
    }

    @NotNull
    public static String getVagrantExecutable(@Nullable Project project, boolean askIfEmpty) {
        String executablePath = VagrantSettings.getInstance().getVagrantExecutable();
        if (StringUtil.isEmpty((String)executablePath)) {
            Messages.showErrorDialog((Project)project, (String)"Vagrant executable is not specified.\nPlease set set a path to Vagrant executable in Settings | Vagrant", (String)"Error Running Vagrant");
        }
        String string = executablePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/vagrant/VagrantUtil", "getVagrantExecutable"));
        }
        return string;
    }

    public static boolean checkVagrantRunning(@NotNull String vagrantFolder, @Nullable String machineName, boolean askToRunIfDown) {
        if (vagrantFolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vagrantFolder", "com/jetbrains/plugins/vagrant/VagrantUtil", "checkVagrantRunning"));
        }
        if (!VagrantCli.isVagrantRunning(vagrantFolder, StringUtil.isNotEmpty((String)machineName) ? machineName : null)) {
            if (askToRunIfDown) {
                AtomicBoolean isRunning = new AtomicBoolean(false);
                ApplicationManager.getApplication().invokeAndWait(() -> {
                    if (vagrantFolder == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vagrantFolder", "com/jetbrains/plugins/vagrant/VagrantUtil", "lambda$checkVagrantRunning$0"));
                    }
                    if (Messages.showYesNoDialog((Project)null, (String)("Do you want to launch VM " + (StringUtil.isNotEmpty((String)machineName) ? "'" + machineName + "'" : "") + " at " + vagrantFolder), (String)"Vagrant Instance Not Running", (Icon)Messages.getQuestionIcon()) == 0) {
                        try {
                            VagrantUtil.runVagrant(vagrantFolder, machineName);
                            isRunning.set(true);
                        }
                        catch (ExecutionException e) {
                            Messages.showErrorDialog((Project)null, (String)e.getMessage(), (String)"Vagrant Launch Error");
                        }
                    }
                }, ModalityState.any());
                return isRunning.get();
            }
            return false;
        }
        return true;
    }

    public static void runVagrant(final @NotNull String vagrantFolder, final @Nullable String machineName) throws ExecutionException {
        if (vagrantFolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vagrantFolder", "com/jetbrains/plugins/vagrant/VagrantUtil", "runVagrant"));
        }
        final Ref error = Ref.create();
        final Task.Modal task = new Task.Modal(null, "Launching Vagrant", true){

            public void run(@NotNull ProgressIndicator pi) {
                if (pi == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pi", "com/jetbrains/plugins/vagrant/VagrantUtil$2", "run"));
                }
                pi.setText(vagrantFolder);
                Semaphore done = new Semaphore();
                done.down();
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    if (vagrantFolder == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vagrantFolder", "com/jetbrains/plugins/vagrant/VagrantUtil$2", "lambda$run$0"));
                    }
                    if (pi == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pi", "com/jetbrains/plugins/vagrant/VagrantUtil$2", "lambda$run$0"));
                    }
                    try {
                        VagrantUtil.doRunVagrant(vagrantFolder, machineName, pi);
                    }
                    catch (ExecutionException e) {
                        error.set((Object)e);
                    }
                    finally {
                        done.up();
                    }
                });
                done.waitFor();
            }

            public void onCancel() {
            }
        };
        if (!ProgressManager.getInstance().hasProgressIndicator()) {
            UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    ProgressManager.getInstance().run((Task)task);
                }
            });
        } else {
            task.run(ProgressManager.getInstance().getProgressIndicator());
        }
        if (error.get() != null) {
            throw (ExecutionException)((Object)error.get());
        }
    }

    private static void doRunVagrant(@NotNull String vagrantFolder, @Nullable String machineName, @NotNull ProgressIndicator pi) throws ExecutionException {
        CapturingProcessHandler ph;
        ProcessOutput output;
        if (vagrantFolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vagrantFolder", "com/jetbrains/plugins/vagrant/VagrantUtil", "doRunVagrant"));
        }
        if (pi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pi", "com/jetbrains/plugins/vagrant/VagrantUtil", "doRunVagrant"));
        }
        GeneralCommandLine cmd = new GeneralCommandLine();
        if (!StringUtil.isEmpty((String)vagrantFolder)) {
            cmd.withWorkDirectory(vagrantFolder);
        }
        String homePath = FileUtil.toSystemDependentName((String)VagrantSettings.getInstance().getVagrantExecutable());
        cmd.setExePath(homePath);
        cmd.addParameter("up");
        if (StringUtil.isNotEmpty((String)machineName)) {
            cmd.addParameter(machineName);
        }
        if ((output = (ph = VagrantUtil.createCapturingHandler(cmd, pi)).runProcessWithProgressIndicator(pi)).getExitCode() != 0) {
            throw new ExecutionException(output.getStderr());
        }
    }

    @NotNull
    public static List<String> getVagrantMachines(@NotNull String instanceFolder) {
        List<String> machines;
        if (instanceFolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instanceFolder", "com/jetbrains/plugins/vagrant/VagrantUtil", "getVagrantMachines"));
        }
        VagrantFileConfig config = VagrantFileConfig.findInFolder(instanceFolder);
        if (config != null && (machines = config.getMachineConfigurationNames()) != null) {
            List<String> list = machines;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/vagrant/VagrantUtil", "getVagrantMachines"));
            }
            return list;
        }
        ArrayList arrayList = Lists.newArrayList();
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/vagrant/VagrantUtil", "getVagrantMachines"));
        }
        return arrayList;
    }

    @NotNull
    public static CapturingProcessHandler createCapturingHandler(GeneralCommandLine cmd, final ProgressIndicator indicator) throws ExecutionException {
        Object object = indicator == null ? new CapturingProcessHandler(cmd) : new CapturingAnsiEscapesAwareProcessHandler(cmd){

            protected CapturingProcessAdapter createProcessAdapter(ProcessOutput processOutput) {
                return new CapturingAnsiEscapesAwareProcessHandler.AnsiEscapesAwareAdapter(processOutput){

                    public void coloredTextAvailable(@NotNull String text, @NotNull Key attributes) {
                        if (text == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/plugins/vagrant/VagrantUtil$4$1", "coloredTextAvailable"));
                        }
                        if (attributes == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/jetbrains/plugins/vagrant/VagrantUtil$4$1", "coloredTextAvailable"));
                        }
                        super.coloredTextAvailable(text, attributes);
                        indicator.setText2(text);
                    }
                };
            }
        };
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/vagrant/VagrantUtil", "createCapturingHandler"));
        }
        return object;
    }
}

