/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.vagrant.actions;

import com.google.common.collect.Lists;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.FutureResult;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.vagrant.VagrantBox;
import com.jetbrains.plugins.vagrant.VagrantBoxManager;
import com.jetbrains.plugins.vagrant.VagrantManager;
import com.jetbrains.plugins.vagrant.VagrantProjectSettings;
import com.jetbrains.plugins.vagrant.actions.VagrantActionBase;
import com.jetbrains.plugins.vagrant.actions.VagrantTask;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class VagrantInitInProjectAction
extends VagrantActionBase {
    @Override
    protected String commandName() {
        return "init";
    }

    @Override
    protected void createVagrantTask(@NotNull Project project, Consumer<VagrantTask> taskRunner) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/vagrant/actions/VagrantInitInProjectAction", "createVagrantTask"));
        }
        String vagrantPath = VagrantManager.getInstance(project).getVagrantExecutable(true);
        if (!StringUtil.isEmpty((String)vagrantPath)) {
            VirtualFile[] roots = ProjectRootManager.getInstance((Project)project).getContentRoots();
            if (roots.length == 1) {
                this.createForRoot(project, vagrantPath, roots[0].getPath(), taskRunner);
            } else if (roots.length > 1) {
                this.selectRoot(project, vagrantPath, roots, taskRunner);
            }
        }
    }

    private void selectRoot(final Project project, final String vagrantPath, VirtualFile[] roots, final Consumer<VagrantTask> taskConsumer) {
        BaseListPopupStep<VirtualFile> sdkHomesStep = new BaseListPopupStep<VirtualFile>("Select a folder for Vagrant instance", (List)Lists.newArrayList((Object[])roots)){

            @NotNull
            public String getTextFor(VirtualFile value) {
                String string = value.getPath();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/vagrant/actions/VagrantInitInProjectAction$1", "getTextFor"));
                }
                return string;
            }

            public PopupStep onChosen(VirtualFile root, boolean finalChoice) {
                ApplicationManager.getApplication().invokeLater(() -> VagrantInitInProjectAction.this.createForRoot(project, vagrantPath, root.getPath(), (Consumer<VagrantTask>)taskConsumer));
                return FINAL_CHOICE;
            }
        };
        ListPopup popup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)sdkHomesStep);
        popup.showInFocusCenter();
    }

    private void selectBoxName(final @NotNull Project project, final @NotNull String executable, final @NotNull String root, @NotNull List<VagrantBox> boxes, @NotNull VagrantBoxManager boxManager) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/vagrant/actions/VagrantInitInProjectAction", "selectBoxName"));
        }
        if (executable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executable", "com/jetbrains/plugins/vagrant/actions/VagrantInitInProjectAction", "selectBoxName"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/jetbrains/plugins/vagrant/actions/VagrantInitInProjectAction", "selectBoxName"));
        }
        if (boxes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "boxes", "com/jetbrains/plugins/vagrant/actions/VagrantInitInProjectAction", "selectBoxName"));
        }
        if (boxManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "boxManager", "com/jetbrains/plugins/vagrant/actions/VagrantInitInProjectAction", "selectBoxName"));
        }
        if (boxes.size() == 0) {
            FutureResult<VagrantBox> futureBox = boxManager.add();
            if (futureBox != null) {
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/vagrant/actions/VagrantInitInProjectAction", "lambda$selectBoxName$0"));
                    }
                    if (executable == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executable", "com/jetbrains/plugins/vagrant/actions/VagrantInitInProjectAction", "lambda$selectBoxName$0"));
                    }
                    if (root == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/jetbrains/plugins/vagrant/actions/VagrantInitInProjectAction", "lambda$selectBoxName$0"));
                    }
                    try {
                        VagrantBox box = (VagrantBox)futureBox.get();
                        if (box != null) {
                            this.init(box, project, executable, root);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
            }
        } else if (boxes.size() == 1) {
            this.init(boxes.get(0), project, executable, root);
        } else {
            BaseListPopupStep<VagrantBox> sdkHomesStep = new BaseListPopupStep<VagrantBox>("Select Vagrant Box", boxes){

                @NotNull
                public String getTextFor(VagrantBox value) {
                    String string = value.getName();
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/vagrant/actions/VagrantInitInProjectAction$2", "getTextFor"));
                    }
                    return string;
                }

                public PopupStep onChosen(VagrantBox box, boolean finalChoice) {
                    VagrantInitInProjectAction.this.init(box, project, executable, root);
                    return FINAL_CHOICE;
                }
            };
            ListPopup popup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)sdkHomesStep);
            popup.showInFocusCenter();
        }
    }

    private void init(@NotNull VagrantBox box, @NotNull Project project, @NotNull String executable, @NotNull String root) {
        if (box == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "box", "com/jetbrains/plugins/vagrant/actions/VagrantInitInProjectAction", "init"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/vagrant/actions/VagrantInitInProjectAction", "init"));
        }
        if (executable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executable", "com/jetbrains/plugins/vagrant/actions/VagrantInitInProjectAction", "init"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/jetbrains/plugins/vagrant/actions/VagrantInitInProjectAction", "init"));
        }
        this.performTask(project, VagrantInitInProjectAction.createInitTask(project, executable, root, this.commandName(), box.getName()));
    }

    private void createForRoot(Project project, String executable, String root, Consumer<VagrantTask> vagrantTaskConsumer) {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            VagrantBoxManager boxManager = new VagrantBoxManager(project);
            boxManager.setVagrantPath(executable);
            List vagrantBoxes = boxManager.listItems();
            UIUtil.invokeLaterIfNeeded(() -> {
                if (vagrantBoxes != null) {
                    this.selectBoxName(project, executable, root, vagrantBoxes, boxManager);
                } else {
                    vagrantTaskConsumer.consume((Object)VagrantInitInProjectAction.createInitTask(project, executable, root, this.commandName()));
                }
            });
        });
    }

    private static VagrantTask createInitTask(@NotNull Project project, @NotNull String executable, @NotNull String root, String ... command) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/vagrant/actions/VagrantInitInProjectAction", "createInitTask"));
        }
        if (executable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executable", "com/jetbrains/plugins/vagrant/actions/VagrantInitInProjectAction", "createInitTask"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/jetbrains/plugins/vagrant/actions/VagrantInitInProjectAction", "createInitTask"));
        }
        VagrantTask task = VagrantTask.create(project, executable, root, command);
        task.setAfterCompletion(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/vagrant/actions/VagrantInitInProjectAction", "lambda$createInitTask$3"));
            }
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/jetbrains/plugins/vagrant/actions/VagrantInitInProjectAction", "lambda$createInitTask$3"));
            }
            VagrantProjectSettings.getInstance(project).setInstanceFolder(root);
            VirtualFile rootFile = LocalFileSystem.getInstance().findFileByPath(root);
            if (rootFile != null) {
                rootFile.refresh(true, false);
            }
        });
        return task;
    }

    @Override
    protected boolean isEnabled(Project project) {
        return true;
    }
}

