/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.vagrant.actions;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunContentExecutor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.process.ColoredProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.plugins.vagrant.VagrantManager;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VagrantTask {
    private final Project myProject;
    private final String myVagrantPath;
    private final String myInstanceFolder;
    private String[] myCommands;
    private static final String HELP_ID = "helpid";
    private Runnable myAfterCompletion;
    private boolean myUseTty;
    private Map<String, String> myEnvs;

    public VagrantTask(@NotNull Project project, @NotNull String vagrantPath, @Nullable String instanceFolder, String ... commands) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/vagrant/actions/VagrantTask", "<init>"));
        }
        if (vagrantPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vagrantPath", "com/jetbrains/plugins/vagrant/actions/VagrantTask", "<init>"));
        }
        if (commands == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commands", "com/jetbrains/plugins/vagrant/actions/VagrantTask", "<init>"));
        }
        this.myUseTty = false;
        this.myEnvs = null;
        this.myProject = project;
        this.myVagrantPath = vagrantPath;
        this.myInstanceFolder = instanceFolder;
        this.myCommands = commands;
    }

    public void setAfterCompletion(Runnable afterCompletion) {
        this.myAfterCompletion = afterCompletion;
    }

    public ProcessHandler createProcessHandler() throws ExecutionException {
        ColoredProcessHandler handler = new ColoredProcessHandler(this.createCommandLine());
        ProcessTerminatedListener.attach((ProcessHandler)handler);
        return handler;
    }

    public GeneralCommandLine createCommandLine() {
        GeneralCommandLine cmd;
        Object object = cmd = this.myUseTty && SystemInfo.isUnix ? new PtyCommandLine() : new GeneralCommandLine();
        if (!StringUtil.isEmpty((String)this.myInstanceFolder)) {
            cmd.withWorkDirectory(this.myInstanceFolder);
        }
        if (this.myEnvs != null) {
            cmd.getEnvironment().putAll(this.myEnvs);
        }
        String homePath = FileUtil.toSystemDependentName((String)this.myVagrantPath);
        cmd.setExePath(homePath);
        for (String command : this.myCommands) {
            cmd.addParameter(command);
        }
        return cmd;
    }

    public void run() throws ExecutionException {
        ProcessHandler process = this.createProcessHandler();
        TransactionGuard.submitTransaction((Disposable)this.myProject, () -> new RunContentExecutor(this.myProject, process).withTitle(this.getTitle()).withRerun(() -> {
            try {
                this.run();
            }
            catch (ExecutionException e) {
                Messages.showErrorDialog((String)e.getMessage(), (String)this.getTitle());
            }
        }).withStop(() -> ((ProcessHandler)process).destroyProcess(), () -> !process.isProcessTerminated()).withHelpId(HELP_ID).withAfterCompletion(this.myAfterCompletion).run());
    }

    public String getTitle() {
        return "vagrant " + StringUtil.join((String[])this.myCommands, (String)" ");
    }

    @Nullable
    public static VagrantTask createFromSettings(Project project, String ... command) {
        return VagrantTask.create(VagrantManager.getInstance(project), command);
    }

    public static VagrantTask create(VagrantManager vagrantManager, String ... command) {
        String vagrantPath = vagrantManager.getVagrantExecutable(true);
        String instanceFolder = vagrantManager.getInstanceFolder();
        if (!StringUtil.isEmpty((String)vagrantPath) && !StringUtil.isEmpty((String)instanceFolder)) {
            VagrantTask task = VagrantTask.create(vagrantManager.getProject(), vagrantPath, instanceFolder, command);
            task.setEnvs(vagrantManager.getEnvs());
            return task;
        }
        return null;
    }

    public static VagrantTask create(Project project, String vagrantPath, String instanceFolder, String ... command) {
        return new VagrantTask(project, vagrantPath, instanceFolder, command);
    }

    public String getInstanceFolder() {
        return this.myInstanceFolder;
    }

    public void withTty(boolean useTty) {
        this.myUseTty = useTty;
    }

    public void setEnvs(Map<String, String> envs) {
        this.myEnvs = envs;
    }

    public Map<String, String> getEnvs() {
        return this.myEnvs;
    }

    public String[] getCommands() {
        return this.myCommands;
    }

    public void setCommands(String[] commands) {
        this.myCommands = commands;
    }
}

