/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.vagrant.cli;

import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.process.CapturingAnsiEscapesAwareProcessHandler;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.VagrantSupport;
import com.intellij.util.PatternUtil;
import com.intellij.util.concurrency.BlockingSet;
import com.jetbrains.plugins.vagrant.VagrantSettings;
import com.jetbrains.plugins.vagrant.VagrantSshConfig;
import com.jetbrains.plugins.vagrant.VagrantUtil;
import com.jetbrains.plugins.vagrant.cli.VagrantOutputParser;
import com.jetbrains.plugins.vagrant.cli.VagrantStatus;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VagrantCli {
    private static final Logger LOG = Logger.getInstance(VagrantCli.class);
    private static final BlockingSet<String> VAGRANT_INSTANCE_FOLDERS = BlockingSet.newInstance();
    @NonNls
    private static final String SSH_CONFIG = "ssh-config";
    @NonNls
    private static final String NO_COLOR = "--no-color";
    private static final Pattern VERSION_PATTERN = Pattern.compile("(Vagrant.*)");
    private static final String CSV_SEPARATOR = ",";
    private static final int TARGET_INDEX = 1;
    private static final int TYPE_INDEX = 2;
    private static final int DATA_INDEX = 3;
    private static final String STATE_TYPE = "state";
    private static final String PROVIDER_NAME_TYPE = "provider-name";

    @NotNull
    public static VagrantSshConfig execSshConfigCommand(@Nullable Project project, @NotNull String executable, @NotNull String instanceFolder, @Nullable String machineName) throws IOException, VagrantSupport.MultipleMachinesException {
        String[] stringArray;
        if (executable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executable", "com/jetbrains/plugins/vagrant/cli/VagrantCli", "execSshConfigCommand"));
        }
        if (instanceFolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instanceFolder", "com/jetbrains/plugins/vagrant/cli/VagrantCli", "execSshConfigCommand"));
        }
        if (StringUtil.isNotEmpty((String)machineName)) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = SSH_CONFIG;
            stringArray2[1] = NO_COLOR;
            stringArray = stringArray2;
            stringArray2[2] = machineName;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = SSH_CONFIG;
            stringArray = stringArray3;
            stringArray3[1] = NO_COLOR;
        }
        ProcessOutput output = VagrantCli.runVagrantProcess(project, executable, instanceFolder, stringArray);
        if (output.getExitCode() != 0 && !VagrantSupport.isNotReadyForSsh((String)output.getStderr())) {
            VagrantCli.throwSshConfigParseError(output.getStderr() + output.getStdout());
        }
        if (output.getStdoutLines().size() == 0) {
            VagrantCli.throwSshConfigParseError(output.getStderr());
        }
        LOG.debug("output >" + output.getStdout() + "<");
        VagrantSshConfig sshConfig = VagrantCli.parse(instanceFolder, output.getStdoutLines());
        if (!VagrantCli.isConfigValid(sshConfig)) {
            throw new IOException("Can't parse ssh config:" + output.getStdout());
        }
        VagrantSshConfig vagrantSshConfig = sshConfig;
        if (vagrantSshConfig == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/vagrant/cli/VagrantCli", "execSshConfigCommand"));
        }
        return vagrantSshConfig;
    }

    public static VagrantSshConfig parse(String instanceFolder, @Nullable List<String> lines) {
        List<String> normalizedLines = VagrantCli.unwrapLines(lines);
        LOG.debug("data to parse " + normalizedLines.size());
        VagrantSshConfig result = new VagrantSshConfig(instanceFolder);
        for (String line : normalizedLines) {
            LOG.debug("line to process: >" + line + "<");
            if (VagrantCli.starts(line, "HostName")) {
                result.setHost(VagrantCli.value(line));
                continue;
            }
            if (VagrantCli.starts(line, "User ")) {
                result.setUser(VagrantCli.value(line));
                continue;
            }
            if (VagrantCli.starts(line, "Port")) {
                try {
                    result.setPort(VagrantCli.value(line));
                }
                catch (Exception exception) {}
                continue;
            }
            if (VagrantCli.starts(line, "UserKnownHostsFile")) {
                result.setUserKnownHostsFile(VagrantCli.value(line));
                continue;
            }
            if (VagrantCli.starts(line, "StrictHostKeyChecking")) {
                result.setStringHostKeyChecking("yes".equals(VagrantCli.value(line)));
                continue;
            }
            if (VagrantCli.starts(line, "PasswordAuthentication")) {
                result.setPasswordAuthentication("yes".equals(VagrantCli.value(line)));
                continue;
            }
            if (VagrantCli.starts(line, "IdentityFile")) {
                result.setIdentityFilePath(VagrantCli.unquoteValue(VagrantCli.value(line)));
                continue;
            }
            if (!VagrantCli.starts(line, "IdentitiesOnly")) continue;
            result.setIdentitiesOnly("yes".equals(VagrantCli.value(line)));
        }
        return result;
    }

    @Nullable
    private static String unquoteValue(@Nullable String value) {
        return value != null ? StringUtil.unquoteString((String)value, (char)'\"') : null;
    }

    @NotNull
    private static List<String> unwrapLines(@Nullable List<String> lines) {
        ArrayList normalizedLines = Lists.newArrayList();
        if (lines == null) {
            ArrayList arrayList = normalizedLines;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/vagrant/cli/VagrantCli", "unwrapLines"));
            }
            return arrayList;
        }
        for (String line : lines) {
            if (line.isEmpty()) continue;
            if (Character.isWhitespace(line.charAt(0)) || line.startsWith("Host ") || normalizedLines.isEmpty()) {
                normalizedLines.add(line);
                continue;
            }
            int lastNormalizedLine = normalizedLines.size() - 1;
            normalizedLines.set(lastNormalizedLine, (String)normalizedLines.get(lastNormalizedLine) + line);
        }
        ArrayList arrayList = normalizedLines;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/vagrant/cli/VagrantCli", "unwrapLines"));
        }
        return arrayList;
    }

    private static boolean starts(String line, String text) {
        return line.trim().startsWith(text);
    }

    @Nullable
    private static String value(String line) {
        int ind = (line = line.trim()).indexOf(" ");
        if (ind == -1) {
            return null;
        }
        return line.substring(ind + 1).trim();
    }

    private static void throwSshConfigParseError(String s) throws IOException, VagrantSupport.MultipleMachinesException {
        if (VagrantCli.isMultipleMachinesError(s)) {
            throw new VagrantSupport.MultipleMachinesException();
        }
        throw new IOException(s);
    }

    private static boolean isConfigValid(VagrantSshConfig config) {
        return !StringUtil.isEmpty((String)config.getHost()) && !StringUtil.isEmpty((String)config.getPort());
    }

    public static ProcessOutput runVagrantProcess(@Nullable Project project, @NotNull String executable, @NotNull String instanceFolder, String ... commands) throws IOException {
        if (executable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executable", "com/jetbrains/plugins/vagrant/cli/VagrantCli", "runVagrantProcess"));
        }
        if (instanceFolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instanceFolder", "com/jetbrains/plugins/vagrant/cli/VagrantCli", "runVagrantProcess"));
        }
        if (commands == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commands", "com/jetbrains/plugins/vagrant/cli/VagrantCli", "runVagrantProcess"));
        }
        List commandList = Lists.asList((Object)executable, (Object[])commands);
        ThrowableComputable computable = () -> {
            if (instanceFolder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instanceFolder", "com/jetbrains/plugins/vagrant/cli/VagrantCli", "lambda$runVagrantProcess$0"));
            }
            VAGRANT_INSTANCE_FOLDERS.put((Object)instanceFolder);
            try {
                CapturingProcessHandler processHandler;
                GeneralCommandLine cmd = SystemInfo.isWindows ? new GeneralCommandLine() : new PtyCommandLine();
                cmd.withWorkDirectory(instanceFolder);
                cmd.withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE);
                cmd.setExePath((String)commandList.get(0));
                cmd.addParameters(commandList.subList(1, commandList.size()));
                ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                try {
                    processHandler = VagrantUtil.createCapturingHandler(cmd, indicator);
                }
                catch (ExecutionException e) {
                    throw new IOException(e);
                }
                if (indicator != null) {
                    ProcessOutput processOutput = processHandler.runProcessWithProgressIndicator(indicator);
                    return processOutput;
                }
                ProcessOutput processOutput = processHandler.runProcess();
                return processOutput;
            }
            finally {
                VAGRANT_INSTANCE_FOLDERS.remove((Object)instanceFolder);
            }
        };
        if (ApplicationManager.getApplication().isDispatchThread()) {
            return (ProcessOutput)ProgressManager.getInstance().runProcessWithProgressSynchronously(computable, "Running Vagrant " + commandList, true, project);
        }
        return (ProcessOutput)computable.compute();
    }

    public static boolean isMultipleMachinesError(String error) {
        return error.contains("multi-VM");
    }

    public static boolean isVagrantRunning(@NotNull String instanceFolder, @Nullable String machineName) {
        if (instanceFolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instanceFolder", "com/jetbrains/plugins/vagrant/cli/VagrantCli", "isVagrantRunning"));
        }
        try {
            ProcessOutput po = VagrantCli.runVagrantProcess(null, VagrantSettings.getInstance().getVagrantExecutable(), instanceFolder, "status");
            return VagrantCli.parseVagrantStatus(po, machineName);
        }
        catch (IOException e) {
            return false;
        }
    }

    private static boolean parseVagrantStatus(@NotNull ProcessOutput po, @Nullable String machineName) {
        if (po == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "po", "com/jetbrains/plugins/vagrant/cli/VagrantCli", "parseVagrantStatus"));
        }
        return VagrantOutputParser.isVagrantRunning(po.getStdoutLines(false), machineName);
    }

    @Nullable
    public static String execVagrantVersion(@NotNull String executable) {
        if (executable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executable", "com/jetbrains/plugins/vagrant/cli/VagrantCli", "execVagrantVersion"));
        }
        try {
            String[] cmdarray = new String[]{executable, "--version"};
            Process process = Runtime.getRuntime().exec(cmdarray, null, null);
            CapturingAnsiEscapesAwareProcessHandler processHandler = new CapturingAnsiEscapesAwareProcessHandler(process, StringUtil.join((String[])cmdarray, (String)" "));
            ProcessOutput output = processHandler.runProcess();
            if (output.checkSuccess(LOG)) {
                String match = PatternUtil.getFirstMatch((List)output.getStdoutLines(), (Pattern)VERSION_PATTERN);
                if (LOG.isDebugEnabled()) {
                    if (StringUtil.isNotEmpty((String)match)) {
                        LOG.debug("Vagrant version command output: " + match.trim());
                    } else {
                        LOG.debug("Unable to find Vagrant version in Vagrant output:\n" + output.getStdout());
                    }
                }
                return match;
            }
        }
        catch (IOException e) {
            LOG.debug("Error occurred while getting Vagrant version", (Throwable)e);
        }
        return null;
    }

    @NotNull
    public static List<VagrantStatus> execVagrantStatusCommand(@NotNull String executable, @NotNull String instanceFolder) throws IOException {
        if (executable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executable", "com/jetbrains/plugins/vagrant/cli/VagrantCli", "execVagrantStatusCommand"));
        }
        if (instanceFolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instanceFolder", "com/jetbrains/plugins/vagrant/cli/VagrantCli", "execVagrantStatusCommand"));
        }
        ProcessOutput output = VagrantCli.runVagrantProcess(null, executable, instanceFolder, "status", "--machine-readable");
        if (output.getExitCode() != 0) {
            throw new RuntimeException("Error occurred while executing \"vagrant status\" inside \"" + instanceFolder + "\" folder:\n" + output.getStderr());
        }
        if (output.isTimeout()) {
            throw new RuntimeException("Timeout while executing \"vagrant status\" command inside \"" + instanceFolder + "\" folder");
        }
        List<VagrantStatus> list = VagrantCli.parseMachineReadableVagrantStatusCommandOutput(output.getStdoutLines());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/vagrant/cli/VagrantCli", "execVagrantStatusCommand"));
        }
        return list;
    }

    @NotNull
    public static List<VagrantStatus> parseMachineReadableVagrantStatusCommandOutput(@NotNull List<String> stdoutLines) {
        if (stdoutLines == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stdoutLines", "com/jetbrains/plugins/vagrant/cli/VagrantCli", "parseMachineReadableVagrantStatusCommandOutput"));
        }
        LinkedHashMap<String, Map> machinesValues = new LinkedHashMap<String, Map>();
        for (String line : stdoutLines) {
            String target;
            List values = StringUtil.split((String)line, (String)CSV_SEPARATOR);
            if (values.size() < 4 || !StringUtil.isNotEmpty((String)(target = ((String)values.get(1)).trim()))) continue;
            String type = ((String)values.get(2)).trim();
            String data = ((String)values.get(3)).trim();
            Map machineValues = machinesValues.computeIfAbsent(target, s -> new HashMap());
            machineValues.put(type, data);
        }
        ArrayList<VagrantStatus> statuses = new ArrayList<VagrantStatus>();
        for (Map.Entry entry : machinesValues.entrySet()) {
            String machineName = (String)entry.getKey();
            String state = (String)((Map)entry.getValue()).get(STATE_TYPE);
            String provider = (String)((Map)entry.getValue()).get(PROVIDER_NAME_TYPE);
            if (state == null || provider == null) continue;
            statuses.add(new VagrantStatus(machineName, state, provider));
        }
        ArrayList<VagrantStatus> arrayList = statuses;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/vagrant/cli/VagrantCli", "parseMachineReadableVagrantStatusCommandOutput"));
        }
        return arrayList;
    }
}

