/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.vagrant.ui;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.vagrant.VagrantSettings;
import com.jetbrains.plugins.vagrant.VagrantSshConfig;
import com.jetbrains.plugins.vagrant.VagrantUtil;
import com.jetbrains.plugins.vagrant.cli.VagrantCli;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectVagrantFolderDialog
extends DialogWrapper {
    private JPanel myMainPanel;
    private TextFieldWithBrowseButton myExecutableField;
    private TextFieldWithBrowseButton myFolderField;
    private JBLabel myExecutableLabel;
    private Project myProject;
    private VagrantSshConfig mySshConfig;
    private boolean myEditExecutable = false;

    public SelectVagrantFolderDialog(@Nullable Project project) {
        super(project);
        VirtualFile baseDir;
        this.$$$setupUI$$$();
        this.setTitle("Select Vagrant Environment Folder");
        this.myProject = project;
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, false, false, false, false);
        this.myExecutableField.addActionListener((ActionListener)new ComponentWithBrowseButton.BrowseFolderActionListener("Select Vagrant executable", "", (ComponentWithBrowseButton)this.myExecutableField, null, descriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT));
        String executable = VagrantSettings.getInstance().getVagrantExecutable();
        if (!StringUtil.isEmpty((String)executable)) {
            this.myExecutableField.setText(FileUtil.toSystemDependentName((String)executable));
            this.setExecutableVisible(this.myEditExecutable);
        } else {
            IdeFocusManager.findInstanceByComponent((Component)this.myMainPanel).requestFocus((Component)this.myFolderField, true);
        }
        if (this.myProject != null && (baseDir = this.myProject.getBaseDir()) != null && baseDir.findChild("Vagrantfile") != null) {
            this.myFolderField.setText(FileUtil.toSystemDependentName((String)this.myProject.getBasePath()));
        }
        FileChooserDescriptor folderDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        this.myFolderField.addActionListener((ActionListener)new ComponentWithBrowseButton.BrowseFolderActionListener("Select Vagrant folder", "", (ComponentWithBrowseButton)this.myFolderField, null, folderDescriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT));
        this.myFolderField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                SelectVagrantFolderDialog.this.initValidation();
            }
        });
        this.myExecutableField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                SelectVagrantFolderDialog.this.initValidation();
            }
        });
        this.initFromSettings();
        this.init();
    }

    private void setExecutableVisible(boolean visible) {
        this.myExecutableField.setVisible(visible);
        this.myExecutableLabel.setVisible(visible);
        this.pack();
    }

    public void setEditExecutable(boolean editExecutable) {
        this.myEditExecutable = editExecutable;
    }

    private void initFromSettings() {
        Pair<String, String> instance = VagrantUtil.getInstanceParameters(this.myProject);
        if (instance != null) {
            this.myExecutableField.setText((String)instance.first);
            this.myFolderField.setText((String)instance.second);
        }
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myFolderField;
    }

    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    protected ValidationInfo doValidate() {
        if (StringUtil.isEmpty((String)this.getFolder())) {
            return new ValidationInfo("Specify folder with Vagrant virtual environment");
        }
        if (!new File(this.getFolder()).exists()) {
            return new ValidationInfo("Folder " + this.getFolder() + " doesn't exist");
        }
        return null;
    }

    protected void doOKAction() {
        this.mySshConfig = this.createSshConfig();
        if (this.mySshConfig != null) {
            super.doOKAction();
        }
    }

    @NotNull
    public VagrantSshConfig getSshConfig() {
        VagrantSshConfig vagrantSshConfig = this.mySshConfig;
        if (vagrantSshConfig == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/vagrant/ui/SelectVagrantFolderDialog", "getSshConfig"));
        }
        return vagrantSshConfig;
    }

    @Nullable
    public VagrantSshConfig createSshConfig() {
        try {
            return VagrantCli.execSshConfigCommand(this.myProject, this.getExecutable(), this.getFolder(), null);
        }
        catch (Exception e) {
            UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    SelectVagrantFolderDialog.this.setExecutableVisible(true);
                    Messages.showErrorDialog((String)e.getMessage(), (String)"Error Getting Vagrant Ssh-Config");
                }
            });
            return null;
        }
    }

    private String getFolder() {
        return this.myFolderField.getText();
    }

    private String getExecutable() {
        return this.myExecutableField.getText();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JBLabel jBLabel;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 2, 0, 3, 6, 3, new Dimension(400, -1), null, null));
        this.myExecutableLabel = jBLabel = new JBLabel();
        jBLabel.setText("Vagrant executable");
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Vagrant instance folder");
        jPanel2.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myExecutableField = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myFolderField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 1, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

