/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonMapFormatVisitor;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ContainerSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.PropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import com.fasterxml.jackson.databind.ser.std.MapProperty;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.ArrayBuilders;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

@JacksonStdImpl
public class MapSerializer
extends ContainerSerializer<Map<?, ?>>
implements ContextualSerializer {
    private static final long serialVersionUID = 1L;
    protected static final JavaType UNSPECIFIED_TYPE = TypeFactory.unknownType();
    protected final BeanProperty _property;
    protected final Set<String> _ignoredEntries;
    protected final boolean _valueTypeIsStatic;
    protected final JavaType _keyType;
    protected final JavaType _valueType;
    protected JsonSerializer<Object> _keySerializer;
    protected JsonSerializer<Object> _valueSerializer;
    protected final TypeSerializer _valueTypeSerializer;
    protected PropertySerializerMap _dynamicValueSerializers;
    protected final Object _filterId;
    protected final boolean _sortKeys;
    protected final Object _suppressableValue;

    protected MapSerializer(Set<String> ignoredEntries, JavaType keyType, JavaType valueType, boolean valueTypeIsStatic, TypeSerializer vts, JsonSerializer<?> keySerializer, JsonSerializer<?> valueSerializer) {
        super(Map.class, false);
        this._ignoredEntries = ignoredEntries == null || ignoredEntries.isEmpty() ? null : ignoredEntries;
        this._keyType = keyType;
        this._valueType = valueType;
        this._valueTypeIsStatic = valueTypeIsStatic;
        this._valueTypeSerializer = vts;
        this._keySerializer = keySerializer;
        this._valueSerializer = valueSerializer;
        this._dynamicValueSerializers = PropertySerializerMap.emptyForProperties();
        this._property = null;
        this._filterId = null;
        this._sortKeys = false;
        this._suppressableValue = null;
    }

    protected void _ensureOverride() {
        if (this.getClass() != MapSerializer.class) {
            throw new IllegalStateException("Missing override in class " + this.getClass().getName());
        }
    }

    protected MapSerializer(MapSerializer src, BeanProperty property, JsonSerializer<?> keySerializer, JsonSerializer<?> valueSerializer, Set<String> ignoredEntries) {
        super(Map.class, false);
        this._ignoredEntries = ignoredEntries == null || ignoredEntries.isEmpty() ? null : ignoredEntries;
        this._keyType = src._keyType;
        this._valueType = src._valueType;
        this._valueTypeIsStatic = src._valueTypeIsStatic;
        this._valueTypeSerializer = src._valueTypeSerializer;
        this._keySerializer = keySerializer;
        this._valueSerializer = valueSerializer;
        this._dynamicValueSerializers = src._dynamicValueSerializers;
        this._property = property;
        this._filterId = src._filterId;
        this._sortKeys = src._sortKeys;
        this._suppressableValue = src._suppressableValue;
    }

    @Deprecated
    protected MapSerializer(MapSerializer src, TypeSerializer vts) {
        this(src, vts, src._suppressableValue);
    }

    protected MapSerializer(MapSerializer src, TypeSerializer vts, Object suppressableValue) {
        super(Map.class, false);
        this._ignoredEntries = src._ignoredEntries;
        this._keyType = src._keyType;
        this._valueType = src._valueType;
        this._valueTypeIsStatic = src._valueTypeIsStatic;
        this._valueTypeSerializer = vts;
        this._keySerializer = src._keySerializer;
        this._valueSerializer = src._valueSerializer;
        this._dynamicValueSerializers = src._dynamicValueSerializers;
        this._property = src._property;
        this._filterId = src._filterId;
        this._sortKeys = src._sortKeys;
        if (suppressableValue == JsonInclude.Include.NON_ABSENT) {
            suppressableValue = this._valueType.isReferenceType() ? JsonInclude.Include.NON_EMPTY : JsonInclude.Include.NON_NULL;
        }
        this._suppressableValue = suppressableValue;
    }

    protected MapSerializer(MapSerializer src, Object filterId, boolean sortKeys) {
        super(Map.class, false);
        this._ignoredEntries = src._ignoredEntries;
        this._keyType = src._keyType;
        this._valueType = src._valueType;
        this._valueTypeIsStatic = src._valueTypeIsStatic;
        this._valueTypeSerializer = src._valueTypeSerializer;
        this._keySerializer = src._keySerializer;
        this._valueSerializer = src._valueSerializer;
        this._dynamicValueSerializers = src._dynamicValueSerializers;
        this._property = src._property;
        this._filterId = filterId;
        this._sortKeys = sortKeys;
        this._suppressableValue = src._suppressableValue;
    }

    public MapSerializer _withValueTypeSerializer(TypeSerializer vts) {
        if (this._valueTypeSerializer == vts) {
            return this;
        }
        this._ensureOverride();
        return new MapSerializer(this, vts, null);
    }

    public MapSerializer withResolved(BeanProperty property, JsonSerializer<?> keySerializer, JsonSerializer<?> valueSerializer, Set<String> ignored, boolean sortKeys) {
        this._ensureOverride();
        MapSerializer ser = new MapSerializer(this, property, keySerializer, valueSerializer, ignored);
        if (sortKeys != ser._sortKeys) {
            ser = new MapSerializer(ser, this._filterId, sortKeys);
        }
        return ser;
    }

    public MapSerializer withFilterId(Object filterId) {
        if (this._filterId == filterId) {
            return this;
        }
        this._ensureOverride();
        return new MapSerializer(this, filterId, this._sortKeys);
    }

    public MapSerializer withContentInclusion(Object suppressableValue) {
        if (suppressableValue == this._suppressableValue) {
            return this;
        }
        this._ensureOverride();
        return new MapSerializer(this, this._valueTypeSerializer, suppressableValue);
    }

    @Deprecated
    public static MapSerializer construct(String[] ignoredList, JavaType mapType, boolean staticValueType, TypeSerializer vts, JsonSerializer<Object> keySerializer, JsonSerializer<Object> valueSerializer, Object filterId) {
        HashSet<String> ignoredEntries = ignoredList == null || ignoredList.length == 0 ? null : ArrayBuilders.arrayToSet(ignoredList);
        return MapSerializer.construct(ignoredEntries, mapType, staticValueType, vts, keySerializer, valueSerializer, filterId);
    }

    public static MapSerializer construct(Set<String> ignoredEntries, JavaType mapType, boolean staticValueType, TypeSerializer vts, JsonSerializer<Object> keySerializer, JsonSerializer<Object> valueSerializer, Object filterId) {
        JavaType keyType;
        JavaType valueType;
        if (mapType == null) {
            keyType = valueType = UNSPECIFIED_TYPE;
        } else {
            keyType = mapType.getKeyType();
            valueType = mapType.getContentType();
        }
        if (!staticValueType) {
            staticValueType = valueType != null && valueType.isFinal();
        } else if (valueType.getRawClass() == Object.class) {
            staticValueType = false;
        }
        MapSerializer ser = new MapSerializer(ignoredEntries, keyType, valueType, staticValueType, vts, keySerializer, valueSerializer);
        if (filterId != null) {
            ser = ser.withFilterId(filterId);
        }
        return ser;
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider provider, BeanProperty property) throws JsonMappingException {
        Object filterId;
        AnnotatedMember m;
        Boolean B;
        JsonFormat.Value format;
        JsonInclude.Value inclV;
        JsonInclude.Include incl;
        JsonSerializer<Object> ser = null;
        JsonSerializer<Object> keySer = null;
        AnnotationIntrospector intr = provider.getAnnotationIntrospector();
        AnnotatedMember propertyAcc = property == null ? null : property.getMember();
        Object suppressableValue = this._suppressableValue;
        if (propertyAcc != null && intr != null) {
            Object serDef = intr.findKeySerializer(propertyAcc);
            if (serDef != null) {
                keySer = provider.serializerInstance(propertyAcc, serDef);
            }
            if ((serDef = intr.findContentSerializer(propertyAcc)) != null) {
                ser = provider.serializerInstance(propertyAcc, serDef);
            }
        }
        if ((incl = (inclV = this.findIncludeOverrides(provider, property, Map.class)).getContentInclusion()) != null && incl != JsonInclude.Include.USE_DEFAULTS) {
            suppressableValue = incl;
        }
        if (ser == null) {
            ser = this._valueSerializer;
        }
        if ((ser = this.findConvertingContentSerializer(provider, property, ser)) == null) {
            if (this._valueTypeIsStatic && !this._valueType.isJavaLangObject()) {
                ser = provider.findValueSerializer(this._valueType, property);
            }
        } else {
            ser = provider.handleSecondaryContextualization(ser, property);
        }
        if (keySer == null) {
            keySer = this._keySerializer;
        }
        keySer = keySer == null ? provider.findKeySerializer(this._keyType, property) : provider.handleSecondaryContextualization(keySer, property);
        Set<String> ignored = this._ignoredEntries;
        boolean sortKeys = false;
        if (intr != null && propertyAcc != null) {
            Boolean b;
            Set newIgnored;
            JsonIgnoreProperties.Value ignorals = intr.findPropertyIgnorals(propertyAcc);
            if (ignorals != null && (newIgnored = ignorals.findIgnoredForSerialization()) != null && !newIgnored.isEmpty()) {
                ignored = ignored == null ? new HashSet<String>() : new HashSet<String>(ignored);
                for (String str : newIgnored) {
                    ignored.add(str);
                }
            }
            boolean bl = sortKeys = (b = intr.findSerializationSortAlphabetically(propertyAcc)) != null && b != false;
        }
        if ((format = this.findFormatOverrides(provider, property, Map.class)) != null && (B = format.getFeature(JsonFormat.Feature.WRITE_SORTED_MAP_ENTRIES)) != null) {
            sortKeys = B;
        }
        MapSerializer mser = this.withResolved(property, keySer, ser, ignored, sortKeys);
        if (suppressableValue != this._suppressableValue) {
            mser = mser.withContentInclusion(suppressableValue);
        }
        if (property != null && (m = property.getMember()) != null && (filterId = intr.findFilterId(m)) != null) {
            mser = mser.withFilterId(filterId);
        }
        return mser;
    }

    @Override
    public JavaType getContentType() {
        return this._valueType;
    }

    @Override
    public JsonSerializer<?> getContentSerializer() {
        return this._valueSerializer;
    }

    @Override
    public boolean isEmpty(SerializerProvider prov, Map<?, ?> value) {
        if (value == null || value.isEmpty()) {
            return true;
        }
        Object supp = this._suppressableValue;
        if (supp == null || supp == JsonInclude.Include.ALWAYS) {
            return false;
        }
        JsonSerializer<Object> valueSer = this._valueSerializer;
        if (valueSer != null) {
            for (Object elemValue : value.values()) {
                if (elemValue == null || valueSer.isEmpty(prov, elemValue)) continue;
                return false;
            }
            return true;
        }
        PropertySerializerMap serializers = this._dynamicValueSerializers;
        for (Object elemValue : value.values()) {
            if (elemValue == null) continue;
            Class<?> cc = elemValue.getClass();
            valueSer = serializers.serializerFor(cc);
            if (valueSer == null) {
                try {
                    valueSer = this._findAndAddDynamic(serializers, cc, prov);
                }
                catch (JsonMappingException e) {
                    return false;
                }
                serializers = this._dynamicValueSerializers;
            }
            if (valueSer.isEmpty(prov, elemValue)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasSingleElement(Map<?, ?> value) {
        return value.size() == 1;
    }

    public JsonSerializer<?> getKeySerializer() {
        return this._keySerializer;
    }

    @Override
    public void serialize(Map<?, ?> value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeStartObject(value);
        if (!value.isEmpty()) {
            Object suppressableValue = this._suppressableValue;
            if (suppressableValue == JsonInclude.Include.ALWAYS) {
                suppressableValue = null;
            } else if (suppressableValue == null && !provider.isEnabled(SerializationFeature.WRITE_NULL_MAP_VALUES)) {
                suppressableValue = JsonInclude.Include.NON_NULL;
            }
            if (this._sortKeys || provider.isEnabled(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS)) {
                value = this._orderEntries(value);
            }
            if (this._filterId != null) {
                this.serializeFilteredFields(value, gen, provider, this.findPropertyFilter(provider, this._filterId, value), suppressableValue);
            } else if (suppressableValue != null) {
                this.serializeOptionalFields(value, gen, provider, suppressableValue);
            } else if (this._valueSerializer != null) {
                this.serializeFieldsUsing(value, gen, provider, this._valueSerializer);
            } else {
                this.serializeFields(value, gen, provider);
            }
        }
        gen.writeEndObject();
    }

    @Override
    public void serializeWithType(Map<?, ?> value, JsonGenerator gen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        typeSer.writeTypePrefixForObject(value, gen);
        gen.setCurrentValue(value);
        if (!value.isEmpty()) {
            Object suppressableValue = this._suppressableValue;
            if (suppressableValue == JsonInclude.Include.ALWAYS) {
                suppressableValue = null;
            } else if (suppressableValue == null && !provider.isEnabled(SerializationFeature.WRITE_NULL_MAP_VALUES)) {
                suppressableValue = JsonInclude.Include.NON_NULL;
            }
            if (this._sortKeys || provider.isEnabled(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS)) {
                value = this._orderEntries(value);
            }
            if (this._filterId != null) {
                this.serializeFilteredFields(value, gen, provider, this.findPropertyFilter(provider, this._filterId, value), suppressableValue);
            } else if (suppressableValue != null) {
                this.serializeOptionalFields(value, gen, provider, suppressableValue);
            } else if (this._valueSerializer != null) {
                this.serializeFieldsUsing(value, gen, provider, this._valueSerializer);
            } else {
                this.serializeFields(value, gen, provider);
            }
        }
        typeSer.writeTypeSuffixForObject(value, gen);
    }

    public void serializeFields(Map<?, ?> value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (this._valueTypeSerializer != null) {
            this.serializeTypedFields(value, gen, provider, null);
            return;
        }
        JsonSerializer<Object> keySerializer = this._keySerializer;
        Set<String> ignored = this._ignoredEntries;
        PropertySerializerMap serializers = this._dynamicValueSerializers;
        for (Map.Entry<?, ?> entry : value.entrySet()) {
            Class<?> cc;
            Object valueElem = entry.getValue();
            Object keyElem = entry.getKey();
            if (keyElem == null) {
                provider.findNullKeySerializer(this._keyType, this._property).serialize(null, gen, provider);
            } else {
                if (ignored != null && ignored.contains(keyElem)) continue;
                keySerializer.serialize(keyElem, gen, provider);
            }
            if (valueElem == null) {
                provider.defaultSerializeNull(gen);
                continue;
            }
            JsonSerializer<Object> serializer = this._valueSerializer;
            if (serializer == null && (serializer = serializers.serializerFor(cc = valueElem.getClass())) == null) {
                serializer = this._valueType.hasGenericTypes() ? this._findAndAddDynamic(serializers, provider.constructSpecializedType(this._valueType, cc), provider) : this._findAndAddDynamic(serializers, cc, provider);
                serializers = this._dynamicValueSerializers;
            }
            try {
                serializer.serialize(valueElem, gen, provider);
            }
            catch (Exception e) {
                String keyDesc = "" + keyElem;
                this.wrapAndThrow(provider, (Throwable)e, value, keyDesc);
            }
        }
    }

    public void serializeOptionalFields(Map<?, ?> value, JsonGenerator gen, SerializerProvider provider, Object suppressableValue) throws IOException {
        if (this._valueTypeSerializer != null) {
            this.serializeTypedFields(value, gen, provider, suppressableValue);
            return;
        }
        Set<String> ignored = this._ignoredEntries;
        PropertySerializerMap serializers = this._dynamicValueSerializers;
        for (Map.Entry<?, ?> entry : value.entrySet()) {
            JsonSerializer<Object> valueSer;
            JsonSerializer<Object> keySerializer;
            Object keyElem = entry.getKey();
            if (keyElem == null) {
                keySerializer = provider.findNullKeySerializer(this._keyType, this._property);
            } else {
                if (ignored != null && ignored.contains(keyElem)) continue;
                keySerializer = this._keySerializer;
            }
            Object valueElem = entry.getValue();
            if (valueElem == null) {
                if (suppressableValue != null) continue;
                valueSer = provider.getDefaultNullValueSerializer();
            } else {
                Class<?> cc;
                valueSer = this._valueSerializer;
                if (valueSer == null && (valueSer = serializers.serializerFor(cc = valueElem.getClass())) == null) {
                    valueSer = this._valueType.hasGenericTypes() ? this._findAndAddDynamic(serializers, provider.constructSpecializedType(this._valueType, cc), provider) : this._findAndAddDynamic(serializers, cc, provider);
                    serializers = this._dynamicValueSerializers;
                }
                if (suppressableValue == JsonInclude.Include.NON_EMPTY && valueSer.isEmpty(provider, valueElem)) continue;
            }
            try {
                keySerializer.serialize(keyElem, gen, provider);
                valueSer.serialize(valueElem, gen, provider);
            }
            catch (Exception e) {
                String keyDesc = "" + keyElem;
                this.wrapAndThrow(provider, (Throwable)e, value, keyDesc);
            }
        }
    }

    public void serializeFieldsUsing(Map<?, ?> value, JsonGenerator gen, SerializerProvider provider, JsonSerializer<Object> ser) throws IOException {
        JsonSerializer<Object> keySerializer = this._keySerializer;
        Set<String> ignored = this._ignoredEntries;
        TypeSerializer typeSer = this._valueTypeSerializer;
        for (Map.Entry<?, ?> entry : value.entrySet()) {
            Object keyElem = entry.getKey();
            if (ignored != null && ignored.contains(keyElem)) continue;
            if (keyElem == null) {
                provider.findNullKeySerializer(this._keyType, this._property).serialize(null, gen, provider);
            } else {
                keySerializer.serialize(keyElem, gen, provider);
            }
            Object valueElem = entry.getValue();
            if (valueElem == null) {
                provider.defaultSerializeNull(gen);
                continue;
            }
            try {
                if (typeSer == null) {
                    ser.serialize(valueElem, gen, provider);
                    continue;
                }
                ser.serializeWithType(valueElem, gen, provider, typeSer);
            }
            catch (Exception e) {
                String keyDesc = "" + keyElem;
                this.wrapAndThrow(provider, (Throwable)e, value, keyDesc);
            }
        }
    }

    public void serializeFilteredFields(Map<?, ?> value, JsonGenerator gen, SerializerProvider provider, PropertyFilter filter, Object suppressableValue) throws IOException {
        Set<String> ignored = this._ignoredEntries;
        PropertySerializerMap serializers = this._dynamicValueSerializers;
        MapProperty prop = new MapProperty(this._valueTypeSerializer, this._property);
        for (Map.Entry<?, ?> entry : value.entrySet()) {
            JsonSerializer<Object> valueSer;
            Object keyElem = entry.getKey();
            if (ignored != null && ignored.contains(keyElem)) continue;
            JsonSerializer<Object> keySerializer = keyElem == null ? provider.findNullKeySerializer(this._keyType, this._property) : this._keySerializer;
            Object valueElem = entry.getValue();
            if (valueElem == null) {
                if (suppressableValue != null) continue;
                valueSer = provider.getDefaultNullValueSerializer();
            } else {
                Class<?> cc;
                valueSer = this._valueSerializer;
                if (valueSer == null && (valueSer = serializers.serializerFor(cc = valueElem.getClass())) == null) {
                    valueSer = this._valueType.hasGenericTypes() ? this._findAndAddDynamic(serializers, provider.constructSpecializedType(this._valueType, cc), provider) : this._findAndAddDynamic(serializers, cc, provider);
                    serializers = this._dynamicValueSerializers;
                }
                if (suppressableValue == JsonInclude.Include.NON_EMPTY && valueSer.isEmpty(provider, valueElem)) continue;
            }
            prop.reset(keyElem, keySerializer, valueSer);
            try {
                filter.serializeAsField(valueElem, gen, provider, prop);
            }
            catch (Exception e) {
                String keyDesc = "" + keyElem;
                this.wrapAndThrow(provider, (Throwable)e, value, keyDesc);
            }
        }
    }

    @Deprecated
    public void serializeFilteredFields(Map<?, ?> value, JsonGenerator gen, SerializerProvider provider, PropertyFilter filter) throws IOException {
        this.serializeFilteredFields(value, gen, provider, filter, provider.isEnabled(SerializationFeature.WRITE_NULL_MAP_VALUES) ? null : JsonInclude.Include.NON_NULL);
    }

    public void serializeTypedFields(Map<?, ?> value, JsonGenerator gen, SerializerProvider provider, Object suppressableValue) throws IOException {
        Set<String> ignored = this._ignoredEntries;
        PropertySerializerMap serializers = this._dynamicValueSerializers;
        for (Map.Entry<?, ?> entry : value.entrySet()) {
            JsonSerializer<Object> valueSer;
            JsonSerializer<Object> keySerializer;
            Object keyElem = entry.getKey();
            if (keyElem == null) {
                keySerializer = provider.findNullKeySerializer(this._keyType, this._property);
            } else {
                if (ignored != null && ignored.contains(keyElem)) continue;
                keySerializer = this._keySerializer;
            }
            Object valueElem = entry.getValue();
            if (valueElem == null) {
                if (suppressableValue != null) continue;
                valueSer = provider.getDefaultNullValueSerializer();
            } else {
                valueSer = this._valueSerializer;
                Class<?> cc = valueElem.getClass();
                valueSer = serializers.serializerFor(cc);
                if (valueSer == null) {
                    valueSer = this._valueType.hasGenericTypes() ? this._findAndAddDynamic(serializers, provider.constructSpecializedType(this._valueType, cc), provider) : this._findAndAddDynamic(serializers, cc, provider);
                    serializers = this._dynamicValueSerializers;
                }
                if (suppressableValue == JsonInclude.Include.NON_EMPTY && valueSer.isEmpty(provider, valueElem)) continue;
            }
            keySerializer.serialize(keyElem, gen, provider);
            try {
                valueSer.serializeWithType(valueElem, gen, provider, this._valueTypeSerializer);
            }
            catch (Exception e) {
                String keyDesc = "" + keyElem;
                this.wrapAndThrow(provider, (Throwable)e, value, keyDesc);
            }
        }
    }

    @Deprecated
    protected void serializeTypedFields(Map<?, ?> value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        this.serializeTypedFields(value, gen, provider, provider.isEnabled(SerializationFeature.WRITE_NULL_MAP_VALUES) ? null : JsonInclude.Include.NON_NULL);
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        return this.createSchemaNode("object", true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonMapFormatVisitor v2;
        JsonMapFormatVisitor jsonMapFormatVisitor = v2 = visitor == null ? null : visitor.expectMapFormat(typeHint);
        if (v2 != null) {
            v2.keyFormat(this._keySerializer, this._keyType);
            JsonSerializer<Object> valueSer = this._valueSerializer;
            if (valueSer == null) {
                valueSer = this._findAndAddDynamic(this._dynamicValueSerializers, this._valueType, visitor.getProvider());
            }
            v2.valueFormat(valueSer, this._valueType);
        }
    }

    protected final JsonSerializer<Object> _findAndAddDynamic(PropertySerializerMap map, Class<?> type, SerializerProvider provider) throws JsonMappingException {
        PropertySerializerMap.SerializerAndMapResult result = map.findAndAddSecondarySerializer(type, provider, this._property);
        if (map != result.map) {
            this._dynamicValueSerializers = result.map;
        }
        return result.serializer;
    }

    protected final JsonSerializer<Object> _findAndAddDynamic(PropertySerializerMap map, JavaType type, SerializerProvider provider) throws JsonMappingException {
        PropertySerializerMap.SerializerAndMapResult result = map.findAndAddSecondarySerializer(type, provider, this._property);
        if (map != result.map) {
            this._dynamicValueSerializers = result.map;
        }
        return result.serializer;
    }

    protected Map<?, ?> _orderEntries(Map<?, ?> input) {
        if (input instanceof SortedMap) {
            return input;
        }
        return new TreeMap(input);
    }
}

