/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.remote;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.javascript.nodejs.NodeFileTransfer;
import com.intellij.javascript.nodejs.NodeJSRemoteInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterChangeListener;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.interpreter.remote.NodeJsRemoteInterpreter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.Consumer;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.ui.FormBuilder;
import com.jetbrains.nodejs.run.NodeJSRunConfigurationExtension;
import com.jetbrains.nodejs.run.NodeJSRuntimeSession;
import com.jetbrains.nodejs.run.NodeJsRunConfiguration;
import java.io.File;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeJSRemoteRunConfigurationExtension
extends NodeJSRunConfigurationExtension {
    protected void readExternal(@NotNull NodeJsRunConfiguration runConfiguration, @NotNull Element element) throws InvalidDataException {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/jetbrains/nodejs/remote/NodeJSRemoteRunConfigurationExtension", "readExternal"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/nodejs/remote/NodeJSRemoteRunConfigurationExtension", "readExternal"));
        }
    }

    protected void writeExternal(@NotNull NodeJsRunConfiguration runConfiguration, @NotNull Element element) throws WriteExternalException {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/jetbrains/nodejs/remote/NodeJSRemoteRunConfigurationExtension", "writeExternal"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/nodejs/remote/NodeJSRemoteRunConfigurationExtension", "writeExternal"));
        }
        super.writeExternal((RunConfigurationBase)runConfiguration, element);
    }

    protected boolean showEditorInMainPage(@NotNull NodeJsRunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/jetbrains/nodejs/remote/NodeJSRemoteRunConfigurationExtension", "showEditorInMainPage"));
        }
        return true;
    }

    @Nullable
    protected <P extends NodeJsRunConfiguration> SettingsEditor<P> createEditor(@NotNull P configuration, @NotNull Getter<NodeJsInterpreter> currentInterpreterGetter, @NotNull Consumer<NodeJsInterpreterChangeListener> listenerRegistrar) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/jetbrains/nodejs/remote/NodeJSRemoteRunConfigurationExtension", "createEditor"));
        }
        if (currentInterpreterGetter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentInterpreterGetter", "com/jetbrains/nodejs/remote/NodeJSRemoteRunConfigurationExtension", "createEditor"));
        }
        if (listenerRegistrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listenerRegistrar", "com/jetbrains/nodejs/remote/NodeJSRemoteRunConfigurationExtension", "createEditor"));
        }
        return new RemoteMappingsEditor<P>(configuration, listenerRegistrar);
    }

    @Nullable
    public NodeFileTransfer overrideFileTransfer(@NotNull NodeJsRunConfiguration configuration) throws ExecutionException {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/jetbrains/nodejs/remote/NodeJSRemoteRunConfigurationExtension", "overrideFileTransfer"));
        }
        if (NodeJSRemoteRunConfigurationExtension.isRemoteAndPasses(configuration)) {
            NodeJSRemoteInterpreterManager manager = NodeJSRemoteInterpreterManager.getInstance();
            assert (manager != null);
            RemoteSdkAdditionalData data = manager.getRemoteSdkAdditionalData(configuration.getProject(), configuration.getRawExePath());
            return manager.getFileTransfer(configuration.getProject(), data);
        }
        return null;
    }

    private static boolean isRemoteAndPasses(@NotNull NodeJsRunConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/jetbrains/nodejs/remote/NodeJSRemoteRunConfigurationExtension", "isRemoteAndPasses"));
        }
        String rawExePath = configuration.getRawExePath();
        if (StringUtil.isEmptyOrSpaces((String)rawExePath)) {
            return false;
        }
        NodeJsInterpreterRef ref = NodeJsInterpreterRef.create((String)rawExePath);
        NodeJsRemoteInterpreter remoteInterpreter = NodeJsRemoteInterpreter.tryCast((NodeJsInterpreter)ref.resolveWithoutAliases());
        if (remoteInterpreter == null) {
            return false;
        }
        try {
            NodeJSRemoteInterpreterManager manager = NodeJSRemoteInterpreterManager.getInstance();
            assert (manager != null);
            RemoteSdkAdditionalData data = manager.getRemoteSdkAdditionalData(configuration.getProject(), rawExePath);
            return CredentialsType.WEB_DEPLOYMENT.equals(data.getRemoteConnectionType()) || CredentialsType.SSH_HOST.equals(data.getRemoteConnectionType()) || CredentialsType.VAGRANT.equals(data.getRemoteConnectionType());
        }
        catch (ExecutionException e) {
            return false;
        }
    }

    public void checkConfiguration(@NotNull NodeJsRunConfiguration configuration, String nodePath) throws RuntimeConfigurationException {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/jetbrains/nodejs/remote/NodeJSRemoteRunConfigurationExtension", "checkConfiguration"));
        }
        NodeJSRemoteInterpreterManager manager = NodeJSRemoteInterpreterManager.getInstance();
        if (manager == null) {
            throw new RuntimeConfigurationError(NodeJSRemoteInterpreterManager.noRemoteNodeInterpreterPluginMessage());
        }
        if (!NodeJSRemoteRunConfigurationExtension.isRemoteAndPasses(configuration)) {
            return;
        }
        try {
            Project project = configuration.getProject();
            RemoteSdkAdditionalData data = manager.getRemoteSdkAdditionalData(project, nodePath);
            PathMappingSettings settings = manager.setupMappings(project, data);
            if (settings.isEmpty()) {
                throw new RuntimeConfigurationError("Path mappings for selected interpreter are not set.");
            }
        }
        catch (ExecutionException e) {
            throw new RuntimeConfigurationError("Error during checking remote mappings: " + e.getMessage());
        }
    }

    protected boolean isApplicableFor(@NotNull NodeJsRunConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/jetbrains/nodejs/remote/NodeJSRemoteRunConfigurationExtension", "isApplicableFor"));
        }
        return true;
    }

    protected boolean isEnabledFor(@NotNull NodeJsRunConfiguration applicableConfiguration, @Nullable RunnerSettings runnerSettings) {
        if (applicableConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "applicableConfiguration", "com/jetbrains/nodejs/remote/NodeJSRemoteRunConfigurationExtension", "isEnabledFor"));
        }
        return true;
    }

    @Nullable
    protected NodeJSRunConfigurationExtension.RuntimeSessionHelper createLocalRuntimeSession(@NotNull NodeJsRunConfiguration runConfiguration, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/jetbrains/nodejs/remote/NodeJSRemoteRunConfigurationExtension", "createLocalRuntimeSession"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/jetbrains/nodejs/remote/NodeJSRemoteRunConfigurationExtension", "createLocalRuntimeSession"));
        }
        return null;
    }

    @Nullable
    protected NodeJSRunConfigurationExtension.RuntimeSessionHelper createRemoteRuntimeSession(final @NotNull NodeJsRunConfiguration runConfiguration, @NotNull ExecutionEnvironment environment, @NotNull NodeFileTransfer fileTransfer) throws ExecutionException {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/jetbrains/nodejs/remote/NodeJSRemoteRunConfigurationExtension", "createRemoteRuntimeSession"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/jetbrains/nodejs/remote/NodeJSRemoteRunConfigurationExtension", "createRemoteRuntimeSession"));
        }
        if (fileTransfer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileTransfer", "com/jetbrains/nodejs/remote/NodeJSRemoteRunConfigurationExtension", "createRemoteRuntimeSession"));
        }
        if (!NodeJSRemoteRunConfigurationExtension.isRemoteAndPasses(runConfiguration)) {
            return null;
        }
        return new NodeJSRunConfigurationExtension.RuntimeSessionHelper(){

            public String configureAppFilePath(File localUsualPath, String workingDirectory, NodeJSRuntimeSession executionSession) throws ExecutionException {
                return null;
            }

            public ProcessHandler createProcessHandler(GeneralCommandLine commandLine, int debugPort, List<Integer> openPorts) throws ExecutionException {
                try {
                    NodeJSRemoteInterpreterManager instance = NodeJSRemoteInterpreterManager.getInstance();
                    assert (instance != null);
                    return instance.createProcessHandler(runConfiguration.getProject(), commandLine, runConfiguration.getRawExePath(), openPorts);
                }
                catch (InterruptedException e) {
                    throw new ExecutionException((Throwable)e);
                }
            }
        };
    }

    private static class RemoteMappingsEditor<P extends NodeJsRunConfiguration>
    extends SettingsEditor<P> {
        private final P myConfiguration;
        private String myDelayedRemoteProblem;
        private Disposable myDisposable;
        private Consumer<NodeJsInterpreter> myInterpreterPathConsumer;
        private TextFieldWithBrowseButton myRemoteMappingsField;
        private JBLabel myRemoteMappingsLabel;

        public RemoteMappingsEditor(P configuration, Consumer<NodeJsInterpreterChangeListener> listenerRegistrar) {
            this.myConfiguration = configuration;
            listenerRegistrar.consume((Object)new NodeJsInterpreterChangeListener(){

                public void interpreterChanged(@Nullable NodeJsInterpreter newInterpreter) {
                    myDelayedRemoteProblem = null;
                    if (myRemoteMappingsField == null || myInterpreterPathConsumer == null) {
                        return;
                    }
                    myInterpreterPathConsumer.consume((Object)newInterpreter);
                    myRemoteMappingsLabel.setVisible(myRemoteMappingsField.isVisible());
                    this.fireEditorStateChanged();
                }
            });
        }

        protected void resetEditorFrom(@NotNull P s) {
            if (s == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/jetbrains/nodejs/remote/NodeJSRemoteRunConfigurationExtension$RemoteMappingsEditor", "resetEditorFrom"));
            }
        }

        protected void applyEditorTo(@NotNull P s) throws ConfigurationException {
            if (s == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/jetbrains/nodejs/remote/NodeJSRemoteRunConfigurationExtension$RemoteMappingsEditor", "applyEditorTo"));
            }
            if (this.myDelayedRemoteProblem != null) {
                throw new RuntimeConfigurationWarning(this.myDelayedRemoteProblem);
            }
        }

        @NotNull
        protected JComponent createEditor() {
            NodeJSRemoteInterpreterManager remoteInterpreterManager = NodeJSRemoteInterpreterManager.getInstance();
            this.myRemoteMappingsLabel = new JBLabel("Path Mappings:");
            this.myDisposable = new Disposable(){

                public void dispose() {
                }
            };
            assert (remoteInterpreterManager != null);
            Pair pair = remoteInterpreterManager.createRemoteMappingsField(this.myConfiguration.getProject(), this.myDisposable, s -> {
                this.myDelayedRemoteProblem = s;
                this.fireEditorStateChanged();
            });
            this.myRemoteMappingsField = (TextFieldWithBrowseButton)pair.getFirst();
            this.myInterpreterPathConsumer = (Consumer)pair.getSecond();
            FormBuilder formBuilder = new FormBuilder();
            formBuilder.addLabeledComponent((JComponent)this.myRemoteMappingsLabel, (JComponent)this.myRemoteMappingsField);
            JPanel jPanel = formBuilder.getPanel();
            if (jPanel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/remote/NodeJSRemoteRunConfigurationExtension$RemoteMappingsEditor", "createEditor"));
            }
            return jPanel;
        }

        protected void disposeEditor() {
            super.disposeEditor();
            if (this.myDisposable != null) {
                Disposer.dispose((Disposable)this.myDisposable);
            }
        }
    }
}

