/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.remote.docker;

import com.intellij.docker.agent.settings.DockerVolumeBindingImpl;
import com.intellij.docker.remote.DockerContainerSettings;
import com.intellij.docker.remote.DockerCredentialsHolder;
import com.intellij.docker.remote.run.runtime.RemoteDockerApplicationRuntime;
import com.intellij.execution.ExecutionException;
import com.intellij.javascript.nodejs.NodeFileTransfer;
import com.intellij.javascript.nodejs.NodeLocalFileTransfer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.ThrowableConsumer;
import com.jetbrains.nodejs.run.NodeJsRunConfiguration;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public class DockerFileTransfer
implements NodeFileTransfer {
    private final DockerCredentialsHolder myCredentials;
    private final NodeJsRunConfiguration myConfiguration;
    private final PathMappingSettings myMappings;
    private final NodeLocalFileTransfer myLocalFileTransfer;
    private RemoteDockerApplicationRuntime myContainer;

    public DockerFileTransfer(DockerCredentialsHolder credentials, NodeJsRunConfiguration configuration, PathMappingSettings mappings) {
        this.myCredentials = credentials;
        this.myConfiguration = configuration;
        this.myMappings = mappings;
        DockerContainerSettings data = (DockerContainerSettings)configuration.getCopyableUserData(DockerContainerSettings.KEY);
        if (data != null && !data.getVolumeBindings().isEmpty()) {
            for (DockerVolumeBindingImpl binding : data.getVolumeBindings()) {
                this.myMappings.add(new PathMappingSettings.PathMapping(binding.getHostPath(), binding.getContainerPath()));
            }
        }
        this.myLocalFileTransfer = new NodeLocalFileTransfer();
    }

    public List<String> listDirectoryContents(@NotNull String remoteWorkingDir) throws IOException {
        if (remoteWorkingDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteWorkingDir", "com/jetbrains/nodejs/remote/docker/DockerFileTransfer", "listDirectoryContents"));
        }
        return this.myLocalFileTransfer.listDirectoryContents(this.myMappings.convertToLocal(remoteWorkingDir));
    }

    public void copy(@NotNull String sourceDir, @NotNull Set<String> names, @NotNull String targetDir) throws IOException {
        if (sourceDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceDir", "com/jetbrains/nodejs/remote/docker/DockerFileTransfer", "copy"));
        }
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/jetbrains/nodejs/remote/docker/DockerFileTransfer", "copy"));
        }
        if (targetDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetDir", "com/jetbrains/nodejs/remote/docker/DockerFileTransfer", "copy"));
        }
        this.myLocalFileTransfer.copy(this.myMappings.convertToLocal(sourceDir), names, this.myMappings.convertToLocal(targetDir));
    }

    public void fetch(@NotNull String sourceDir, @NotNull Set<String> names, @NotNull String targetDir) throws IOException {
        if (sourceDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceDir", "com/jetbrains/nodejs/remote/docker/DockerFileTransfer", "fetch"));
        }
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/jetbrains/nodejs/remote/docker/DockerFileTransfer", "fetch"));
        }
        if (targetDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetDir", "com/jetbrains/nodejs/remote/docker/DockerFileTransfer", "fetch"));
        }
        this.myLocalFileTransfer.fetch(this.myMappings.convertToLocal(sourceDir), names, this.myMappings.convertToLocal(targetDir));
    }

    public void fetch(@NotNull String sourcePath, @NotNull String targetPath) throws IOException {
        if (sourcePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourcePath", "com/jetbrains/nodejs/remote/docker/DockerFileTransfer", "fetch"));
        }
        if (targetPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetPath", "com/jetbrains/nodejs/remote/docker/DockerFileTransfer", "fetch"));
        }
        try {
            String convertedToLocal = this.myMappings.convertToLocal(sourcePath);
            if (sourcePath.equals(convertedToLocal)) {
                if (this.myContainer == null) {
                    return;
                }
                File targetFile = new File(targetPath);
                int idx = (sourcePath = sourcePath.replace("\\", "/")).lastIndexOf("/");
                String dirPath = idx < 0 ? sourcePath : sourcePath.substring(0, idx);
                String sourceName = idx < 0 ? targetFile.getName() : sourcePath.substring(idx + 1);
                this.myContainer.downloadDirectory(dirPath, targetFile.getParentFile(), null, null);
                if (!sourceName.equals(targetFile.getName())) {
                    FileUtil.rename((File)new File(targetFile.getParentFile(), sourceName), (String)targetFile.getName());
                }
            } else {
                this.myLocalFileTransfer.fetch(convertedToLocal, this.myMappings.convertToLocal(targetPath));
            }
        }
        catch (ServerRuntimeException e) {
            throw new IOException(e);
        }
    }

    public String copyToRemoteTmpFile(@NotNull String remoteDir, String localFileName, String content) throws IOException {
        if (remoteDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteDir", "com/jetbrains/nodejs/remote/docker/DockerFileTransfer", "copyToRemoteTmpFile"));
        }
        return this.myMappings.convertToRemote(this.myLocalFileTransfer.copyToRemoteTmpFile(this.myMappings.convertToLocal(remoteDir), localFileName, content));
    }

    public String getPathForTempFile(@NotNull String remoteDir, String localFileName) throws IOException {
        if (remoteDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteDir", "com/jetbrains/nodejs/remote/docker/DockerFileTransfer", "getPathForTempFile"));
        }
        return "/tmp/a" + UUID.randomUUID() + "/" + localFileName;
    }

    public void grouped(@NotNull String title, @NotNull ThrowableConsumer<NodeFileTransfer, IOException> consumer) throws IOException {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/jetbrains/nodejs/remote/docker/DockerFileTransfer", "grouped"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/jetbrains/nodejs/remote/docker/DockerFileTransfer", "grouped"));
        }
        this.myLocalFileTransfer.grouped(title, consumer);
    }

    public void deleteRemote(@NotNull String path) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/jetbrains/nodejs/remote/docker/DockerFileTransfer", "deleteRemote"));
        }
        this.myLocalFileTransfer.deleteRemote(this.myMappings.convertToLocal(path));
    }

    public void delete(@NotNull String dir, @NotNull HashSet<String> set) throws IOException {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/jetbrains/nodejs/remote/docker/DockerFileTransfer", "delete"));
        }
        if (set == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "set", "com/jetbrains/nodejs/remote/docker/DockerFileTransfer", "delete"));
        }
        this.myLocalFileTransfer.delete(this.myMappings.convertToLocal(dir), set);
    }

    public boolean mkDir(@NotNull String remoteDir, String name) throws IOException {
        if (remoteDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteDir", "com/jetbrains/nodejs/remote/docker/DockerFileTransfer", "mkDir"));
        }
        return this.myLocalFileTransfer.mkDir(this.myMappings.convertToLocal(remoteDir), name);
    }

    public boolean isLocal() {
        return false;
    }

    public boolean hasInternalMapping() {
        return true;
    }

    public String getMappingFor(@NotNull String localPath) throws ExecutionException {
        if (localPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localPath", "com/jetbrains/nodejs/remote/docker/DockerFileTransfer", "getMappingFor"));
        }
        return this.myMappings.convertToRemote(localPath);
    }

    public void setContainer(RemoteDockerApplicationRuntime container) {
        this.myContainer = container;
    }
}

