/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.remote.docker;

import com.intellij.docker.agent.DockerAgentDeploymentConfig;
import com.intellij.docker.agent.settings.DockerVolumeBinding;
import com.intellij.docker.agent.settings.DockerVolumeBindingImpl;
import com.intellij.docker.remote.DockerContainerSettings;
import com.intellij.docker.remote.DockerCredentialsHolder;
import com.intellij.docker.remote.DockerCredentialsType;
import com.intellij.docker.remote.run.runtime.DockerAgentBuildImageConfig;
import com.intellij.docker.remote.run.runtime.DockerExecProcess;
import com.intellij.docker.remote.run.runtime.DockerUtil;
import com.intellij.docker.remote.run.runtime.RemoteDockerApplicationRuntime;
import com.intellij.docker.remote.run.runtime.RemoteDockerRuntime;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.javascript.nodejs.NodeFileTransfer;
import com.intellij.javascript.nodejs.NodeJSRemoteInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterChangeListener;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.interpreter.remote.NodeJsRemoteInterpreter;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.Consumer;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.SystemProperties;
import com.intellij.util.xmlb.XmlSerializer;
import com.jetbrains.nodejs.remote.docker.DockerFileTransfer;
import com.jetbrains.nodejs.remote.docker.NodeJSDockerRunner;
import com.jetbrains.nodejs.remote.docker.NodeJSDockerUtil;
import com.jetbrains.nodejs.remote.docker.NodeJSRunDockerContainerSettingsEditor;
import com.jetbrains.nodejs.run.NodeJSRunConfigurationExtension;
import com.jetbrains.nodejs.run.NodeJSRuntimeSession;
import com.jetbrains.nodejs.run.NodeJsRunConfiguration;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jdom.Attribute;
import org.jdom.DataConversionException;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeJSDockerRunConfigurationExtension
extends NodeJSRunConfigurationExtension {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.nodejs.remote.docker.NodeJSDockerRunConfigurationExtension");
    private static final Set<String> NAMES_TO_FILTER = new HashSet<String>(Arrays.asList("node_modules", ".idea", ".dockerignore"));
    public static final Condition<VirtualFile> VOLUMES_FILTER = new Condition<VirtualFile>(){

        public boolean value(VirtualFile file) {
            String name = file.getName();
            return !NAMES_TO_FILTER.contains(SystemInfo.isFileSystemCaseSensitive ? name : name.toLowerCase());
        }
    };

    @Nullable
    protected NodeJSRunConfigurationExtension.RuntimeSessionHelper createLocalRuntimeSession(@NotNull NodeJsRunConfiguration runConfiguration, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/jetbrains/nodejs/remote/docker/NodeJSDockerRunConfigurationExtension", "createLocalRuntimeSession"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/jetbrains/nodejs/remote/docker/NodeJSDockerRunConfigurationExtension", "createLocalRuntimeSession"));
        }
        return null;
    }

    @Nullable
    protected NodeJSRunConfigurationExtension.RuntimeSessionHelper createRemoteRuntimeSession(@NotNull NodeJsRunConfiguration runConfiguration, @NotNull ExecutionEnvironment environment, @NotNull NodeFileTransfer fileTransfer) throws ExecutionException {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/jetbrains/nodejs/remote/docker/NodeJSDockerRunConfigurationExtension", "createRemoteRuntimeSession"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/jetbrains/nodejs/remote/docker/NodeJSDockerRunConfigurationExtension", "createRemoteRuntimeSession"));
        }
        if (fileTransfer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileTransfer", "com/jetbrains/nodejs/remote/docker/NodeJSDockerRunConfigurationExtension", "createRemoteRuntimeSession"));
        }
        if (!NodeJSDockerRunConfigurationExtension.isMatchingConfiguration(runConfiguration)) {
            return null;
        }
        ParametersWorker parametersWorker = new ParametersWorker(runConfiguration);
        DockerCredentialsHolder credentials = parametersWorker.getDockerCredentialsHolder();
        if (credentials == null) {
            return null;
        }
        boolean isDebug = DefaultDebugExecutor.EXECUTOR_ID.equals(environment.getExecutor().getId());
        return new MyRuntimeSessionHelper(runConfiguration.getProject(), parametersWorker, runConfiguration, isDebug, fileTransfer);
    }

    protected void readExternal(@NotNull NodeJsRunConfiguration runConfiguration, @NotNull Element element) throws InvalidDataException {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/jetbrains/nodejs/remote/docker/NodeJSDockerRunConfigurationExtension", "readExternal"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/nodejs/remote/docker/NodeJSDockerRunConfigurationExtension", "readExternal"));
        }
        DockerContainerSettings value = (DockerContainerSettings)XmlSerializer.deserialize((Element)element, DockerContainerSettings.class);
        runConfiguration.putCopyableUserData(DockerContainerSettings.KEY, (Object)value);
        Attribute generateImage = element.getAttribute(NodeJSDockerUtil.GENERATE_IMAGE.toString());
        try {
            if (generateImage != null && Boolean.TRUE.equals(generateImage.getBooleanValue())) {
                runConfiguration.putCopyableUserData(NodeJSDockerUtil.GENERATE_IMAGE, (Object)true);
            }
        }
        catch (DataConversionException dataConversionException) {
            // empty catch block
        }
    }

    protected void writeExternal(@NotNull NodeJsRunConfiguration runConfiguration, @NotNull Element element) throws WriteExternalException {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/jetbrains/nodejs/remote/docker/NodeJSDockerRunConfigurationExtension", "writeExternal"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/nodejs/remote/docker/NodeJSDockerRunConfigurationExtension", "writeExternal"));
        }
        DockerContainerSettings data = (DockerContainerSettings)runConfiguration.getCopyableUserData(DockerContainerSettings.KEY);
        if (data != null) {
            XmlSerializer.serializeInto((Object)data, (Element)element);
        }
        if (NodeJSDockerRunConfigurationExtension.isGenerateImage(runConfiguration)) {
            element.setAttribute(NodeJSDockerUtil.GENERATE_IMAGE.toString(), String.valueOf(Boolean.TRUE));
        }
    }

    @Nullable
    public NodeFileTransfer overrideFileTransfer(@NotNull NodeJsRunConfiguration configuration) throws ExecutionException {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/jetbrains/nodejs/remote/docker/NodeJSDockerRunConfigurationExtension", "overrideFileTransfer"));
        }
        if (!NodeJSDockerRunConfigurationExtension.isMatchingConfiguration(configuration)) {
            return null;
        }
        ParametersWorker parametersWorker = new ParametersWorker(configuration);
        DockerCredentialsHolder credentials = parametersWorker.getDockerCredentialsHolder();
        if (credentials == null) {
            return null;
        }
        parametersWorker.getMappings().add(new PathMappingSettings.PathMapping(configuration.getProject().getBasePath(), "/opt/project"));
        return new DockerFileTransfer(credentials, configuration, parametersWorker.getMappings());
    }

    protected boolean isApplicableFor(@NotNull NodeJsRunConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/jetbrains/nodejs/remote/docker/NodeJSDockerRunConfigurationExtension", "isApplicableFor"));
        }
        return true;
    }

    private static boolean isMatchingConfiguration(@NotNull NodeJsRunConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/jetbrains/nodejs/remote/docker/NodeJSDockerRunConfigurationExtension", "isMatchingConfiguration"));
        }
        String rawExePath = configuration.getRawExePath();
        if (StringUtil.isEmptyOrSpaces((String)rawExePath)) {
            return false;
        }
        NodeJsInterpreterRef ref = NodeJsInterpreterRef.create((String)rawExePath);
        NodeJsRemoteInterpreter remoteInterpreter = NodeJsRemoteInterpreter.tryCast((NodeJsInterpreter)ref.resolveWithoutAliases());
        if (remoteInterpreter == null) {
            return false;
        }
        try {
            NodeJSRemoteInterpreterManager manager = NodeJSRemoteInterpreterManager.getInstance();
            assert (manager != null);
            RemoteSdkAdditionalData data = manager.getRemoteSdkAdditionalData(configuration.getProject(), rawExePath);
            return DockerCredentialsType.getInstance().equals(data.getRemoteConnectionType());
        }
        catch (ExecutionException e) {
            return false;
        }
    }

    protected boolean isEnabledFor(@NotNull NodeJsRunConfiguration applicableConfiguration, @Nullable RunnerSettings runnerSettings) {
        if (applicableConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "applicableConfiguration", "com/jetbrains/nodejs/remote/docker/NodeJSDockerRunConfigurationExtension", "isEnabledFor"));
        }
        return true;
    }

    protected boolean showEditorInMainPage(@NotNull NodeJsRunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/jetbrains/nodejs/remote/docker/NodeJSDockerRunConfigurationExtension", "showEditorInMainPage"));
        }
        return true;
    }

    @Nullable
    protected <P extends NodeJsRunConfiguration> SettingsEditor<P> createEditor(@NotNull P configuration, @NotNull Getter<NodeJsInterpreter> currentInterpreterGetter, Consumer<NodeJsInterpreterChangeListener> listenerRegistrar) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/jetbrains/nodejs/remote/docker/NodeJSDockerRunConfigurationExtension", "createEditor"));
        }
        if (currentInterpreterGetter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentInterpreterGetter", "com/jetbrains/nodejs/remote/docker/NodeJSDockerRunConfigurationExtension", "createEditor"));
        }
        return new NodeJSRunDockerContainerSettingsEditor<P>(configuration, listenerRegistrar);
    }

    public void checkConfiguration(@NotNull NodeJsRunConfiguration configuration, String nodePath) throws RuntimeConfigurationException {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/jetbrains/nodejs/remote/docker/NodeJSDockerRunConfigurationExtension", "checkConfiguration"));
        }
        if (!NodeJSDockerRunConfigurationExtension.isMatchingConfiguration(configuration)) {
            return;
        }
        if (new ParametersWorker(configuration).getDockerCredentialsHolder() == null) {
            return;
        }
        DockerContainerSettings data = (DockerContainerSettings)configuration.getCopyableUserData(DockerContainerSettings.KEY);
        if (!NodeJSDockerRunConfigurationExtension.isGenerateImage(configuration) && (data == null || data.getVolumeBindings().isEmpty())) {
            throw new RuntimeConfigurationException("Remote working directory and target file can not be determined.<br/>Currently you need to either define one or more volume bindings in Docker container settings, or choose 'Auto configure' option.");
        }
    }

    private static boolean isGenerateImage(@NotNull NodeJsRunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/jetbrains/nodejs/remote/docker/NodeJSDockerRunConfigurationExtension", "isGenerateImage"));
        }
        return Boolean.TRUE.equals(runConfiguration.getCopyableUserData(NodeJSDockerUtil.GENERATE_IMAGE));
    }

    private static VirtualFile findSubdir(final @NotNull Project project, @NotNull String name) throws ExecutionException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/remote/docker/NodeJSDockerRunConfigurationExtension", "findSubdir"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/nodejs/remote/docker/NodeJSDockerRunConfigurationExtension", "findSubdir"));
        }
        for (VirtualFile child : NodeJSDockerRunConfigurationExtension.sortByName(project.getBaseDir().getChildren())) {
            if (!child.getName().startsWith(name) || !child.isDirectory()) continue;
            return child;
        }
        final String newName = NodeJSDockerRunConfigurationExtension.findName(project.getBaseDir(), name, "");
        if (newName == null) {
            throw new ExecutionException("Can not create helpers directory locally");
        }
        return (VirtualFile)new WriteCommandAction<VirtualFile>(project, new PsiFile[0]){

            protected void run(@NotNull Result<VirtualFile> result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/nodejs/remote/docker/NodeJSDockerRunConfigurationExtension$2", "run"));
                }
                result.setResult((Object)project.getBaseDir().createChildDirectory((Object)this, newName));
            }
        }.execute().getResultObject();
    }

    static VirtualFile[] sortByName(VirtualFile[] children) {
        Arrays.sort(children, new Comparator<VirtualFile>(){

            @Override
            public int compare(VirtualFile o1, VirtualFile o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return children;
    }

    static String findName(@NotNull VirtualFile base, @NotNull String baseName, @NotNull String extensionWithDot) {
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "com/jetbrains/nodejs/remote/docker/NodeJSDockerRunConfigurationExtension", "findName"));
        }
        if (baseName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseName", "com/jetbrains/nodejs/remote/docker/NodeJSDockerRunConfigurationExtension", "findName"));
        }
        if (extensionWithDot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensionWithDot", "com/jetbrains/nodejs/remote/docker/NodeJSDockerRunConfigurationExtension", "findName"));
        }
        for (int i = 0; i < 1000; ++i) {
            String newName = baseName + (i == 0 ? "" : String.valueOf(i)) + extensionWithDot;
            if (base.findChild(newName) != null) continue;
            return newName;
        }
        return null;
    }

    private static class HelperFileCreator {
        @NotNull
        private final String myTemplateName;
        @NotNull
        private final String myTemplateContents;
        private VirtualFile myBase;

        private HelperFileCreator(@NotNull String templateName, @NotNull String templateContents) {
            if (templateName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateName", "com/jetbrains/nodejs/remote/docker/NodeJSDockerRunConfigurationExtension$HelperFileCreator", "<init>"));
            }
            if (templateContents == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateContents", "com/jetbrains/nodejs/remote/docker/NodeJSDockerRunConfigurationExtension$HelperFileCreator", "<init>"));
            }
            this.myTemplateName = templateName;
            this.myTemplateContents = templateContents;
        }

        public HelperFileCreator withSubdir(@NotNull VirtualFile dir) {
            if (dir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/jetbrains/nodejs/remote/docker/NodeJSDockerRunConfigurationExtension$HelperFileCreator", "withSubdir"));
            }
            this.myBase = dir;
            return this;
        }

        public File execute(@NotNull Project project) throws ExecutionException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/remote/docker/NodeJSDockerRunConfigurationExtension$HelperFileCreator", "execute"));
            }
            this.myBase = this.myBase == null ? project.getBaseDir() : this.myBase;
            int idx = this.myTemplateName.lastIndexOf(46);
            String name = idx > 0 ? this.myTemplateName.substring(0, idx) : this.myTemplateName;
            String extension = idx > 0 ? this.myTemplateName.substring(idx + 1) : "";
            try {
                VirtualFile[] children;
                for (VirtualFile child : children = NodeJSDockerRunConfigurationExtension.sortByName(this.myBase.getChildren())) {
                    if (!child.getName().startsWith(name) || !this.myTemplateContents.equals(FileUtil.loadFile((File)new File(child.getPath())))) continue;
                    return new File(child.getPath());
                }
                return this.createUtilFile(name, extension, new ByteArrayInputStream(this.myTemplateContents.getBytes(CharsetToolkit.UTF8_CHARSET)));
            }
            catch (IOException e) {
                throw new ExecutionException((Throwable)e);
            }
        }

        private File createUtilFile(@NotNull String baseName, @NotNull String extension, @NotNull InputStream is) throws ExecutionException {
            File file;
            if (baseName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseName", "com/jetbrains/nodejs/remote/docker/NodeJSDockerRunConfigurationExtension$HelperFileCreator", "createUtilFile"));
            }
            if (extension == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/jetbrains/nodejs/remote/docker/NodeJSDockerRunConfigurationExtension$HelperFileCreator", "createUtilFile"));
            }
            if (is == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "is", "com/jetbrains/nodejs/remote/docker/NodeJSDockerRunConfigurationExtension$HelperFileCreator", "createUtilFile"));
            }
            try {
                String newName = NodeJSDockerRunConfigurationExtension.findName(this.myBase, baseName, extension.isEmpty() ? "" : "." + extension);
                if (newName == null) {
                    File file2 = null;
                    return file2;
                }
                File toFile = new File(this.myBase.getPath(), newName);
                try (FileOutputStream fos = new FileOutputStream(toFile);){
                    FileUtil.copy((InputStream)is, (OutputStream)fos);
                }
                file = toFile;
            }
            catch (IOException e) {
                throw new ExecutionException((Throwable)e);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            return file;
        }
    }

    private static class MyRuntimeSessionHelper
    implements NodeJSRunConfigurationExtension.RuntimeSessionHelper {
        public static final String DOCKERFILE = "JetBrains.Dockerfile";
        public static final String SHELL = "start.sh";
        private static final String JB_DIR = "JetBrainsHelpers";
        private static final String NODE_MODULES_MAP_FOLDER = "NodeJS.Docker.Node.modules.map.folder";
        private static final long TIMEOUT = TimeUnit.SECONDS.toMillis(60L);
        @NotNull
        private final Project myProject;
        @NotNull
        private final ParametersWorker myParametersWorker;
        @NotNull
        private final NodeJsRunConfiguration myRunConfiguration;
        private final NodeJSDockerRunner.DockerInputParameters myDockerInputParameters;
        @Nullable
        private File myLocalDockerFile;
        @Nullable
        private File myLocalShellFile;
        private final boolean myGenerateImage;
        private VirtualFile myPackageJson;
        private DockerFileTransfer myFileTransfer;

        public MyRuntimeSessionHelper(@NotNull Project project, @NotNull ParametersWorker parametersWorker, @NotNull NodeJsRunConfiguration runConfiguration, boolean isDebug, @NotNull NodeFileTransfer fileTransfer) throws ExecutionException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/remote/docker/NodeJSDockerRunConfigurationExtension$MyRuntimeSessionHelper", "<init>"));
            }
            if (parametersWorker == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parametersWorker", "com/jetbrains/nodejs/remote/docker/NodeJSDockerRunConfigurationExtension$MyRuntimeSessionHelper", "<init>"));
            }
            if (runConfiguration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/jetbrains/nodejs/remote/docker/NodeJSDockerRunConfigurationExtension$MyRuntimeSessionHelper", "<init>"));
            }
            if (fileTransfer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileTransfer", "com/jetbrains/nodejs/remote/docker/NodeJSDockerRunConfigurationExtension$MyRuntimeSessionHelper", "<init>"));
            }
            this.myProject = project;
            this.myParametersWorker = parametersWorker;
            this.myRunConfiguration = runConfiguration;
            this.myGenerateImage = NodeJSDockerRunConfigurationExtension.isGenerateImage(runConfiguration);
            this.myDockerInputParameters = new NodeJSDockerRunner.DockerInputParameters(this.myProject, this.myRunConfiguration, parametersWorker.getDockerCredentialsHolder());
            this.createHelperFilesUnderProjectRoot();
            if (fileTransfer instanceof DockerFileTransfer) {
                this.myFileTransfer = (DockerFileTransfer)fileTransfer;
            }
        }

        @Nullable
        public String getDebugHost() {
            return this.myDockerInputParameters.myDockerHost;
        }

        public String configureAppFilePath(File localUsualPath, String workingDirectory, NodeJSRuntimeSession executionSession) throws ExecutionException {
            return null;
        }

        public ProcessHandler createProcessHandler(GeneralCommandLine commandLine, int debugPort, List<Integer> openPorts) throws ExecutionException {
            NodeJSDockerRunner runner = new NodeJSDockerRunner(this.myDockerInputParameters);
            if (this.myGenerateImage) {
                UsageTrigger.trigger((String)"node.js.docker.generated.run");
                if (!((Boolean)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                    ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                    if (indicator != null) {
                        indicator.setIndeterminate(true);
                    }
                    DockerVolumeBindingImpl hardcodedBinding = NodeJSRunDockerContainerSettingsEditor.createHardcodedBinding(this.myProject);
                    runner.addVolumeMapping((DockerVolumeBinding)hardcodedBinding);
                    if (this.myLocalDockerFile != null && this.myLocalShellFile != null) {
                        String nodeModules = this.findNodeModules();
                        runner.withImage(this.buildNewImage(this.myDockerInputParameters.myDockerRuntime, true));
                        if (this.myLocalShellFile != null) {
                            FileUtil.delete((File)this.myLocalShellFile);
                        }
                        if (nodeModules != null) {
                            try {
                                runner.addTmpVolumeMapping(nodeModules, this.getTmpMappingPathForNodeModules(), this.myProject);
                            }
                            catch (IOException e) {
                                throw new ExecutionException((Throwable)e);
                            }
                        }
                        runner.withRemoteInterpreter("/tmp/project_modules/start.sh");
                    } else {
                        runner.withImage(this.myParametersWorker.getDockerCredentialsHolder().getImageName());
                    }
                    return true;
                }, "Building Project Image", true, this.myProject)).booleanValue()) {
                    throw new ProcessCanceledException();
                }
            } else {
                UsageTrigger.trigger((String)"node.js.docker.custom.run");
                runner.withImage(this.myParametersWorker.getDockerCredentialsHolder().getImageName());
            }
            DockerExecProcess process = runner.execute(commandLine, openPorts);
            if (this.myFileTransfer != null) {
                this.myFileTransfer.setContainer(process.getApplicationRuntime());
            }
            return new KillableColoredProcessHandler((Process)process, commandLine.getCommandLineString());
        }

        @NotNull
        private String getTmpMappingPathForNodeModules() throws IOException {
            PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
            String tmpPath = propertiesComponent.getValue(NODE_MODULES_MAP_FOLDER);
            if (tmpPath == null || !new File(tmpPath).isDirectory()) {
                File tmpDir = new File(PathManager.getTempPath());
                File homeDir = new File(SystemProperties.getUserHome());
                tmpPath = FileUtil.createTempDirectory((File)(FileUtil.isAncestor((File)homeDir, (File)tmpDir, (boolean)false) ? tmpDir : homeDir), (String)"node_modules", null, (boolean)true).getAbsolutePath();
                propertiesComponent.setValue(NODE_MODULES_MAP_FOLDER, tmpPath);
            }
            String string = tmpPath;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/remote/docker/NodeJSDockerRunConfigurationExtension$MyRuntimeSessionHelper", "getTmpMappingPathForNodeModules"));
            }
            return string;
        }

        @Nullable
        private String findNodeModules() {
            VirtualFile parent;
            VirtualFile nodeModules;
            if (this.myPackageJson != null && (nodeModules = (parent = this.myPackageJson.getParent()).findChild("node_modules")) != null) {
                return nodeModules.getPath();
            }
            return null;
        }

        private String buildNewImage(RemoteDockerRuntime dockerRuntime, boolean firstTime) throws ExecutionException {
            String tag = FileUtil.sanitizeFileName((String)StringUtil.toLowerCase((String)this.myProject.getName()));
            try {
                assert (this.myLocalDockerFile != null);
                DockerAgentBuildImageConfig config = new DockerAgentBuildImageConfig(tag, this.myLocalDockerFile, false);
                RemoteDockerApplicationRuntime applicationRuntime = RemoteDockerApplicationRuntime.create((RemoteDockerRuntime)dockerRuntime, (DockerAgentDeploymentConfig)config);
                return applicationRuntime.getAgentApplication().getImageId();
            }
            catch (ServerRuntimeException e) {
                LOG.info((Throwable)e);
                if (firstTime && DockerUtil.isCanNotRetrieveImageIdCause((String)e.getMessage())) {
                    LOG.info(String.format("Doing the second attempt to build image '%s'", tag));
                    try {
                        Thread.sleep(TIMEOUT);
                    }
                    catch (InterruptedException e1) {
                        throw new RuntimeException(e1);
                    }
                    return this.buildNewImage(dockerRuntime, false);
                }
                throw new ExecutionException("Problem during building project image: " + e.getMessage(), (Throwable)e);
            }
        }

        private void createHelperFilesUnderProjectRoot() throws ExecutionException {
            try {
                if (this.myGenerateImage) {
                    this.myPackageJson = this.findPackageJson();
                    if (this.myPackageJson == null) {
                        return;
                    }
                    String shellContents = this.createShellScriptContents();
                    this.myLocalShellFile = new HelperFileCreator(SHELL, shellContents).execute(this.myProject);
                    FileUtil.setExecutableAttribute((String)this.myLocalShellFile.getAbsolutePath(), (boolean)true);
                    if (this.myLocalShellFile == null) {
                        throw new ExecutionException("Can not create start.sh");
                    }
                    String contents = this.createDockerfileContents();
                    this.myLocalDockerFile = new HelperFileCreator(DOCKERFILE, contents).execute(this.myProject);
                    if (this.myLocalDockerFile == null) {
                        throw new ExecutionException("Can not create JetBrains.Dockerfile");
                    }
                }
            }
            catch (IOException e) {
                throw new ExecutionException((Throwable)e);
            }
        }

        private String createDockerfileContents() throws ExecutionException {
            assert (this.myLocalShellFile != null);
            return "# Created by " + ApplicationNamesInfo.getInstance().getFullProductName() + "\nFROM " + this.myParametersWorker.getDockerCredentialsHolder().getImageName() + "\nWORKDIR /tmp/project_modules\nCOPY package.json /tmp/project_modules/package.json\nRUN npm install .\nCOPY " + this.myLocalShellFile.getName() + " /tmp/project_modules/" + SHELL;
        }

        private String createShellScriptContents() {
            return "#!/bin/sh\n# Created by " + ApplicationNamesInfo.getInstance().getFullProductName() + "\ncp -r -L /tmp/project_modules/node_modules " + "/opt/project" + " || (echo 'Can not copy node_modules from image, installing locally' && npm --no-bin-links install .)\n" + this.myDockerInputParameters.mySdkAdditionalData.getInterpreterPath() + " \"$@\"";
        }

        private VirtualFile findPackageJson() throws ExecutionException {
            File ioWorkingDirectory = new File(this.myRunConfiguration.getWorkingDirectory());
            VirtualFile vfWorkingDirectory = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(ioWorkingDirectory);
            if (vfWorkingDirectory == null) {
                throw new ExecutionException("Can not find working directory: " + ioWorkingDirectory.getPath());
            }
            VirtualFile packageJson = vfWorkingDirectory.findChild("package.json");
            if (packageJson == null && !FileUtil.filesEqual((File)ioWorkingDirectory, (File)new File(this.myProject.getBasePath()))) {
                return this.myProject.getBaseDir().findChild("package.json");
            }
            return packageJson;
        }
    }

    static class ParametersWorker {
        private final Project myProject;
        private RemoteSdkAdditionalData mySdkAdditionalData;
        private DockerCredentialsHolder myDockerCredentialsHolder;
        private PathMappingSettings myMappings;

        public ParametersWorker(@NotNull NodeJsRunConfiguration configuration) {
            if (configuration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/jetbrains/nodejs/remote/docker/NodeJSDockerRunConfigurationExtension$ParametersWorker", "<init>"));
            }
            this.myProject = configuration.getProject();
            String rawExePath = configuration.getRawExePath();
            if (StringUtil.isEmptyOrSpaces((String)rawExePath)) {
                return;
            }
            NodeJsInterpreterRef ref = NodeJsInterpreterRef.create((String)rawExePath);
            NodeJsRemoteInterpreter remoteInterpreter = NodeJsRemoteInterpreter.tryCast((NodeJsInterpreter)ref.resolveWithoutAliases());
            if (remoteInterpreter == null) {
                return;
            }
            try {
                NodeJSRemoteInterpreterManager manager = NodeJSRemoteInterpreterManager.getInstance();
                assert (manager != null);
                this.mySdkAdditionalData = manager.getRemoteSdkAdditionalData(this.myProject, rawExePath);
                this.myDockerCredentialsHolder = DockerCredentialsHolder.tryGetDockerCredentials((RemoteSdkAdditionalData)this.mySdkAdditionalData);
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }

        public PathMappingSettings getMappings() throws ExecutionException {
            if (this.myMappings != null) {
                return this.myMappings;
            }
            this.myMappings = NodeJSRemoteInterpreterManager.getInstance().setupMappings(this.myProject, this.mySdkAdditionalData);
            return this.myMappings;
        }

        public RemoteSdkAdditionalData getSdkAdditionalData() {
            return this.mySdkAdditionalData;
        }

        public DockerCredentialsHolder getDockerCredentialsHolder() {
            return this.myDockerCredentialsHolder;
        }
    }
}

