/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.remote.docker;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.agent.settings.DockerPortBinding;
import com.intellij.docker.agent.settings.DockerPortBindingImpl;
import com.intellij.docker.agent.settings.DockerVolumeBinding;
import com.intellij.docker.agent.settings.DockerVolumeBindingImpl;
import com.intellij.docker.remote.DockerContainerSettings;
import com.intellij.docker.remote.DockerCredentialsHolder;
import com.intellij.docker.remote.run.common.EnvsBuilder;
import com.intellij.docker.remote.run.common.ExtraHostsBuilder;
import com.intellij.docker.remote.run.common.PortsBuilder;
import com.intellij.docker.remote.run.common.VolumesBuilder;
import com.intellij.docker.remote.run.runtime.DockerAgentDeploymentConfigImpl;
import com.intellij.docker.remote.run.runtime.DockerExecProcess;
import com.intellij.docker.remote.run.runtime.DockerUtil;
import com.intellij.docker.remote.run.runtime.RemoteDockerRuntime;
import com.intellij.docker.remote.run.runtime.WrappedInternalServerErrorException;
import com.intellij.docker.remote.run.runtime.WrappedNotFoundException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.javascript.nodejs.NodeJSRemoteInterpreterManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.nodejs.remote.docker.NodeJSDockerUtil;
import com.jetbrains.nodejs.run.NodeJsRunConfiguration;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class NodeJSDockerRunner {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.nodejs.remote.NodeJSDockerUtil");
    @NotNull
    private final ContainerData myContainerData;
    @NotNull
    private final DockerInputParameters myDockerInputParameters;
    private String myRemoteInterpreter;

    public NodeJSDockerRunner(@NotNull DockerInputParameters dockerInputParameters) {
        if (dockerInputParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dockerInputParameters", "com/jetbrains/nodejs/remote/docker/NodeJSDockerRunner", "<init>"));
        }
        this.myDockerInputParameters = dockerInputParameters;
        this.myContainerData = new ContainerData();
        this.myRemoteInterpreter = null;
    }

    public NodeJSDockerRunner withImage(@NotNull String imageName) {
        if (imageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "imageName", "com/jetbrains/nodejs/remote/docker/NodeJSDockerRunner", "withImage"));
        }
        this.myContainerData.myImageName = imageName;
        return this;
    }

    public void addVolumeMapping(DockerVolumeBinding binding) {
        if (this.containsBinding(binding)) {
            return;
        }
        String hostPath = NodeJSDockerRunner.convertToDockerPath(binding.getHostPath());
        String containerPath = binding.getContainerPath();
        this.myContainerData.myVolumesBuilder.addBoundVolume(containerPath, hostPath, binding.isReadOnly());
        this.myDockerInputParameters.myPathMappingSettings.add(new PathMappingSettings.PathMapping(DockerUtil.toHostPath((String)hostPath), containerPath));
    }

    private boolean containsBinding(DockerVolumeBinding newBinding) {
        for (DockerVolumeBinding binding : this.myContainerData.myVolumesBuilder.build()) {
            if (!NodeJSDockerRunner.convertToDockerPath(StringUtil.notNullize((String)binding.getHostPath())).equals(NodeJSDockerRunner.convertToDockerPath(StringUtil.notNullize((String)newBinding.getHostPath()))) || !StringUtil.notNullize((String)binding.getContainerPath()).equals(StringUtil.notNullize((String)newBinding.getContainerPath()))) continue;
            return true;
        }
        return false;
    }

    public static String convertToDockerPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/jetbrains/nodejs/remote/docker/NodeJSDockerRunner", "convertToDockerPath"));
        }
        return DockerUtil.toUnixPath((String)FileUtil.toSystemIndependentName((String)path));
    }

    public void addTmpVolumeMapping(@NotNull String localPath, @NotNull String localTmpPath, Project project) throws IOException {
        if (localPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localPath", "com/jetbrains/nodejs/remote/docker/NodeJSDockerRunner", "addTmpVolumeMapping"));
        }
        if (localTmpPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localTmpPath", "com/jetbrains/nodejs/remote/docker/NodeJSDockerRunner", "addTmpVolumeMapping"));
        }
        String remote = this.myDockerInputParameters.myPathMappingSettings.convertToRemote(localPath);
        this.myContainerData.myVolumesBuilder.addBoundVolume(remote, DockerUtil.toUnixPath((String)FileUtil.toSystemIndependentName((String)localTmpPath)), false);
    }

    public NodeJSDockerRunner withRemoteInterpreter(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/jetbrains/nodejs/remote/docker/NodeJSDockerRunner", "withRemoteInterpreter"));
        }
        this.myRemoteInterpreter = path;
        return this;
    }

    public DockerExecProcess execute(@NotNull GeneralCommandLine commandLine, List<Integer> ports) throws RemoteSdkException {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/jetbrains/nodejs/remote/docker/NodeJSDockerRunner", "execute"));
        }
        this.myContainerData.myVolumesBuilder.addBoundVolumes((Iterable)this.myDockerInputParameters.myContainerSettings.getVolumeBindings());
        DockerAgentDeploymentConfigImpl config = new DockerAgentDeploymentConfigImpl(this.myContainerData.myImageName, this.myContainerData.myVolumesBuilder.build());
        this.prepareCreateContainerCommandFromCommandLine(config, commandLine);
        ArrayList<DockerPortBinding> portBindings = new ArrayList<DockerPortBinding>();
        this.prepareCreateContainerCommandFromContainerSettings(config, portBindings);
        if (!(this.myDockerInputParameters.myContainerSettings.isPublishAllPorts() || ports.isEmpty() && portBindings.isEmpty())) {
            NodeJSDockerRunner.addPortsMappings(config, ports, portBindings);
        }
        try {
            RemoteDockerRuntime dockerRuntime = this.myDockerInputParameters.myDockerRuntime;
            return DockerExecProcess.Factory.startProcessWithRemove((RemoteDockerRuntime)dockerRuntime, (DockerAgentDeploymentConfigImpl)config);
        }
        catch (WrappedNotFoundException e) {
            throw DockerUtil.propagateNotFoundException((ServerRuntimeException)((Object)e), (String)this.myContainerData.myImageName);
        }
        catch (WrappedInternalServerErrorException e) {
            throw DockerUtil.propagateInternalServerErrorException((ServerRuntimeException)((Object)e));
        }
        catch (ServerRuntimeException | IOException e) {
            throw DockerUtil.propagateRemoteSdkException((Throwable)e);
        }
    }

    private static void addPortsMappings(@NotNull DockerAgentDeploymentConfigImpl config, @NotNull List<Integer> ports, List<DockerPortBinding> portBindings) {
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/jetbrains/nodejs/remote/docker/NodeJSDockerRunner", "addPortsMappings"));
        }
        if (ports == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ports", "com/jetbrains/nodejs/remote/docker/NodeJSDockerRunner", "addPortsMappings"));
        }
        portBindings.addAll(ContainerUtil.map(ports, port -> {
            DockerPortBindingImpl portBinding = new DockerPortBindingImpl();
            portBinding.setContainerPort(port.intValue());
            portBinding.setHostPort(port);
            return portBinding;
        }));
        PortsBuilder portsBuilder = PortsBuilder.builder();
        portsBuilder.addPortBindings(portBindings);
        config.withPortBindings(portsBuilder.buildPortBindings());
        config.withExposedPorts(portsBuilder.buildExposedPorts());
    }

    private void prepareCreateContainerCommandFromCommandLine(@NotNull DockerAgentDeploymentConfigImpl config, @NotNull GeneralCommandLine commandLine) {
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/jetbrains/nodejs/remote/docker/NodeJSDockerRunner", "prepareCreateContainerCommandFromCommandLine"));
        }
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/jetbrains/nodejs/remote/docker/NodeJSDockerRunner", "prepareCreateContainerCommandFromCommandLine"));
        }
        File directory = commandLine.getWorkDirectory();
        if (directory != null) {
            config.withWorkingDir(DockerUtil.toUnixPath((String)directory.getPath()));
        }
        ArrayList<String> cmd = new ArrayList<String>();
        if (this.myRemoteInterpreter == null) {
            cmd.add(this.myDockerInputParameters.mySdkAdditionalData.getInterpreterPath());
        } else {
            cmd.add("/bin/sh");
            cmd.add(this.myRemoteInterpreter);
        }
        cmd.addAll(commandLine.getParametersList().getList());
        config.withCommand(ArrayUtil.toStringArray(cmd));
        this.myContainerData.myEnvironmentBuilder.addEnvs(commandLine.getEnvironment()).addEnv("JETBRAINS_REMOTE_RUN", "1");
    }

    private void prepareCreateContainerCommandFromContainerSettings(@NotNull DockerAgentDeploymentConfigImpl config, List<DockerPortBinding> ports) {
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/jetbrains/nodejs/remote/docker/NodeJSDockerRunner", "prepareCreateContainerCommandFromContainerSettings"));
        }
        this.myContainerData.myEnvironmentBuilder.addEnvs(this.myDockerInputParameters.myContainerSettings.getEnvVars());
        config.withEnvs(this.myContainerData.myEnvironmentBuilder.withPassParentEnvironment(true).buildEnvs());
        if (this.myDockerInputParameters.myContainerSettings.isPublishAllPorts()) {
            config.withPublishAllPorts(true);
        } else {
            ports.addAll(this.myDockerInputParameters.myContainerSettings.getPortBindings());
        }
        if (this.myDockerInputParameters.myContainerSettings.isNetworkDisabled()) {
            config.withNetworkDisabled(true);
        } else if (StringUtil.isNotEmpty((String)this.myDockerInputParameters.myContainerSettings.getNetworkMode())) {
            config.withNetworkMode(this.myDockerInputParameters.myContainerSettings.getNetworkMode());
        }
        config.withLinks(this.myDockerInputParameters.myContainerSettings.getLinks());
        config.withExtraHosts(ExtraHostsBuilder.builder().addExtraHosts(this.myDockerInputParameters.myContainerSettings.getExtraHosts()).build());
        List bindings = this.myDockerInputParameters.myContainerSettings.getVolumeBindings();
        for (DockerVolumeBindingImpl binding : bindings) {
            this.addVolumeMapping((DockerVolumeBinding)binding);
        }
    }

    private static class ContainerData {
        private String myImageName;
        private final VolumesBuilder myVolumesBuilder = VolumesBuilder.builder();
        private final EnvsBuilder myEnvironmentBuilder = EnvsBuilder.builder();
    }

    static class DockerInputParameters {
        @NotNull
        final RemoteSdkAdditionalData mySdkAdditionalData;
        @NotNull
        final DockerContainerSettings myContainerSettings;
        @NotNull
        final RemoteDockerRuntime myDockerRuntime;
        @NotNull
        final String myDockerHost;
        @NotNull
        final PathMappingSettings myPathMappingSettings;
        @NotNull
        final Project myProject;
        @NotNull
        final VolumesBuilder myVolumesBuilder;

        public DockerInputParameters(@NotNull Project project, @NotNull NodeJsRunConfiguration configuration, @NotNull DockerCredentialsHolder credentials) throws ExecutionException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/remote/docker/NodeJSDockerRunner$DockerInputParameters", "<init>"));
            }
            if (configuration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/jetbrains/nodejs/remote/docker/NodeJSDockerRunner$DockerInputParameters", "<init>"));
            }
            if (credentials == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "credentials", "com/jetbrains/nodejs/remote/docker/NodeJSDockerRunner$DockerInputParameters", "<init>"));
            }
            this.myProject = project;
            String rawExePath = configuration.getRawExePath();
            NodeJSRemoteInterpreterManager manager = NodeJSRemoteInterpreterManager.getInstance();
            assert (manager != null);
            this.mySdkAdditionalData = manager.getRemoteSdkAdditionalData(project, rawExePath);
            DockerContainerSettings containerSettings = (DockerContainerSettings)configuration.getCopyableUserData(DockerContainerSettings.KEY);
            if (containerSettings == null) {
                containerSettings = new DockerContainerSettings();
                containerSettings.setVersion(1);
            }
            this.myContainerSettings = containerSettings;
            DockerCloudConfiguration account = NodeJSDockerUtil.getAccount(credentials);
            this.myDockerHost = DockerUtil.getDockerHost((DockerCloudConfiguration)account);
            try {
                this.myDockerRuntime = RemoteDockerRuntime.create((DockerCloudConfiguration)account, (Project)this.myProject);
            }
            catch (ServerRuntimeException e) {
                throw new ExecutionException((Throwable)e);
            }
            this.myPathMappingSettings = manager.setupMappings(project, this.mySdkAdditionalData);
            this.myVolumesBuilder = VolumesBuilder.builder();
            List bindings = this.myContainerSettings.getVolumeBindings();
            for (DockerVolumeBindingImpl binding : bindings) {
                this.myVolumesBuilder.addBoundVolume(binding.getContainerPath(), binding.getHostPath(), binding.isReadOnly());
            }
        }
    }
}

