/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.javascript.debugger.JavaScriptDebuggerConsoleExecuteActionHandler;
import com.intellij.javascript.debugger.VariablesHolder;
import com.intellij.lang.javascript.psi.impl.JSExpressionCodeFragmentImpl;
import com.intellij.lang.javascript.psi.resolve.ImplicitJSVariableImpl;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JavaScriptConsolePsiFile
extends JSExpressionCodeFragmentImpl {
    private final JavaScriptDebuggerConsoleExecuteActionHandler consoleExecuteActionHandler;

    public JavaScriptConsolePsiFile(@NotNull Project project, @NotNull VirtualFile file, @NotNull JavaScriptDebuggerConsoleExecuteActionHandler consoleExecuteActionHandler) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/debugger/JavaScriptConsolePsiFile", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/debugger/JavaScriptConsolePsiFile", "<init>"));
        }
        if (consoleExecuteActionHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleExecuteActionHandler", "com/intellij/javascript/debugger/JavaScriptConsolePsiFile", "<init>"));
        }
        super(project, file, null, true);
        this.consoleExecuteActionHandler = consoleExecuteActionHandler;
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        String requiredName;
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/javascript/debugger/JavaScriptConsolePsiFile", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/javascript/debugger/JavaScriptConsolePsiFile", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/javascript/debugger/JavaScriptConsolePsiFile", "processDeclarations"));
        }
        if (!super.processDeclarations(processor2, state, lastParent, place)) {
            return false;
        }
        if (lastParent == null) {
            return true;
        }
        if (processor2 instanceof ResolveProcessor && (requiredName = ((ResolveProcessor)processor2).getName()) != null) {
            String typeName = this.consoleExecuteActionHandler.getLocalVariables().getTypeByName(requiredName);
            if (typeName == null) {
                typeName = this.consoleExecuteActionHandler.getGlobalVariables().getTypeByName(requiredName);
            }
            return typeName == null || processor2.execute((PsiElement)JavaScriptConsolePsiFile.createImplicitPsiVariable(lastParent, requiredName, typeName), state);
        }
        return !JavaScriptConsolePsiFile.processVariables(processor2, state, lastParent, this.consoleExecuteActionHandler.getLocalVariables()) && !JavaScriptConsolePsiFile.processVariables(processor2, state, lastParent, this.consoleExecuteActionHandler.getGlobalVariables());
    }

    private static boolean processVariables(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, @NotNull PsiElement lastParent, @NotNull VariablesHolder variablesHolder) {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/javascript/debugger/JavaScriptConsolePsiFile", "processVariables"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/javascript/debugger/JavaScriptConsolePsiFile", "processVariables"));
        }
        if (lastParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lastParent", "com/intellij/javascript/debugger/JavaScriptConsolePsiFile", "processVariables"));
        }
        if (variablesHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variablesHolder", "com/intellij/javascript/debugger/JavaScriptConsolePsiFile", "processVariables"));
        }
        for (LookupElement variant : variablesHolder.getLookupElements()) {
            String name = variant.getLookupString();
            String typeName = variablesHolder.getTypeByName(name);
            assert (typeName != null);
            if (processor2.execute((PsiElement)JavaScriptConsolePsiFile.createImplicitPsiVariable(lastParent, name, typeName), state)) continue;
            return true;
        }
        return false;
    }

    private static ImplicitJSVariableImpl createImplicitPsiVariable(@NotNull PsiElement parent, @NotNull String name, @NotNull String typeName) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/javascript/debugger/JavaScriptConsolePsiFile", "createImplicitPsiVariable"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/javascript/debugger/JavaScriptConsolePsiFile", "createImplicitPsiVariable"));
        }
        if (typeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeName", "com/intellij/javascript/debugger/JavaScriptConsolePsiFile", "createImplicitPsiVariable"));
        }
        return new ImplicitJSVariableImpl(name, typeName, parent);
    }
}

