/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.javascript.debugger.DebuggableFileFinder;
import com.intellij.javascript.debugger.FilePathRegExpCreator;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.JavaScriptDebugProcessKt;
import com.intellij.javascript.debugger.JavaScriptLineBreakpointManager;
import com.intellij.javascript.debugger.JavaScriptLineBreakpointManagerKt;
import com.intellij.javascript.debugger.PsiVisitorKt;
import com.intellij.javascript.debugger.sourcemap.SourceMapHelperKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.intellij.util.Url;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.Breakpoint;
import org.jetbrains.debugger.BreakpointManager;
import org.jetbrains.debugger.BreakpointTarget;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.DebugProcessImpl;
import org.jetbrains.debugger.LineBreakpointManager;
import org.jetbrains.debugger.Location;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.ScriptRegExpBreakpointTarget;
import org.jetbrains.debugger.SourceInfo;
import org.jetbrains.debugger.SuspendContext;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.sourcemap.SourceMap;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001;B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\"\u0010\u0014\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u0018H\u0003J.\u0010\u001d\u001a\u00020\u00162\f\u0010\u0011\u001a\b\u0012\u0002\b\u0003\u0018\u00010\n2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u0013H\u0014J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000e0 2\u0006\u0010!\u001a\u00020\"H\u0014J\u0018\u0010#\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0 2\u0006\u0010$\u001a\u00020\u000eJ\"\u0010%\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020&H\u0002J$\u0010'\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0 2\n\u0010(\u001a\u0006\u0012\u0002\b\u00030)2\u0006\u0010*\u001a\u00020\u001cJ\u0010\u0010+\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J\u0010\u0010,\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\"\u0010-\u001a\u00020\u00102\u0006\u0010.\u001a\u00020\u00072\u0006\u0010/\u001a\u00020\u001c2\n\b\u0002\u00100\u001a\u0004\u0018\u00010\u001cJ\u0016\u00101\u001a\u00020\u00102\u0006\u0010.\u001a\u00020\u00072\u0006\u0010/\u001a\u00020\u001cJ0\u00102\u001a\b\u0012\u0004\u0012\u0002030 2\u0006\u0010.\u001a\u00020\u00072\u0006\u00104\u001a\u0002052\b\u00106\u001a\u0004\u0018\u0001072\b\u00108\u001a\u0004\u0018\u000109J\u001a\u0010:\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010.\u001a\u00020\u0007RC\u0010\u0005\u001a7\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012 \u0012\u001e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n \b*\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0018\u00010\t0\t0\u0006\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\f\u001a\u0015\u0012\f\u0012\n \b*\u0004\u0018\u00010\u000e0\u000e0\r\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/intellij/javascript/debugger/JavaScriptLineBreakpointManager;", "Lorg/jetbrains/debugger/LineBreakpointManager;", "debugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "(Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;)V", "actualLocationNotFound", "Ljava/util/concurrent/ConcurrentMap;", "Lorg/jetbrains/debugger/Vm;", "kotlin.jvm.PlatformType", "", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "Lorg/jetbrains/annotations/NotNull;", "anyFirstLineBreakpoints", "Lcom/intellij/util/containers/ConcurrentList;", "Lorg/jetbrains/debugger/Breakpoint;", "beforeBreakpointRemoved", "", "breakpoint", "disable", "", "checkDuplicates", "newTarget", "Lorg/jetbrains/debugger/BreakpointTarget;", "location", "Lorg/jetbrains/debugger/Location;", "breakpointManager", "Lorg/jetbrains/debugger/BreakpointManager;", "createNameRegExp", "", "createTarget", "isTemporary", "doRunToLocation", "", "position", "Lcom/intellij/xdebugger/XSourcePosition;", "findBreakpoints", "vmBreakpoint", "findExisting", "Lorg/jetbrains/debugger/ScriptRegExpBreakpointTarget;", "findTopFirstLineBreakpoints", "context", "Lorg/jetbrains/debugger/SuspendContext;", "scriptName", "isAnyFirstLineBreakpoint", "isUseScriptIdTarget", "setAnyFirstLineBreakpoint", "vm", "regExp", "condition", "setMeteorAnyClientScriptBreakpointIfNeed", "sourceMapFound", "Lcom/intellij/javascript/debugger/JavaScriptLineBreakpointManager$VmBreakpointLocation;", "map", "Lorg/jetbrains/debugger/sourcemap/SourceMap;", "script", "Lorg/jetbrains/debugger/Script;", "scriptUrl", "Lcom/intellij/util/Url;", "sourceMapNotFound", "VmBreakpointLocation", "JavaScriptDebugger"})
public final class JavaScriptLineBreakpointManager
extends LineBreakpointManager {
    private final ConcurrentList<Breakpoint> anyFirstLineBreakpoints;
    private final ConcurrentMap<Vm, Set<XLineBreakpoint<?>>> actualLocationNotFound;
    private final JavaScriptDebugProcess<?> debugProcess;

    public boolean isAnyFirstLineBreakpoint(@NotNull Breakpoint breakpoint) {
        Intrinsics.checkParameterIsNotNull((Object)breakpoint, (String)"breakpoint");
        return this.anyFirstLineBreakpoints.contains((Object)breakpoint);
    }

    public final void setAnyFirstLineBreakpoint(@NotNull Vm vm, @NotNull String regExp, @Nullable String condition) {
        Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
        Intrinsics.checkParameterIsNotNull((Object)regExp, (String)"regExp");
        BreakpointManager breakpointManager = vm.getBreakpointManager();
        JavaScriptDebugProcessKt.getLOG().assertTrue(breakpointManager.getRegExpBreakpointSupported());
        this.anyFirstLineBreakpoints.add((Object)BreakpointManager.DefaultImpls.setBreakpoint$default((BreakpointManager)breakpointManager, (BreakpointTarget)((BreakpointTarget)new ScriptRegExpBreakpointTarget(regExp, null, 2, null)), (int)0, (int)0, null, (String)condition, (int)0, (boolean)false, null, (int)236, null));
    }

    public static /* bridge */ /* synthetic */ void setAnyFirstLineBreakpoint$default(JavaScriptLineBreakpointManager javaScriptLineBreakpointManager, Vm vm, String string, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        javaScriptLineBreakpointManager.setAnyFirstLineBreakpoint(vm, string, string2);
    }

    public final void setMeteorAnyClientScriptBreakpointIfNeed(@NotNull Vm vm, @NotNull String regExp) {
        Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
        Intrinsics.checkParameterIsNotNull((Object)regExp, (String)"regExp");
        for (Breakpoint breakpoint : this.anyFirstLineBreakpoints) {
            BreakpointTarget breakpointTarget = breakpoint.getTarget();
            if (breakpointTarget == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.debugger.ScriptRegExpBreakpointTarget");
            }
            if (!Intrinsics.areEqual((Object)((ScriptRegExpBreakpointTarget)breakpointTarget).toString(), (Object)regExp)) continue;
            return;
        }
        JavaScriptLineBreakpointManager.setAnyFirstLineBreakpoint$default(this, vm, regExp, null, 4, null);
    }

    protected void beforeBreakpointRemoved(@NotNull XLineBreakpoint<?> breakpoint, boolean disable) {
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        if (!disable) {
            Iterator iterator;
            Iterator iterator2;
            Object object = this.actualLocationNotFound;
            Iterator iterator3 = iterator2 = (iterator = object.entrySet().iterator());
            while (iterator3.hasNext()) {
                Object object2 = object = iterator3.next();
                Vm key = (Vm)object2.getKey();
                object2 = object;
                Set value = (Set)object2.getValue();
                if (!value.remove(breakpoint) || !value.isEmpty()) continue;
                iterator.remove();
            }
        }
    }

    private final boolean isUseScriptIdTarget(Location location) {
        if (this.debugProcess.isFilesOnlyInLocalFileSystem()) {
            return true;
        }
        if (!this.anyFirstLineBreakpoints.isEmpty()) {
            String scriptUrl = location.getUrl().toExternalForm();
            for (Breakpoint breakpoint : this.anyFirstLineBreakpoints) {
                if (!(breakpoint.getTarget() instanceof ScriptRegExpBreakpointTarget)) continue;
                String string = breakpoint.getTarget().toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"breakpoint.target.toString()");
                String string2 = scriptUrl;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"scriptUrl");
                if (!JavaScriptLineBreakpointManagerKt.match(string, string2)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    protected BreakpointTarget createTarget(@Nullable XLineBreakpoint<?> breakpoint, @NotNull BreakpointManager breakpointManager, @NotNull Location location, boolean isTemporary) {
        Intrinsics.checkParameterIsNotNull((Object)breakpointManager, (String)"breakpointManager");
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        Script script = location.getScript();
        if (!isTemporary) {
            CharSequence charSequence;
            if (script != null && this.isUseScriptIdTarget(location)) {
                return (BreakpointTarget)new BreakpointTarget.ScriptId(script);
            }
            if (breakpointManager.getRegExpBreakpointSupported() && (location.getUrl().isInLocalFileSystem() || !((charSequence = (CharSequence)location.getUrl().getAuthority()) == null || charSequence.length() == 0))) {
                return (BreakpointTarget)new ScriptRegExpBreakpointTarget(this.createNameRegExp(location), this.debugProcess.getBreakpointLanguageHint(breakpoint, location));
            }
        }
        if (script == null) {
            return (BreakpointTarget)new BreakpointTarget.ScriptName(location.getUrl().toExternalForm());
        }
        return (BreakpointTarget)new BreakpointTarget.ScriptId(script);
    }

    @Nullable
    protected Breakpoint checkDuplicates(@NotNull BreakpointTarget newTarget, @NotNull Location location, @NotNull BreakpointManager breakpointManager) {
        Intrinsics.checkParameterIsNotNull((Object)newTarget, (String)"newTarget");
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        Intrinsics.checkParameterIsNotNull((Object)breakpointManager, (String)"breakpointManager");
        if (location.getScript() != null && newTarget instanceof ScriptRegExpBreakpointTarget) {
            Breakpoint breakpoint = this.findExisting(breakpointManager, location, (ScriptRegExpBreakpointTarget)newTarget);
            if (breakpoint != null) {
                Breakpoint breakpoint2;
                Breakpoint it = breakpoint2 = breakpoint;
                return it;
            }
        }
        return super.checkDuplicates(newTarget, location, breakpointManager);
    }

    private final Breakpoint findExisting(BreakpointManager breakpointManager, Location location, ScriptRegExpBreakpointTarget newTarget) {
        for (Breakpoint breakpoint : breakpointManager.getBreakpoints()) {
            BreakpointTarget target = breakpoint.getTarget();
            if (!(target instanceof ScriptRegExpBreakpointTarget) || this.isAnyFirstLineBreakpoint(breakpoint) || !breakpoint.getEnabled() || breakpoint.getLine() != location.getLine() || breakpoint.getColumn() != Breakpoint.Companion.EMPTY_VALUE && breakpoint.getColumn() != location.getColumn()) continue;
            String string = newTarget.toString();
            String string2 = target.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"target.toString()");
            if (!StringsKt.endsWith$default((String)string, (String)string2, (boolean)false, (int)2, null)) continue;
            return breakpoint;
        }
        return null;
    }

    private final String createNameRegExp(Location location) {
        CharSequence charSequence;
        boolean useCaseSensitiveUrl;
        String property = System.getProperty("js.debug.url.case.sensitive");
        boolean bl = property == null ? SystemInfoRt.isFileSystemCaseSensitive && !this.debugProcess.isFilesOnlyInLocalFileSystem() : (useCaseSensitiveUrl = (charSequence = (CharSequence)property).length() == 0 || Boolean.parseBoolean((String)(charSequence = property)));
        if (this.debugProcess.isFilesOnlyInLocalFileSystem() && this.debugProcess instanceof FilePathRegExpCreator) {
            FilePathRegExpCreator filePathRegExpCreator = (FilePathRegExpCreator)((Object)this.debugProcess);
            Url url = location.getUrl();
            Intrinsics.checkExpressionValueIsNotNull((Object)url, (String)"location.url");
            return filePathRegExpCreator.createFilePathRegExp(url, false);
        }
        return JavaScriptLineBreakpointManagerKt.access$createUrlRegExp(location, useCaseSensitiveUrl);
    }

    public final void sourceMapNotFound(@NotNull XLineBreakpoint<?> breakpoint, @NotNull Vm vm) {
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
        this.actualLocationNotFound.computeIfAbsent(vm, sourceMapNotFound.1.INSTANCE).add(breakpoint);
    }

    @NotNull
    public final List<VmBreakpointLocation> sourceMapFound(@NotNull Vm vm, @NotNull SourceMap map, @Nullable Script script, @Nullable Url scriptUrl) {
        Iterator iterator;
        Iterator iterator2;
        Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
        Intrinsics.checkParameterIsNotNull((Object)map, (String)"map");
        Set set = (Set)this.actualLocationNotFound.get(vm);
        if (set == null) {
            return CollectionsKt.emptyList();
        }
        Set actualLocationNotFound = set;
        if (actualLocationNotFound.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        boolean isScriptInNodeModules = this.debugProcess.isFilesOnlyInLocalFileSystem() && script != null && StringsKt.contains$default((CharSequence)script.getUrl().getPath(), (CharSequence)"/node_modules/", (boolean)false, (int)2, null);
        List sourceMapFound = null;
        Iterator iterator3 = iterator2 = (iterator = actualLocationNotFound.iterator());
        while (iterator3.hasNext()) {
            XSourcePosition breakpointLocation;
            XLineBreakpoint breakpoint = (XLineBreakpoint)iterator3.next();
            if (breakpoint.getSourcePosition() == null) {
                continue;
            }
            Project project = this.debugProcess.getSession().getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"debugProcess.session.project");
            SourceInfo lambdaLocation = PsiVisitorKt.getLambdaPosition(breakpoint, project);
            DebuggableFileFinder debuggableFileFinder = this.debugProcess.getFinder();
            VirtualFile virtualFile = breakpointLocation.getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"breakpointLocation.file");
            List<Url> remoteUrls = debuggableFileFinder.getRemoteUrls(virtualFile);
            if (isScriptInNodeModules) {
                Object v4;
                block8: {
                    Iterable $receiver$iv = remoteUrls;
                    for (Object element$iv : $receiver$iv) {
                        Url it = (Url)element$iv;
                        if (!StringsKt.contains$default((CharSequence)it.getPath(), (CharSequence)"/node_modules/", (boolean)false, (int)2, null)) continue;
                        v4 = element$iv;
                        break block8;
                    }
                    v4 = null;
                }
                if (v4 == null) continue;
            }
            VirtualFile virtualFile2 = breakpointLocation.getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"breakpointLocation.file");
            SourceInfo sourceInfo = lambdaLocation;
            List<Location> actualLocations = SourceMapHelperKt.getRawLocations(this.debugProcess, remoteUrls, virtualFile2, breakpointLocation.getLine(), map, script, scriptUrl, sourceInfo != null ? sourceInfo.getColumn() : -1);
            Collection collection = actualLocations;
            if (!(!collection.isEmpty())) continue;
            iterator.remove();
            if (sourceMapFound == null) {
                sourceMapFound = (List)new SmartList();
            }
            sourceMapFound.add(new VmBreakpointLocation(breakpoint, actualLocations));
        }
        List list = sourceMapFound;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public final List<XLineBreakpoint<?>> findTopFirstLineBreakpoints(@NotNull SuspendContext<?> context, @NotNull String scriptName) {
        Intrinsics.checkParameterIsNotNull(context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)scriptName, (String)"scriptName");
        CallFrame callFrame = context.getTopFrame();
        int breakLine = callFrame != null ? callFrame.getLine() : 0;
        for (Breakpoint breakpoint : context.getVm().getBreakpointManager().getBreakpoints()) {
            boolean bl;
            if (this.isAnyFirstLineBreakpoint(breakpoint) || !breakpoint.getEnabled() || breakpoint.getLine() != 0 && breakpoint.getLine() != breakLine) continue;
            BreakpointTarget breakpointTarget = breakpoint.getTarget();
            BreakpointTarget breakpointTarget2 = breakpointTarget;
            if (breakpointTarget2 instanceof ScriptRegExpBreakpointTarget) {
                String string = breakpointTarget.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"breakpointTarget.toString()");
                bl = JavaScriptLineBreakpointManagerKt.match(string, scriptName);
            } else {
                Script script;
                bl = breakpointTarget2 instanceof BreakpointTarget.ScriptName ? Intrinsics.areEqual((Object)scriptName, (Object)breakpointTarget.toString()) : (breakpointTarget2 instanceof BreakpointTarget.ScriptId ? Intrinsics.areEqual((Object)scriptName, (Object)(script = ((BreakpointTarget.ScriptId)breakpointTarget).script).getUrl().trimParameters().toExternalForm()) || Intrinsics.areEqual((Object)scriptName, (Object)script.getUrl().trimParameters().toDecodedForm()) : false);
            }
            if (!bl) continue;
            List list = (List)this.getVmToIdeBreakpoints().get((Object)breakpoint);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            return list;
        }
        return CollectionsKt.emptyList();
    }

    @NotNull
    public final List<XLineBreakpoint<?>> findBreakpoints(@NotNull Breakpoint vmBreakpoint) {
        Intrinsics.checkParameterIsNotNull((Object)vmBreakpoint, (String)"vmBreakpoint");
        List list = (List)this.getVmToIdeBreakpoints().get((Object)vmBreakpoint);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected List<Breakpoint> doRunToLocation(@NotNull XSourcePosition position) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        DebuggableFileFinder debuggableFileFinder = this.debugProcess.getFinder();
        VirtualFile virtualFile = position.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"position.file");
        List<Url> urls = debuggableFileFinder.getRemoteUrls(virtualFile);
        List locations = SourceMapHelperKt.getRawLocations$default(this.debugProcess, urls, position, null, null, null, 56, null);
        if (locations.isEmpty()) {
            DebuggableFileFinder debuggableFileFinder2 = this.debugProcess.getFinder();
            VirtualFile virtualFile2 = position.getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"position.file");
            if (debuggableFileFinder2.isOnlySourceMappedBreakpoints(virtualFile2)) {
                String message = "Cannot run to location, source location is not mapped: " + position;
                this.debugProcess.getSession().reportError(message);
                JavaScriptDebugProcessKt.getLOG().warn(message);
                return CollectionsKt.emptyList();
            }
        }
        if (locations.isEmpty()) {
            Vm vm = this.debugProcess.getActiveOrMainVm();
            if (vm == null) {
                Intrinsics.throwNpe();
            }
            Url url = (Url)CollectionsKt.first(urls);
            int n = position.getLine();
            XSourcePosition xSourcePosition = position;
            if (!(xSourcePosition instanceof SourceInfo)) {
                xSourcePosition = null;
            }
            SourceInfo sourceInfo = (SourceInfo)xSourcePosition;
            list = CollectionsKt.listOfNotNull((Object)LineBreakpointManager.doSetBreakpoint$default((LineBreakpointManager)this, (Vm)vm, null, (Location)new Location(url, n, sourceInfo != null ? sourceInfo.getColumn() : -1), (boolean)true, null, (int)16, null));
        } else {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)locations;
            Collection destination$iv$iv = new ArrayList();
            void $receiver$iv$iv$iv = $receiver$iv$iv;
            Iterator iterator = $receiver$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Breakpoint breakpoint;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                Location it = (Location)element$iv$iv;
                Vm vm = this.debugProcess.getActiveOrMainVm();
                if (vm == null) {
                    Intrinsics.throwNpe();
                }
                if (LineBreakpointManager.doSetBreakpoint$default((LineBreakpointManager)this, (Vm)vm, null, (Location)it, (boolean)true, null, (int)16, null) == null) continue;
                Breakpoint it$iv$iv = breakpoint;
                destination$iv$iv.add(it$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    public JavaScriptLineBreakpointManager(@NotNull JavaScriptDebugProcess<?> debugProcess) {
        Intrinsics.checkParameterIsNotNull(debugProcess, (String)"debugProcess");
        super((DebugProcessImpl)debugProcess);
        this.debugProcess = debugProcess;
        this.anyFirstLineBreakpoints = ContainerUtil.createConcurrentList();
        this.actualLocationNotFound = ContainerUtil.newConcurrentMap();
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\r\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lcom/intellij/javascript/debugger/JavaScriptLineBreakpointManager$VmBreakpointLocation;", "", "breakpoint", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "actualLocations", "", "Lorg/jetbrains/debugger/Location;", "(Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;Ljava/util/List;)V", "getActualLocations", "()Ljava/util/List;", "getBreakpoint", "()Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "component1", "component2", "copy", "JavaScriptDebugger"})
    public static final class VmBreakpointLocation {
        @NotNull
        private final XLineBreakpoint<?> breakpoint;
        @NotNull
        private final List<Location> actualLocations;

        @NotNull
        public final XLineBreakpoint<?> getBreakpoint() {
            return this.breakpoint;
        }

        @NotNull
        public final List<Location> getActualLocations() {
            return this.actualLocations;
        }

        public VmBreakpointLocation(@NotNull XLineBreakpoint<?> breakpoint, @NotNull List<Location> actualLocations) {
            Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
            Intrinsics.checkParameterIsNotNull(actualLocations, (String)"actualLocations");
            this.breakpoint = breakpoint;
            this.actualLocations = actualLocations;
        }

        @NotNull
        public final XLineBreakpoint<?> component1() {
            return this.breakpoint;
        }

        @NotNull
        public final List<Location> component2() {
            return this.actualLocations;
        }

        @NotNull
        public final VmBreakpointLocation copy(@NotNull XLineBreakpoint<?> breakpoint, @NotNull List<Location> actualLocations) {
            Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
            Intrinsics.checkParameterIsNotNull(actualLocations, (String)"actualLocations");
            return new VmBreakpointLocation(breakpoint, actualLocations);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ VmBreakpointLocation copy$default(VmBreakpointLocation vmBreakpointLocation, XLineBreakpoint xLineBreakpoint, List list, int n, Object object) {
            if ((n & 1) != 0) {
                xLineBreakpoint = vmBreakpointLocation.breakpoint;
            }
            if ((n & 2) != 0) {
                list = vmBreakpointLocation.actualLocations;
            }
            return vmBreakpointLocation.copy(xLineBreakpoint, list);
        }

        public String toString() {
            return "VmBreakpointLocation(breakpoint=" + this.breakpoint + ", actualLocations=" + this.actualLocations + ")";
        }

        public int hashCode() {
            XLineBreakpoint<?> xLineBreakpoint = this.breakpoint;
            List<Location> list = this.actualLocations;
            return (xLineBreakpoint != null ? xLineBreakpoint.hashCode() : 0) * 31 + (list != null ? ((Object)list).hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof VmBreakpointLocation)) break block3;
                    VmBreakpointLocation vmBreakpointLocation = (VmBreakpointLocation)object;
                    if (!Intrinsics.areEqual(this.breakpoint, vmBreakpointLocation.breakpoint) || !Intrinsics.areEqual(this.actualLocations, vmBreakpointLocation.actualLocations)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

