/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.sourcemap.visualizer;

import com.intellij.ide.browsers.BrowserFamily;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.sourcemap.visualizer.EditorListItem;
import com.intellij.javascript.debugger.sourcemap.visualizer.SourceFileFinder;
import com.intellij.javascript.debugger.sourcemap.visualizer.SourceMapInspectorKt;
import com.intellij.javascript.debugger.sourcemap.visualizer.SourceMapVisualizer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.event.CaretAdapter;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseMotionAdapter;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.AncestorListenerAdapter;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.util.SingleAlarm;
import com.intellij.util.Url;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.javascript.debugger.JavaScriptDebugAware;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.MappingEntry;
import org.jetbrains.debugger.sourcemap.MappingList;
import org.jetbrains.debugger.sourcemap.Mappings;
import org.jetbrains.debugger.sourcemap.MappingsProcessorInLine;
import org.jetbrains.debugger.sourcemap.SourceMap;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u0001:\u0001AB/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ \u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0002J \u0010(\u001a\u00020)2\u0006\u00100\u001a\u00020\u00112\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u000202H\u0002J\u0010\u00104\u001a\u0002052\b\u00106\u001a\u0004\u0018\u000107J\u0010\u00108\u001a\u00020\u00192\u0006\u00109\u001a\u00020\u0005H\u0002J\u0010\u0010:\u001a\u00020)2\u0006\u0010;\u001a\u00020#H\u0002J\u0010\u0010<\u001a\u00020)2\u0006\u0010=\u001a\u00020#H\u0002J\b\u0010>\u001a\u00020)H\u0002J\u0018\u0010?\u001a\u00020)2\u0006\u0010@\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R/\u0010\u000f\u001a#\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u0011\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00130\u00130\u0010\u00a2\u0006\u0002\b\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u001dX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010&\u001a\u0004\u0018\u00010'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lcom/intellij/javascript/debugger/sourcemap/visualizer/SourceMapInspector;", "", "map", "Lorg/jetbrains/debugger/sourcemap/SourceMap;", "generatedFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "disposable", "Lcom/intellij/openapi/Disposable;", "sourceFileFinder", "Lcom/intellij/javascript/debugger/sourcemap/visualizer/SourceFileFinder;", "(Lorg/jetbrains/debugger/sourcemap/SourceMap;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;Lcom/intellij/javascript/debugger/sourcemap/visualizer/SourceFileFinder;)V", "alarm", "Lcom/intellij/util/SingleAlarm;", "currentHighlighters", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/openapi/editor/markup/MarkupModel;", "kotlin.jvm.PlatformType", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "Lorg/jetbrains/annotations/NotNull;", "editorListModel", "Lcom/intellij/ui/CollectionComboBoxModel;", "Lcom/intellij/javascript/debugger/sourcemap/visualizer/EditorListItem;", "generatedEditor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "getGeneratedEditor", "()Lcom/intellij/openapi/editor/ex/EditorEx;", "generatedTextEditor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "getGeneratedTextEditor$JavaScriptDebugger", "()Lcom/intellij/openapi/fileEditor/TextEditor;", "setGeneratedTextEditor$JavaScriptDebugger", "(Lcom/intellij/openapi/fileEditor/TextEditor;)V", "positionToSelect", "Lcom/intellij/openapi/editor/LogicalPosition;", "positionToSelectIsSource", "", "rightPanel", "Ljavax/swing/JPanel;", "addSelectedHighlighter", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "mapping", "Lorg/jetbrains/debugger/sourcemap/MappingEntry;", "mappings", "Lorg/jetbrains/debugger/sourcemap/MappingList;", "markupModel", "startOffset", "", "endOffset", "createMainComponent", "Ljavax/swing/JComponent;", "selectedSourceUrl", "Lcom/intellij/util/Url;", "createSourceEditor", "virtualFile", "highlightGenerated", "sourcePosition", "highlightSource", "generatedPosition", "removeHighlighters", "scheduleHighlight", "position", "SourceFileFinderImpl", "JavaScriptDebugger"})
public final class SourceMapInspector {
    @NotNull
    private TextEditor generatedTextEditor;
    @NotNull
    private final EditorEx generatedEditor;
    private JPanel rightPanel;
    private final SingleAlarm alarm;
    private LogicalPosition positionToSelect;
    private boolean positionToSelectIsSource;
    private CollectionComboBoxModel<EditorListItem> editorListModel;
    private final MultiMap<MarkupModel, RangeHighlighter> currentHighlighters;
    private final SourceFileFinder sourceFileFinder;
    private final SourceMap map;
    private final Project project;
    private final Disposable disposable;

    @NotNull
    public final TextEditor getGeneratedTextEditor$JavaScriptDebugger() {
        return this.generatedTextEditor;
    }

    public final void setGeneratedTextEditor$JavaScriptDebugger(@NotNull TextEditor textEditor) {
        Intrinsics.checkParameterIsNotNull((Object)textEditor, (String)"<set-?>");
        this.generatedTextEditor = textEditor;
    }

    @NotNull
    public final EditorEx getGeneratedEditor() {
        return this.generatedEditor;
    }

    private final void scheduleHighlight(LogicalPosition position, boolean positionToSelectIsSource) {
        this.positionToSelect = position;
        this.positionToSelectIsSource = positionToSelectIsSource;
        this.alarm.cancelAndRequest();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final JComponent createMainComponent(@Nullable Url selectedSourceUrl) {
        List editors = CollectionsKt.mutableListOf((Object[])new EditorListItem[0]);
        Url[] sources = this.map.getSources();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.project).getFileIndex();
        int selectedIndex = -1;
        int n = 0;
        int n2 = sources.length - 1;
        if (n <= n2) {
            while (true) {
                Font font;
                void i2;
                Url url;
                VirtualFile file;
                if ((file = this.sourceFileFinder.find(url = sources[i2])) == null) {
                    Intrinsics.checkExpressionValueIsNotNull((Object)UIUtil.getListFont().deriveFont(2), (String)"UIUtil.getListFont().deriveFont(Font.ITALIC)");
                } else if (!fileIndex.isInContent(file) || fileIndex.isInLibrarySource(file) || fileIndex.isInLibraryClasses(file)) {
                    Intrinsics.checkExpressionValueIsNotNull((Object)UIUtil.getListFont(), (String)"UIUtil.getListFont()");
                } else {
                    Intrinsics.checkExpressionValueIsNotNull((Object)UIUtil.getListFont().deriveFont(1), (String)"UIUtil.getListFont().deriveFont(Font.BOLD)");
                }
                Collection collection = editors;
                String string = file == null ? url.toDecodedForm() : SourceMapInspectorKt.getFileTitle(file);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"if (file == null) url.to\u2026) else getFileTitle(file)");
                EditorListItem editorListItem = new EditorListItem((int)i2, file, font, string);
                collection.add(editorListItem);
                if (selectedIndex == -1 && selectedSourceUrl != null && Intrinsics.areEqual((Object)selectedSourceUrl, (Object)url)) {
                    selectedIndex = i2;
                }
                if (i2 == n2) break;
                ++i2;
            }
        }
        this.editorListModel = new CollectionComboBoxModel(editors);
        ComboBox comboBox = new ComboBox((ComboBoxModel)this.editorListModel, 100);
        new ComboboxSpeedSearch(comboBox, (JComboBox)comboBox){
            final /* synthetic */ ComboBox $comboBox;

            @Nullable
            protected String getElementText(@NotNull Object element) {
                Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                EditorListItem item = (EditorListItem)element;
                return item.getFile() == null ? item.getName() : item.getFile().getName();
            }
            {
                this.$comboBox = $captured_local_variable$0;
                super($super_call_param$1);
            }
        };
        comboBox.setRenderer((ListCellRenderer)new ListCellRendererWrapper<EditorListItem>(){

            public void customize(@NotNull JList<Object> list, @Nullable EditorListItem item, int index, boolean selected, boolean hasFocus) {
                Intrinsics.checkParameterIsNotNull(list, (String)"list");
                if (item != null) {
                    Object object = item.getFile();
                    if (object == null || (object = object.getFileType()) == null || (object = object.getIcon()) == null) {
                        object = UnknownFileType.INSTANCE.getIcon();
                    }
                    this.setIcon((Icon)object);
                    this.setText(item.getName());
                    this.setFont(item.getFont());
                }
            }
        });
        comboBox.addItemListener(new ItemListener(this){
            final /* synthetic */ SourceMapInspector this$0;

            public final void itemStateChanged(ItemEvent e) {
                LogicalPosition sourcePosition2;
                if (e.getStateChange() != 1) {
                    return;
                }
                Object object = e.getItem();
                if (!(object instanceof EditorListItem)) {
                    object = null;
                }
                EditorListItem editorListItem = (EditorListItem)object;
                if (editorListItem == null) {
                    return;
                }
                EditorListItem selectedItem = editorListItem;
                JPanel jPanel = SourceMapInspector.access$getRightPanel$p(this.this$0);
                if (jPanel == null) {
                    Intrinsics.throwNpe();
                }
                if (jPanel.getComponentCount() > 1) {
                    JPanel jPanel2 = SourceMapInspector.access$getRightPanel$p(this.this$0);
                    if (jPanel2 == null) {
                        Intrinsics.throwNpe();
                    }
                    jPanel2.remove(1);
                }
                if (selectedItem.getEditor() == null && selectedItem.getFile() != null) {
                    selectedItem.setEditor(SourceMapInspector.access$createSourceEditor(this.this$0, selectedItem.getFile()));
                }
                if (selectedItem.getEditor() != null) {
                    JPanel jPanel3 = SourceMapInspector.access$getRightPanel$p(this.this$0);
                    if (jPanel3 == null) {
                        Intrinsics.throwNpe();
                    }
                    EditorEx editorEx = selectedItem.getEditor();
                    if (editorEx == null) {
                        Intrinsics.throwNpe();
                    }
                    jPanel3.add(editorEx.getComponent(), "Center", 1);
                }
                if (selectedItem.getFile() == null) {
                    sourcePosition2 = new LogicalPosition(0, 0);
                } else {
                    JavaScriptDebugAware debugAware;
                    PsiFile psiFile = PsiManager.getInstance((Project)SourceMapInspector.access$getProject$p(this.this$0)).findFile(selectedItem.getFile());
                    if (psiFile == null) {
                        Intrinsics.throwNpe();
                    }
                    PsiFile file = psiFile;
                    PsiElement navigationElement = null;
                    JavaScriptDebugAware[] javaScriptDebugAwareArray = (JavaScriptDebugAware[])JavaScriptDebugAware.EP_NAME.getExtensions();
                    for (int j = 0; j < javaScriptDebugAwareArray.length && (navigationElement = (debugAware = javaScriptDebugAwareArray[j]).getNavigationElementForSourcemapInspector(file)) == null; ++j) {
                    }
                    if (navigationElement == null) {
                        navigationElement = file.getNavigationElement();
                    }
                    PsiElement psiElement = navigationElement;
                    if (psiElement == null) {
                        Intrinsics.throwNpe();
                    }
                    int offset = psiElement.getTextOffset();
                    EditorEx editorEx = selectedItem.getEditor();
                    if (editorEx == null) {
                        Intrinsics.throwNpe();
                    }
                    DocumentEx document = editorEx.getDocument();
                    int line = document.getLineNumber(offset);
                    sourcePosition2 = new LogicalPosition(line, offset - document.getLineStartOffset(line));
                }
                JPanel jPanel4 = SourceMapInspector.access$getRightPanel$p(this.this$0);
                if (jPanel4 == null) {
                    Intrinsics.throwNpe();
                }
                if (jPanel4.getParent() != null) {
                    JPanel jPanel5 = SourceMapInspector.access$getRightPanel$p(this.this$0);
                    if (jPanel5 == null) {
                        Intrinsics.throwNpe();
                    }
                    jPanel5.revalidate();
                    JPanel jPanel6 = SourceMapInspector.access$getRightPanel$p(this.this$0);
                    if (jPanel6 == null) {
                        Intrinsics.throwNpe();
                    }
                    jPanel6.repaint();
                    SourceMapInspector.access$highlightGenerated(this.this$0, sourcePosition2);
                } else {
                    SourceMapInspector.access$setPositionToSelect$p(this.this$0, sourcePosition2);
                    SourceMapInspector.access$setPositionToSelectIsSource$p(this.this$0, true);
                }
            }
            {
                this.this$0 = sourceMapInspector;
            }
        });
        JPanel jPanel = this.rightPanel = new JPanel(new BorderLayout());
        if (jPanel == null) {
            Intrinsics.throwNpe();
        }
        jPanel.add((Component)comboBox, "First");
        comboBox.setSelectedIndex(selectedIndex);
        JBSplitter splitter = new JBSplitter();
        splitter.setSplitterProportionKey("SourceMapInspector.splitter");
        splitter.setFirstComponent(this.generatedEditor.getComponent());
        splitter.setSecondComponent((JComponent)this.rightPanel);
        this.generatedEditor.getComponent().addAncestorListener((AncestorListener)new AncestorListenerAdapter(this){
            final /* synthetic */ SourceMapInspector this$0;

            public void ancestorAdded(@NotNull AncestorEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                this.this$0.getGeneratedEditor().getComponent().removeAncestorListener((AncestorListener)((Object)this));
                if (SourceMapInspector.access$getPositionToSelect$p(this.this$0) == null) {
                    return;
                }
                LogicalPosition logicalPosition = SourceMapInspector.access$getPositionToSelect$p(this.this$0);
                if (logicalPosition == null) {
                    Intrinsics.throwNpe();
                }
                SourceMapInspector.access$highlightGenerated(this.this$0, logicalPosition);
                SourceMapInspector.access$setPositionToSelect$p(this.this$0, null);
                SourceMapInspector.access$setPositionToSelectIsSource$p(this.this$0, false);
            }
            {
                this.this$0 = $outer;
            }
        });
        return (JComponent)splitter;
    }

    private final EditorEx createSourceEditor(VirtualFile virtualFile) {
        FileEditor fileEditor = TextEditorProvider.getInstance().createEditor(this.project, virtualFile);
        if (fileEditor == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.fileEditor.TextEditor");
        }
        TextEditor textEditor = (TextEditor)fileEditor;
        Editor editor = textEditor.getEditor();
        if (editor == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
        }
        EditorEx sourceEditor = (EditorEx)editor;
        SourceMapInspectorKt.access$setupEditor(sourceEditor);
        sourceEditor.getCaretModel().addCaretListener((CaretListener)new CaretAdapter(this){
            final /* synthetic */ SourceMapInspector this$0;

            public void caretPositionChanged(@NotNull CaretEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                LogicalPosition logicalPosition = event.getNewPosition();
                Intrinsics.checkExpressionValueIsNotNull((Object)logicalPosition, (String)"event.newPosition");
                SourceMapInspector.access$scheduleHighlight(this.this$0, logicalPosition, true);
            }
            {
                this.this$0 = $outer;
            }
        });
        Disposer.register((Disposable)this.disposable, (Disposable)((Disposable)textEditor));
        return sourceEditor;
    }

    private final void highlightGenerated(LogicalPosition sourcePosition2) {
        EditorListItem item;
        this.removeHighlighters();
        CollectionComboBoxModel<EditorListItem> collectionComboBoxModel = this.editorListModel;
        if (collectionComboBoxModel == null) {
            Intrinsics.throwNpe();
        }
        EditorListItem editorListItem = item = (EditorListItem)collectionComboBoxModel.getSelected();
        if (editorListItem == null) {
            Intrinsics.throwNpe();
        }
        Mappings mappings = this.map.findSourceMappings(editorListItem.getSourceIndex());
        if (mappings == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.debugger.sourcemap.MappingList");
        }
        MappingList mappingsOrderedBySource = (MappingList)mappings;
        int mappingIndex = mappingsOrderedBySource.indexOf(sourcePosition2.line, sourcePosition2.column);
        if (mappingIndex == -1) {
            return;
        }
        MappingEntry mappingEntry = mappingsOrderedBySource.get(sourcePosition2.line, sourcePosition2.column);
        if (mappingEntry == null) {
            Intrinsics.throwNpe();
        }
        MappingEntry mapping = mappingEntry;
        EditorEx editorEx = item.getEditor();
        if (editorEx == null) {
            Intrinsics.throwNpe();
        }
        this.addSelectedHighlighter((Editor)editorEx, mapping, mappingsOrderedBySource);
        MappingEntry nextMapping = Mappings.DefaultImpls.getNextOnTheSameLine$default((Mappings)mappingsOrderedBySource, (int)mappingIndex, (boolean)false, (int)2, null);
        mappingsOrderedBySource.processMappingsInLine(mapping.getSourceLine(), new MappingsProcessorInLine(this, mapping, nextMapping){
            final /* synthetic */ SourceMapInspector this$0;
            final /* synthetic */ MappingEntry $mapping;
            final /* synthetic */ MappingEntry $nextMapping;

            public boolean process(@NotNull MappingEntry entry, @Nullable MappingEntry nextEntry) {
                Intrinsics.checkParameterIsNotNull((Object)entry, (String)"entry");
                if (entry.getSourceColumn() >= this.$mapping.getSourceColumn()) {
                    Mappings mappings = SourceMapInspector.access$getMap$p(this.this$0).getGeneratedMappings();
                    if (mappings == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.debugger.sourcemap.MappingList");
                    }
                    SourceMapInspector.access$addSelectedHighlighter(this.this$0, (Editor)this.this$0.getGeneratedEditor(), entry, (MappingList)mappings);
                }
                return nextEntry != null && nextEntry != this.$nextMapping;
            }
            {
                this.this$0 = $outer;
                this.$mapping = $captured_local_variable$1;
                this.$nextMapping = $captured_local_variable$2;
            }
        });
        this.generatedEditor.getScrollingModel().scrollTo(new LogicalPosition(mapping.getGeneratedLine(), mapping.getGeneratedColumn()), ScrollType.CENTER);
    }

    private final void removeHighlighters() {
        if (this.currentHighlighters.isEmpty()) {
            return;
        }
        for (MarkupModel markupModel : this.currentHighlighters.keySet()) {
            for (RangeHighlighter rangeHighlighter : this.currentHighlighters.get((Object)markupModel)) {
                if (!rangeHighlighter.isValid()) continue;
                markupModel.removeHighlighter(rangeHighlighter);
            }
        }
        this.currentHighlighters.clear();
    }

    private final void addSelectedHighlighter(Editor editor, MappingEntry mapping, MappingList mappings) {
        int lineStartOffset = editor.getDocument().getLineStartOffset(mappings.getLine(mapping));
        MarkupModel markupModel = editor.getMarkupModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)markupModel, (String)"editor.markupModel");
        int n = lineStartOffset + mappings.getColumn(mapping);
        Document document = editor.getDocument();
        Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"editor.document");
        this.addSelectedHighlighter(markupModel, n, mappings.getEndOffset(mapping, lineStartOffset, document));
    }

    private final void addSelectedHighlighter(MarkupModel markupModel, int startOffset, int endOffset) {
        if (startOffset == endOffset) {
            return;
        }
        if (endOffset < startOffset) {
            throw (Throwable)new IllegalStateException();
        }
        RangeHighlighter highlighter = markupModel.addRangeHighlighter(startOffset, endOffset, 6100, SourceMapVisualizer.SELECTED_MARKER, HighlighterTargetArea.EXACT_RANGE);
        this.currentHighlighters.putValue((Object)markupModel, (Object)highlighter);
    }

    private final void highlightSource(LogicalPosition generatedPosition) {
        String string;
        JLabel component;
        this.removeHighlighters();
        MappingEntry mapping = this.map.getGeneratedMappings().get(generatedPosition.line, generatedPosition.column);
        JComponent headerComponent = this.generatedEditor.getHeaderComponent();
        if (headerComponent instanceof JLabel) {
            component = (JLabel)headerComponent;
        } else if (headerComponent != null) {
            JPanel compoundComponent = new JPanel(new BorderLayout());
            compoundComponent.add((Component)headerComponent, "First");
            component = new JLabel("0:0", 4);
            compoundComponent.add((Component)component, "Last");
            this.generatedEditor.setHeaderComponent((JComponent)compoundComponent);
        } else {
            component = new JLabel("0:0", 4);
            this.generatedEditor.setHeaderComponent((JComponent)component);
        }
        if (mapping == null || mapping.getSource() == -1) {
            component.setText("unmapped");
            return;
        }
        StringBuilder stringBuilder = new StringBuilder().append(mapping.getSourceLine() + ":" + mapping.getSourceColumn());
        if (mapping.getName() == null) {
            string = "";
        } else {
            StringBuilder stringBuilder2 = new StringBuilder().append(" ");
            String string2 = mapping.getName();
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            string = stringBuilder2.append(string2).toString();
        }
        component.setText(stringBuilder.append(string).append(" (").append(mapping.getGeneratedLine()).append(":").append(mapping.getGeneratedColumn()).append(")").toString());
        int sourceIndex = mapping.getSource();
        CollectionComboBoxModel<EditorListItem> collectionComboBoxModel = this.editorListModel;
        if (collectionComboBoxModel == null) {
            Intrinsics.throwNpe();
        }
        EditorListItem listItem = (EditorListItem)collectionComboBoxModel.getElementAt(sourceIndex);
        VirtualFile virtualFile = listItem.getFile();
        if (virtualFile == null) {
            return;
        }
        VirtualFile sourceFile = virtualFile;
        EditorEx sourceEditor = listItem.getEditor();
        if (sourceEditor == null) {
            sourceEditor = this.createSourceEditor(sourceFile);
            listItem.setEditor(sourceEditor);
            JPanel jPanel = this.rightPanel;
            if (jPanel == null) {
                Intrinsics.throwNpe();
            }
            jPanel.add(sourceEditor.getComponent(), "Center", 1);
            JPanel jPanel2 = this.rightPanel;
            if (jPanel2 == null) {
                Intrinsics.throwNpe();
            }
            jPanel2.revalidate();
            JPanel jPanel3 = this.rightPanel;
            if (jPanel3 == null) {
                Intrinsics.throwNpe();
            }
            jPanel3.repaint();
        }
        CollectionComboBoxModel<EditorListItem> collectionComboBoxModel2 = this.editorListModel;
        if (collectionComboBoxModel2 == null) {
            Intrinsics.throwNpe();
        }
        collectionComboBoxModel2.setSelectedItem((Object)listItem);
        Mappings mappings = this.map.findSourceMappings(sourceIndex);
        if (mappings == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.debugger.sourcemap.MappingList");
        }
        this.addSelectedHighlighter((Editor)sourceEditor, mapping, (MappingList)mappings);
        Mappings mappings2 = this.map.getGeneratedMappings();
        if (mappings2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.debugger.sourcemap.MappingList");
        }
        this.addSelectedHighlighter((Editor)this.generatedEditor, mapping, (MappingList)mappings2);
        sourceEditor.getScrollingModel().scrollTo(new LogicalPosition(mapping.getSourceLine(), mapping.getSourceColumn()), ScrollType.MAKE_VISIBLE);
        if ((Boolean)SourceMapInspectorKt.access$getEDITOR_MARKED$p().get((UserDataHolder)sourceEditor) != Boolean.TRUE) {
            SourceMapInspectorKt.access$getEDITOR_MARKED$p().set((UserDataHolder)sourceEditor, (Object)true);
            SourceMapVisualizer.addMarkersToSourceFile(this.map, (MarkupModel)sourceEditor.getMarkupModel(), (Url)((Object[])this.map.getSources())[sourceIndex]);
        }
    }

    public SourceMapInspector(@NotNull SourceMap map, @NotNull VirtualFile generatedFile, @NotNull Project project, @NotNull Disposable disposable, @Nullable SourceFileFinder sourceFileFinder) {
        Intrinsics.checkParameterIsNotNull((Object)map, (String)"map");
        Intrinsics.checkParameterIsNotNull((Object)generatedFile, (String)"generatedFile");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)disposable, (String)"disposable");
        this.map = map;
        this.project = project;
        this.disposable = disposable;
        FileEditor fileEditor = TextEditorProvider.getInstance().createEditor(this.project, generatedFile);
        if (fileEditor == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.fileEditor.TextEditor");
        }
        this.generatedTextEditor = (TextEditor)fileEditor;
        Editor editor = this.generatedTextEditor.getEditor();
        if (editor == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
        }
        this.generatedEditor = (EditorEx)editor;
        this.currentHighlighters = MultiMap.createSmart();
        SourceFileFinder sourceFileFinder2 = sourceFileFinder;
        if (sourceFileFinder2 == null) {
            sourceFileFinder2 = new SourceFileFinderImpl();
        }
        this.sourceFileFinder = sourceFileFinder2;
        Disposer.register((Disposable)this.disposable, (Disposable)((Disposable)this.generatedTextEditor));
        SourceMapInspectorKt.access$setupEditor(this.generatedEditor);
        this.generatedEditor.setHeaderComponent((JComponent)new JLabel("0:0", 4));
        SourceMapVisualizer.addMarkersToGeneratedFile(this.map, (MarkupModel)this.generatedEditor.getMarkupModel());
        this.alarm = new SingleAlarm(new Runnable(){

            @Override
            public final void run() {
                LogicalPosition p = positionToSelect;
                if (p != null) {
                    positionToSelect = null;
                    if (positionToSelectIsSource) {
                        this.highlightGenerated(p);
                    } else {
                        this.highlightSource(p);
                    }
                }
            }
        }, 100);
        this.generatedEditor.addEditorMouseMotionListener((EditorMouseMotionListener)new EditorMouseMotionAdapter(){

            public void mouseMoved(@NotNull EditorMouseEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                if (event.getMouseEvent().isShiftDown()) {
                    LogicalPosition logicalPosition = event.getEditor().xyToLogicalPosition(event.getMouseEvent().getPoint());
                    Intrinsics.checkExpressionValueIsNotNull((Object)logicalPosition, (String)"event.editor.xyToLogical\u2026n(event.mouseEvent.point)");
                    this.scheduleHighlight(logicalPosition, false);
                }
            }
        });
        this.generatedEditor.getCaretModel().addCaretListener((CaretListener)new CaretAdapter(){

            public void caretPositionChanged(@NotNull CaretEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                LogicalPosition logicalPosition = event.getNewPosition();
                Intrinsics.checkExpressionValueIsNotNull((Object)logicalPosition, (String)"event.newPosition");
                this.scheduleHighlight(logicalPosition, false);
            }
        });
    }

    @Nullable
    public static final /* synthetic */ JPanel access$getRightPanel$p(SourceMapInspector $this) {
        return $this.rightPanel;
    }

    public static final /* synthetic */ void access$setRightPanel$p(SourceMapInspector $this, @Nullable JPanel jPanel) {
        $this.rightPanel = jPanel;
    }

    @NotNull
    public static final /* synthetic */ EditorEx access$createSourceEditor(SourceMapInspector $this, @NotNull VirtualFile virtualFile) {
        return $this.createSourceEditor(virtualFile);
    }

    public static final /* synthetic */ void access$setPositionToSelectIsSource$p(SourceMapInspector $this, boolean bl) {
        $this.positionToSelectIsSource = bl;
    }

    public static final /* synthetic */ void access$addSelectedHighlighter(SourceMapInspector $this, @NotNull Editor editor, @NotNull MappingEntry mapping, @NotNull MappingList mappings) {
        $this.addSelectedHighlighter(editor, mapping, mappings);
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/javascript/debugger/sourcemap/visualizer/SourceMapInspector$SourceFileFinderImpl;", "Lcom/intellij/javascript/debugger/sourcemap/visualizer/SourceFileFinder;", "(Lcom/intellij/javascript/debugger/sourcemap/visualizer/SourceMapInspector;)V", "userDataHolder", "Lcom/intellij/openapi/util/UserDataHolderBase;", "find", "Lcom/intellij/openapi/vfs/VirtualFile;", "source", "Lcom/intellij/util/Url;", "JavaScriptDebugger"})
    public final class SourceFileFinderImpl
    implements SourceFileFinder {
        private final UserDataHolderBase userDataHolder = new UserDataHolderBase();

        @Override
        @Nullable
        public VirtualFile find(@NotNull Url source) {
            VirtualFile file;
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            VirtualFile virtualFile = SourceMapInspectorKt.createSourceFromProvidedContent(SourceMapInspector.this.map, source, (UserDataHolder)this.userDataHolder);
            if (virtualFile == null) {
                virtualFile = file = SourceMapInspectorKt.getSourceFile(source);
            }
            if (file == null) {
                for (JavaScriptDebugProcess debugProcess : XDebuggerManager.getInstance((Project)SourceMapInspector.this.project).getDebugProcesses(JavaScriptDebugProcess.class)) {
                    WebBrowser webBrowser;
                    WebBrowser webBrowser2 = webBrowser = debugProcess.getSession().isStopped() ? null : debugProcess.getConnection().getBrowser();
                    if (!Intrinsics.areEqual((Object)BrowserFamily.CHROME, (Object)(webBrowser2 != null ? webBrowser2.getFamily() : null))) continue;
                    return debugProcess.findFileOrAny(source);
                }
            }
            return file;
        }
    }
}

