/*
 * Decompiled with CFR 0.152.
 */
package org.coffeescript.editor;

import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandlerBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.coffeescript.CoffeeScriptUtil;
import org.coffeescript.lang.lexer.CoffeeScriptTokenTypes;

public class CoffeeScriptSelectionHandler
extends ExtendWordSelectionHandlerBase {
    public boolean canSelect(PsiElement e) {
        return CoffeeScriptUtil.isShortThisProperty(e) || CoffeeScriptUtil.getHeredoc(e) != null;
    }

    public static TextRange createRangeForHeredocStringContent(PsiElement docString) {
        TextRange textRange = docString.getTextRange();
        int left = textRange.getStartOffset();
        if (docString.getFirstChild().getNode().getElementType() == CoffeeScriptTokenTypes.HEREDOC_START) {
            left += "\"\"\"".length();
        }
        int right = textRange.getEndOffset();
        if (docString.getLastChild().getNode().getElementType() == CoffeeScriptTokenTypes.HEREDOC_END) {
            right -= "\"\"\"".length();
        }
        return new TextRange(left, right);
    }

    private static List<TextRange> createRangesForCurrentLineInHeredocString(PsiElement docString, int cursorOffset) {
        int right;
        int left;
        String text = docString.getText();
        int offset = docString.getTextOffset();
        TextRange textRange = docString.getTextRange();
        int leftNotWhitespacePosition = left = cursorOffset;
        while (textRange.contains(left) && text.charAt(left - offset) != '\n') {
            if (!StringUtil.isWhiteSpace((char)text.charAt(left - offset))) {
                leftNotWhitespacePosition = left;
            }
            --left;
        }
        if (left < cursorOffset) {
            ++left;
        }
        int rightNotWhitespacePosition = right = cursorOffset;
        while (textRange.contains(right) && text.charAt(right - offset) != '\n') {
            if (!StringUtil.isWhiteSpace((char)text.charAt(right - offset))) {
                rightNotWhitespacePosition = right + 1;
            }
            ++right;
        }
        TextRange withoutSpacesRange = new TextRange(leftNotWhitespacePosition, rightNotWhitespacePosition);
        TextRange fullLineRange = new TextRange(left, right);
        return Arrays.asList(withoutSpacesRange, fullLineRange);
    }

    public List<TextRange> select(PsiElement e, CharSequence editorText, int cursorOffset, Editor editor) {
        ArrayList<TextRange> result = new ArrayList<TextRange>();
        PsiElement heredoc = CoffeeScriptUtil.getHeredoc(e);
        if (heredoc != null) {
            result.addAll(CoffeeScriptSelectionHandler.createRangesForCurrentLineInHeredocString(heredoc, cursorOffset));
            TextRange docStringContentRange = CoffeeScriptSelectionHandler.createRangeForHeredocStringContent(heredoc);
            result.add(docStringContentRange);
            result.add(heredoc.getTextRange());
        } else if (CoffeeScriptUtil.isShortThisProperty(e)) {
            result.add(e.getParent().getTextRange());
        }
        return result;
    }
}

