/*
 * Decompiled with CFR 0.152.
 */
package org.coffeescript.lang.parser;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.types.JSFileElementType;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.Collections;
import java.util.Map;
import org.coffeescript.CoffeeScriptLanguage;
import org.coffeescript.lang.lexer.CoffeeScriptFlexLexer;
import org.coffeescript.lang.lexer.CoffeeScriptTokenSets;
import org.coffeescript.lang.lexer.CoffeeScriptTokenTypes;
import org.coffeescript.lang.parser.CoffeeScriptElementTypes;
import org.coffeescript.lang.parser.CoffeeScriptParser;
import org.coffeescript.lang.psi.CoffeeScriptFile;
import org.coffeescript.lang.psi.impl.CoffeeScriptCaseClauseImpl;
import org.coffeescript.lang.psi.impl.CoffeeScriptClassImpl;
import org.coffeescript.lang.psi.impl.CoffeeScriptDoExpressionImpl;
import org.coffeescript.lang.psi.impl.CoffeeScriptElementImpl;
import org.coffeescript.lang.psi.impl.CoffeeScriptForStatementImpl;
import org.coffeescript.lang.psi.impl.CoffeeScriptHeregexImpl;
import org.coffeescript.lang.psi.impl.CoffeeScriptParameterImpl;
import org.coffeescript.lang.psi.impl.CoffeeScriptPropertyImpl;
import org.coffeescript.lang.psi.impl.CoffeeScriptRangeImpl;
import org.coffeescript.lang.psi.impl.CoffeeScriptVariableImpl;
import org.jetbrains.annotations.NotNull;

public class CoffeeScriptParserDefinition
implements ParserDefinition {
    public static final IFileElementType FILE_ELEMENT_TYPE = JSFileElementType.create((Language)CoffeeScriptLanguage.INSTANCE);

    @NotNull
    public Lexer createLexer(Project project) {
        CoffeeScriptFlexLexer coffeeScriptFlexLexer = new CoffeeScriptFlexLexer();
        if (coffeeScriptFlexLexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/coffeescript/lang/parser/CoffeeScriptParserDefinition", "createLexer"));
        }
        return coffeeScriptFlexLexer;
    }

    public PsiParser createParser(Project project) {
        return new CoffeeScriptParser();
    }

    public IFileElementType getFileNodeType() {
        return FILE_ELEMENT_TYPE;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = CoffeeScriptTokenSets.WHITESPACE_TOKEN_SET;
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/coffeescript/lang/parser/CoffeeScriptParserDefinition", "getWhitespaceTokens"));
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = CoffeeScriptTokenSets.COMMENTS_TOKEN_SET;
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/coffeescript/lang/parser/CoffeeScriptParserDefinition", "getCommentTokens"));
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = CoffeeScriptTokenSets.STRING_TOKEN_SET;
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/coffeescript/lang/parser/CoffeeScriptParserDefinition", "getStringLiteralElements"));
        }
        return tokenSet;
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        if (node.getElementType() == CoffeeScriptElementTypes.CASE_CLAUSE) {
            CoffeeScriptCaseClauseImpl coffeeScriptCaseClauseImpl = new CoffeeScriptCaseClauseImpl(node);
            if (coffeeScriptCaseClauseImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/coffeescript/lang/parser/CoffeeScriptParserDefinition", "createElement"));
            }
            return coffeeScriptCaseClauseImpl;
        }
        if (node.getElementType() == CoffeeScriptElementTypes.FOR_STATEMENT) {
            CoffeeScriptForStatementImpl coffeeScriptForStatementImpl = new CoffeeScriptForStatementImpl(node);
            if (coffeeScriptForStatementImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/coffeescript/lang/parser/CoffeeScriptParserDefinition", "createElement"));
            }
            return coffeeScriptForStatementImpl;
        }
        if (node.getElementType() == CoffeeScriptElementTypes.RANGE) {
            CoffeeScriptRangeImpl coffeeScriptRangeImpl = new CoffeeScriptRangeImpl(node);
            if (coffeeScriptRangeImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/coffeescript/lang/parser/CoffeeScriptParserDefinition", "createElement"));
            }
            return coffeeScriptRangeImpl;
        }
        if (node.getElementType() == CoffeeScriptElementTypes.VARIABLE) {
            CoffeeScriptVariableImpl coffeeScriptVariableImpl = new CoffeeScriptVariableImpl(node);
            if (coffeeScriptVariableImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/coffeescript/lang/parser/CoffeeScriptParserDefinition", "createElement"));
            }
            return coffeeScriptVariableImpl;
        }
        if (node.getElementType() == CoffeeScriptElementTypes.PROPERTY) {
            CoffeeScriptPropertyImpl coffeeScriptPropertyImpl = new CoffeeScriptPropertyImpl(node);
            if (coffeeScriptPropertyImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/coffeescript/lang/parser/CoffeeScriptParserDefinition", "createElement"));
            }
            return coffeeScriptPropertyImpl;
        }
        if (node.getElementType() == CoffeeScriptElementTypes.CLASS) {
            CoffeeScriptClassImpl coffeeScriptClassImpl = new CoffeeScriptClassImpl(node);
            if (coffeeScriptClassImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/coffeescript/lang/parser/CoffeeScriptParserDefinition", "createElement"));
            }
            return coffeeScriptClassImpl;
        }
        if (node.getElementType() == CoffeeScriptElementTypes.HEREGEX) {
            CoffeeScriptHeregexImpl coffeeScriptHeregexImpl = new CoffeeScriptHeregexImpl(node);
            if (coffeeScriptHeregexImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/coffeescript/lang/parser/CoffeeScriptParserDefinition", "createElement"));
            }
            return coffeeScriptHeregexImpl;
        }
        if (node.getElementType() == CoffeeScriptElementTypes.DO_EXPRESSION) {
            CoffeeScriptDoExpressionImpl coffeeScriptDoExpressionImpl = new CoffeeScriptDoExpressionImpl(node);
            if (coffeeScriptDoExpressionImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/coffeescript/lang/parser/CoffeeScriptParserDefinition", "createElement"));
            }
            return coffeeScriptDoExpressionImpl;
        }
        if (node.getElementType() == CoffeeScriptTokenTypes.EMBEDDED_CONTENT) {
            CoffeeScriptEmbeddedContentImpl coffeeScriptEmbeddedContentImpl = new CoffeeScriptEmbeddedContentImpl(node);
            if (coffeeScriptEmbeddedContentImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/coffeescript/lang/parser/CoffeeScriptParserDefinition", "createElement"));
            }
            return coffeeScriptEmbeddedContentImpl;
        }
        if (node.getElementType() == CoffeeScriptElementTypes.PARAMETER) {
            CoffeeScriptParameterImpl coffeeScriptParameterImpl = new CoffeeScriptParameterImpl(node);
            if (coffeeScriptParameterImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/coffeescript/lang/parser/CoffeeScriptParserDefinition", "createElement"));
            }
            return coffeeScriptParameterImpl;
        }
        CoffeeScriptElementImpl coffeeScriptElementImpl = new CoffeeScriptElementImpl(node);
        if (coffeeScriptElementImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/coffeescript/lang/parser/CoffeeScriptParserDefinition", "createElement"));
        }
        return coffeeScriptElementImpl;
    }

    public PsiFile createFile(FileViewProvider viewProvider) {
        return new CoffeeScriptFile(viewProvider);
    }

    public ParserDefinition.SpaceRequirements spaceExistanceTypeBetweenTokens(ASTNode left, ASTNode right) {
        return ParserDefinition.SpaceRequirements.MAY;
    }

    private static class CoffeeScriptEmbeddedContentImpl
    extends ASTWrapperPsiElement
    implements JSEmbeddedContent {
        public CoffeeScriptEmbeddedContentImpl(@NotNull ASTNode node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/coffeescript/lang/parser/CoffeeScriptParserDefinition$CoffeeScriptEmbeddedContentImpl", "<init>"));
            }
            super(node);
        }

        public IElementType getElementType() {
            return this.getNode().getElementType();
        }

        @NotNull
        public Map<String, JSReferenceExpression> getExtensionSymbols() {
            Map<String, JSReferenceExpression> map = Collections.emptyMap();
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/coffeescript/lang/parser/CoffeeScriptParserDefinition$CoffeeScriptEmbeddedContentImpl", "getExtensionSymbols"));
            }
            return map;
        }
    }
}

