/*
 * Decompiled with CFR 0.152.
 */
package org.coffeescript.refactoring.surround;

import com.intellij.lang.ASTNode;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import org.coffeescript.refactoring.CoffeeScriptChangeUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class CoffeeScriptBaseSurrounder
implements Surrounder {
    public TextRange surroundElements(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement[] elements) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/coffeescript/refactoring/surround/CoffeeScriptBaseSurrounder", "surroundElements"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/coffeescript/refactoring/surround/CoffeeScriptBaseSurrounder", "surroundElements"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "org/coffeescript/refactoring/surround/CoffeeScriptBaseSurrounder", "surroundElements"));
        }
        ASTNode node = CoffeeScriptChangeUtil.createCoffeeScriptNodeFromText(this.getStatementTemplate(elements[0]), project);
        if (node == null) {
            return null;
        }
        PsiElement container = elements[0].getParent();
        container.getNode().addChild(node, elements[0].getNode());
        ASTNode nodeToReplace = this.getNodeToReplace(node);
        for (PsiElement element : elements) {
            ASTNode childNode = element.getNode();
            ASTNode childNodeCopy = childNode.copyElement();
            container.getNode().removeChild(childNode);
            nodeToReplace.getTreeParent().addChild(childNodeCopy, nodeToReplace);
        }
        nodeToReplace.getTreeParent().removeChild(nodeToReplace);
        CodeStyleManager csManager = CodeStyleManager.getInstance((Project)project);
        csManager.reformat(node.getPsi());
        return this.getSurroundSelectionRange(node);
    }

    @NonNls
    protected abstract String getStatementTemplate(PsiElement var1);

    @NotNull
    protected abstract ASTNode getNodeToReplace(ASTNode var1);

    protected abstract TextRange getSurroundSelectionRange(ASTNode var1);
}

