/*
 * Decompiled with CFR 0.152.
 */
package org.coffeescript.refactoring.surround;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import org.coffeescript.CsBundle;
import org.coffeescript.lang.parser.CoffeeScriptElementTypes;
import org.coffeescript.refactoring.surround.CoffeeScriptBaseSurrounder;
import org.jetbrains.annotations.NotNull;

public class CoffeeScriptWithIfElseSurrounder
extends CoffeeScriptBaseSurrounder {
    @Override
    protected String getStatementTemplate(PsiElement context) {
        return "if condition \n  body\nelse";
    }

    @Override
    @NotNull
    protected ASTNode getNodeToReplace(ASTNode surroundedNode) {
        ASTNode aSTNode = surroundedNode.findChildByType(CoffeeScriptElementTypes.INDENT_BLOCK).getFirstChildNode();
        if (aSTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/coffeescript/refactoring/surround/CoffeeScriptWithIfElseSurrounder", "getNodeToReplace"));
        }
        return aSTNode;
    }

    @Override
    protected TextRange getSurroundSelectionRange(ASTNode statementNode) {
        JSIfStatement ifStatement = (JSIfStatement)statementNode.getPsi();
        int startOffset = ifStatement.getCondition().getTextOffset();
        int endOffset = startOffset + ifStatement.getCondition().getTextLength();
        return new TextRange(startOffset, endOffset);
    }

    public String getTemplateDescription() {
        return CsBundle.message("surrounder.if.else", new Object[0]);
    }

    public boolean isApplicable(@NotNull PsiElement[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "org/coffeescript/refactoring/surround/CoffeeScriptWithIfElseSurrounder", "isApplicable"));
        }
        return true;
    }
}

