/*
 * Decompiled with CFR 0.152.
 */
package org.jcodings;

import java.nio.charset.Charset;
import org.jcodings.ApplyAllCaseFoldFunction;
import org.jcodings.CaseFoldCodeItem;
import org.jcodings.IntHolder;
import org.jcodings.ascii.AsciiTables;
import org.jcodings.exception.EncodingException;
import org.jcodings.exception.InternalException;
import org.jcodings.util.BytesHash;

public abstract class Encoding
implements Cloneable {
    public static final int CHAR_INVALID = -1;
    private static int count;
    protected final int minLength;
    protected final int maxLength;
    protected final boolean isFixedWidth;
    protected final boolean isSingleByte;
    protected final boolean isDummy;
    protected final boolean isAsciiCompatible;
    protected byte[] name;
    protected int hashCode;
    private int index;
    protected Charset charset = null;
    public static final byte NEW_LINE = 10;

    protected Encoding(String string, int n, int n2, boolean bl) {
        this.setName(string);
        this.minLength = n;
        this.maxLength = n2;
        this.isFixedWidth = n == n2;
        this.isSingleByte = this.isFixedWidth && n == 1;
        this.index = count++;
        this.isDummy = bl;
        this.isAsciiCompatible = n == 1 && !bl;
    }

    protected Encoding(String string, int n, int n2) {
        this(string, n, n2, false);
    }

    protected final void setName(String string) {
        this.name = string.getBytes();
        this.hashCode = BytesHash.hashCode(this.name, 0, this.name.length);
    }

    protected final void setName(byte[] byArray) {
        this.name = byArray;
        this.hashCode = BytesHash.hashCode(this.name, 0, this.name.length);
    }

    public final String toString() {
        return new String(this.name);
    }

    public final boolean equals(Object object) {
        return this == object;
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public final int getIndex() {
        return this.index;
    }

    public final byte[] getName() {
        return this.name;
    }

    public final boolean isDummy() {
        return this.isDummy;
    }

    public final boolean isAsciiCompatible() {
        return this.isAsciiCompatible;
    }

    public Charset getCharset() {
        if (!this.isDummy() && this.charset == null && this.getCharsetName() != null) {
            this.charset = Charset.forName(this.getCharsetName());
        }
        return this.charset;
    }

    public String getCharsetName() {
        return null;
    }

    public Encoding replicate(byte[] byArray) {
        try {
            Encoding encoding = (Encoding)this.clone();
            encoding.setName(byArray);
            encoding.index = count++;
            return encoding;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new EncodingException("could not replicate <%n> encoding", new String(byArray));
        }
    }

    public abstract int length(byte var1);

    public abstract int length(byte[] var1, int var2, int var3);

    public final int maxLength() {
        return this.maxLength;
    }

    public final int maxLengthDistance() {
        return this.maxLength();
    }

    public final int minLength() {
        return this.minLength;
    }

    public abstract boolean isNewLine(byte[] var1, int var2, int var3);

    public abstract int mbcToCode(byte[] var1, int var2, int var3);

    public abstract int codeToMbcLength(int var1);

    public abstract int codeToMbc(int var1, byte[] var2, int var3);

    public abstract int mbcCaseFold(int var1, byte[] var2, IntHolder var3, int var4, byte[] var5);

    public byte[] toLowerCaseTable() {
        return null;
    }

    public abstract void applyAllCaseFold(int var1, ApplyAllCaseFoldFunction var2, Object var3);

    public abstract CaseFoldCodeItem[] caseFoldCodesByString(int var1, byte[] var2, int var3, int var4);

    public abstract int propertyNameToCType(byte[] var1, int var2, int var3);

    public abstract boolean isCodeCType(int var1, int var2);

    public abstract int[] ctypeCodeRange(int var1, IntHolder var2);

    public abstract int leftAdjustCharHead(byte[] var1, int var2, int var3, int var4);

    public abstract boolean isReverseMatchAllowed(byte[] var1, int var2, int var3);

    public final int rightAdjustCharHead(byte[] byArray, int n, int n2, int n3) {
        int n4 = this.leftAdjustCharHead(byArray, n, n2, n3);
        if (n4 < n2) {
            n4 += this.length(byArray, n4, n3);
        }
        return n4;
    }

    public final int rightAdjustCharHeadWithPrev(byte[] byArray, int n, int n2, int n3, IntHolder intHolder) {
        int n4 = this.leftAdjustCharHead(byArray, n, n2, n3);
        if (n4 < n2) {
            if (intHolder != null) {
                intHolder.value = n4;
            }
            n4 += this.length(byArray, n4, n3);
        } else if (intHolder != null) {
            intHolder.value = -1;
        }
        return n4;
    }

    public final int prevCharHead(byte[] byArray, int n, int n2, int n3) {
        if (n2 <= n) {
            return -1;
        }
        return this.leftAdjustCharHead(byArray, n, n2 - 1, n3);
    }

    public final int stepBack(byte[] byArray, int n, int n2, int n3, int n4) {
        while (n2 != -1 && n4-- > 0) {
            if (n2 <= n) {
                return -1;
            }
            n2 = this.leftAdjustCharHead(byArray, n, n2 - 1, n3);
        }
        return n2;
    }

    public final int step(byte[] byArray, int n, int n2, int n3) {
        int n4 = n;
        while (n3-- > 0) {
            n4 += this.length(byArray, n4, n2);
        }
        return n4 <= n2 ? n4 : -1;
    }

    public abstract int strLength(byte[] var1, int var2, int var3);

    public abstract int strCodeAt(byte[] var1, int var2, int var3, int var4);

    public final int strLengthNull(byte[] byArray, int n, int n2) {
        int n3 = 0;
        while (true) {
            if (byArray[n] == 0) {
                int n4 = this.minLength();
                if (n4 == 1) {
                    return n3;
                }
                int n5 = n + 1;
                while (n4 > 1 && byArray[n5] == 0) {
                    ++n5;
                    --n4;
                }
                if (n4 == 1) {
                    return n3;
                }
            }
            n += this.length(byArray, n, n2);
            ++n3;
        }
    }

    public final int strByteLengthNull(byte[] byArray, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        while (true) {
            if (byArray[n4] == 0) {
                int n5 = this.minLength();
                if (n5 == 1) {
                    return n4 - n3;
                }
                int n6 = n4 + 1;
                while (n5 > 1) {
                    if (n6 >= byArray.length) {
                        return n4 - n3;
                    }
                    if (byArray[n6] != 0) break;
                    ++n6;
                    --n5;
                }
                if (n5 == 1) {
                    return n4 - n3;
                }
            }
            n4 += this.length(byArray, n4, n2);
        }
    }

    public final int strNCmp(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        while (n4-- > 0) {
            if (n >= n2) {
                return byArray2[n3];
            }
            int n5 = this.mbcToCode(byArray, n, n2);
            int n6 = byArray2[n3] - n5;
            if (n6 != 0) {
                return n6;
            }
            ++n3;
            n += this.length(byArray, n, n2);
        }
        return 0;
    }

    public final boolean isNewLine(int n) {
        return this.isCodeCType(n, 0);
    }

    public final boolean isGraph(int n) {
        return this.isCodeCType(n, 5);
    }

    public final boolean isPrint(int n) {
        return this.isCodeCType(n, 7);
    }

    public final boolean isAlnum(int n) {
        return this.isCodeCType(n, 13);
    }

    public final boolean isAlpha(int n) {
        return this.isCodeCType(n, 1);
    }

    public final boolean isLower(int n) {
        return this.isCodeCType(n, 6);
    }

    public final boolean isUpper(int n) {
        return this.isCodeCType(n, 10);
    }

    public final boolean isCntrl(int n) {
        return this.isCodeCType(n, 3);
    }

    public final boolean isPunct(int n) {
        return this.isCodeCType(n, 8);
    }

    public final boolean isSpace(int n) {
        return this.isCodeCType(n, 9);
    }

    public final boolean isBlank(int n) {
        return this.isCodeCType(n, 2);
    }

    public final boolean isDigit(int n) {
        return this.isCodeCType(n, 4);
    }

    public final boolean isXDigit(int n) {
        return this.isCodeCType(n, 11);
    }

    public final boolean isWord(int n) {
        return this.isCodeCType(n, 12);
    }

    public final boolean isMbcWord(byte[] byArray, int n, int n2) {
        return this.isWord(this.mbcToCode(byArray, n, n2));
    }

    public final boolean isSbWord(int n) {
        return Encoding.isAscii(n) && this.isWord(n);
    }

    public final boolean isMbcHead(byte[] byArray, int n, int n2) {
        return this.length(byArray, n, n2) != 1;
    }

    public boolean isMbcCrnl(byte[] byArray, int n, int n2) {
        return this.mbcToCode(byArray, n, n2) == 13 && this.isNewLine(byArray, n + this.length(byArray, n, n2), n2);
    }

    public static int digitVal(int n) {
        return n - 48;
    }

    public static int odigitVal(int n) {
        return Encoding.digitVal(n);
    }

    public final int xdigitVal(int n) {
        if (this.isDigit(n)) {
            return Encoding.digitVal(n);
        }
        return this.isUpper(n) ? n - 65 + 10 : n - 97 + 10;
    }

    public static boolean isMbcAscii(byte by) {
        return (by & 0xFF) < 128;
    }

    public static boolean isAscii(int n) {
        return n < 128;
    }

    public static boolean isAscii(byte by) {
        return by >= 0;
    }

    public static byte asciiToLower(int n) {
        return AsciiTables.ToLowerCaseTable[n];
    }

    public static byte asciiToUpper(int n) {
        return AsciiTables.ToUpperCaseTable[n];
    }

    public static boolean isWordGraphPrint(int n) {
        return n == 12 || n == 5 || n == 7;
    }

    public final int mbcodeStartPosition() {
        return this.minLength() > 1 ? 0 : 128;
    }

    public final boolean isSingleByte() {
        return this.isSingleByte;
    }

    public final boolean isFixedWidth() {
        return this.isFixedWidth;
    }

    public static Encoding load(String string) {
        Class<?> clazz;
        String string2 = "org.jcodings.specific." + string + "Encoding";
        try {
            clazz = Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InternalException("encoding class <%n> not found", string2);
        }
        try {
            return (Encoding)clazz.getField("INSTANCE").get(clazz);
        }
        catch (Exception exception) {
            throw new InternalException("problem loading encoding <%n>", string2);
        }
    }
}

