/*
 * Decompiled with CFR 0.152.
 */
package org.jcodings.specific;

import org.jcodings.IntHolder;
import org.jcodings.ascii.AsciiTables;
import org.jcodings.exception.EncodingException;
import org.jcodings.unicode.UnicodeEncoding;

abstract class BaseUTF8Encoding
extends UnicodeEncoding {
    static final boolean USE_INVALID_CODE_SCHEME = true;
    private static final int INVALID_CODE_FE = -2;
    private static final int INVALID_CODE_FF = -1;

    protected BaseUTF8Encoding(int[] nArray, int[][] nArray2) {
        super("UTF-8", 1, 6, nArray, nArray2);
    }

    @Override
    public String getCharsetName() {
        return "UTF-8";
    }

    @Override
    public boolean isNewLine(byte[] byArray, int n, int n2) {
        return n < n2 && byArray[n] == 10;
    }

    @Override
    public int codeToMbcLength(int n) {
        if ((n & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n & 0xFFFFF800) == 0) {
            return 2;
        }
        if ((n & 0xFFFF0000) == 0) {
            return 3;
        }
        if ((n & 0xFFE00000) == 0) {
            return 4;
        }
        if ((n & 0xFC000000) == 0) {
            return 5;
        }
        if ((n & Integer.MIN_VALUE) == 0) {
            return 6;
        }
        if (n == -2) {
            return 1;
        }
        if (n == -1) {
            return 1;
        }
        throw new EncodingException("invalid code point value");
    }

    @Override
    public int mbcToCode(byte[] byArray, int n, int n2) {
        int n3 = this.length(byArray, n, n2);
        int n4 = byArray[n++] & 0xFF;
        if (n3 > 1) {
            int n5 = n4 & (1 << 6 - --n3) - 1;
            while (n3-- != 0) {
                n4 = byArray[n++] & 0xFF;
                n5 = n5 << 6 | n4 & 0x3F;
            }
            return n5;
        }
        if (n4 > 253) {
            return n4 == 254 ? -2 : -1;
        }
        return n4;
    }

    static byte trailS(int n, int n2) {
        return (byte)(n >>> n2 & 0x3F | 0x80);
    }

    static byte trail0(int n) {
        return (byte)(n & 0x3F | 0x80);
    }

    @Override
    public int codeToMbc(int n, byte[] byArray, int n2) {
        int n3 = n2;
        if ((n & 0xFFFFFF80) == 0) {
            byArray[n3] = (byte)n;
            return 1;
        }
        if ((n & 0xFFFFF800) == 0) {
            byArray[n3++] = (byte)(n >>> 6 & 0x1F | 0xC0);
        } else if ((n & 0xFFFF0000) == 0) {
            byArray[n3++] = (byte)(n >>> 12 & 0xF | 0xE0);
            byArray[n3++] = BaseUTF8Encoding.trailS(n, 6);
        } else if ((n & 0xFFE00000) == 0) {
            byArray[n3++] = (byte)(n >>> 18 & 7 | 0xF0);
            byArray[n3++] = BaseUTF8Encoding.trailS(n, 12);
            byArray[n3++] = BaseUTF8Encoding.trailS(n, 6);
        } else if ((n & 0xFC000000) == 0) {
            byArray[n3++] = (byte)(n >>> 24 & 3 | 0xF8);
            byArray[n3++] = BaseUTF8Encoding.trailS(n, 18);
            byArray[n3++] = BaseUTF8Encoding.trailS(n, 12);
            byArray[n3++] = BaseUTF8Encoding.trailS(n, 6);
        } else if ((n & Integer.MIN_VALUE) == 0) {
            byArray[n3++] = (byte)(n >>> 30 & 1 | 0xFC);
            byArray[n3++] = BaseUTF8Encoding.trailS(n, 24);
            byArray[n3++] = BaseUTF8Encoding.trailS(n, 18);
            byArray[n3++] = BaseUTF8Encoding.trailS(n, 12);
            byArray[n3++] = BaseUTF8Encoding.trailS(n, 6);
        } else {
            if (n == -2) {
                byArray[n3] = -2;
                return 1;
            }
            if (n == -1) {
                byArray[n3] = -1;
                return 1;
            }
            throw new EncodingException("too big wide-char value");
        }
        byArray[n3++] = BaseUTF8Encoding.trail0(n);
        return n3 - n2;
    }

    @Override
    public int mbcCaseFold(int n, byte[] byArray, IntHolder intHolder, int n2, byte[] byArray2) {
        int n3 = intHolder.value++;
        int n4 = 0;
        if (BaseUTF8Encoding.isMbcAscii(byArray[n3])) {
            byArray2[n4] = AsciiTables.ToLowerCaseTable[byArray[n3] & 0xFF];
            return 1;
        }
        return super.mbcCaseFold(n, byArray, intHolder, n2, byArray2);
    }

    @Override
    public int[] ctypeCodeRange(int n, IntHolder intHolder) {
        intHolder.value = 128;
        return super.ctypeCodeRange(n);
    }

    private static boolean utf8IsLead(int n) {
        return (n & 0xC0 & 0xFF) != 128;
    }

    @Override
    public int leftAdjustCharHead(byte[] byArray, int n, int n2, int n3) {
        int n4;
        if (n2 <= n) {
            return n2;
        }
        for (n4 = n2; !BaseUTF8Encoding.utf8IsLead(byArray[n4] & 0xFF) && n4 > n; --n4) {
        }
        return n4;
    }

    @Override
    public boolean isReverseMatchAllowed(byte[] byArray, int n, int n2) {
        return true;
    }
}

