/*
 * Decompiled with CFR 0.152.
 */
package org.jcodings.specific;

import org.jcodings.IntHolder;
import org.jcodings.ascii.AsciiTables;
import org.jcodings.unicode.FixedWidthUnicodeEncoding;

public final class UTF32LEEncoding
extends FixedWidthUnicodeEncoding {
    public static UTF32LEEncoding INSTANCE = new UTF32LEEncoding();

    protected UTF32LEEncoding() {
        super("UTF-32LE", 4);
    }

    @Override
    public boolean isNewLine(byte[] byArray, int n, int n2) {
        return n + 3 < n2 && byArray[n] == 10 && byArray[n + 1] == 0 && byArray[n + 2] == 0 && byArray[n + 3] == 0;
    }

    @Override
    public int mbcToCode(byte[] byArray, int n, int n2) {
        return (((byArray[n + 3] & 0xFF) * 256 + (byArray[n + 2] & 0xFF)) * 256 + (byArray[n + 1] & 0xFF)) * 256 + (byArray[n] & 0xFF);
    }

    @Override
    public int codeToMbc(int n, byte[] byArray, int n2) {
        int n3 = n2;
        byArray[n3++] = (byte)(n & 0xFF);
        byArray[n3++] = (byte)((n & 0xFF00) >>> 8);
        byArray[n3++] = (byte)((n & 0xFF0000) >>> 16);
        byArray[n3++] = (byte)((n & 0xFF000000) >>> 24);
        return 4;
    }

    @Override
    public int mbcCaseFold(int n, byte[] byArray, IntHolder intHolder, int n2, byte[] byArray2) {
        int n3 = intHolder.value;
        int n4 = 0;
        if (UTF32LEEncoding.isAscii(byArray[n3] & 0xFF) && byArray[n3 + 1] == 0 && byArray[n3 + 2] == 0 && byArray[n3 + 3] == 0) {
            byArray2[n4++] = AsciiTables.ToLowerCaseTable[byArray[n3] & 0xFF];
            byArray2[n4++] = 0;
            byArray2[n4++] = 0;
            byArray2[n4] = 0;
            intHolder.value += 4;
            return 4;
        }
        return super.mbcCaseFold(n, byArray, intHolder, n2, byArray2);
    }
}

