/*
 * Decompiled with CFR 0.152.
 */
package org.jcodings.transcode;

import org.jcodings.Ptr;
import org.jcodings.exception.InternalException;
import org.jcodings.transcode.Buffer;
import org.jcodings.transcode.EConvFlags;
import org.jcodings.transcode.EConvResult;
import org.jcodings.transcode.Transcoder;
import org.jcodings.transcode.TranscoderDB;
import org.jcodings.transcode.Transcoding;
import org.jcodings.util.CaseInsensitiveBytesHash;

public final class EConv
implements EConvFlags {
    int flags;
    byte[] source;
    byte[] destination;
    boolean started = false;
    byte[] replacementString;
    int replacementLength;
    byte[] replacementEncoding;
    Buffer inBuf = new Buffer();
    EConvElement[] elements;
    int numTranscoders;
    int numFinished;
    Transcoding lastTranscoding;
    final LastError lastError = new LastError();
    static final byte[] NULL_STRING = new byte[0];
    static final int[] NULL_POINTER = new int[0];

    public String toString() {
        return new String(this.source) + " => " + new String(this.destination);
    }

    EConv(int n) {
        if (n < 0) {
            n = 1;
        }
        this.elements = new EConvElement[n];
        this.lastError.result = EConvResult.SourceBufferEmpty;
    }

    static boolean decorator(byte[] byArray, byte[] byArray2) {
        return byArray.length == 0;
    }

    void addTranscoderAt(Transcoder transcoder, int n) {
        if (this.numTranscoders == this.elements.length) {
            EConvElement[] eConvElementArray = new EConvElement[this.elements.length * 2];
            System.arraycopy(this.elements, 0, eConvElementArray, 0, n);
            System.arraycopy(this.elements, n, eConvElementArray, n + 1, this.elements.length - n);
            this.elements = eConvElementArray;
        } else {
            System.arraycopy(this.elements, n, this.elements, n + 1, this.elements.length - n - 1);
        }
        this.elements[n] = new EConvElement(transcoder.transcoding(0));
        this.elements[n].allocate(4096);
        ++this.numTranscoders;
        if (!EConv.decorator(transcoder.source, transcoder.destination)) {
            for (int i = this.numTranscoders - 1; n <= i; --i) {
                Transcoding transcoding = this.elements[i].transcoding;
                Transcoder transcoder2 = transcoding.transcoder;
                if (EConv.decorator(transcoder2.source, transcoder2.destination)) continue;
                this.lastTranscoding = transcoding;
                break;
            }
        }
    }

    private int transSweep(byte[] byArray, Ptr ptr, int n, byte[] byArray2, Ptr ptr2, int n2, int n3, int n4) {
        boolean bl = true;
        Ptr ptr3 = new Ptr();
        Ptr ptr4 = new Ptr();
        while (bl) {
            block6: for (int i = 0; i < this.numTranscoders; ++i) {
                EConvResult eConvResult;
                int n5;
                byte[] byArray3;
                int n6;
                byte[] byArray4;
                int n7;
                EConvElement eConvElement = this.elements[i];
                if (i == 0) {
                    ptr3.p = ptr.p;
                    n7 = n;
                    byArray4 = byArray;
                } else {
                    EConvElement eConvElement2 = this.elements[i - 1];
                    ptr3.p = eConvElement2.dataStart;
                    n7 = eConvElement2.dataEnd;
                    byArray4 = eConvElement2.bytes;
                }
                if (i == this.numTranscoders - 1) {
                    ptr4.p = ptr2.p;
                    n6 = n2;
                    byArray3 = byArray2;
                } else {
                    if (eConvElement.bufStart != eConvElement.dataStart) {
                        int n8 = eConvElement.dataEnd - eConvElement.dataStart;
                        n5 = eConvElement.dataStart - eConvElement.bufStart;
                        System.arraycopy(eConvElement.bytes, eConvElement.dataStart, eConvElement.bytes, eConvElement.bufStart, n8);
                        eConvElement.dataStart = eConvElement.bufStart;
                        eConvElement.dataEnd -= n5;
                    }
                    ptr4.p = eConvElement.dataEnd;
                    n6 = eConvElement.bufEnd;
                    byArray3 = eConvElement.bytes;
                }
                int n9 = n3;
                if (this.numFinished != i) {
                    n9 |= 0x10000;
                }
                if (i == 0 && (n3 & 0x20000) != 0) {
                    n4 = 1;
                    n3 &= 0xFFFDFFFF;
                }
                if (i != 0) {
                    n9 &= 0xFFFDFFFF;
                }
                n5 = ptr3.p;
                int n10 = ptr4.p;
                eConvElement.lastResult = eConvResult = eConvElement.transcoding.convert(byArray4, ptr3, n7, byArray3, ptr4, n6, n9);
                if (n5 != ptr3.p || n10 != ptr4.p) {
                    bl = true;
                }
                switch (eConvResult) {
                    case InvalidByteSequence: 
                    case IncompleteInput: 
                    case UndefinedConversion: 
                    case AfterOutput: {
                        return i;
                    }
                    case DestinationBufferFull: 
                    case SourceBufferEmpty: {
                        continue block6;
                    }
                    case Finished: {
                        this.numFinished = i + 1;
                    }
                }
            }
        }
        return -1;
    }

    private EConvResult transConv(byte[] byArray, Ptr ptr, int n, byte[] byArray2, Ptr ptr2, int n2, int n3, Ptr ptr3) {
        if (this.elements[0].lastResult == EConvResult.AfterOutput) {
            this.elements[0].lastResult = EConvResult.SourceBufferEmpty;
        }
        this.numTranscoders = 1;
        block4: for (int i = 1; i >= 0; --i) {
            switch (this.elements[i].lastResult) {
                case InvalidByteSequence: 
                case IncompleteInput: 
                case UndefinedConversion: 
                case AfterOutput: 
                case Finished: {
                    return this.transConvNeedReport(byArray, ptr, n, byArray2, ptr2, n2, n3, ptr3, i + 1, i);
                }
                case DestinationBufferFull: 
                case SourceBufferEmpty: {
                    continue block4;
                }
                default: {
                    throw new InternalException("unexpected transcode last result");
                }
            }
        }
        if (this.elements[this.numTranscoders - 1].lastResult == EConvResult.DestinationBufferFull && (n3 & 0x20000) != 0) {
            EConvResult eConvResult = this.transConv(NULL_STRING, Ptr.NULL, 0, byArray2, ptr2, n2, n3 & 0xFFFDFFFF | 0x10000, ptr3);
            return eConvResult.isSourceBufferEmpty() ? EConvResult.AfterOutput : eConvResult;
        }
        return this.transConvNeedReport(byArray, ptr, n, byArray2, ptr2, n2, n3, ptr3, 0, -1);
    }

    private EConvResult transConvNeedReport(byte[] byArray, Ptr ptr, int n, byte[] byArray2, Ptr ptr2, int n2, int n3, Ptr ptr3, int n4, int n5) {
        do {
            n5 = this.transSweep(byArray, ptr, n, byArray2, ptr2, n2, n3, n4);
            n4 = n5 + 1;
        } while (n5 != -1 && n5 != this.numTranscoders - 1);
        for (int i = this.numTranscoders - 1; i >= 0; --i) {
            if (this.elements[i].lastResult == EConvResult.SourceBufferEmpty) continue;
            EConvResult eConvResult = this.elements[i].lastResult;
            switch (eConvResult) {
                case InvalidByteSequence: 
                case IncompleteInput: 
                case UndefinedConversion: 
                case AfterOutput: {
                    this.elements[i].lastResult = EConvResult.SourceBufferEmpty;
                }
            }
            if (ptr3 != null) {
                ptr3.p = i;
            }
            return eConvResult;
        }
        if (ptr3 != null) {
            ptr3.p = -1;
        }
        return EConvResult.SourceBufferEmpty;
    }

    private EConvResult convertInternal(byte[] byArray, Ptr ptr, int n, byte[] byArray2, Ptr ptr2, int n2, int n3) {
        EConvResult eConvResult;
        this.lastError.reset();
        if (this.numTranscoders == 0) {
            int n4;
            if (this.inBuf.bytes != null && this.inBuf.dataStart != this.inBuf.dataEnd) {
                if (n2 - ptr2.p < this.inBuf.dataEnd - this.inBuf.dataStart) {
                    int n5 = n2 - ptr2.p;
                    System.arraycopy(this.inBuf, this.inBuf.dataStart, byArray2, ptr2.p, n5);
                    ptr2.p = n2;
                    this.inBuf.dataStart += n5;
                    return this.convertInternalResult(EConvResult.DestinationBufferFull, null);
                }
                n4 = this.inBuf.dataEnd - this.inBuf.dataStart;
                System.arraycopy(this.inBuf, this.inBuf.dataStart, byArray2, ptr2.p, n4);
                ptr2.p += n4;
                this.inBuf.dataStart = this.inBuf.dataEnd = this.inBuf.bufStart;
                if ((n3 & 0x20000) != 0) {
                    return this.convertInternalResult(EConvResult.AfterOutput, null);
                }
            }
            if ((n4 = n2 - ptr2.p < n - ptr.p ? n2 - ptr2.p : n - ptr.p) > 0 && (n3 & 0x20000) != 0) {
                byArray2[ptr2.p++] = byArray[ptr.p++];
                return this.convertInternalResult(EConvResult.AfterOutput, null);
            }
            System.arraycopy(byArray, ptr.p, byArray2, ptr2.p, n4);
            ptr2.p += n4;
            ptr.p += n4;
            EConvResult eConvResult2 = ptr.p != n ? EConvResult.DestinationBufferFull : ((n3 & 0x10000) != 0 ? EConvResult.SourceBufferEmpty : EConvResult.Finished);
            return this.convertInternalResult(eConvResult2, null);
        }
        boolean bl = false;
        EConvElement eConvElement = this.elements[this.numTranscoders - 1];
        if (eConvElement.bytes != null) {
            int n6 = eConvElement.dataStart;
            int n7 = eConvElement.dataEnd;
            byte[] byArray3 = eConvElement.bytes;
            if (n6 != n7) {
                if (n2 - ptr2.p < n7 - n6) {
                    int n8 = n2 = ptr2.p;
                    System.arraycopy(byArray3, n6, byArray2, ptr2.p, n8);
                    ptr2.p = n2;
                    eConvElement.dataStart += n8;
                    return this.convertInternalResult(EConvResult.DestinationBufferFull, null);
                }
                int n9 = n7 - n6;
                System.arraycopy(byArray3, n6, byArray2, ptr2.p, n9);
                ptr2.p += n9;
                eConvElement.dataStart = eConvElement.dataEnd = eConvElement.bufStart;
                bl = true;
            }
        }
        Ptr ptr3 = new Ptr(0);
        if (this.inBuf != null && this.inBuf.dataStart != this.inBuf.dataEnd) {
            Ptr ptr4 = new Ptr(this.inBuf.dataStart);
            eConvResult = this.transConv(this.inBuf.bytes, ptr4, this.inBuf.dataEnd, byArray2, ptr2, n2, n3 & 0xFFFDFFFF | 0x10000, ptr3);
            this.inBuf.dataStart = ptr4.p;
            if (!eConvResult.isSourceBufferEmpty()) {
                return this.convertInternalResult(EConvResult.SourceBufferEmpty, ptr3);
            }
        }
        if (bl && (n3 & 0x20000) != 0 && ptr.p != n) {
            n = ptr.p;
            eConvResult = this.transConv(byArray, ptr, n, byArray2, ptr2, n2, n3, ptr3);
            if (eConvResult.isSourceBufferEmpty()) {
                eConvResult = EConvResult.AfterOutput;
            }
        } else if ((n3 & 0x20000) != 0 || this.numTranscoders == 1) {
            eConvResult = this.transConv(byArray, ptr, n, byArray2, ptr2, n2, n3, ptr3);
        } else {
            n3 |= 0x20000;
            while ((eConvResult = this.transConv(byArray, ptr, n, byArray2, ptr2, n2, n3, ptr3)).isAfterOutput()) {
            }
        }
        return this.convertInternalResult(eConvResult, ptr3);
    }

    private EConvResult convertInternalResult(EConvResult eConvResult, Ptr ptr) {
        this.lastError.result = eConvResult;
        switch (eConvResult) {
            case InvalidByteSequence: 
            case IncompleteInput: 
            case UndefinedConversion: {
                Transcoding transcoding;
                this.lastError.errorTranscoding = transcoding = this.elements[ptr.p].transcoding;
                this.lastError.source = transcoding.transcoder.source;
                this.lastError.destination = transcoding.transcoder.destination;
                this.lastError.errorBytes = transcoding.readBuf;
                this.lastError.errorBytesP = 0;
                this.lastError.errorBytesEnd = transcoding.recognizedLength;
                this.lastError.readAgainLength = transcoding.readAgainLength;
            }
        }
        return eConvResult;
    }

    private EConvResult convert(byte[] byArray, Ptr ptr, int n, byte[] byArray2, Ptr ptr2, int n2, int n3) {
        EConvResult eConvResult;
        this.started = true;
        block7: while (true) {
            if ((eConvResult = this.convertInternal(byArray, ptr, n, byArray2, ptr2, n2, n3)).isInvalidByteSequence() || eConvResult.isIncompleteInput()) {
                switch (this.flags & 0xF) {
                    case 2: {
                        if (this.outputReplacementCharacter() != 0) break;
                        continue block7;
                    }
                }
            }
            if (!eConvResult.isUndefinedConversion()) break;
            switch (this.flags & 0xF0) {
                case 32: {
                    if (this.outputReplacementCharacter() != 0) break block7;
                    continue block7;
                }
                case 48: {
                    if (this.outputHexCharref() != 0) break block7;
                    continue block7;
                }
            }
            break;
        }
        return eConvResult;
    }

    private int outputHexCharref() {
        int n;
        int n2;
        byte[] byArray;
        if (CaseInsensitiveBytesHash.caseInsensitiveEquals(this.lastError.source, "UTF-32BE".getBytes())) {
            byArray = this.lastError.errorBytes;
            n2 = this.lastError.errorBytesP;
            n = this.lastError.errorBytesEnd - this.lastError.errorBytesP;
        } else {
            Ptr ptr = new Ptr();
            byte[] byArray2 = new byte[1024];
            byArray = EConv.allocateConvertedString(this.lastError.source, "UTF-32BE".getBytes(), this.lastError.errorBytes, this.lastError.errorBytesP, this.lastError.errorBytesEnd - this.lastError.errorBytesP, byArray2, ptr);
            if (byArray == null) {
                return -1;
            }
            n2 = 0;
            n = ptr.p;
        }
        if (n % 4 != 0) {
            return -1;
        }
        int n3 = n2;
        while (4 <= n) {
            int n4 = 0;
            n4 += (byArray[n3] & 0xFF) << 24;
            n4 += (byArray[n3 + 1] & 0xFF) << 16;
            n4 += (byArray[n3 + 2] & 0xFF) << 8;
            byte[] byArray3 = String.format("&#x%X;", n4 += byArray[n3 + 3]).getBytes();
            if (this.insertOuput(byArray3, byArray3.length, "US-ASCII".getBytes()) == -1) {
                return -1;
            }
            n3 += 4;
            n -= 4;
        }
        return 0;
    }

    private byte[] encodingToInsertOutput() {
        Transcoding transcoding = this.lastTranscoding;
        if (transcoding == null) {
            return NULL_STRING;
        }
        Transcoder transcoder = transcoding.transcoder;
        return transcoder.compatibility.isEncoder() ? transcoder.source : transcoder.destination;
    }

    private static byte[] allocateConvertedString(byte[] byArray, byte[] byArray2, byte[] byArray3, int n, int n2, byte[] byArray4, Ptr ptr) {
        int n3 = byArray4 != null ? byArray4.length : (n2 == 0 ? 1 : n2);
        EConv eConv = TranscoderDB.open(byArray, byArray2, 0);
        if (eConv == null) {
            return null;
        }
        byte[] byArray5 = byArray4 != null ? byArray4 : new byte[n3];
        int n4 = 0;
        Ptr ptr2 = new Ptr(n);
        Ptr ptr3 = new Ptr(n4);
        EConvResult eConvResult = eConv.convert(byArray3, ptr2, n + n2, byArray5, ptr3, n3, 0);
        while (eConvResult.isDestinationBufferFull()) {
            byte[] byArray6 = new byte[n3 *= 2];
            System.arraycopy(byArray5, 0, byArray6, 0, n3 / 2);
            byArray5 = byArray6;
            ptr3.p = n4;
            eConvResult = eConv.convert(byArray3, ptr2, n + n2, byArray5, ptr3, n3, 0);
            n4 = ptr3.p;
        }
        if (!eConvResult.isFinished()) {
            return null;
        }
        eConv.close();
        ptr.p = n4;
        return byArray5;
    }

    int insertOuput(byte[] byArray, int n, byte[] byArray2) {
        Buffer buffer;
        Transcoding transcoding;
        int n2;
        byte[] byArray3;
        byte[] byArray4 = this.encodingToInsertOutput();
        byte[] byArray5 = new byte[4096];
        this.started = true;
        if (n == 0) {
            return 0;
        }
        if (CaseInsensitiveBytesHash.caseInsensitiveEquals(byArray4, byArray2)) {
            byArray3 = byArray;
            n2 = n;
        } else {
            Ptr ptr = new Ptr();
            byArray3 = EConv.allocateConvertedString(byArray2, byArray4, byArray, 0, n, byArray5, ptr);
            n2 = ptr.p;
        }
        int n3 = n2;
        int n4 = this.numTranscoders - 1;
        if (this.numTranscoders == 0) {
            transcoding = null;
            buffer = this.inBuf;
        } else if (this.elements[n4].transcoding.transcoder.compatibility.isEncoder()) {
            transcoding = this.elements[n4].transcoding;
            if ((n3 += transcoding.readAgainLength) < n2) {
                return -1;
            }
            buffer = n4 == 0 ? this.inBuf : this.elements[n4 - 1];
        } else {
            transcoding = this.elements[n4].transcoding;
            buffer = this.elements[n4];
        }
        if (buffer == null) {
            buffer = new Buffer();
            buffer.allocate(n3);
        } else if (n3 > buffer.bufEnd - buffer.dataEnd) {
            System.arraycopy(buffer.bytes, buffer.dataStart, buffer.bytes, buffer.bufStart, buffer.dataEnd - buffer.dataStart);
            buffer.dataEnd = buffer.dataStart + (buffer.dataEnd - buffer.dataStart);
            buffer.dataStart = buffer.bufStart;
            if (n3 > buffer.bufEnd - buffer.dataEnd) {
                int n5 = buffer.dataEnd - buffer.bufStart + n3;
                if (n3 > n5) {
                    return -1;
                }
                byte[] byArray6 = new byte[n5];
                System.arraycopy(buffer.bytes, buffer.bufStart, byArray6, 0, n5);
                buffer.bytes = byArray6;
                buffer.dataStart = 0;
                buffer.dataEnd -= buffer.bufStart;
                buffer.bufStart = 0;
                buffer.bufEnd = 0;
            }
        }
        System.arraycopy(byArray3, 0, buffer, buffer.dataEnd, n2);
        buffer.dataEnd += n2;
        if (transcoding != null && transcoding.transcoder.compatibility.isEncoder()) {
            System.arraycopy(transcoding.readBuf, transcoding.recognizedLength, buffer, buffer.dataEnd, transcoding.readAgainLength);
            buffer.dataEnd = transcoding.readAgainLength;
            transcoding.readAgainLength = 0;
        }
        return 0;
    }

    void close() {
        for (int i = 0; i < this.numTranscoders; ++i) {
            this.elements[i].transcoding.close();
        }
    }

    int putbackable() {
        return this.numTranscoders == 0 ? 0 : this.elements[0].transcoding.readAgainLength;
    }

    void putback(byte[] byArray, int n, int n2) {
        if (this.numTranscoders == 0 || n2 == 0) {
            return;
        }
        Transcoding transcoding = this.elements[0].transcoding;
        System.arraycopy(transcoding.readBuf, transcoding.recognizedLength + transcoding.readAgainLength, byArray, n, n2);
        transcoding.readAgainLength -= n2;
    }

    boolean addConverter(byte[] byArray, byte[] byArray2, int n) {
        if (this.started) {
            return false;
        }
        TranscoderDB.Entry entry = TranscoderDB.getEntry(byArray, byArray2);
        if (entry == null) {
            return false;
        }
        Transcoder transcoder = entry.getTranscoder();
        if (transcoder == null) {
            return false;
        }
        this.addTranscoderAt(transcoder, n);
        return true;
    }

    boolean decorateAt(byte[] byArray, int n) {
        return this.addConverter(NULL_STRING, byArray, n);
    }

    boolean decorateAtFirst(byte[] byArray) {
        if (this.numTranscoders == 0) {
            return this.decorateAt(byArray, 0);
        }
        Transcoder transcoder = this.elements[0].transcoding.transcoder;
        if (!EConv.decorator(transcoder.source, transcoder.destination) && transcoder.compatibility.isDecoder()) {
            return this.decorateAt(byArray, 1);
        }
        return this.decorateAt(byArray, 0);
    }

    boolean decorateAtLast(byte[] byArray) {
        if (this.numTranscoders == 0) {
            return this.decorateAt(byArray, 0);
        }
        Transcoder transcoder = this.elements[this.numTranscoders - 1].transcoding.transcoder;
        if (!EConv.decorator(transcoder.source, transcoder.destination) && transcoder.compatibility.isDecoder()) {
            return this.decorateAt(byArray, this.numTranscoders - 1);
        }
        return this.decorateAt(byArray, this.numTranscoders);
    }

    private void binmode() {
        TranscoderDB.Entry entry;
        Transcoder[] transcoderArray = new Transcoder[3];
        int n = 0;
        if ((this.flags & 0x100) != 0 && (entry = TranscoderDB.getEntry(NULL_STRING, "universal_newline".getBytes())).getTranscoder() != null) {
            transcoderArray[n++] = entry.getTranscoder();
        }
        if ((this.flags & 0x1000) != 0 && (entry = TranscoderDB.getEntry(NULL_STRING, "crlf_newline".getBytes())).getTranscoder() != null) {
            transcoderArray[n++] = entry.getTranscoder();
        }
        if ((this.flags & 0x2000) != 0 && (entry = TranscoderDB.getEntry(NULL_STRING, "cr_newline".getBytes())).getTranscoder() != null) {
            transcoderArray[n++] = entry.getTranscoder();
        }
        int n2 = this.numTranscoders;
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            int n4;
            for (n4 = 0; n4 < n && transcoderArray[n4] != this.elements[i].transcoding.transcoder; ++n4) {
            }
            if (n4 == n) {
                this.elements[n3] = this.elements[i];
                ++n3;
                continue;
            }
            this.elements[i].transcoding.close();
            --this.numTranscoders;
        }
        this.flags &= 0xFFFFC0FF;
    }

    private int makeReplacement() {
        byte[] byArray;
        byte[] byArray2;
        int n;
        if (this.replacementString != null) {
            return 0;
        }
        byte[] byArray3 = this.encodingToInsertOutput();
        if (byArray3.length != 0) {
            if (CaseInsensitiveBytesHash.caseInsensitiveEquals(byArray3, "UTF-8".getBytes())) {
                n = 3;
                byArray2 = "UTF-8".getBytes();
                byArray = new byte[]{-17, -65, -67};
            } else {
                n = 1;
                byArray2 = "US-ASCII".getBytes();
                byArray = new byte[]{63};
            }
        } else {
            n = 1;
            byArray2 = NULL_STRING;
            byArray = new byte[]{63};
        }
        this.replacementString = byArray;
        this.replacementLength = n;
        this.replacementEncoding = byArray2;
        return 0;
    }

    int setReplacement(byte[] byArray, int n, int n2, byte[] byArray2) {
        int n3;
        byte[] byArray3;
        byte[] byArray4 = this.encodingToInsertOutput();
        if (CaseInsensitiveBytesHash.caseInsensitiveEquals(byArray2, byArray4)) {
            byArray3 = new byte[n2];
            System.arraycopy(byArray, n, byArray3, 0, n2);
            n3 = n2;
            byArray4 = byArray2;
        } else {
            Ptr ptr = new Ptr();
            byArray3 = EConv.allocateConvertedString(byArray2, byArray4, byArray, n, n2, null, ptr);
            if (byArray == null) {
                return -1;
            }
            n3 = ptr.p;
        }
        this.replacementString = byArray3;
        this.replacementLength = n3;
        this.replacementEncoding = byArray4;
        return 0;
    }

    int outputReplacementCharacter() {
        if (this.makeReplacement() == -1) {
            return -1;
        }
        if (this.insertOuput(this.replacementString, this.replacementLength, this.replacementEncoding) == -1) {
            return -1;
        }
        return 0;
    }

    public String toStringFull() {
        String string = "EConv " + new String(this.source) + " => " + new String(this.destination) + "\n";
        string = string + "  started: " + this.started + "\n";
        string = string + "  replacement string: " + (this.replacementString == null ? "null" : new String(this.replacementString, 0, this.replacementLength)) + "\n";
        string = string + "  replacement encoding: " + (this.replacementEncoding == null ? "null" : new String(this.replacementEncoding)) + "\n";
        string = string + "\n";
        for (int i = 0; i < this.numTranscoders; ++i) {
            string = string + "  element " + i + ": " + this.elements[i].toString() + "\n";
        }
        string = string + "\n";
        string = string + "  lastTranscoding: " + this.lastTranscoding + "\n";
        string = string + "  last error: " + (this.lastError == null ? "null" : this.lastError.toString());
        return string;
    }

    static final class LastError {
        EConvResult result;
        Transcoding errorTranscoding;
        byte[] source;
        byte[] destination;
        byte[] errorBytes;
        int errorBytesP;
        int errorBytesEnd;
        int readAgainLength;

        LastError() {
        }

        void reset() {
            this.result = null;
            this.errorTranscoding = null;
            this.destination = null;
            this.source = null;
            this.errorBytes = null;
            this.errorBytesEnd = 0;
            this.errorBytesP = 0;
            this.readAgainLength = 0;
        }

        public String toString() {
            String string = "Last Error " + (this.source == null ? "null" : new String(this.source)) + " => " + (this.destination == null ? "null" : new String(this.destination)) + "\n";
            string = string + "  result: " + this.result.toString() + "\n";
            string = string + "  error bytes: " + (this.errorBytes == null ? "null" : new String(this.errorBytes, this.errorBytesP, this.errorBytesP + this.errorBytesEnd)) + "\n";
            string = string + "  read again length: " + this.readAgainLength;
            return string;
        }
    }

    static final class EConvElement
    extends Buffer {
        final Transcoding transcoding;
        EConvResult lastResult;

        EConvElement(Transcoding transcoding) {
            this.transcoding = transcoding;
            this.lastResult = EConvResult.SourceBufferEmpty;
        }

        public String toString() {
            String string = "EConv " + this.transcoding.toString() + "\n";
            string = string + "  last result: " + (Object)((Object)this.lastResult);
            return string;
        }
    }
}

