/*
 * Decompiled with CFR 0.152.
 */
package org.jcodings.transcode;

import java.util.Arrays;
import org.jcodings.ObjPtr;
import org.jcodings.exception.TranscoderException;
import org.jcodings.transcode.EConv;
import org.jcodings.transcode.EConvFlags;
import org.jcodings.transcode.Transcoder;
import org.jcodings.transcode.TranscoderList;
import org.jcodings.util.CaseInsensitiveBytesHash;
import org.jcodings.util.Hash;

public class TranscoderDB
implements EConvFlags {
    public static final CaseInsensitiveBytesHash<CaseInsensitiveBytesHash<Entry>> transcoders = new CaseInsensitiveBytesHash();

    static Entry makeEntry(byte[] byArray, byte[] byArray2) {
        Entry entry;
        CaseInsensitiveBytesHash<Entry> caseInsensitiveBytesHash = transcoders.get(byArray);
        if (caseInsensitiveBytesHash == null) {
            caseInsensitiveBytesHash = new CaseInsensitiveBytesHash();
            transcoders.putDirect(byArray, caseInsensitiveBytesHash);
        }
        if ((entry = caseInsensitiveBytesHash.get(byArray2)) != null) {
            throw new TranscoderException("transcoder from <%n> has been already registered", new String(byArray + " to " + new String(byArray2)));
        }
        entry = new Entry(byArray, byArray2);
        caseInsensitiveBytesHash.putDirect(byArray2, entry);
        return entry;
    }

    static Entry getEntry(byte[] byArray, byte[] byArray2) {
        CaseInsensitiveBytesHash<Entry> caseInsensitiveBytesHash = transcoders.get(byArray);
        return caseInsensitiveBytesHash == null ? null : caseInsensitiveBytesHash.get(byArray2);
    }

    static void register(Transcoder transcoder) {
        Entry entry = TranscoderDB.makeEntry(transcoder.source, transcoder.destination);
        if (entry.transcoder != null) {
            throw new TranscoderException("transcoder from <%n> has been already registered", new String(transcoder.source + " to " + new String(transcoder.destination)));
        }
        entry.transcoder = transcoder;
    }

    static void declare(byte[] byArray, byte[] byArray2, String string) {
        Entry entry = TranscoderDB.makeEntry(byArray, byArray2);
        entry.transcoderClass = string;
    }

    static int searchPath(byte[] byArray, byte[] byArray2, SearchPathCallback searchPathCallback) {
        if (CaseInsensitiveBytesHash.caseInsensitiveEquals(byArray, byArray2)) {
            return -1;
        }
        ObjPtr objPtr = new ObjPtr();
        SearchPathQueue searchPathQueue = new SearchPathQueue();
        searchPathQueue.encoding = byArray;
        ObjPtr<SearchPathQueue> objPtr2 = searchPathQueue.next;
        objPtr.p = searchPathQueue;
        CaseInsensitiveBytesHash<byte[]> caseInsensitiveBytesHash = new CaseInsensitiveBytesHash<byte[]>();
        caseInsensitiveBytesHash.put(byArray, EConv.NULL_STRING);
        while (objPtr.p != null) {
            Object object;
            byte[] byArray3;
            CaseInsensitiveBytesHash<Entry> caseInsensitiveBytesHash2;
            searchPathQueue = (SearchPathQueue)objPtr.p;
            objPtr.p = searchPathQueue.next.p;
            if (objPtr.p == null) {
                objPtr2 = objPtr;
            }
            if ((caseInsensitiveBytesHash2 = transcoders.get(searchPathQueue.encoding)) == null) continue;
            Entry entry = caseInsensitiveBytesHash2.get(byArray2);
            if (entry != null) {
                caseInsensitiveBytesHash.put(byArray2, searchPathQueue.encoding);
                byArray3 = byArray2;
                int n = 0;
                while ((object = (byte[])caseInsensitiveBytesHash.get(byArray3)) != EConv.NULL_STRING) {
                    ++n;
                    byArray3 = object;
                }
                int n2 = n;
                byArray3 = byArray2;
                while ((object = (byte[])caseInsensitiveBytesHash.get(byArray3)) != EConv.NULL_STRING) {
                    searchPathCallback.call((byte[])object, byArray3, --n2);
                    byArray3 = object;
                }
                return n;
            }
            byArray3 = searchPathQueue.encoding;
            for (Hash.HashEntry hashEntry : caseInsensitiveBytesHash2.entryIterator()) {
                object = (CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntry)hashEntry;
                byte[] byArray4 = object.bytes;
                if (caseInsensitiveBytesHash.get(byArray4) != null) continue;
                SearchPathQueue searchPathQueue2 = new SearchPathQueue();
                searchPathQueue2.encoding = byArray4;
                searchPathQueue2.next.p = null;
                objPtr2.p = searchPathQueue2;
                objPtr2 = searchPathQueue2.next;
                caseInsensitiveBytesHash.putDirect(byArray4, byArray3);
            }
            byArray3 = null;
        }
        return -1;
    }

    private static EConv openByTrascoderEntries(int n, Entry[] entryArray) {
        EConv eConv = new EConv(n);
        for (int i = 0; i < n; ++i) {
            Transcoder transcoder = entryArray[i].getTranscoder();
            eConv.addTranscoderAt(transcoder, eConv.numTranscoders);
        }
        return eConv;
    }

    private static EConv open0(byte[] byArray, byte[] byArray2, int n) {
        Object object;
        Entry[] entryArray;
        int n2;
        if (byArray.length == 0 && byArray2.length == 0) {
            n2 = 0;
            entryArray = null;
        } else {
            object = new ObjPtr();
            n2 = TranscoderDB.searchPath(byArray, byArray2, new SearchPathCallback((ObjPtr)object){
                int additional = 0;
                final /* synthetic */ ObjPtr val$lentries;
                {
                    this.val$lentries = objPtr;
                }

                @Override
                public void call(byte[] byArray, byte[] byArray2, int n) {
                    if (this.val$lentries.p == null) {
                        this.val$lentries.p = new Entry[n + 1 + this.additional];
                    }
                    ((Entry[])this.val$lentries.p)[n] = TranscoderDB.getEntry(byArray, byArray2);
                }
            });
            entryArray = (Entry[])((ObjPtr)object).p;
        }
        object = TranscoderDB.openByTrascoderEntries(n2, entryArray);
        ((EConv)object).flags = n;
        ((EConv)object).source = byArray;
        ((EConv)object).destination = byArray2;
        return object;
    }

    private static int decoratorNames(int n, byte[][] byArray) {
        switch (n & 0x3F00) {
            case 0: 
            case 256: 
            case 4096: 
            case 8192: {
                break;
            }
            default: {
                return -1;
            }
        }
        if ((n & 0x4000) != 0 && (n & 0x8000) != 0) {
            return -1;
        }
        int n2 = 0;
        if ((n & 0x4000) != 0) {
            byArray[n2++] = "xml_text_escape".getBytes();
        }
        if ((n & 0x8000) != 0) {
            byArray[n2++] = "xml_attr_content_escape".getBytes();
        }
        if ((n & 0x100000) != 0) {
            byArray[n2++] = "xml_attr_quote".getBytes();
        }
        if ((n & 0x1000) != 0) {
            byArray[n2++] = "crlf_newline".getBytes();
        }
        if ((n & 0x2000) != 0) {
            byArray[n2++] = "cr_newline".getBytes();
        }
        if ((n & 0x100) != 0) {
            byArray[n2] = "universal_newline".getBytes();
        }
        return n2;
    }

    static EConv open(byte[] byArray, byte[] byArray2, int n) {
        byte[][] byArrayArray = new byte[32][];
        int n2 = TranscoderDB.decoratorNames(n, byArrayArray);
        if (n2 == -1) {
            return null;
        }
        EConv eConv = TranscoderDB.open0(byArray, byArray2, n & 0xFF);
        for (int i = 0; i < n2; ++i) {
            if (eConv.decorateAtLast(byArrayArray[i])) continue;
            eConv.close();
            return null;
        }
        eConv.flags |= n & 0xFFFFFF00;
        return eConv;
    }

    static byte[] asciiCompatibleEncoding(byte[] byArray) {
        CaseInsensitiveBytesHash<Entry> caseInsensitiveBytesHash = transcoders.get(byArray);
        if (caseInsensitiveBytesHash == null || caseInsensitiveBytesHash.size() != 1) {
            return null;
        }
        byte[] byArray2 = null;
        for (Entry entry : caseInsensitiveBytesHash) {
            Transcoder transcoder;
            if (EConv.decorator(entry.source, entry.destination) || (transcoder = entry.getTranscoder()) == null || !transcoder.compatibility.isDecoder()) continue;
            byArray2 = transcoder.destination;
            break;
        }
        return byArray2;
    }

    static {
        String[][] stringArray = TranscoderList.LIST;
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i];
            TranscoderDB.declare(stringArray2[0].getBytes(), stringArray2[1].getBytes(), stringArray2[2]);
        }
    }

    static interface SearchPathCallback {
        public void call(byte[] var1, byte[] var2, int var3);
    }

    static final class SearchPathQueue {
        ObjPtr<SearchPathQueue> next = new ObjPtr();
        byte[] encoding;

        SearchPathQueue() {
        }
    }

    public static final class Entry {
        private String transcoderClass;
        private final byte[] source;
        private final byte[] destination;
        private Transcoder transcoder;

        private Entry(byte[] byArray, byte[] byArray2) {
            this.source = byArray;
            this.destination = byArray2;
        }

        public byte[] getSource() {
            return this.source;
        }

        public byte[] getDestination() {
            return this.destination;
        }

        public Transcoder getTranscoder() {
            if (this.transcoder == null) {
                if (this.transcoderClass != null) {
                    this.transcoder = Transcoder.load(this.transcoderClass);
                } else {
                    Transcoder.GenericTranscoderEntry[] genericTranscoderEntryArray = TranscoderList.GENERIC_LIST;
                    for (int i = 0; i < genericTranscoderEntryArray.length; ++i) {
                        Transcoder.GenericTranscoderEntry genericTranscoderEntry = genericTranscoderEntryArray[i];
                        if (!Arrays.equals(this.source, genericTranscoderEntry.source) || !Arrays.equals(this.destination, genericTranscoderEntry.destination)) continue;
                        this.transcoder = genericTranscoderEntry.createTranscoder();
                        break;
                    }
                }
            }
            return this.transcoder;
        }
    }
}

