/*
 * Decompiled with CFR 0.152.
 */
package org.jcodings.unicode;

import org.jcodings.ApplyAllCaseFoldFunction;
import org.jcodings.CaseFoldCodeItem;
import org.jcodings.CodeRange;
import org.jcodings.IntHolder;
import org.jcodings.MultiByteEncoding;
import org.jcodings.exception.CharacterPropertyException;
import org.jcodings.unicode.UnicodeProperties;
import org.jcodings.util.ArrayReader;
import org.jcodings.util.CaseInsensitiveBytesHash;
import org.jcodings.util.IntArrayHash;
import org.jcodings.util.IntHash;

public abstract class UnicodeEncoding
extends MultiByteEncoding {
    private static final int PROPERTY_NAME_MAX_SIZE = 20;
    static final short[] UNICODE_ISO_8859_1_CTypeTable = new short[]{16392, 16392, 16392, 16392, 16392, 16392, 16392, 16392, 16392, 17036, 17033, 17032, 17032, 17032, 16392, 16392, 16392, 16392, 16392, 16392, 16392, 16392, 16392, 16392, 16392, 16392, 16392, 16392, 16392, 16392, 16392, 16392, 17028, 16800, 16800, 16800, 16800, 16800, 16800, 16800, 16800, 16800, 16800, 16800, 16800, 16800, 16800, 16800, 30896, 30896, 30896, 30896, 30896, 30896, 30896, 30896, 30896, 30896, 16800, 16800, 16800, 16800, 16800, 16800, 16800, 31906, 31906, 31906, 31906, 31906, 31906, 29858, 29858, 29858, 29858, 29858, 29858, 29858, 29858, 29858, 29858, 29858, 29858, 29858, 29858, 29858, 29858, 29858, 29858, 29858, 29858, 16800, 16800, 16800, 16800, 20896, 16800, 30946, 30946, 30946, 30946, 30946, 30946, 28898, 28898, 28898, 28898, 28898, 28898, 28898, 28898, 28898, 28898, 28898, 28898, 28898, 28898, 28898, 28898, 28898, 28898, 28898, 28898, 16800, 16800, 16800, 16800, 16392, 8, 8, 8, 8, 8, 648, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 644, 416, 160, 160, 160, 160, 160, 160, 160, 160, 12514, 416, 160, 168, 160, 160, 160, 160, 4256, 4256, 160, 12514, 160, 416, 160, 4256, 12514, 416, 4256, 4256, 4256, 416, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 160, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 160, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514};
    static final CaseInsensitiveBytesHash<Integer> CTypeNameHash = UnicodeEncoding.initializeCTypeNameTable();
    static final int[] CaseFold_From = ArrayReader.readIntArray("CaseFold_From");
    static final int[][] CaseFold_To = ArrayReader.readNestedIntArray("CaseFold_To");
    static final int[] CaseFold_Locale_From = ArrayReader.readIntArray("CaseFold_Locale_From");
    static final int[][] CaseFold_Locale_To = ArrayReader.readNestedIntArray("CaseFold_Locale_To");
    static final int[] CaseUnfold_11_From = ArrayReader.readIntArray("CaseUnfold_11_From");
    static final int[][] CaseUnfold_11_To = ArrayReader.readNestedIntArray("CaseUnfold_11_To");
    static final int[] CaseUnfold_11_Locale_From = ArrayReader.readIntArray("CaseUnfold_11_Locale_From");
    static final int[][] CaseUnfold_11_Locale_To = ArrayReader.readNestedIntArray("CaseUnfold_11_Locale_To");
    static final int[][] CaseUnfold_12 = ArrayReader.readNestedIntArray("CaseUnfold_12");
    static final int[][] CaseUnfold_12_Locale = ArrayReader.readNestedIntArray("CaseUnfold_12_Locale");
    static final int[][] CaseUnfold_13 = ArrayReader.readNestedIntArray("CaseUnfold_13");
    static final IntHash<int[]> FoldHash = UnicodeEncoding.initializeFoldHash();
    static final IntHash<int[]> Unfold1Hash = UnicodeEncoding.initializeUnfold1Hash();
    static final IntArrayHash<int[]> Unfold2Hash = UnicodeEncoding.initializeUnfold2Hash();
    static final IntArrayHash<int[]> Unfold3Hash = UnicodeEncoding.initializeUnfold3Hash();

    protected UnicodeEncoding(String string, int n, int n2, int[] nArray) {
        super(string, n, n2, nArray, null, UNICODE_ISO_8859_1_CTypeTable);
    }

    protected UnicodeEncoding(String string, int n, int n2, int[] nArray, int[][] nArray2) {
        super(string, n, n2, nArray, nArray2, UNICODE_ISO_8859_1_CTypeTable);
    }

    @Override
    public String getCharsetName() {
        return new String(this.getName());
    }

    @Override
    public boolean isCodeCType(int n, int n2) {
        if (n2 <= 14 && n < 256) {
            return this.isCodeCTypeInternal(n, n2);
        }
        if (n2 > UnicodeProperties.CodeRangeTable.length) {
            throw new InternalError("undefined type (bug)");
        }
        return CodeRange.isInCodeRange(UnicodeProperties.CodeRangeTable[n2].getRange(), n);
    }

    protected final int[] ctypeCodeRange(int n) {
        if (n >= UnicodeProperties.CodeRangeTable.length) {
            throw new InternalError("undefined type (bug)");
        }
        return UnicodeProperties.CodeRangeTable[n].getRange();
    }

    @Override
    public int propertyNameToCType(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[20];
        int n3 = 0;
        for (int i = n; i < n2; i += this.length(byArray, i, n2)) {
            int n4 = this.mbcToCode(byArray, i, n2);
            if (n4 >= 128) {
                throw new CharacterPropertyException("invalid character property name <%n>");
            }
            byArray2[n3++] = (byte)n4;
            if (n3 < 20) continue;
            throw new CharacterPropertyException("invalid character property name <%n>", byArray, n, n2);
        }
        Integer n5 = CTypeNameHash.get(byArray2, 0, n3);
        if (n5 == null) {
            throw new CharacterPropertyException("invalid character property name <%n>", byArray, n, n2);
        }
        return n5;
    }

    @Override
    public int mbcCaseFold(int n, byte[] byArray, IntHolder intHolder, int n2, byte[] byArray2) {
        int n3 = intHolder.value;
        int n4 = 0;
        int n5 = this.mbcToCode(byArray, n3, n2);
        int n6 = this.length(byArray, n3, n2);
        intHolder.value += n6;
        int[] nArray = FoldHash.get(n5);
        if (nArray != null) {
            if (nArray.length == 1) {
                return this.codeToMbc(nArray[0], byArray2, n4);
            }
            int n7 = 0;
            for (int i = 0; i < nArray.length; ++i) {
                n6 = this.codeToMbc(nArray[i], byArray2, n4);
                n4 += n6;
                n7 += n6;
            }
            return n7;
        }
        for (int i = 0; i < n6; ++i) {
            byArray2[n4++] = byArray[n3++];
        }
        return n6;
    }

    @Override
    public void applyAllCaseFold(int n, ApplyAllCaseFoldFunction applyAllCaseFoldFunction, Object object) {
        int n2;
        int n3;
        int[] nArray;
        int n4;
        int n5;
        int[] nArray2 = new int[]{0};
        for (n5 = 0; n5 < CaseUnfold_11_From.length; ++n5) {
            n4 = CaseUnfold_11_From[n5];
            nArray = CaseUnfold_11_To[n5];
            for (n3 = 0; n3 < nArray.length; ++n3) {
                nArray2[0] = n4;
                applyAllCaseFoldFunction.apply(nArray[n3], nArray2, 1, object);
                nArray2[0] = nArray[n3];
                applyAllCaseFoldFunction.apply(n4, nArray2, 1, object);
                for (n2 = 0; n2 < n3; ++n2) {
                    nArray2[0] = nArray[n2];
                    applyAllCaseFoldFunction.apply(nArray[n3], nArray2, 1, object);
                    nArray2[0] = nArray[n3];
                    applyAllCaseFoldFunction.apply(nArray[n2], nArray2, 1, object);
                }
            }
        }
        for (n5 = 0; n5 < CaseUnfold_11_Locale_From.length; ++n5) {
            n4 = CaseUnfold_11_Locale_From[n5];
            nArray = CaseUnfold_11_Locale_To[n5];
            for (n3 = 0; n3 < nArray.length; ++n3) {
                nArray2[0] = n4;
                applyAllCaseFoldFunction.apply(nArray[n3], nArray2, 1, object);
                nArray2[0] = nArray[n3];
                applyAllCaseFoldFunction.apply(n4, nArray2, 1, object);
                for (n2 = 0; n2 < n3; ++n2) {
                    nArray2[0] = nArray[n2];
                    applyAllCaseFoldFunction.apply(nArray[n3], nArray2, 1, object);
                    nArray2[0] = nArray[n3];
                    applyAllCaseFoldFunction.apply(nArray[n2], nArray2, 1, object);
                }
            }
        }
        if ((n & 0x40000000) != 0) {
            for (n5 = 0; n5 < CaseUnfold_12.length; n5 += 2) {
                int[] nArray3 = CaseUnfold_12[n5];
                nArray = CaseUnfold_12[n5 + 1];
                for (n3 = 0; n3 < nArray.length; ++n3) {
                    applyAllCaseFoldFunction.apply(nArray[n3], nArray3, 2, object);
                    for (n2 = 0; n2 < nArray.length; ++n2) {
                        if (n2 == n3) continue;
                        nArray2[0] = nArray[n2];
                        applyAllCaseFoldFunction.apply(nArray[n3], nArray2, 1, object);
                    }
                }
            }
            for (n5 = 0; n5 < CaseUnfold_12_Locale.length; n5 += 2) {
                int[] nArray4 = CaseUnfold_12_Locale[n5];
                nArray = CaseUnfold_12_Locale[n5 + 1];
                for (n3 = 0; n3 < nArray.length; ++n3) {
                    applyAllCaseFoldFunction.apply(nArray[n3], nArray4, 2, object);
                    for (n2 = 0; n2 < nArray.length; ++n2) {
                        if (n2 == n3) continue;
                        nArray2[0] = nArray[n2];
                        applyAllCaseFoldFunction.apply(nArray[n3], nArray2, 1, object);
                    }
                }
            }
            for (n5 = 0; n5 < CaseUnfold_13.length; n5 += 2) {
                int[] nArray5 = CaseUnfold_13[n5];
                nArray = CaseUnfold_13[n5 + 1];
                for (n3 = 0; n3 < nArray.length; ++n3) {
                    applyAllCaseFoldFunction.apply(nArray[n3], nArray5, 3, object);
                    for (n2 = 0; n2 < nArray.length; ++n2) {
                        if (n2 == n3) continue;
                        nArray2[0] = nArray[n2];
                        applyAllCaseFoldFunction.apply(nArray[n3], nArray2, 1, object);
                    }
                }
            }
        }
    }

    @Override
    public CaseFoldCodeItem[] caseFoldCodesByString(int n, byte[] byArray, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7 = this.mbcToCode(byArray, n2, n3);
        int n8 = this.length(byArray, n2, n3);
        int n9 = 0;
        int n10 = 0;
        int[] nArray = FoldHash.get(n7);
        CaseFoldCodeItem[] caseFoldCodeItemArray = null;
        if (nArray != null) {
            caseFoldCodeItemArray = new CaseFoldCodeItem[13];
            if (nArray.length == 1) {
                n6 = n7;
                caseFoldCodeItemArray[0] = new CaseFoldCodeItem(n8, 1, new int[]{nArray[0]});
                ++n9;
                n7 = nArray[0];
                if ((nArray = Unfold1Hash.get(n7)) != null) {
                    for (n5 = 0; n5 < nArray.length; ++n5) {
                        if (nArray[n5] == n6) continue;
                        caseFoldCodeItemArray[n9] = new CaseFoldCodeItem(n8, 1, new int[]{nArray[n5]});
                        ++n9;
                    }
                }
            } else if ((n & 0x40000000) != 0) {
                int[] nArray2;
                int n11;
                int[][] nArray3 = new int[3][4];
                int[] nArray4 = new int[3];
                for (n10 = 0; n10 < nArray.length; ++n10) {
                    nArray3[n10][0] = nArray[n10];
                    int[] nArray5 = Unfold1Hash.get(nArray3[n10][0]);
                    if (nArray5 != null) {
                        for (n11 = 0; n11 < nArray5.length; ++n11) {
                            nArray3[n10][n11 + 1] = nArray5[n11];
                        }
                        nArray4[n10] = nArray5.length + 1;
                        continue;
                    }
                    nArray4[n10] = 1;
                }
                if (n10 == 2) {
                    for (int i = 0; i < nArray4[0]; ++i) {
                        for (n11 = 0; n11 < nArray4[1]; ++n11) {
                            caseFoldCodeItemArray[n9] = new CaseFoldCodeItem(n8, 2, new int[]{nArray3[0][i], nArray3[1][n11]});
                            ++n9;
                        }
                    }
                    nArray2 = Unfold2Hash.get(nArray);
                    if (nArray2 != null) {
                        for (n11 = 0; n11 < nArray2.length; ++n11) {
                            if (nArray2[n11] == n7) continue;
                            caseFoldCodeItemArray[n9] = new CaseFoldCodeItem(n8, 1, new int[]{nArray2[n11]});
                            ++n9;
                        }
                    }
                } else {
                    for (int i = 0; i < nArray4[0]; ++i) {
                        for (n11 = 0; n11 < nArray4[1]; ++n11) {
                            for (n4 = 0; n4 < nArray4[2]; ++n4) {
                                caseFoldCodeItemArray[n9] = new CaseFoldCodeItem(n8, 3, new int[]{nArray3[0][i], nArray3[1][n11], nArray3[2][n4]});
                                ++n9;
                            }
                        }
                    }
                    nArray2 = Unfold3Hash.get(nArray);
                    if (nArray2 != null) {
                        for (n11 = 0; n11 < nArray2.length; ++n11) {
                            if (nArray2[n11] == n7) continue;
                            caseFoldCodeItemArray[n9] = new CaseFoldCodeItem(n8, 1, new int[]{nArray2[n11]});
                            ++n9;
                        }
                    }
                }
                n = 0;
            }
        } else {
            nArray = Unfold1Hash.get(n7);
            if (nArray != null) {
                caseFoldCodeItemArray = new CaseFoldCodeItem[13];
                for (int i = 0; i < nArray.length; ++i) {
                    caseFoldCodeItemArray[n9] = new CaseFoldCodeItem(n8, 1, new int[]{nArray[i]});
                    ++n9;
                }
            }
        }
        if ((n & 0x40000000) != 0) {
            if (caseFoldCodeItemArray == null) {
                caseFoldCodeItemArray = new CaseFoldCodeItem[13];
            }
            if ((n2 += n8) < n3) {
                n6 = n7;
                n7 = this.mbcToCode(byArray, n2, n3);
                nArray = FoldHash.get(n7);
                n5 = nArray != null && nArray.length == 1 ? nArray[0] : n7;
                int n12 = this.length(byArray, n2, n3);
                n8 += n12;
                int[] nArray6 = Unfold2Hash.get(n6, n5);
                if (nArray6 != null) {
                    for (n4 = 0; n4 < nArray6.length; ++n4) {
                        caseFoldCodeItemArray[n9] = new CaseFoldCodeItem(n8, 1, new int[]{nArray6[n4]});
                        ++n9;
                    }
                }
                if ((n2 += n12) < n3) {
                    n7 = this.mbcToCode(byArray, n2, n3);
                    nArray = FoldHash.get(n7);
                    n4 = nArray != null && nArray.length == 1 ? nArray[0] : n7;
                    n12 = this.length(byArray, n2, n3);
                    n8 += n12;
                    nArray6 = Unfold3Hash.get(n6, n5, n4);
                    if (nArray6 != null) {
                        for (int i = 0; i < nArray6.length; ++i) {
                            caseFoldCodeItemArray[n9] = new CaseFoldCodeItem(n8, 1, new int[]{nArray6[i]});
                            ++n9;
                        }
                    }
                }
            }
        }
        if (caseFoldCodeItemArray == null || n9 == 0) {
            return EMPTY_FOLD_CODES;
        }
        if (n9 < caseFoldCodeItemArray.length) {
            CaseFoldCodeItem[] caseFoldCodeItemArray2 = new CaseFoldCodeItem[n9];
            System.arraycopy(caseFoldCodeItemArray, 0, caseFoldCodeItemArray2, 0, n9);
            return caseFoldCodeItemArray2;
        }
        return caseFoldCodeItemArray;
    }

    private static CaseInsensitiveBytesHash<Integer> initializeCTypeNameTable() {
        CaseInsensitiveBytesHash<Integer> caseInsensitiveBytesHash = new CaseInsensitiveBytesHash<Integer>();
        for (int i = 0; i < UnicodeProperties.CodeRangeTable.length; ++i) {
            caseInsensitiveBytesHash.putDirect(UnicodeProperties.CodeRangeTable[i].name, i);
        }
        return caseInsensitiveBytesHash;
    }

    private static IntHash<int[]> initializeFoldHash() {
        int n;
        IntHash<int[]> intHash = new IntHash<int[]>(1200);
        for (n = 0; n < CaseFold_From.length; ++n) {
            intHash.putDirect(CaseFold_From[n], CaseFold_To[n]);
        }
        for (n = 0; n < CaseFold_Locale_From.length; ++n) {
            intHash.putDirect(CaseFold_Locale_From[n], CaseFold_Locale_To[n]);
        }
        return intHash;
    }

    private static IntHash<int[]> initializeUnfold1Hash() {
        int n;
        IntHash<int[]> intHash = new IntHash<int[]>(1000);
        for (n = 0; n < CaseUnfold_11_From.length; ++n) {
            intHash.putDirect(CaseUnfold_11_From[n], CaseUnfold_11_To[n]);
        }
        for (n = 0; n < CaseUnfold_11_Locale_From.length; ++n) {
            intHash.putDirect(CaseUnfold_11_Locale_From[n], CaseUnfold_11_Locale_To[n]);
        }
        return intHash;
    }

    private static IntArrayHash<int[]> initializeUnfold2Hash() {
        int n;
        IntArrayHash<int[]> intArrayHash = new IntArrayHash<int[]>(200);
        for (n = 0; n < CaseUnfold_12.length; n += 2) {
            intArrayHash.putDirect(CaseUnfold_12[n], CaseUnfold_12[n + 1]);
        }
        for (n = 0; n < CaseUnfold_12_Locale.length; n += 2) {
            intArrayHash.putDirect(CaseUnfold_12_Locale[n], CaseUnfold_12_Locale[n + 1]);
        }
        return intArrayHash;
    }

    private static IntArrayHash<int[]> initializeUnfold3Hash() {
        IntArrayHash<int[]> intArrayHash = new IntArrayHash<int[]>(30);
        for (int i = 0; i < CaseUnfold_13.length; i += 2) {
            intArrayHash.putDirect(CaseUnfold_13[i], CaseUnfold_13[i + 1]);
        }
        return intArrayHash;
    }

    static final class CodeRangeEntry {
        final String table;
        final byte[] name;
        int[] range;

        CodeRangeEntry(String string, String string2) {
            this.table = string2;
            this.name = string.getBytes();
        }

        public int[] getRange() {
            if (this.range == null) {
                this.range = ArrayReader.readIntArray(this.table);
            }
            return this.range;
        }
    }
}

