/*
 * Decompiled with CFR 0.152.
 */
package org.jcodings.util;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jcodings.exception.InternalException;

public class ArrayReader {
    static DataInputStream openStream(String string) {
        String string2 = "/tables/" + string + ".bin";
        InputStream inputStream = ArrayReader.class.getResourceAsStream(string2);
        if (inputStream == null) {
            throw new InternalException("entry: " + string2 + " not found");
        }
        return new DataInputStream(inputStream);
    }

    public static byte[] readByteArray(String string) {
        DataInputStream dataInputStream = ArrayReader.openStream(string);
        try {
            int n = dataInputStream.readInt();
            byte[] byArray = new byte[n];
            for (int i = 0; i < n; ++i) {
                byArray[i] = dataInputStream.readByte();
            }
            ArrayReader.checkAvailable(dataInputStream, string);
            return byArray;
        }
        catch (IOException iOException) {
            ArrayReader.decorate(iOException, string);
            return null;
        }
    }

    public static int[] readIntArray(String string) {
        DataInputStream dataInputStream = ArrayReader.openStream(string);
        try {
            int n = dataInputStream.readInt();
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = dataInputStream.readInt();
            }
            ArrayReader.checkAvailable(dataInputStream, string);
            return nArray;
        }
        catch (IOException iOException) {
            ArrayReader.decorate(iOException, string);
            return null;
        }
    }

    public static int[][] readNestedIntArray(String string) {
        DataInputStream dataInputStream = ArrayReader.openStream(string);
        try {
            int n = dataInputStream.readInt();
            int[][] nArrayArray = new int[n][];
            for (int i = 0; i < n; ++i) {
                int n2 = dataInputStream.readInt();
                int[] nArray = new int[n2];
                nArrayArray[i] = nArray;
                for (int j = 0; j < n2; ++j) {
                    nArray[j] = dataInputStream.readInt();
                }
            }
            ArrayReader.checkAvailable(dataInputStream, string);
            return nArrayArray;
        }
        catch (IOException iOException) {
            ArrayReader.decorate(iOException, string);
            return null;
        }
    }

    static void checkAvailable(DataInputStream dataInputStream, String string) throws IOException {
        if (dataInputStream.available() != 0) {
            throw new InternalException("length mismatch for table: " + string + " (" + dataInputStream.available() + " left)");
        }
    }

    static void decorate(IOException iOException, String string) {
        throw new InternalException("problem reading table: " + string + ": " + iOException);
    }
}

