/*
 * Decompiled with CFR 0.152.
 */
package org.jcodings.util;

import org.jcodings.util.Hash;

public final class BytesHash<V>
extends Hash<V> {
    public BytesHash() {
    }

    public BytesHash(int n) {
        super(n);
    }

    @Override
    protected void init() {
        this.head = new BytesHashEntry();
    }

    public static int hashCode(byte[] byArray, int n, int n2) {
        int n3 = 0;
        while (n < n2) {
            n3 = (n3 << 16) + (n3 << 6) - n3 + byArray[n++];
        }
        n3 += n3 >> 5;
        return n3;
    }

    public V put(byte[] byArray, V v) {
        return this.put(byArray, 0, byArray.length, v);
    }

    public V put(byte[] byArray, int n, int n2, V v) {
        this.checkResize();
        int n3 = BytesHash.hashValue(BytesHash.hashCode(byArray, n, n2));
        int n4 = BytesHash.bucketIndex(n3, this.table.length);
        BytesHashEntry bytesHashEntry = (BytesHashEntry)this.table[n4];
        while (bytesHashEntry != null) {
            if (bytesHashEntry.hash == n3 && bytesHashEntry.equals(byArray, n, n2)) {
                bytesHashEntry.value = v;
                return v;
            }
            bytesHashEntry = (BytesHashEntry)bytesHashEntry.next;
        }
        this.table[n4] = new BytesHashEntry<V>(n3, this.table[n4], v, byArray, n, n2, this.head);
        ++this.size;
        return null;
    }

    public void putDirect(byte[] byArray, V v) {
        this.putDirect(byArray, 0, byArray.length, v);
    }

    public void putDirect(byte[] byArray, int n, int n2, V v) {
        this.checkResize();
        int n3 = BytesHash.hashValue(BytesHash.hashCode(byArray, n, n2));
        int n4 = BytesHash.bucketIndex(n3, this.table.length);
        this.table[n4] = new BytesHashEntry<V>(n3, this.table[n4], v, byArray, n, n2, this.head);
        ++this.size;
    }

    public V get(byte[] byArray) {
        return this.get(byArray, 0, byArray.length);
    }

    public V get(byte[] byArray, int n, int n2) {
        int n3 = BytesHash.hashValue(BytesHash.hashCode(byArray, n, n2));
        BytesHashEntry bytesHashEntry = (BytesHashEntry)this.table[BytesHash.bucketIndex(n3, this.table.length)];
        while (bytesHashEntry != null) {
            if (bytesHashEntry.hash == n3 && bytesHashEntry.equals(byArray, n, n2)) {
                return (V)bytesHashEntry.value;
            }
            bytesHashEntry = (BytesHashEntry)bytesHashEntry.next;
        }
        return null;
    }

    public V delete(byte[] byArray) {
        return this.delete(byArray, 0, byArray.length);
    }

    public V delete(byte[] byArray, int n, int n2) {
        int n3 = BytesHash.hashValue(BytesHash.hashCode(byArray, n, n2));
        int n4 = BytesHash.bucketIndex(n3, this.table.length);
        BytesHashEntry bytesHashEntry = (BytesHashEntry)this.table[n4];
        if (bytesHashEntry == null) {
            return null;
        }
        if (bytesHashEntry.hash == n3 && bytesHashEntry.equals(byArray, n, n2)) {
            this.table[n4] = bytesHashEntry.next;
            --this.size;
            bytesHashEntry.remove();
            return (V)bytesHashEntry.value;
        }
        while (bytesHashEntry.next != null) {
            Hash.HashEntry hashEntry = bytesHashEntry.next;
            if (hashEntry.hash == n3 && bytesHashEntry.equals(byArray, n, n2)) {
                bytesHashEntry.next = bytesHashEntry.next.next;
                --this.size;
                hashEntry.remove();
                return hashEntry.value;
            }
            bytesHashEntry = (BytesHashEntry)bytesHashEntry.next;
        }
        return null;
    }

    public static final class BytesHashEntry<V>
    extends Hash.HashEntry<V> {
        public final byte[] bytes;
        public final int p;
        public final int end;

        public BytesHashEntry(int n, Hash.HashEntry<V> hashEntry, V v, byte[] byArray, int n2, int n3, Hash.HashEntry<V> hashEntry2) {
            super(n, hashEntry, v, hashEntry2);
            this.bytes = byArray;
            this.p = n2;
            this.end = n3;
        }

        public BytesHashEntry() {
            this.bytes = null;
            this.end = 0;
            this.p = 0;
        }

        public boolean equals(byte[] byArray, int n, int n2) {
            if (this.end - this.p != n2 - n) {
                return false;
            }
            if (this.bytes == byArray) {
                return true;
            }
            int n3 = this.p;
            while (n3 < this.end) {
                if (this.bytes[n3++] == byArray[n++]) continue;
                return false;
            }
            return true;
        }
    }
}

