/*
 * Decompiled with CFR 0.152.
 */
package org.jcodings.util;

import org.jcodings.ascii.AsciiTables;
import org.jcodings.util.Hash;

public final class CaseInsensitiveBytesHash<V>
extends Hash<V> {
    public CaseInsensitiveBytesHash() {
    }

    public CaseInsensitiveBytesHash(int n) {
        super(n);
    }

    @Override
    protected void init() {
        this.head = new CaseInsensitiveBytesHashEntry();
    }

    public static int hashCode(byte[] byArray, int n, int n2) {
        int n3 = 0;
        while (n < n2) {
            n3 = (n3 << 16) + (n3 << 6) - n3 + AsciiTables.ToLowerCaseTable[byArray[n++] & 0xFF];
        }
        n3 += n3 >> 5;
        return n3;
    }

    public V put(byte[] byArray, V v) {
        return this.put(byArray, 0, byArray.length, v);
    }

    public V put(byte[] byArray, int n, int n2, V v) {
        this.checkResize();
        int n3 = CaseInsensitiveBytesHash.hashValue(CaseInsensitiveBytesHash.hashCode(byArray, n, n2));
        int n4 = CaseInsensitiveBytesHash.bucketIndex(n3, this.table.length);
        CaseInsensitiveBytesHashEntry caseInsensitiveBytesHashEntry = (CaseInsensitiveBytesHashEntry)this.table[n4];
        while (caseInsensitiveBytesHashEntry != null) {
            if (caseInsensitiveBytesHashEntry.hash == n3 && caseInsensitiveBytesHashEntry.equals(byArray, n, n2)) {
                caseInsensitiveBytesHashEntry.value = v;
                return v;
            }
            caseInsensitiveBytesHashEntry = (CaseInsensitiveBytesHashEntry)caseInsensitiveBytesHashEntry.next;
        }
        this.table[n4] = new CaseInsensitiveBytesHashEntry<V>(n3, this.table[n4], v, byArray, n, n2, this.head);
        ++this.size;
        return null;
    }

    public void putDirect(byte[] byArray, V v) {
        this.putDirect(byArray, 0, byArray.length, v);
    }

    public void putDirect(byte[] byArray, int n, int n2, V v) {
        this.checkResize();
        int n3 = CaseInsensitiveBytesHash.hashValue(CaseInsensitiveBytesHash.hashCode(byArray, n, n2));
        int n4 = CaseInsensitiveBytesHash.bucketIndex(n3, this.table.length);
        this.table[n4] = new CaseInsensitiveBytesHashEntry<V>(n3, this.table[n4], v, byArray, n, n2, this.head);
        ++this.size;
    }

    public V get(byte[] byArray) {
        return this.get(byArray, 0, byArray.length);
    }

    public V get(byte[] byArray, int n, int n2) {
        int n3 = CaseInsensitiveBytesHash.hashValue(CaseInsensitiveBytesHash.hashCode(byArray, n, n2));
        CaseInsensitiveBytesHashEntry caseInsensitiveBytesHashEntry = (CaseInsensitiveBytesHashEntry)this.table[CaseInsensitiveBytesHash.bucketIndex(n3, this.table.length)];
        while (caseInsensitiveBytesHashEntry != null) {
            if (caseInsensitiveBytesHashEntry.hash == n3 && caseInsensitiveBytesHashEntry.equals(byArray, n, n2)) {
                return (V)caseInsensitiveBytesHashEntry.value;
            }
            caseInsensitiveBytesHashEntry = (CaseInsensitiveBytesHashEntry)caseInsensitiveBytesHashEntry.next;
        }
        return null;
    }

    public V delete(byte[] byArray) {
        return this.delete(byArray, 0, byArray.length);
    }

    public V delete(byte[] byArray, int n, int n2) {
        int n3 = CaseInsensitiveBytesHash.hashValue(CaseInsensitiveBytesHash.hashCode(byArray, n, n2));
        int n4 = CaseInsensitiveBytesHash.bucketIndex(n3, this.table.length);
        CaseInsensitiveBytesHashEntry caseInsensitiveBytesHashEntry = (CaseInsensitiveBytesHashEntry)this.table[n4];
        if (caseInsensitiveBytesHashEntry == null) {
            return null;
        }
        if (caseInsensitiveBytesHashEntry.hash == n3 && caseInsensitiveBytesHashEntry.equals(byArray, n, n2)) {
            this.table[n4] = caseInsensitiveBytesHashEntry.next;
            --this.size;
            caseInsensitiveBytesHashEntry.remove();
            return (V)caseInsensitiveBytesHashEntry.value;
        }
        while (caseInsensitiveBytesHashEntry.next != null) {
            Hash.HashEntry hashEntry = caseInsensitiveBytesHashEntry.next;
            if (hashEntry.hash == n3 && caseInsensitiveBytesHashEntry.equals(byArray, n, n2)) {
                caseInsensitiveBytesHashEntry.next = caseInsensitiveBytesHashEntry.next.next;
                --this.size;
                hashEntry.remove();
                return hashEntry.value;
            }
            caseInsensitiveBytesHashEntry = (CaseInsensitiveBytesHashEntry)caseInsensitiveBytesHashEntry.next;
        }
        return null;
    }

    @Override
    public CaseInsensitiveBytesHashEntryIterator entryIterator() {
        return new CaseInsensitiveBytesHashEntryIterator();
    }

    public static boolean caseInsensitiveEquals(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        if (n4 - n3 != n2 - n) {
            return false;
        }
        if (byArray2 == byArray) {
            return true;
        }
        int n5 = n3;
        while (n5 < n4) {
            if (AsciiTables.ToLowerCaseTable[byArray2[n5++] & 0xFF] == AsciiTables.ToLowerCaseTable[byArray[n++] & 0xFF]) continue;
            return false;
        }
        return true;
    }

    public static boolean caseInsensitiveEquals(byte[] byArray, byte[] byArray2) {
        return CaseInsensitiveBytesHash.caseInsensitiveEquals(byArray, 0, byArray.length, byArray2, 0, byArray2.length);
    }

    public class CaseInsensitiveBytesHashEntryIterator
    extends Hash.HashEntryIterator {
        public CaseInsensitiveBytesHashEntryIterator() {
            super(CaseInsensitiveBytesHash.this);
        }

        @Override
        public CaseInsensitiveBytesHashEntry<V> next() {
            return (CaseInsensitiveBytesHashEntry)super.next();
        }
    }

    public static final class CaseInsensitiveBytesHashEntry<V>
    extends Hash.HashEntry<V> {
        public final byte[] bytes;
        public final int p;
        public final int end;

        public CaseInsensitiveBytesHashEntry(int n, Hash.HashEntry<V> hashEntry, V v, byte[] byArray, int n2, int n3, Hash.HashEntry<V> hashEntry2) {
            super(n, hashEntry, v, hashEntry2);
            this.bytes = byArray;
            this.p = n2;
            this.end = n3;
        }

        public CaseInsensitiveBytesHashEntry() {
            this.bytes = null;
            this.end = 0;
            this.p = 0;
        }

        public boolean equals(byte[] byArray, int n, int n2) {
            if (this.end - this.p != n2 - n) {
                return false;
            }
            if (this.bytes == byArray) {
                return true;
            }
            int n3 = this.p;
            while (n3 < this.end) {
                if (AsciiTables.ToLowerCaseTable[this.bytes[n3++] & 0xFF] == AsciiTables.ToLowerCaseTable[byArray[n++] & 0xFF]) continue;
                return false;
            }
            return true;
        }
    }
}

