/*
 * Decompiled with CFR 0.152.
 */
package org.jcodings.util;

import java.util.Iterator;
import org.jcodings.exception.InternalException;

public abstract class Hash<V>
implements Iterable<V> {
    protected HashEntry<V>[] table;
    protected int size;
    private static final int[] PRIMES = new int[]{11, 19, 37, 67, 131, 283, 521, 1033, 2053, 4099, 8219, 16427, 32771, 65581, 131101, 262147, 524309, 0x100007, 0x200011, 0x40000F, 0x800009, 16777259, 0x2000023, 0x400000F, 134217757, 0x10000003, 0x2000000B, 0x40000055, 0};
    private static final int INITIAL_CAPACITY = PRIMES[0];
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    protected HashEntry<V> head;
    private static final int MIN_CAPA = 8;
    private static final int HASH_SIGN_BIT_MASK = Integer.MAX_VALUE;

    public Hash() {
        this.table = new HashEntry[INITIAL_CAPACITY];
        this.init();
    }

    protected abstract void init();

    public Hash(int n) {
        int n2 = 0;
        int n3 = 8;
        while (n2 < PRIMES.length) {
            if (n3 > n) {
                this.table = new HashEntry[PRIMES[n2]];
                this.init();
                return;
            }
            ++n2;
            n3 <<= 1;
        }
        throw new InternalException("run out of polynomials");
    }

    public final int size() {
        return this.size;
    }

    protected final void checkResize() {
        if (this.size == this.table.length) {
            int n = this.table.length + 1;
            int n2 = 0;
            int n3 = 8;
            while (n2 < PRIMES.length) {
                if (n3 > n) {
                    this.resize(PRIMES[n2]);
                    return;
                }
                ++n2;
                n3 <<= 1;
            }
            return;
        }
    }

    protected final void resize(int n) {
        HashEntry<V>[] hashEntryArray = this.table;
        HashEntry[] hashEntryArray2 = new HashEntry[n];
        for (int i = 0; i < hashEntryArray.length; ++i) {
            HashEntry<V> hashEntry = hashEntryArray[i];
            hashEntryArray[i] = null;
            while (hashEntry != null) {
                HashEntry hashEntry2 = hashEntry.next;
                int n2 = Hash.bucketIndex(hashEntry.hash, n);
                hashEntry.next = hashEntryArray2[n2];
                hashEntryArray2[n2] = hashEntry;
                hashEntry = hashEntry2;
            }
        }
        this.table = hashEntryArray2;
    }

    protected static int bucketIndex(int n, int n2) {
        return n % n2;
    }

    protected static int hashValue(int n) {
        return n & Integer.MAX_VALUE;
    }

    @Override
    public Iterator<V> iterator() {
        return new HashIterator();
    }

    public HashEntryIterator entryIterator() {
        return new HashEntryIterator();
    }

    public class HashEntryIterator
    implements Iterator<HashEntry<V>>,
    Iterable<HashEntry<V>> {
        HashEntry<V> next;

        public HashEntryIterator() {
            this.next = Hash.this.head.after;
        }

        @Override
        public Iterator<HashEntry<V>> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            return this.next != Hash.this.head;
        }

        @Override
        public HashEntry<V> next() {
            HashEntry hashEntry = this.next;
            this.next = hashEntry.after;
            return hashEntry;
        }

        @Override
        public void remove() {
            throw new InternalException("not supported operation exception");
        }
    }

    public class HashIterator
    implements Iterator<V> {
        HashEntry<V> next;

        public HashIterator() {
            this.next = Hash.this.head.after;
        }

        @Override
        public boolean hasNext() {
            return this.next != Hash.this.head;
        }

        @Override
        public V next() {
            HashEntry hashEntry = this.next;
            this.next = hashEntry.after;
            return hashEntry.value;
        }

        @Override
        public void remove() {
            throw new InternalException("not supported operation exception");
        }
    }

    public static class HashEntry<V> {
        final int hash;
        protected HashEntry<V> next;
        protected HashEntry<V> before;
        protected HashEntry<V> after;
        public V value;

        HashEntry(int n, HashEntry<V> hashEntry, V v, HashEntry<V> hashEntry2) {
            this.hash = n;
            this.next = hashEntry;
            this.value = v;
            this.after = hashEntry2;
            this.before = hashEntry2.before;
            this.before.after = this;
            this.after.before = this;
        }

        void remove() {
            this.before.after = this.after;
            this.after.before = this.before;
        }

        HashEntry() {
            this.hash = 0;
            this.before = this.after = this;
        }

        public int getHash() {
            return this.hash;
        }
    }
}

