/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.tiff;

import com.twelvemonkeys.imageio.ImageReaderBase;
import com.twelvemonkeys.imageio.color.CIELabColorConverter;
import com.twelvemonkeys.imageio.color.ColorSpaces;
import com.twelvemonkeys.imageio.color.YCbCrConverter;
import com.twelvemonkeys.imageio.metadata.CompoundDirectory;
import com.twelvemonkeys.imageio.metadata.Directory;
import com.twelvemonkeys.imageio.metadata.Entry;
import com.twelvemonkeys.imageio.metadata.exif.EXIFReader;
import com.twelvemonkeys.imageio.metadata.exif.Rational;
import com.twelvemonkeys.imageio.metadata.iptc.IPTCReader;
import com.twelvemonkeys.imageio.metadata.psd.PSDReader;
import com.twelvemonkeys.imageio.metadata.xmp.XMPReader;
import com.twelvemonkeys.imageio.plugins.tiff.CCITTFaxDecoderStream;
import com.twelvemonkeys.imageio.plugins.tiff.HorizontalDeDifferencingStream;
import com.twelvemonkeys.imageio.plugins.tiff.LZWDecoder;
import com.twelvemonkeys.imageio.plugins.tiff.TIFFImageMetadata;
import com.twelvemonkeys.imageio.plugins.tiff.TIFFImageReaderSpi;
import com.twelvemonkeys.imageio.plugins.tiff.YCbCr16UpsamplerStream;
import com.twelvemonkeys.imageio.plugins.tiff.YCbCrUpsamplerStream;
import com.twelvemonkeys.imageio.stream.ByteArrayImageInputStream;
import com.twelvemonkeys.imageio.stream.SubImageInputStream;
import com.twelvemonkeys.imageio.util.IIOUtil;
import com.twelvemonkeys.imageio.util.ImageTypeSpecifiers;
import com.twelvemonkeys.imageio.util.ProgressListenerBase;
import com.twelvemonkeys.io.FastByteArrayOutputStream;
import com.twelvemonkeys.io.LittleEndianDataInputStream;
import com.twelvemonkeys.io.enc.Decoder;
import com.twelvemonkeys.io.enc.DecoderStream;
import com.twelvemonkeys.io.enc.PackBitsDecoder;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.CMMException;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.event.IIOReadProgressListener;
import javax.imageio.event.IIOReadWarningListener;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.plugins.jpeg.JPEGImageReadParam;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageInputStream;

public class TIFFImageReader
extends ImageReaderBase {
    static final boolean DEBUG = "true".equalsIgnoreCase(System.getProperty("com.twelvemonkeys.imageio.plugins.tiff.debug"));
    static final double[] CCIR_601_1_COEFFICIENTS = new double[]{0.299, 0.587, 0.114};
    private CompoundDirectory IFDs;
    private Directory currentIFD;

    TIFFImageReader(TIFFImageReaderSpi tIFFImageReaderSpi) {
        super((ImageReaderSpi)((Object)tIFFImageReaderSpi));
    }

    protected void resetMembers() {
        this.IFDs = null;
        this.currentIFD = null;
    }

    private void readMetadata() throws IOException {
        if (this.imageInput == null) {
            throw new IllegalStateException("input not set");
        }
        if (this.IFDs == null) {
            this.IFDs = (CompoundDirectory)new EXIFReader().read(this.imageInput);
            if (DEBUG) {
                Entry entry;
                Object object;
                Object object2;
                System.err.println("Byte order: " + this.imageInput.getByteOrder());
                System.err.println("Number of images: " + this.IFDs.directoryCount());
                for (int i = 0; i < this.IFDs.directoryCount(); ++i) {
                    System.err.printf("IFD %d: %s\n", i, this.IFDs.getDirectory(i));
                }
                Entry entry2 = this.IFDs.getEntryById((Object)700);
                if (entry2 != null) {
                    object2 = (byte[])entry2.getValue();
                    int n = ((byte[])object2).length;
                    for (int i = n - 1; i > 0 && object2[i] == 0; --i) {
                        --n;
                    }
                    object = new XMPReader().read((ImageInputStream)new ByteArrayImageInputStream(object2, 0, n));
                    System.err.println("-----------------------------------------------------------------------------");
                    System.err.println("xmp: " + object);
                }
                if ((object2 = (Object)this.IFDs.getEntryById((Object)33723)) != null) {
                    Object object3 = object2.getValue();
                    if (object3 instanceof short[]) {
                        System.err.println("short[]: " + object3);
                    }
                    if (object3 instanceof long[]) {
                        System.err.println("long[]: " + object3);
                        object = (long[])object3;
                        object3 = new byte[((Entry)object).length * 8];
                        ByteBuffer.wrap((byte[])object3).asLongBuffer().put((long[])object);
                    }
                    if (object3 instanceof float[]) {
                        System.err.println("float[]: " + object3);
                    }
                    if (object3 instanceof double[]) {
                        System.err.println("double[]: " + object3);
                    }
                    object = new IPTCReader().read((ImageInputStream)new ByteArrayImageInputStream((byte[])object3));
                    System.err.println("-----------------------------------------------------------------------------");
                    System.err.println("iptc: " + object);
                }
                if ((entry = this.IFDs.getEntryById((Object)34377)) != null) {
                    object = new PSDReader().read((ImageInputStream)new ByteArrayImageInputStream((byte[])entry.getValue()));
                    System.err.println("-----------------------------------------------------------------------------");
                    System.err.println("psd: " + object);
                }
                if ((object = this.IFDs.getEntryById((Object)37724)) != null) {
                    byte[] byArray = (byte[])object.getValue();
                    String string = "Adobe Photoshop Document Data Block";
                    if (Arrays.equals(string.getBytes(StandardCharsets.US_ASCII), Arrays.copyOf(byArray, string.length()))) {
                        System.err.println("foo: " + string);
                    }
                }
            }
        }
    }

    private void readIFD(int n) throws IOException {
        this.readMetadata();
        this.checkBounds(n);
        this.currentIFD = this.IFDs.getDirectory(n);
    }

    public int getNumImages(boolean bl) throws IOException {
        this.readMetadata();
        return this.IFDs.directoryCount();
    }

    private Number getValueAsNumberWithDefault(int n, String string, Number number) throws IIOException {
        Entry entry = this.currentIFD.getEntryById((Object)n);
        if (entry == null) {
            if (number != null) {
                return number;
            }
            throw new IIOException("Missing TIFF tag: " + (string != null ? string : Integer.valueOf(n)));
        }
        return (Number)entry.getValue();
    }

    private long getValueAsLongWithDefault(int n, String string, Long l) throws IIOException {
        return this.getValueAsNumberWithDefault(n, string, l).longValue();
    }

    private long getValueAsLongWithDefault(int n, Long l) throws IIOException {
        return this.getValueAsLongWithDefault(n, null, l);
    }

    private int getValueAsIntWithDefault(int n, String string, Integer n2) throws IIOException {
        return this.getValueAsNumberWithDefault(n, string, n2).intValue();
    }

    private int getValueAsIntWithDefault(int n, Integer n2) throws IIOException {
        return this.getValueAsIntWithDefault(n, null, n2);
    }

    private int getValueAsInt(int n, String string) throws IIOException {
        return this.getValueAsIntWithDefault(n, string, null);
    }

    public int getWidth(int n) throws IOException {
        this.readIFD(n);
        return this.getValueAsInt(256, "ImageWidth");
    }

    public int getHeight(int n) throws IOException {
        this.readIFD(n);
        return this.getValueAsInt(257, "ImageHeight");
    }

    public ImageTypeSpecifier getRawImageType(int n) throws IOException {
        this.readIFD(n);
        int n2 = this.getSampleFormat();
        int n3 = this.getValueAsIntWithDefault(284, 2);
        int n4 = this.getValueAsInt(262, "PhotometricInterpretation");
        int n5 = this.getValueAsIntWithDefault(277, 1);
        int n6 = this.getBitsPerSample();
        int n7 = this.getDataType(n2, n6);
        int n8 = this.getOpaqueSamplesPerPixel(n4);
        long[] lArray = this.getValueAsLongArray(338, "ExtraSamples", false);
        if (lArray == null && n5 > n8) {
            lArray = new long[n5 - n8];
            lArray[0] = 2L;
        }
        boolean bl = lArray != null;
        boolean bl2 = bl && lArray[0] == 1L;
        int n9 = n8 + (bl ? 1 : 0);
        ICC_Profile iCC_Profile = this.getICCProfile();
        switch (n4) {
            case 0: 
            case 1: {
                switch (n9) {
                    case 1: {
                        ColorSpace colorSpace;
                        if (iCC_Profile != null && iCC_Profile.getColorSpaceType() != 6) {
                            this.processWarningOccurred(String.format("Embedded ICC color profile (type %s), is incompatible with image data (GRAY/type 6). Ignoring profile.", iCC_Profile.getColorSpaceType()));
                            iCC_Profile = null;
                        }
                        ColorSpace colorSpace2 = colorSpace = iCC_Profile == null ? ColorSpace.getInstance(1003) : ColorSpaces.createColorSpace((ICC_Profile)iCC_Profile);
                        if (colorSpace == ColorSpace.getInstance(1003) && (n6 == 1 || n6 == 2 || n6 == 4 || n6 == 8 || n6 == 16 || n6 == 32)) {
                            return ImageTypeSpecifiers.createGrayscale((int)n6, (int)n7);
                        }
                        if (n6 == 1 || n6 == 2 || n6 == 4 || n6 == 8 || n6 == 16 || n6 == 32) {
                            return ImageTypeSpecifiers.createInterleaved((ColorSpace)colorSpace, (int[])new int[]{0}, (int)n7, (boolean)false, (boolean)false);
                        }
                        throw new IIOException(String.format("Unsupported BitsPerSample for Bi-level/Gray TIFF (expected 1, 2, 4, 8, 16 or 32): %d", n6));
                    }
                    case 2: {
                        ColorSpace colorSpace;
                        if (iCC_Profile != null && iCC_Profile.getColorSpaceType() != 6) {
                            this.processWarningOccurred(String.format("Embedded ICC color profile (type %s), is incompatible with image data (GRAY/type 6). Ignoring profile.", iCC_Profile.getColorSpaceType()));
                            iCC_Profile = null;
                        }
                        ColorSpace colorSpace3 = colorSpace = iCC_Profile == null ? ColorSpace.getInstance(1003) : ColorSpaces.createColorSpace((ICC_Profile)iCC_Profile);
                        if (colorSpace == ColorSpace.getInstance(1003) && (n6 == 8 || n6 == 16 || n6 == 32)) {
                            switch (n3) {
                                case 1: {
                                    return ImageTypeSpecifiers.createGrayscale((int)n6, (int)n7, (boolean)bl2);
                                }
                                case 2: {
                                    return ImageTypeSpecifiers.createBanded((ColorSpace)colorSpace, (int[])new int[]{0, 1}, (int[])new int[]{0, 0}, (int)n7, (boolean)true, (boolean)bl2);
                                }
                            }
                        } else if (n6 == 8 || n6 == 16 || n6 == 32) {
                            switch (n3) {
                                case 1: {
                                    return ImageTypeSpecifiers.createInterleaved((ColorSpace)colorSpace, (int[])new int[]{0, 1}, (int)n7, (boolean)true, (boolean)bl2);
                                }
                                case 2: {
                                    return ImageTypeSpecifiers.createBanded((ColorSpace)colorSpace, (int[])new int[]{0, 1}, (int[])new int[]{0, 0}, (int)n7, (boolean)true, (boolean)bl2);
                                }
                            }
                        }
                        throw new IIOException(String.format("Unsupported BitsPerSample for Gray + Alpha TIFF (expected 8, 16 or 32): %d", n6));
                    }
                }
                throw new IIOException(String.format("Unsupported SamplesPerPixel/BitsPerSample combination for Bi-level/Gray TIFF (expected 1/1, 1/2, 1/4, 1/8, 1/16 or 1/32, or 2/8, 2/16 or 2/32): %d/%d", n5, n6));
            }
            case 2: 
            case 6: {
                if (iCC_Profile != null && iCC_Profile.getColorSpaceType() != 5) {
                    this.processWarningOccurred(String.format("Embedded ICC color profile (type %s), is incompatible with image data (RGB/type 5). Ignoring profile.", iCC_Profile.getColorSpaceType()));
                    iCC_Profile = null;
                }
                ColorSpace colorSpace = iCC_Profile == null ? ColorSpace.getInstance(1000) : ColorSpaces.createColorSpace((ICC_Profile)iCC_Profile);
                switch (n9) {
                    case 3: {
                        if (n6 == 8 || n6 == 16 || n6 == 32) {
                            switch (n3) {
                                case 1: {
                                    return ImageTypeSpecifiers.createInterleaved((ColorSpace)colorSpace, (int[])new int[]{0, 1, 2}, (int)n7, (boolean)false, (boolean)false);
                                }
                                case 2: {
                                    return ImageTypeSpecifiers.createBanded((ColorSpace)colorSpace, (int[])new int[]{0, 1, 2}, (int[])new int[]{0, 0, 0}, (int)n7, (boolean)false, (boolean)false);
                                }
                            }
                        }
                    }
                    case 4: {
                        if (n6 == 8 || n6 == 16 || n6 == 32) {
                            switch (n3) {
                                case 1: {
                                    return ImageTypeSpecifiers.createInterleaved((ColorSpace)colorSpace, (int[])new int[]{0, 1, 2, 3}, (int)n7, (boolean)true, (boolean)bl2);
                                }
                                case 2: {
                                    return ImageTypeSpecifiers.createBanded((ColorSpace)colorSpace, (int[])new int[]{0, 1, 2, 3}, (int[])new int[]{0, 0, 0, 0}, (int)n7, (boolean)true, (boolean)bl2);
                                }
                            }
                            break;
                        }
                        if (n6 != 4) break;
                        return ImageTypeSpecifiers.createPacked((ColorSpace)colorSpace, (int)61440, (int)3840, (int)240, (int)15, (int)1, (boolean)bl2);
                    }
                }
                throw new IIOException(String.format("Unsupported SamplesPerPixels/BitsPerSample combination for RGB TIFF (expected 3/8, 4/8, 3/16 or 4/16): %d/%d", n5, n6));
            }
            case 3: {
                if (n5 != 1) {
                    throw new IIOException("Bad SamplesPerPixel value for Palette TIFF (expected 1): " + n5);
                }
                if (n6 <= 0 || n6 > 16) {
                    throw new IIOException("Bad BitsPerSample value for Palette TIFF (expected <= 16): " + n6);
                }
                Entry entry = this.currentIFD.getEntryById((Object)320);
                if (entry == null) {
                    throw new IIOException("Missing ColorMap for Palette TIFF");
                }
                IndexColorModel indexColorModel = this.createIndexColorModel(n6, n7, (int[])entry.getValue());
                return ImageTypeSpecifiers.createFromIndexColorModel((IndexColorModel)indexColorModel);
            }
            case 5: {
                int n10 = this.getValueAsIntWithDefault(332, 1);
                int n11 = this.getValueAsIntWithDefault(334, 4);
                if (n10 != 1 && (iCC_Profile == null || iCC_Profile.getNumComponents() != n11)) {
                    throw new IIOException(String.format("Embedded ICC color profile for Photometric Separated is missing or is incompatible with image data: %s != NumberOfInks (%s).", iCC_Profile != null ? Integer.valueOf(iCC_Profile.getNumComponents()) : "null", n11));
                }
                if (iCC_Profile != null && n10 == 1 && iCC_Profile.getColorSpaceType() != 9) {
                    this.processWarningOccurred(String.format("Embedded ICC color profile (type %s), is incompatible with image data (CMYK/type 9). Ignoring profile.", iCC_Profile.getColorSpaceType()));
                    iCC_Profile = null;
                }
                ColorSpace colorSpace = iCC_Profile == null ? ColorSpaces.getColorSpace((int)5001) : ColorSpaces.createColorSpace((ICC_Profile)iCC_Profile);
                switch (n9) {
                    case 4: {
                        if (n6 == 8 || n6 == 16) {
                            switch (n3) {
                                case 1: {
                                    return ImageTypeSpecifiers.createInterleaved((ColorSpace)colorSpace, (int[])new int[]{0, 1, 2, 3}, (int)n7, (boolean)false, (boolean)false);
                                }
                                case 2: {
                                    return ImageTypeSpecifiers.createBanded((ColorSpace)colorSpace, (int[])new int[]{0, 1, 2, 3}, (int[])new int[]{0, 0, 0, 0}, (int)n7, (boolean)false, (boolean)false);
                                }
                            }
                        }
                    }
                    case 5: {
                        if (n6 != 8 && n6 != 16) break;
                        switch (n3) {
                            case 1: {
                                return ImageTypeSpecifiers.createInterleaved((ColorSpace)colorSpace, (int[])new int[]{0, 1, 2, 3, 4}, (int)n7, (boolean)true, (boolean)bl2);
                            }
                            case 2: {
                                return ImageTypeSpecifiers.createBanded((ColorSpace)colorSpace, (int[])new int[]{0, 1, 2, 3, 4}, (int[])new int[]{0, 0, 0, 0, 0}, (int)n7, (boolean)true, (boolean)bl2);
                            }
                        }
                    }
                }
                throw new IIOException(String.format("Unsupported SamplesPerPixels/BitsPerSample combination for Separated TIFF (expected 4/8, 4/16, 5/8 or 5/16): %d/%s", n5, n6));
            }
            case 8: 
            case 9: 
            case 10: {
                ColorSpace colorSpace = ColorSpace.getInstance(1000);
                switch (n3) {
                    case 1: {
                        return ImageTypeSpecifiers.createInterleaved((ColorSpace)colorSpace, (int[])new int[]{0, 1, 2}, (int)n7, (boolean)false, (boolean)false);
                    }
                }
                throw new IIOException(String.format("Unsupported PlanarConfiguration for Lab color TIFF (expected 1): %d", n3));
            }
            case 4: 
            case 32803: 
            case 32844: 
            case 32845: 
            case 34892: {
                throw new IIOException("Unsupported TIFF PhotometricInterpretation value: " + n4);
            }
        }
        throw new IIOException("Unknown TIFF PhotometricInterpretation value: " + n4);
    }

    private int getOpaqueSamplesPerPixel(int n) throws IIOException {
        switch (n) {
            case 0: 
            case 1: 
            case 3: 
            case 4: {
                return 1;
            }
            case 2: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                return 3;
            }
            case 5: {
                return this.getValueAsIntWithDefault(334, 4);
            }
            case 32803: 
            case 32844: 
            case 32845: 
            case 34892: {
                throw new IIOException("Unsupported TIFF PhotometricInterpretation value: " + n);
            }
        }
        throw new IIOException("Unknown TIFF PhotometricInterpretation value: " + n);
    }

    private int getDataType(int n, int n2) throws IIOException {
        switch (n) {
            case 1: 
            case 4: {
                return n2 <= 8 ? 0 : (n2 <= 16 ? 1 : 3);
            }
            case 2: {
                switch (n2) {
                    case 8: {
                        return 0;
                    }
                    case 16: {
                        return 2;
                    }
                    case 32: {
                        return 3;
                    }
                }
                throw new IIOException("Unsupported BitsPerSample for SampleFormat 2/Signed Integer (expected 8/16/32): " + n2);
            }
            case 3: {
                if (n2 == 32) {
                    return 4;
                }
                throw new IIOException("Unsupported BitsPerSample for SampleFormat 3/Floating Point (expected 32): " + n2);
            }
        }
        throw new IIOException("Unknown TIFF SampleFormat (expected 1, 2, 3 or 4): " + n);
    }

    private IndexColorModel createIndexColorModel(int n, int n2, int[] nArray) {
        int n3;
        int[] nArray2 = new int[nArray.length / 3];
        boolean bl = true;
        for (n3 = 0; n3 < nArray2.length; ++n3) {
            nArray2[n3] = nArray[n3] / 256 << 16 | nArray[n3 + nArray2.length] / 256 << 8 | nArray[n3 + 2 * nArray2.length] / 256;
            if (!bl || nArray2[n3] == 0) continue;
            bl = false;
        }
        if (bl) {
            this.processWarningOccurred("8 bit ColorMap detected.");
            for (n3 = 0; n3 < nArray2.length; ++n3) {
                nArray2[n3] = nArray[n3] << 16 | nArray[n3 + nArray2.length] << 8 | nArray[n3 + 2 * nArray2.length];
            }
        }
        return new IndexColorModel(n, nArray2.length, nArray2, 0, false, -1, n2);
    }

    private int getSampleFormat() throws IIOException {
        long[] lArray = this.getValueAsLongArray(339, "SampleFormat", false);
        if (lArray != null) {
            long l = lArray[0];
            for (int i = 1; i < lArray.length; ++i) {
                if (lArray[i] == l) continue;
                throw new IIOException("Variable TIFF SampleFormat not supported: " + Arrays.toString(lArray));
            }
            return (int)l;
        }
        return 1;
    }

    private int getBitsPerSample() throws IIOException {
        long[] lArray = this.getValueAsLongArray(258, "BitsPerSample", false);
        if (lArray == null || lArray.length == 0) {
            return 1;
        }
        int n = (int)lArray[0];
        if (lArray.length != 3 || lArray[0] != 5L || lArray[1] != 6L || lArray[2] != 5L) {
            for (int i = 1; i < lArray.length; ++i) {
                if (lArray[i] == (long)n) continue;
                throw new IIOException("Variable BitsPerSample not supported: " + Arrays.toString(lArray));
            }
        }
        return n;
    }

    public Iterator<ImageTypeSpecifier> getImageTypes(int n) throws IOException {
        this.readIFD(n);
        ImageTypeSpecifier imageTypeSpecifier = this.getRawImageType(n);
        LinkedHashSet<ImageTypeSpecifier> linkedHashSet = new LinkedHashSet<ImageTypeSpecifier>(5);
        if (imageTypeSpecifier.getColorModel().getColorSpace().getType() == 5) {
            if (imageTypeSpecifier.getNumBands() == 3 && imageTypeSpecifier.getBitsPerBand(0) == 8) {
                linkedHashSet.add(ImageTypeSpecifier.createFromBufferedImageType(5));
            } else if (imageTypeSpecifier.getNumBands() == 4 && imageTypeSpecifier.getBitsPerBand(0) == 8) {
                linkedHashSet.add(ImageTypeSpecifier.createFromBufferedImageType(6));
                linkedHashSet.add(ImageTypeSpecifier.createFromBufferedImageType(7));
            }
        }
        linkedHashSet.add(imageTypeSpecifier);
        return linkedHashSet.iterator();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public BufferedImage read(int var1_1, ImageReadParam var2_2) throws IOException {
        this.readIFD(var1_1);
        var3_3 = this.getWidth(var1_1);
        var4_4 = this.getHeight(var1_1);
        var5_5 = TIFFImageReader.getDestination((ImageReadParam)var2_2, this.getImageTypes(var1_1), (int)var3_3, (int)var4_4);
        var6_6 = this.getRawImageType(var1_1);
        TIFFImageReader.checkReadParamBandSettings((ImageReadParam)var2_2, (int)var6_6.getNumBands(), (int)var5_5.getSampleModel().getNumBands());
        var7_7 = new Rectangle();
        var8_8 = new Rectangle();
        TIFFImageReader.computeRegions((ImageReadParam)var2_2, (int)var3_3, (int)var4_4, (BufferedImage)var5_5, (Rectangle)var7_7, (Rectangle)var8_8);
        var9_9 = var2_2 != null ? var2_2.getSourceXSubsampling() : 1;
        var10_10 = var2_2 != null ? var2_2.getSourceYSubsampling() : 1;
        var11_11 = this.clipToRect(var5_5.getRaster(), var8_8, var2_2 != null ? var2_2.getDestinationBands() : null);
        var12_12 = this.getValueAsInt(262, "PhotometricInterpretation");
        var13_13 = this.getValueAsIntWithDefault(259, 1);
        var14_14 = this.getValueAsIntWithDefault(317, 1);
        var15_15 = this.getValueAsIntWithDefault(284, 1);
        var16_16 = var15_15 == 2 ? 1 : var6_6.getNumBands();
        var17_17 = var3_3;
        var18_18 = this.getValueAsLongWithDefault(278, 0xFFFFFFFFL);
        var20_19 = var18_18 < (long)var4_4 ? (int)var18_18 : var4_4;
        var21_20 = this.getValueAsLongArray(324, "TileOffsets", false);
        if (var21_20 != null) {
            var22_21 = this.getValueAsLongArray(325, "TileByteCounts", false);
            if (var22_21 == null) {
                this.processWarningOccurred("Missing TileByteCounts for tiled TIFF with compression: " + var13_13);
            }
            var17_17 = this.getValueAsInt(322, "TileWidth");
            var20_19 = this.getValueAsInt(323, "TileHeight");
        } else {
            var21_20 = this.getValueAsLongArray(273, "StripOffsets", true);
            var22_21 = this.getValueAsLongArray(279, "StripByteCounts", false);
            if (var22_21 == null) {
                this.processWarningOccurred("Missing StripByteCounts for TIFF with compression: " + var13_13);
            }
            var17_17 = this.getValueAsIntWithDefault(322, "TileWidth", var17_17);
            var20_19 = this.getValueAsIntWithDefault(323, "TileHeight", var20_19);
        }
        var23_22 = (var3_3 + var17_17 - 1) / var17_17;
        var24_23 = (var4_4 + var20_19 - 1) / var20_19;
        var25_24 = var6_6.createBufferedImage(var17_17, 1).getRaster();
        var26_25 = new Rectangle(var7_7);
        var27_26 = 0;
        block13 : switch (var13_13) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 32773: 
            case 32946: {
                var28_27 = null;
                var29_28 = 1;
                if (var12_12 == 6) {
                    if (var25_24.getNumBands() != 3) {
                        throw new IIOException("TIFF PhotometricInterpretation YCbCr requires SamplesPerPixel == 3: " + var25_24.getNumBands());
                    }
                    if (var25_24.getTransferType() != 0 && var25_24.getTransferType() != 1) {
                        throw new IIOException("TIFF PhotometricInterpretation YCbCr requires BitsPerSample == [8,8,8] or [16,16,16]");
                    }
                    var29_28 = this.getValueAsIntWithDefault(531, 1);
                    if (var29_28 != 1 && var29_28 != 2) {
                        this.processWarningOccurred("Uknown TIFF YCbCrPositioning value, expected 1 or 2: " + var29_28);
                    }
                    if ((var30_29 = this.currentIFD.getEntryById((Object)530)) != null) {
                        try {
                            var28_27 = (int[])var30_29.getValue();
                        }
                        catch (ClassCastException var31_33) {
                            throw new IIOException("Unknown TIFF YCbCrSubSampling value type: " + var30_29.getTypeName(), var31_33);
                        }
                        if (var28_27.length != 2 || var28_27[0] != 1 && var28_27[0] != 2 && var28_27[0] != 4 || var28_27[1] != 1 && var28_27[1] != 2 && var28_27[1] != 4) {
                            throw new IIOException("Bad TIFF YCbCrSubSampling value: " + Arrays.toString(var28_27));
                        }
                        if (var28_27[0] < var28_27[1]) {
                            this.processWarningOccurred("TIFF PhotometricInterpretation YCbCr with bad subsampling, expected subHoriz >= subVert: " + Arrays.toString(var28_27));
                        }
                    } else {
                        var28_27 = new int[]{2, 2};
                    }
                }
                this.processImageStarted(var1_1);
                for (var30_30 = 0; var30_30 < var24_23; ++var30_30) {
                    var31_34 = 0;
                    var32_37 = Math.min(var20_19, var4_4 - var27_26);
                    for (var33_39 = 0; var33_39 < var23_22; ++var33_39) {
                        var34_41 = Math.min(var17_17, var3_3 - var31_34);
                        var35_44 = var30_30 * var23_22 + var33_39;
                        this.imageInput.seek(var21_20[var35_44]);
                        if (var13_13 == 1 && var12_12 != 6) {
                            var36_47 /* !! */  = this.imageInput;
                        } else {
                            var37_50 = var22_21 != null ? IIOUtil.createStreamAdapter((ImageInputStream)this.imageInput, (long)var22_21[var35_44]) : IIOUtil.createStreamAdapter((ImageInputStream)this.imageInput);
                            var37_50 = this.createDecompressorStream(var13_13, var17_17, var16_16, (InputStream)var37_50);
                            var37_50 = this.createUnpredictorStream(var14_14, var17_17, var16_16, this.getBitsPerSample(), (InputStream)var37_50, this.imageInput.getByteOrder());
                            if (var12_12 == 6 && var25_24.getTransferType() == 0) {
                                var37_50 = new YCbCrUpsamplerStream((InputStream)var37_50, var28_27, var29_28, var34_41);
                            } else if (var12_12 == 6 && var25_24.getTransferType() == 1) {
                                var37_50 = new YCbCr16UpsamplerStream((InputStream)var37_50, var28_27, var29_28, var34_41, this.imageInput.getByteOrder());
                            } else if (var12_12 == 6) {
                                throw new AssertionError();
                            }
                            var36_47 /* !! */  = this.imageInput.getByteOrder() == ByteOrder.BIG_ENDIAN ? new DataInputStream((InputStream)var37_50) : new LittleEndianDataInputStream((InputStream)var37_50);
                        }
                        var26_25.width = Math.min((var34_41 + var9_9 - 1) / var9_9, var7_7.width);
                        var37_50 = this.clipRowToRect(var25_24, var26_25, var2_2 != null ? var2_2.getSourceBands() : null, var2_2 != null ? var2_2.getSourceXSubsampling() : 1);
                        this.readStripTileData((Raster)var37_50, var7_7, var9_9, var10_10, var16_16, var12_12, var11_11, var31_34, var27_26, var34_41, var32_37, var36_47 /* !! */ );
                        if (this.abortRequested()) break;
                        var31_34 += var34_41;
                    }
                    this.processImageProgress(100.0f * (float)var27_26 / (float)var4_4);
                    if (this.abortRequested()) {
                        this.processReadAborted();
                        break block13;
                    }
                    var27_26 += var32_37;
                }
                break;
            }
            case 7: {
                var30_31 = this.createJPEGDelegate();
                var31_35 = (JPEGImageReadParam)var30_31.getDefaultReadParam();
                var32_38 = this.currentIFD.getEntryById((Object)347);
                v0 = var33_40 = var32_38 != null ? (byte[])var32_38.getValue() : null;
                if (var33_40 != null) {
                    var30_31.setInput(new ByteArrayImageInputStream(var33_40));
                    var30_31.getStreamMetadata();
                } else {
                    this.processWarningOccurred("Missing JPEGTables for TIFF with compression: 7 (JPEG)");
                }
                this.processImageStarted(var1_1);
                for (var34_42 = 0; var34_42 < var24_23; ++var34_42) {
                    var35_45 = 0;
                    var36_48 = Math.min(var20_19, var4_4 - var27_26);
                    for (var37_51 = 0; var37_51 < var23_22; ++var37_51) {
                        var38_54 = var34_42 * var23_22 + var37_51;
                        var39_56 = Math.min(var17_17, var3_3 - var35_45);
                        if (new Rectangle(var35_45, var27_26, var39_56, var36_48).intersects(var7_7)) {
                            this.imageInput.seek(var21_20[var38_54]);
                            var40_60 = var22_21 != null ? (int)var22_21[var38_54] : 32767;
                            var41_63 = new SubImageInputStream(this.imageInput, (long)var40_60);
                            var42_67 = null;
                            try {
                                var30_31.setInput(var41_63);
                                var31_35.setSourceRegion(new Rectangle(0, 0, var39_56, var36_48));
                                if (var12_12 == 6 || var12_12 == 2) {
                                    var31_35.setDestinationOffset(new Point(var35_45 - var7_7.x, var27_26 - var7_7.y));
                                    var31_35.setDestination(var5_5);
                                    var30_31.read(0, var31_35);
                                } else {
                                    var43_70 = var30_31.readRaster(0, var31_35);
                                    this.normalizeColor(var12_12, ((DataBufferByte)var43_70.getDataBuffer()).getData());
                                    var5_5.getRaster().setDataElements(var35_45 - var7_7.x, var27_26 - var7_7.y, var43_70);
                                }
                            }
                            catch (Throwable var43_72) {
                                var42_67 = var43_72;
                                throw var43_72;
                            }
                            finally {
                                if (var41_63 != null) {
                                    if (var42_67 != null) {
                                        try {
                                            var41_63.close();
                                        }
                                        catch (Throwable var43_71) {
                                            var42_67.addSuppressed(var43_71);
                                        }
                                    } else {
                                        var41_63.close();
                                    }
                                }
                            }
                        }
                        if (this.abortRequested()) break;
                        var35_45 += var39_56;
                    }
                    this.processImageProgress(100.0f * (float)var27_26 / (float)var4_4);
                    if (this.abortRequested()) {
                        this.processReadAborted();
                        break block13;
                    }
                    var27_26 += var36_48;
                }
                break;
            }
            case 6: {
                var34_43 = this.getValueAsIntWithDefault(512, 1);
                switch (var34_43) {
                    case 1: {
                        break;
                    }
                    case 14: {
                        throw new IIOException("Unsupported TIFF JPEGProcessingMode: Lossless (14)");
                    }
                    default: {
                        throw new IIOException("Unknown TIFF JPEGProcessingMode value: " + var34_43);
                    }
                }
                var30_32 = this.createJPEGDelegate();
                var31_36 = (JPEGImageReadParam)var30_32.getDefaultReadParam();
                var35_46 = this.getValueAsIntWithDefault(513, -1);
                var36_49 = this.getValueAsIntWithDefault(514, -1);
                if (var35_46 == -1) ** GOTO lbl225
                if (this.currentIFD.getEntryById((Object)519) != null || this.currentIFD.getEntryById((Object)520) != null || this.currentIFD.getEntryById((Object)521) != null) {
                    this.processWarningOccurred("Old-style JPEG compressed TIFF with JFIF stream encountered. Ignoring JPEG tables. Reading as single tile.");
                } else {
                    this.processWarningOccurred("Old-style JPEG compressed TIFF with JFIF stream encountered. Reading as single tile.");
                }
                this.imageInput.seek(var35_46);
                var37_52 = var35_46;
                var39_57 = (short)(this.imageInput.readByte() << 8 | this.imageInput.readByte());
                if (var39_57 != -40) {
                    if (var21_20 != null && var21_20.length == 1) {
                        this.imageInput.seek(var21_20[0]);
                        var39_57 = (short)(this.imageInput.readByte() << 8 | this.imageInput.readByte());
                        if (var39_57 == -40) {
                            var37_52 = var21_20[0];
                        }
                    }
                    if (var37_52 != (long)var35_46) {
                        this.processWarningOccurred("Incorrect JPEGInterchangeFormat tag, using StripOffsets/TileOffsets instead.");
                    } else {
                        this.processWarningOccurred("Incorrect JPEGInterchangeFormat tag encountered (not a valid SOI marker).");
                    }
                }
                this.imageInput.seek(var37_52);
                this.processImageStarted(var1_1);
                var40_61 = var36_49 != -1 ? var36_49 : 0x7FFFFFFF;
                var41_64 = new SubImageInputStream(this.imageInput, (long)var40_61);
                var42_68 = null;
                try {
                    var30_32.setInput(var41_64);
                    var31_36.setSourceRegion(new Rectangle(0, 0, var3_3, var4_4));
                    if (var12_12 == 6 || var12_12 == 2) {
                        var31_36.setDestination(var5_5);
                        var30_32.read(0, var31_36);
                    } else {
                        var43_73 = var30_32.readRaster(0, var31_36);
                        var5_5.getRaster().setDataElements(0, 0, var43_73);
                    }
                }
                catch (Throwable var43_75) {
                    var42_68 = var43_75;
                    throw var43_75;
                }
                finally {
                    if (var41_64 != null) {
                        if (var42_68 != null) {
                            try {
                                var41_64.close();
                            }
                            catch (Throwable var43_74) {
                                var42_68.addSuppressed(var43_74);
                            }
                        } else {
                            var41_64.close();
                        }
                    }
                }
                this.processImageProgress(100.0f);
                if (!this.abortRequested()) break;
                this.processReadAborted();
                break;
lbl225:
                // 1 sources

                this.processWarningOccurred("Old-style JPEG compressed TIFF without JFIF stream encountered. Attempting to re-create JFIF stream.");
                var37_53 = this.getValueAsLongArray(519, "JPEGQTables", true);
                var38_55 = new byte[var37_53.length][(int)(var37_53[1] - var37_53[0])];
                for (var39_58 = 0; var39_58 < var38_55.length; ++var39_58) {
                    this.imageInput.seek(var37_53[var39_58]);
                    this.imageInput.readFully(var38_55[var39_58]);
                }
                var39_59 = this.getValueAsLongArray(520, "JPEGDCTables", true);
                var40_62 = new byte[var39_59.length][(int)(var39_59[1] - var39_59[0])];
                for (var41_65 = 0; var41_65 < var40_62.length; ++var41_65) {
                    this.imageInput.seek(var39_59[var41_65]);
                    this.imageInput.readFully(var40_62[var41_65]);
                }
                var41_66 = this.getValueAsLongArray(521, "JPEGACTables", true);
                var42_69 = new byte[var41_66.length][(int)(var41_66[1] - var41_66[0])];
                for (var43_76 = 0; var43_76 < var42_69.length; ++var43_76) {
                    this.imageInput.seek(var41_66[var43_76]);
                    this.imageInput.readFully(var42_69[var43_76]);
                }
                this.processImageStarted(var1_1);
                for (var43_76 = 0; var43_76 < var24_23; ++var43_76) {
                    var44_78 = 0;
                    var45_80 = Math.min(var20_19, var4_4 - var27_26);
                    for (var46_82 = 0; var46_82 < var23_22; ++var46_82) {
                        var47_84 = Math.min(var17_17, var3_3 - var44_78);
                        var48_85 = var43_76 * var23_22 + var46_82;
                        if (new Rectangle(var44_78, var27_26, var47_84, var45_80).intersects(var7_7)) {
                            this.imageInput.seek(var21_20[var48_85]);
                            var49_86 = ImageIO.createImageInputStream(new SequenceInputStream(Collections.enumeration(Arrays.asList(new InputStream[]{TIFFImageReader.createJFIFStream(var11_11, var17_17, var20_19, var38_55, var40_62, var42_69), IIOUtil.createStreamAdapter((ImageInputStream)this.imageInput, (long)(var22_21 != null ? (long)((int)var22_21[var48_85]) : 32767L)), new ByteArrayInputStream(new byte[]{-1, -39})}))));
                            var50_87 = null;
                            try {
                                var30_32.setInput(var49_86);
                                var31_36.setSourceRegion(new Rectangle(0, 0, var47_84, var45_80));
                                var31_36.setDestinationOffset(new Point(var44_78 - var7_7.x, var27_26 - var7_7.y));
                                var31_36.setDestination(var5_5);
                                if (var12_12 == 6 || var12_12 == 2) {
                                    var31_36.setDestination(var5_5);
                                    var30_32.read(0, var31_36);
                                } else {
                                    var51_88 = var30_32.readRaster(0, var31_36);
                                    var5_5.getRaster().setDataElements(0, 0, var51_88);
                                }
                            }
                            catch (Throwable var51_90) {
                                var50_87 = var51_90;
                                throw var51_90;
                            }
                            finally {
                                if (var49_86 != null) {
                                    if (var50_87 != null) {
                                        try {
                                            var49_86.close();
                                        }
                                        catch (Throwable var51_89) {
                                            var50_87.addSuppressed(var51_89);
                                        }
                                    } else {
                                        var49_86.close();
                                    }
                                }
                            }
                        }
                        if (this.abortRequested()) break;
                        var44_78 += var47_84;
                    }
                    this.processImageProgress(100.0f * (float)var27_26 / (float)var4_4);
                    if (this.abortRequested()) {
                        this.processReadAborted();
                        break block13;
                    }
                    var27_26 += var45_80;
                }
                break;
            }
            case 32766: 
            case 32771: 
            case 32809: 
            case 32895: 
            case 32896: 
            case 32897: 
            case 32898: 
            case 32908: 
            case 32909: 
            case 32947: 
            case 34661: 
            case 34676: 
            case 34677: 
            case 34712: {
                throw new IIOException("Unsupported TIFF Compression value: " + var13_13);
            }
            default: {
                throw new IIOException("Unknown TIFF Compression value: " + var13_13);
            }
        }
        this.processImageComplete();
        return var5_5;
    }

    private ImageReader createJPEGDelegate() throws IIOException {
        try {
            Class<?> clazz = Class.forName("com.sun.imageio.plugins.jpeg.JPEGImageReader");
            Constructor<?> constructor = clazz.getConstructor(ImageReaderSpi.class);
            return (ImageReader)constructor.newInstance(this.getOriginatingProvider());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            Iterator<ImageReader> iterator;
            if (DEBUG) {
                reflectiveOperationException.printStackTrace();
            }
            if (!(iterator = ImageIO.getImageReadersByFormatName("JPEG")).hasNext()) {
                throw new IIOException("Could not instantiate JPEGImageReader");
            }
            return iterator.next();
        }
    }

    private static InputStream createJFIFStream(WritableRaster writableRaster, int n, int n2, byte[][] byArray, byte[][] byArray2, byte[][] byArray3) throws IOException {
        byte[] byArray4;
        int n3;
        FastByteArrayOutputStream fastByteArrayOutputStream = new FastByteArrayOutputStream(12 + 3 * writableRaster.getNumBands() + 5 * byArray.length + byArray.length * byArray[0].length + 5 * byArray2.length + byArray2.length * byArray2[0].length + 5 * byArray3.length + byArray3.length * byArray3[0].length + 8 + 2 * writableRaster.getNumBands());
        DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)fastByteArrayOutputStream);
        dataOutputStream.writeShort(65496);
        dataOutputStream.writeShort(65472);
        dataOutputStream.writeShort(8 + 3 * writableRaster.getNumBands());
        dataOutputStream.writeByte(8);
        dataOutputStream.writeShort(n2);
        dataOutputStream.writeShort(n);
        dataOutputStream.writeByte(writableRaster.getNumBands());
        for (n3 = 0; n3 < writableRaster.getNumBands(); ++n3) {
            dataOutputStream.writeByte(n3);
            dataOutputStream.writeByte(n3 == 0 ? 34 : 17);
            dataOutputStream.writeByte(n3);
        }
        for (n3 = 0; n3 < byArray.length; ++n3) {
            byArray4 = byArray[n3];
            dataOutputStream.writeShort(65499);
            dataOutputStream.writeShort(3 + byArray4.length);
            dataOutputStream.writeByte(n3);
            dataOutputStream.write(byArray4);
        }
        for (n3 = 0; n3 < byArray2.length; ++n3) {
            byArray4 = byArray2[n3];
            dataOutputStream.writeShort(65476);
            dataOutputStream.writeShort(3 + byArray4.length);
            dataOutputStream.writeByte(n3);
            dataOutputStream.write(byArray4);
        }
        for (n3 = 0; n3 < byArray3.length; ++n3) {
            byArray4 = byArray3[n3];
            dataOutputStream.writeShort(65476);
            dataOutputStream.writeShort(3 + byArray4.length);
            dataOutputStream.writeByte(16 + (n3 & 0xF));
            dataOutputStream.write(byArray4);
        }
        dataOutputStream.writeShort(65498);
        dataOutputStream.writeShort(6 + 2 * writableRaster.getNumBands());
        dataOutputStream.writeByte(writableRaster.getNumBands());
        for (n3 = 0; n3 < writableRaster.getNumBands(); ++n3) {
            dataOutputStream.writeByte(n3);
            dataOutputStream.writeByte(n3 == 0 ? n3 : 16 + (n3 & 0xF));
        }
        dataOutputStream.writeByte(0);
        dataOutputStream.writeByte(0);
        dataOutputStream.writeByte(0);
        return fastByteArrayOutputStream.createInputStream();
    }

    private Raster clipRowToRect(Raster raster, Rectangle rectangle, int[] nArray, int n) {
        if (rectangle.contains(raster.getMinX(), 0, raster.getWidth(), 1) && n == 1 && nArray == null) {
            return raster;
        }
        return raster.createChild(rectangle.x / n, 0, rectangle.width / n, 1, 0, 0, nArray);
    }

    private WritableRaster clipToRect(WritableRaster writableRaster, Rectangle rectangle, int[] nArray) {
        if (rectangle.contains(writableRaster.getMinX(), writableRaster.getMinY(), writableRaster.getWidth(), writableRaster.getHeight()) && nArray == null) {
            return writableRaster;
        }
        return writableRaster.createWritableChild(rectangle.x, rectangle.y, rectangle.width, rectangle.height, 0, 0, nArray);
    }

    private void readStripTileData(Raster raster, Rectangle rectangle, int n, int n2, int n3, int n4, WritableRaster writableRaster, int n5, int n6, int n7, int n8, DataInput dataInput) throws IOException {
        DataBuffer dataBuffer = raster.getDataBuffer();
        int n9 = dataBuffer.getNumBanks();
        boolean bl = n9 > 1;
        switch (raster.getTransferType()) {
            case 0: {
                for (int i = 0; i < n9; ++i) {
                    int n10 = bl ? ((BandedSampleModel)raster.getSampleModel()).getBankIndices()[i] : i;
                    byte[] byArray = ((DataBufferByte)dataBuffer).getData(n10);
                    WritableRaster writableRaster2 = bl ? writableRaster.createWritableChild(writableRaster.getMinX(), writableRaster.getMinY(), writableRaster.getWidth(), writableRaster.getHeight(), 0, 0, new int[]{i}) : writableRaster;
                    Raster raster2 = bl ? raster.createChild(raster.getMinX(), 0, raster.getWidth(), 1, 0, 0, new int[]{i}) : raster;
                    for (int j = n6; j < n6 + n8 && j < rectangle.y + rectangle.height; ++j) {
                        dataInput.readFully(byArray);
                        if (j % n2 != 0 || j < rectangle.y) continue;
                        if (!bl) {
                            this.normalizeColor(n4, byArray);
                        }
                        if (n != 1) {
                            for (int k = rectangle.x / n * n3; k < (rectangle.x + rectangle.width) / n * n3; k += n3) {
                                System.arraycopy(byArray, k * n, byArray, k, n3);
                            }
                        }
                        writableRaster2.setDataElements(n5, (j - rectangle.y) / n2, raster2);
                    }
                }
                break;
            }
            case 1: 
            case 2: {
                for (int i = 0; i < n9; ++i) {
                    short[] sArray = dataBuffer.getDataType() == 1 ? ((DataBufferUShort)dataBuffer).getData(i) : ((DataBufferShort)dataBuffer).getData(i);
                    WritableRaster writableRaster3 = bl ? writableRaster.createWritableChild(writableRaster.getMinX(), writableRaster.getMinY(), writableRaster.getWidth(), writableRaster.getHeight(), 0, 0, new int[]{i}) : writableRaster;
                    Raster raster3 = bl ? raster.createChild(raster.getMinX(), 0, raster.getWidth(), 1, 0, 0, new int[]{i}) : raster;
                    for (int j = n6; j < n6 + n8 && j < rectangle.y + rectangle.height; ++j) {
                        this.readFully(dataInput, sArray);
                        if (j < rectangle.y) continue;
                        this.normalizeColor(n4, sArray);
                        if (n != 1) {
                            for (int k = rectangle.x / n * n3; k < (rectangle.x + rectangle.width) / n * n3; k += n3) {
                                System.arraycopy(sArray, k * n, sArray, k, n3);
                            }
                        }
                        writableRaster3.setDataElements(n5, j - rectangle.y, raster3);
                    }
                }
                break;
            }
            case 3: {
                for (int i = 0; i < n9; ++i) {
                    int[] nArray = ((DataBufferInt)dataBuffer).getData(i);
                    WritableRaster writableRaster4 = bl ? writableRaster.createWritableChild(writableRaster.getMinX(), writableRaster.getMinY(), writableRaster.getWidth(), writableRaster.getHeight(), 0, 0, new int[]{i}) : writableRaster;
                    Raster raster4 = bl ? raster.createChild(raster.getMinX(), 0, raster.getWidth(), 1, 0, 0, new int[]{i}) : raster;
                    for (int j = n6; j < n6 + n8 && j < rectangle.y + rectangle.height; ++j) {
                        this.readFully(dataInput, nArray);
                        if (j < rectangle.y) continue;
                        this.normalizeColor(n4, nArray);
                        if (n != 1) {
                            for (int k = rectangle.x / n * n3; k < (rectangle.x + rectangle.width) / n * n3; k += n3) {
                                System.arraycopy(nArray, k * n, nArray, k, n3);
                            }
                        }
                        writableRaster4.setDataElements(n5, j - rectangle.y, raster4);
                    }
                }
                break;
            }
            case 4: {
                for (int i = 0; i < n9; ++i) {
                    float[] fArray = ((DataBufferFloat)raster.getDataBuffer()).getData(i);
                    WritableRaster writableRaster5 = bl ? writableRaster.createWritableChild(writableRaster.getMinX(), writableRaster.getMinY(), writableRaster.getWidth(), writableRaster.getHeight(), 0, 0, new int[]{i}) : writableRaster;
                    Raster raster5 = bl ? raster.createChild(raster.getMinX(), 0, raster.getWidth(), 1, 0, 0, new int[]{i}) : raster;
                    for (int j = n6; j < n6 + n8 && j < rectangle.y + rectangle.height; ++j) {
                        this.readFully(dataInput, fArray);
                        if (j < rectangle.y) continue;
                        this.clamp(fArray);
                        this.normalizeColor(n4, fArray);
                        if (n != 1) {
                            for (int k = rectangle.x / n * n3; k < (rectangle.x + rectangle.width) / n * n3; k += n3) {
                                System.arraycopy(fArray, k * n, fArray, k, n3);
                            }
                        }
                        writableRaster5.setDataElements(n5, j - rectangle.y, raster5);
                    }
                }
                break;
            }
        }
    }

    private void clamp(float[] fArray) {
        for (int i = 0; i < fArray.length; ++i) {
            if (!(fArray[i] > 1.0f)) continue;
            fArray[i] = 1.0f;
        }
    }

    private void readFully(DataInput dataInput, float[] fArray) throws IOException {
        if (dataInput instanceof ImageInputStream) {
            ImageInputStream imageInputStream = (ImageInputStream)dataInput;
            imageInputStream.readFully(fArray, 0, fArray.length);
        } else {
            for (int i = 0; i < fArray.length; ++i) {
                fArray[i] = dataInput.readFloat();
            }
        }
    }

    private void readFully(DataInput dataInput, int[] nArray) throws IOException {
        if (dataInput instanceof ImageInputStream) {
            ImageInputStream imageInputStream = (ImageInputStream)dataInput;
            imageInputStream.readFully(nArray, 0, nArray.length);
        } else {
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = dataInput.readInt();
            }
        }
    }

    private void readFully(DataInput dataInput, short[] sArray) throws IOException {
        if (dataInput instanceof ImageInputStream) {
            ImageInputStream imageInputStream = (ImageInputStream)dataInput;
            imageInputStream.readFully(sArray, 0, sArray.length);
        } else {
            for (int i = 0; i < sArray.length; ++i) {
                sArray[i] = dataInput.readShort();
            }
        }
    }

    private void normalizeColor(int n, byte[] byArray) {
        switch (n) {
            case 0: {
                int n2 = 0;
                while (n2 < byArray.length) {
                    int n3 = n2++;
                    byArray[n3] = ~byArray[n3];
                }
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                CIELabColorConverter cIELabColorConverter = new CIELabColorConverter(n == 8 ? CIELabColorConverter.Illuminant.D65 : CIELabColorConverter.Illuminant.D50);
                float[] fArray = new float[3];
                for (int i = 0; i < byArray.length; i += 3) {
                    float f;
                    float f2;
                    float f3 = (float)(byArray[i] & 0xFF) * 100.0f / 255.0f;
                    if (n == 8) {
                        f2 = byArray[i + 1];
                        f = byArray[i + 2];
                    } else {
                        f2 = (byArray[i + 1] & 0xFF) - 128;
                        f = (byArray[i + 2] & 0xFF) - 128;
                    }
                    cIELabColorConverter.toRGB(f3, f2, f, fArray);
                    byArray[i] = (byte)fArray[0];
                    byArray[i + 1] = (byte)fArray[1];
                    byArray[i + 2] = (byte)fArray[2];
                }
                break;
            }
            case 6: {
                Entry entry = this.currentIFD.getEntryById((Object)529);
                if (entry == null) {
                    for (int i = 0; i < byArray.length; i += 3) {
                        YCbCrConverter.convertYCbCr2RGB((byte[])byArray, (byte[])byArray, (int)i);
                    }
                } else {
                    Rational[] rationalArray = (Rational[])entry.getValue();
                    double[] dArray = new double[]{rationalArray[0].doubleValue(), rationalArray[1].doubleValue(), rationalArray[2].doubleValue()};
                    for (int i = 0; i < byArray.length; i += 3) {
                        YCbCrConverter.convertYCbCr2RGB((byte[])byArray, (byte[])byArray, (double[])dArray, (int)i);
                    }
                }
                break;
            }
        }
    }

    private void normalizeColor(int n, short[] sArray) {
        switch (n) {
            case 0: {
                int n2 = 0;
                while (n2 < sArray.length) {
                    int n3 = n2++;
                    sArray[n3] = ~sArray[n3];
                }
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                CIELabColorConverter cIELabColorConverter = new CIELabColorConverter(n == 10 ? CIELabColorConverter.Illuminant.D65 : CIELabColorConverter.Illuminant.D50);
                float[] fArray = new float[3];
                float f = n == 8 ? 65535.0f : 65280.0f;
                for (int i = 0; i < sArray.length; i += 3) {
                    float f2;
                    float f3;
                    float f4 = (float)(sArray[i] & 0xFFFF) * 100.0f / f;
                    if (n == 8) {
                        f3 = (float)sArray[i + 1] / 256.0f;
                        f2 = (float)sArray[i + 2] / 256.0f;
                    } else {
                        f3 = (float)((sArray[i + 1] & 0xFFFF) - 32768) / 256.0f;
                        f2 = (float)((sArray[i + 2] & 0xFFFF) - 32768) / 256.0f;
                    }
                    cIELabColorConverter.toRGB(f4, f3, f2, fArray);
                    sArray[i] = (short)(fArray[0] * 257.0f);
                    sArray[i + 1] = (short)(fArray[1] * 257.0f);
                    sArray[i + 2] = (short)(fArray[2] * 257.0f);
                }
                break;
            }
            case 6: {
                double[] dArray;
                Entry entry = this.currentIFD.getEntryById((Object)529);
                if (entry != null) {
                    Rational[] rationalArray = (Rational[])entry.getValue();
                    dArray = new double[]{rationalArray[0].doubleValue(), rationalArray[1].doubleValue(), rationalArray[2].doubleValue()};
                } else {
                    dArray = CCIR_601_1_COEFFICIENTS;
                }
                for (int i = 0; i < sArray.length; i += 3) {
                    this.convertYCbCr2RGB(sArray, sArray, dArray, i);
                }
                break;
            }
        }
    }

    private void normalizeColor(int n, int[] nArray) {
        switch (n) {
            case 0: {
                int n2 = 0;
                while (n2 < nArray.length) {
                    int n3 = n2++;
                    nArray[n3] = ~nArray[n3];
                }
                break;
            }
        }
    }

    private void normalizeColor(int n, float[] fArray) {
        switch (n) {
            default: 
        }
    }

    private void convertYCbCr2RGB(short[] sArray, short[] sArray2, double[] dArray, int n) {
        int n2 = sArray[n + 0] & 0xFFFF;
        int n3 = (sArray[n + 1] & 0xFFFF) - 32768;
        int n4 = (sArray[n + 2] & 0xFFFF) - 32768;
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = dArray[2];
        int n5 = (int)Math.round((double)n4 * (2.0 - 2.0 * d) + (double)n2);
        int n6 = (int)Math.round((double)n3 * (2.0 - 2.0 * d3) + (double)n2);
        int n7 = (int)Math.round(((double)n2 - d * (double)n5 - d3 * (double)n6) / d2);
        short s = this.clampShort(n5);
        short s2 = this.clampShort(n7);
        short s3 = this.clampShort(n6);
        sArray2[n] = s;
        sArray2[n + 1] = s2;
        sArray2[n + 2] = s3;
    }

    private short clampShort(int n) {
        return (short)Math.max(0, Math.min(65535, n));
    }

    private InputStream createDecompressorStream(int n, int n2, int n3, InputStream inputStream) throws IOException {
        switch (n) {
            case 1: {
                return inputStream;
            }
            case 32773: {
                return new DecoderStream(inputStream, (Decoder)new PackBitsDecoder(), 1024);
            }
            case 5: {
                return new DecoderStream(inputStream, LZWDecoder.create(LZWDecoder.isOldBitReversedStream(inputStream)), Math.max(n2 * n3, 1024));
            }
            case 8: 
            case 32946: {
                return new InflaterInputStream(inputStream, new Inflater(), 1024);
            }
            case 2: {
                return new CCITTFaxDecoderStream(inputStream, n2, n, this.getValueAsIntWithDefault(266, 1), 0L);
            }
            case 3: {
                return new CCITTFaxDecoderStream(inputStream, n2, n, this.getValueAsIntWithDefault(266, 1), this.getValueAsLongWithDefault(292, 0L));
            }
            case 4: {
                return new CCITTFaxDecoderStream(inputStream, n2, n, this.getValueAsIntWithDefault(266, 1), this.getValueAsLongWithDefault(293, 0L));
            }
        }
        throw new IllegalArgumentException("Unsupported TIFF compression: " + n);
    }

    private InputStream createUnpredictorStream(int n, int n2, int n3, int n4, InputStream inputStream, ByteOrder byteOrder) throws IOException {
        switch (n) {
            case 1: {
                return inputStream;
            }
            case 2: {
                return new HorizontalDeDifferencingStream(inputStream, n2, n3, n4, byteOrder);
            }
            case 3: {
                throw new IIOException("Unsupported TIFF Predictor value: " + n);
            }
        }
        throw new IIOException("Unknown TIFF Predictor value: " + n);
    }

    private long[] getValueAsLongArray(int n, String string, boolean bl) throws IIOException {
        long[] lArray;
        Entry entry = this.currentIFD.getEntryById((Object)n);
        if (entry == null) {
            if (bl) {
                throw new IIOException("Missing TIFF tag " + string);
            }
            return null;
        }
        if (entry.valueCount() == 1) {
            lArray = new long[]{((Number)entry.getValue()).longValue()};
        } else if (entry.getValue() instanceof short[]) {
            short[] sArray = (short[])entry.getValue();
            lArray = new long[sArray.length];
            int n2 = lArray.length;
            for (int i = 0; i < n2; ++i) {
                lArray[i] = sArray[i];
            }
        } else if (entry.getValue() instanceof int[]) {
            int[] nArray = (int[])entry.getValue();
            lArray = new long[nArray.length];
            int n3 = lArray.length;
            for (int i = 0; i < n3; ++i) {
                lArray[i] = nArray[i];
            }
        } else if (entry.getValue() instanceof long[]) {
            lArray = (long[])entry.getValue();
        } else {
            throw new IIOException(String.format("Unsupported %s type: %s (%s)", string, entry.getTypeName(), entry.getValue().getClass()));
        }
        return lArray;
    }

    private ICC_Profile getICCProfile() throws IOException {
        Entry entry = this.currentIFD.getEntryById((Object)34675);
        if (entry != null) {
            byte[] byArray = (byte[])entry.getValue();
            try {
                ICC_Profile iCC_Profile = ICC_Profile.getInstance(new ByteArrayInputStream(byArray));
                return ColorSpaces.validateProfile((ICC_Profile)iCC_Profile);
            }
            catch (CMMException | IllegalArgumentException runtimeException) {
                this.processWarningOccurred("Ignoring broken/incompatible ICC profile: " + runtimeException.getMessage());
            }
        }
        return null;
    }

    public IIOMetadata getImageMetadata(int n) throws IOException {
        this.readIFD(n);
        return new TIFFImageMetadata(this.currentIFD);
    }

    public IIOMetadata getStreamMetadata() throws IOException {
        return super.getStreamMetadata();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws IOException {
        ImageIO.setUseCache(false);
        for (final String string : stringArray) {
            File file = new File(string);
            ImageInputStream imageInputStream = ImageIO.createImageInputStream(file);
            if (imageInputStream == null) {
                System.err.println("Could not read file: " + file);
                continue;
            }
            TIFFImageReader.deregisterOSXTIFFImageReaderSpi();
            Iterator<ImageReader> iterator = ImageIO.getImageReaders(imageInputStream);
            if (!iterator.hasNext()) {
                System.err.println("No reader for: " + file);
                continue;
            }
            ImageReader imageReader = iterator.next();
            System.err.println("Reading using: " + imageReader);
            imageReader.addIIOReadWarningListener(new IIOReadWarningListener(){

                @Override
                public void warningOccurred(ImageReader imageReader, String string2) {
                    System.err.println("Warning: " + string + ": " + string2);
                }
            });
            imageReader.addIIOReadProgressListener((IIOReadProgressListener)new ProgressListenerBase(){
                private static final int MAX_W = 78;
                int lastProgress = 0;

                public void imageStarted(ImageReader imageReader, int n) {
                    System.out.print("[");
                }

                public void imageProgress(ImageReader imageReader, float f) {
                    int n = (int)(f * 78.0f) / 100;
                    for (int i = this.lastProgress; i < n; ++i) {
                        System.out.print(".");
                    }
                    System.out.flush();
                    this.lastProgress = n;
                }

                public void imageComplete(ImageReader imageReader) {
                    for (int i = this.lastProgress; i < 78; ++i) {
                        System.out.print(".");
                    }
                    System.out.println("]");
                }
            });
            imageReader.setInput(imageInputStream);
            try {
                ImageReadParam imageReadParam = imageReader.getDefaultReadParam();
                int n = imageReader.getNumImages(true);
                for (int i = 0; i < n; ++i) {
                    try {
                        long l = System.currentTimeMillis();
                        BufferedImage bufferedImage = imageReader.read(i, imageReadParam);
                        System.err.println("Read time: " + (System.currentTimeMillis() - l) + " ms");
                        System.err.println("image: " + bufferedImage);
                        if (bufferedImage.getType() == 0) {
                            l = System.currentTimeMillis();
                            bufferedImage = new ColorConvertOp(null).filter(bufferedImage, new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 2));
                            System.err.println("Conversion time: " + (System.currentTimeMillis() - l) + " ms");
                        }
                        TIFFImageReader.showIt(bufferedImage, String.format("Image: %s [%d x %d]", file.getName(), imageReader.getWidth(i), imageReader.getHeight(i)));
                        try {
                            int n2 = imageReader.getNumThumbnails(0);
                            for (int j = 0; j < n2; ++j) {
                                BufferedImage bufferedImage2 = imageReader.readThumbnail(i, j);
                                TIFFImageReader.showIt(bufferedImage2, String.format("Thumbnail: %s [%d x %d]", file.getName(), bufferedImage2.getWidth(), bufferedImage2.getHeight()));
                            }
                            continue;
                        }
                        catch (IIOException iIOException) {
                            System.err.println("Could not read thumbnails: " + iIOException.getMessage());
                            iIOException.printStackTrace();
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        System.err.println(file + " image " + i + " can't be read:");
                        throwable.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                System.err.println(file + " can't be read:");
                throwable.printStackTrace();
            }
            finally {
                imageInputStream.close();
            }
        }
    }

    protected static void showIt(BufferedImage bufferedImage, String string) {
        ImageReaderBase.showIt((BufferedImage)bufferedImage, (String)string);
    }

    private static void deregisterOSXTIFFImageReaderSpi() {
        IIORegistry iIORegistry = IIORegistry.getDefaultInstance();
        Iterator<ImageReaderSpi> iterator = iIORegistry.getServiceProviders(ImageReaderSpi.class, new ServiceRegistry.Filter(){

            @Override
            public boolean filter(Object object) {
                return object.getClass().getName().equals("com.sun.imageio.plugins.tiff.TIFFImageReaderSpi");
            }
        }, false);
        while (iterator.hasNext()) {
            ImageReaderSpi imageReaderSpi = iterator.next();
            iIORegistry.deregisterServiceProvider(imageReaderSpi);
        }
    }
}

