/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.codeInsight;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.XmlTagInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.html.HtmlFileImpl;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.codeInsight.VueDirectiveUtilKt;
import org.jetbrains.vuejs.codeInsight.VueTagProviderKt;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001c\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/vuejs/codeInsight/VueInsertHandler;", "Lcom/intellij/codeInsight/completion/XmlTagInsertHandler;", "()V", "addProperty", "Lcom/intellij/psi/PsiElement;", "newProperty", "Lcom/intellij/lang/javascript/psi/JSProperty;", "obj", "Lcom/intellij/lang/javascript/psi/JSObjectLiteralExpression;", "componentProperty", "handleInsert", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "item", "Lcom/intellij/codeInsight/lookup/LookupElement;", "isSkippedModule", "", "nodeModule", "Lcom/intellij/openapi/vfs/VirtualFile;", "shouldHandleXmlInsert", "Companion", "vuejs"})
public final class VueInsertHandler
extends XmlTagInsertHandler {
    @NotNull
    private static final VueInsertHandler INSTANCE;
    public static final Companion Companion;

    public void handleInsert(@Nullable InsertionContext context, @Nullable LookupElement item) {
        JSProperty newProperty;
        if (context == null || this.shouldHandleXmlInsert(context)) {
            super.handleInsert(context, item);
        }
        if (context == null || item == null) {
            return;
        }
        Object object = item.getObject();
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.lang.javascript.psi.stubs.JSImplicitElement");
        }
        PsiFile importedFile = ((JSImplicitElement)object).getContainingFile();
        if (Intrinsics.areEqual((Object)importedFile, (Object)context.getFile())) {
            return;
        }
        Object object2 = item.getObject();
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiElement");
        }
        VirtualFile nodeModule = NodeModuleSearchUtil.findDependencyRoot((VirtualFile)((PsiElement)object2).getContainingFile().getVirtualFile());
        if (this.isSkippedModule(nodeModule)) {
            return;
        }
        context.commitDocument();
        PsiFile psiFile = context.getFile();
        if (!(psiFile instanceof HtmlFileImpl)) {
            psiFile = null;
        }
        HtmlFileImpl htmlFileImpl = (HtmlFileImpl)psiFile;
        if (htmlFileImpl == null) {
            return;
        }
        HtmlFileImpl file = htmlFileImpl;
        JSEmbeddedContent jSEmbeddedContent = VueTagProviderKt.findScriptContent(file);
        if (jSEmbeddedContent == null) {
            return;
        }
        JSEmbeddedContent content = jSEmbeddedContent;
        JSElement jSElement = ES6PsiUtil.findDefaultExport((JSElement)((JSElement)content));
        if (!(jSElement instanceof JSExportAssignment)) {
            jSElement = null;
        }
        JSExportAssignment jSExportAssignment = (JSExportAssignment)jSElement;
        if (jSExportAssignment == null) {
            return;
        }
        JSExportAssignment defaultExport = jSExportAssignment;
        JSExpression jSExpression = defaultExport.getExpression();
        if (!(jSExpression instanceof JSObjectLiteralExpression)) {
            jSExpression = null;
        }
        JSObjectLiteralExpression jSObjectLiteralExpression = (JSObjectLiteralExpression)jSExpression;
        if (jSObjectLiteralExpression == null) {
            return;
        }
        JSObjectLiteralExpression obj = jSObjectLiteralExpression;
        String string = item.getLookupString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"item.lookupString");
        String name = VueDirectiveUtilKt.toAsset(string);
        JSExpression jSExpression2 = this.componentProperty(obj).getValue();
        if (!(jSExpression2 instanceof JSObjectLiteralExpression)) {
            jSExpression2 = null;
        }
        JSObjectLiteralExpression jSObjectLiteralExpression2 = (JSObjectLiteralExpression)jSExpression2;
        if (jSObjectLiteralExpression2 == null) {
            return;
        }
        JSObjectLiteralExpression components = jSObjectLiteralExpression2;
        String capitalizedName = StringsKt.capitalize((String)name);
        if (components.findProperty(name) != null || components.findProperty(capitalizedName) != null) {
            return;
        }
        ASTNode aSTNode = JSChangeUtil.createExpressionWithContext((String)("{ " + capitalizedName + " }"), (PsiElement)((PsiElement)obj));
        if (aSTNode == null) {
            Intrinsics.throwNpe();
        }
        PsiElement psiElement = aSTNode.getPsi();
        if (psiElement == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.lang.javascript.psi.JSObjectLiteralExpression");
        }
        JSProperty jSProperty = newProperty = ((JSObjectLiteralExpression)psiElement).getFirstProperty();
        Intrinsics.checkExpressionValueIsNotNull((Object)jSProperty, (String)"newProperty");
        this.addProperty(jSProperty, components);
        ES6ImportPsiUtil.insertImport((PsiElement)((PsiElement)content), (String)capitalizedName, (ES6ImportPsiUtil.ImportType)ES6ImportPsiUtil.ImportType.DEFAULT, (PsiFile)importedFile, (Editor)context.getEditor());
    }

    private final boolean shouldHandleXmlInsert(InsertionContext context) {
        PsiFile file = context.getFile();
        if (!file.getLanguage().isKindOf((Language)XMLLanguage.INSTANCE)) {
            return false;
        }
        XmlTag element = (XmlTag)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)context.getStartOffset(), XmlTag.class, (boolean)false);
        return element == null || element.getLanguage().isKindOf((Language)XMLLanguage.INSTANCE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSkippedModule(VirtualFile nodeModule) {
        VirtualFile virtualFile = nodeModule;
        if (Intrinsics.areEqual((Object)"vue", (Object)(virtualFile != null ? virtualFile.getName() : null))) return true;
        VirtualFile virtualFile2 = nodeModule;
        if (!Intrinsics.areEqual((Object)"vue-router", (Object)(virtualFile2 != null ? virtualFile2.getName() : null))) return false;
        return true;
    }

    private final JSProperty componentProperty(JSObjectLiteralExpression obj) {
        PsiElement addedProperty;
        JSProperty newProperty;
        JSProperty property = obj.findProperty("components");
        if (property != null) {
            return property;
        }
        ASTNode aSTNode = JSChangeUtil.createExpressionWithContext((String)"{ components: {} }", (PsiElement)((PsiElement)obj));
        if (aSTNode == null) {
            Intrinsics.throwNpe();
        }
        PsiElement psiElement = aSTNode.getPsi();
        if (psiElement == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.lang.javascript.psi.JSObjectLiteralExpression");
        }
        JSProperty jSProperty = newProperty = ((JSObjectLiteralExpression)psiElement).getFirstProperty();
        Intrinsics.checkExpressionValueIsNotNull((Object)jSProperty, (String)"newProperty");
        PsiElement psiElement2 = addedProperty = this.addProperty(jSProperty, obj);
        if (psiElement2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.lang.javascript.psi.JSProperty");
        }
        return (JSProperty)psiElement2;
    }

    private final PsiElement addProperty(JSProperty newProperty, JSObjectLiteralExpression obj) {
        PsiElement addedProperty;
        JSProperty first = obj.getFirstProperty();
        if (first != null) {
            PsiElement psiElement = obj.addBefore((PsiElement)newProperty, (PsiElement)first);
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"obj.addBefore(newProperty, first)");
            addedProperty = psiElement;
            JSChangeUtil.addWs((ASTNode)obj.getNode(), (ASTNode)first.getNode(), (String)"\n");
        } else {
            PsiElement psiElement = obj.addAfter((PsiElement)newProperty, obj.getFirstChild());
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"obj.addAfter(newProperty, obj.firstChild)");
            addedProperty = psiElement;
        }
        return addedProperty;
    }

    static {
        Companion = new Companion(null);
        INSTANCE = new VueInsertHandler();
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/vuejs/codeInsight/VueInsertHandler$Companion;", "", "()V", "INSTANCE", "Lorg/jetbrains/vuejs/codeInsight/VueInsertHandler;", "getINSTANCE", "()Lorg/jetbrains/vuejs/codeInsight/VueInsertHandler;", "vuejs"})
    public static final class Companion {
        @NotNull
        public final VueInsertHandler getINSTANCE() {
            return INSTANCE;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

