/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.language;

import com.intellij.lexer.LexerBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlTokenType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.language.VueElementTypes;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\fH\u0016J\b\u0010\u0017\u001a\u00020\tH\u0016J\b\u0010\u0018\u001a\u00020\fH\u0016J\b\u0010\u0019\u001a\u00020\fH\u0016J\b\u0010\u001a\u001a\u00020\fH\u0016J\n\u0010\u001b\u001a\u0004\u0018\u00010\u0006H\u0016J(\u0010\u000f\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\fH\u0016R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/vuejs/language/VueInterpolationLexer;", "Lcom/intellij/lexer/LexerBase;", "prefix", "", "suffix", "type", "Lcom/intellij/psi/tree/IElementType;", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/psi/tree/IElementType;)V", "buffer", "", "element", "end", "", "getPrefix", "()Ljava/lang/String;", "start", "state", "getSuffix", "getType", "()Lcom/intellij/psi/tree/IElementType;", "advance", "", "getBufferEnd", "getBufferSequence", "getState", "getTokenEnd", "getTokenStart", "getTokenType", "startOffset", "endOffset", "initialState", "vuejs"})
public final class VueInterpolationLexer
extends LexerBase {
    private CharSequence buffer;
    private int state;
    private IElementType element;
    private int start;
    private int end;
    @NotNull
    private final String prefix;
    @NotNull
    private final String suffix;
    @NotNull
    private final IElementType type;

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
        this.buffer = buffer;
        this.state = 0;
        this.start = 0;
        this.end = 0;
    }

    public int getState() {
        return this.state;
    }

    @Nullable
    public IElementType getTokenType() {
        return this.element;
    }

    public int getTokenStart() {
        return this.start;
    }

    public int getTokenEnd() {
        return this.end;
    }

    public void advance() {
        CharSequence charSequence = this.buffer;
        if (charSequence == null) {
            Intrinsics.throwNpe();
        }
        if (this.end == charSequence.length()) {
            this.element = null;
            return;
        }
        this.start = this.end;
        switch (this.state) {
            case 0: {
                CharSequence charSequence2 = this.buffer;
                if (charSequence2 == null) {
                    Intrinsics.throwNpe();
                }
                if (charSequence2.charAt(this.start) == '\n') {
                    this.element = XmlTokenType.XML_REAL_WHITE_SPACE;
                    while (true) {
                        CharSequence charSequence3 = this.buffer;
                        if (charSequence3 == null) {
                            Intrinsics.throwNpe();
                        }
                        if (this.end >= charSequence3.length()) break;
                        CharSequence charSequence4 = this.buffer;
                        if (charSequence4 == null) {
                            Intrinsics.throwNpe();
                        }
                        if (!StringUtil.isWhiteSpace((char)charSequence4.charAt(this.end))) break;
                        int n = this.end;
                        this.end = n + 1;
                    }
                    return;
                }
                CharSequence charSequence5 = this.buffer;
                if (charSequence5 == null) {
                    Intrinsics.throwNpe();
                }
                int lineEnd = StringsKt.indexOf$default((CharSequence)charSequence5, (char)'\n', (int)this.end, (boolean)false, (int)4, null);
                CharSequence charSequence6 = this.buffer;
                if (charSequence6 == null) {
                    Intrinsics.throwNpe();
                }
                int prefixStart = StringsKt.indexOf$default((CharSequence)charSequence6, (String)this.prefix, (int)this.end, (boolean)false, (int)4, null);
                if (lineEnd >= 0 && (lineEnd < prefixStart || prefixStart < 0)) {
                    this.end = lineEnd;
                } else if (prefixStart >= 0) {
                    this.end = prefixStart + this.prefix.length();
                    this.state = 1;
                } else {
                    CharSequence charSequence7 = this.buffer;
                    if (charSequence7 == null) {
                        Intrinsics.throwNpe();
                    }
                    this.end = charSequence7.length();
                }
                this.element = this.type;
                break;
            }
            case 1: {
                int suffixStart;
                CharSequence charSequence8 = this.buffer;
                if (charSequence8 == null) {
                    Intrinsics.throwNpe();
                }
                if ((suffixStart = StringsKt.indexOf$default((CharSequence)charSequence8, (String)this.suffix, (int)this.end, (boolean)false, (int)4, null)) >= 0) {
                    this.end = suffixStart;
                    this.state = 0;
                } else {
                    CharSequence charSequence9 = this.buffer;
                    if (charSequence9 == null) {
                        Intrinsics.throwNpe();
                    }
                    this.end = charSequence9.length();
                }
                this.element = (IElementType)VueElementTypes.INSTANCE.getEMBEDDED_JS();
            }
        }
    }

    @NotNull
    public CharSequence getBufferSequence() {
        CharSequence charSequence = this.buffer;
        if (charSequence == null) {
            Intrinsics.throwNpe();
        }
        return charSequence;
    }

    public int getBufferEnd() {
        CharSequence charSequence = this.buffer;
        if (charSequence == null) {
            Intrinsics.throwNpe();
        }
        return charSequence.length();
    }

    @NotNull
    public final String getPrefix() {
        return this.prefix;
    }

    @NotNull
    public final String getSuffix() {
        return this.suffix;
    }

    @NotNull
    public final IElementType getType() {
        return this.type;
    }

    public VueInterpolationLexer(@NotNull String prefix, @NotNull String suffix, @NotNull IElementType type) {
        Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
        Intrinsics.checkParameterIsNotNull((Object)suffix, (String)"suffix");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        this.prefix = prefix;
        this.suffix = suffix;
        this.type = type;
    }
}

