/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.language;

import com.intellij.lang.HtmlScriptContentProvider;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lexer.HtmlLexer;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlTokenType;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.language.VueAttributesHandler;
import org.jetbrains.vuejs.language.VueElementTypes;
import org.jetbrains.vuejs.language.VueHandledLexer;
import org.jetbrains.vuejs.language.VueInterpolationLexer;
import org.jetbrains.vuejs.language.VueLangAttributeHandler;
import org.jetbrains.vuejs.language.VueTagClosedHandler;
import org.jetbrains.vuejs.language.VueTemplateCleaner;
import org.jetbrains.vuejs.language.VueTemplateTagHandler;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\r\n\u0002\b\u0005\u0018\u0000 02\u00020\u00012\u00020\u0002:\u00010B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u00020\t2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0014J\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u000eH\u0014J\u000f\u0010\u0012\u001a\t\u0018\u00010\u000e\u00a2\u0006\u0002\b\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0007H\u0016J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0014J\u000f\u0010\u0017\u001a\t\u0018\u00010\u000e\u00a2\u0006\u0002\b\u0013H\u0016J\b\u0010\u0018\u001a\u00020\u0007H\u0016J\b\u0010\u0019\u001a\u00020\u0007H\u0016J\n\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\b\u0010\u001c\u001a\u00020\tH\u0016J\b\u0010\u001d\u001a\u00020\tH\u0016J\b\u0010\u001e\u001a\u00020\tH\u0016J\b\u0010\u001f\u001a\u00020\tH\u0016J\b\u0010 \u001a\u00020\tH\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\tH\u0016J\b\u0010#\u001a\u00020\u000bH\u0016J\b\u0010$\u001a\u00020\u000bH\u0016J\b\u0010%\u001a\u00020\u000bH\u0016J\u0010\u0010&\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020\tH\u0016J\u0010\u0010(\u001a\u00020\u000b2\u0006\u0010)\u001a\u00020\tH\u0016J(\u0010*\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u00072\u0006\u0010.\u001a\u00020\u00072\u0006\u0010/\u001a\u00020\u0007H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lorg/jetbrains/vuejs/language/VueLexer;", "Lcom/intellij/lexer/HtmlLexer;", "Lorg/jetbrains/vuejs/language/VueHandledLexer;", "()V", "interpolationLexer", "Lcom/intellij/lexer/Lexer;", "interpolationStart", "", "seenTemplate", "", "advance", "", "endOfTheEmbeddment", "name", "", "findScriptContentProvider", "Lcom/intellij/lang/HtmlScriptContentProvider;", "mimeType", "getScriptType", "Lorg/jetbrains/annotations/Nullable;", "getState", "getStyleLanguage", "Lcom/intellij/lang/Language;", "getStyleType", "getTokenEnd", "getTokenStart", "getTokenType", "Lcom/intellij/psi/tree/IElementType;", "inTagState", "seenAttribute", "seenScript", "seenStyle", "seenTag", "setSeenAttribute", "attribute", "setSeenScript", "setSeenScriptType", "setSeenStyleType", "setSeenTag", "tag", "setSeenTemplate", "template", "start", "buffer", "", "startOffset", "endOffset", "initialState", "Companion", "vuejs"})
public final class VueLexer
extends HtmlLexer
implements VueHandledLexer {
    private Lexer interpolationLexer;
    private int interpolationStart = -1;
    private boolean seenTemplate;
    private static final int SEEN_INTERPOLATION = 4096;
    public static final Companion Companion = new Companion(null);

    @Nullable
    protected HtmlScriptContentProvider findScriptContentProvider(@Nullable String mimeType) {
        HtmlScriptContentProvider type;
        HtmlScriptContentProvider htmlScriptContentProvider;
        String string = mimeType;
        if (string == null) {
            string = "text/ecmascript-6";
        }
        if ((htmlScriptContentProvider = (type = super.findScriptContentProvider(string))) == null) {
            htmlScriptContentProvider = this.scriptContentViaLang();
        }
        return htmlScriptContentProvider;
    }

    @Nullable
    protected Language getStyleLanguage() {
        Language language = this.styleViaLang(VueLexer.access$getOurDefaultStyleLanguage$p$s133750273());
        if (language == null) {
            language = super.getStyleLanguage();
        }
        return language;
    }

    @Override
    public boolean seenScript() {
        return this.seenScript;
    }

    @Override
    public boolean seenStyle() {
        return this.seenStyle;
    }

    @Override
    public boolean seenTemplate() {
        return this.seenTemplate;
    }

    @Override
    public boolean seenTag() {
        return this.seenTag;
    }

    @Override
    public boolean seenAttribute() {
        return this.seenAttribute;
    }

    @Override
    @Nullable
    public String getScriptType() {
        return this.scriptType;
    }

    @Override
    @Nullable
    public String getStyleType() {
        return this.styleType;
    }

    @Override
    public boolean inTagState() {
        return (this.getState() & 0x3F) == 6;
    }

    @Override
    public void setSeenScriptType() {
        this.seenContentType = true;
    }

    @Override
    public void setSeenScript() {
        this.seenScript = true;
    }

    @Override
    public void setSeenStyleType() {
        this.seenStylesheetType = true;
    }

    @Override
    public void setSeenTemplate(boolean template) {
        this.seenTemplate = template;
    }

    @Override
    public void setSeenTag(boolean tag) {
        this.seenTag = tag;
    }

    @Override
    public void setSeenAttribute(boolean attribute) {
        this.seenAttribute = attribute;
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
        this.seenTemplate = (initialState & VueTemplateTagHandler.Companion.getSEEN_TEMPLATE()) != 0;
        this.interpolationLexer = null;
        this.interpolationStart = -1;
        super.start(buffer, startOffset, endOffset, initialState);
    }

    public int getState() {
        int state = super.getState();
        return state | (this.seenTemplate ? VueTemplateTagHandler.Companion.getSEEN_TEMPLATE() : 0) | (this.interpolationLexer != null ? Companion.getSEEN_INTERPOLATION() : 0);
    }

    protected boolean endOfTheEmbeddment(@Nullable String name) {
        return super.endOfTheEmbeddment(name) || this.seenTemplate && Intrinsics.areEqual((Object)"template", (Object)name);
    }

    @Nullable
    public IElementType getTokenType() {
        IElementType type = super.getTokenType();
        if (this.seenAttribute && Intrinsics.areEqual((Object)type, (Object)JSElementTypes.EMBEDDED_CONTENT)) {
            return (IElementType)VueElementTypes.INSTANCE.getEMBEDDED_JS();
        }
        if (this.interpolationLexer != null) {
            Lexer lexer = this.interpolationLexer;
            if (lexer == null) {
                Intrinsics.throwNpe();
            }
            return lexer.getTokenType();
        }
        return type;
    }

    public int getTokenStart() {
        if (this.interpolationLexer != null) {
            Lexer lexer = this.interpolationLexer;
            if (lexer == null) {
                Intrinsics.throwNpe();
            }
            return this.interpolationStart + lexer.getTokenStart();
        }
        return super.getTokenStart();
    }

    public int getTokenEnd() {
        if (this.interpolationLexer != null) {
            Lexer lexer = this.interpolationLexer;
            if (lexer == null) {
                Intrinsics.throwNpe();
            }
            return this.interpolationStart + lexer.getTokenEnd();
        }
        return super.getTokenEnd();
    }

    public void advance() {
        if (this.interpolationLexer != null) {
            Lexer lexer = this.interpolationLexer;
            if (lexer == null) {
                Intrinsics.throwNpe();
            }
            lexer.advance();
            try {
                Lexer lexer2 = this.interpolationLexer;
                if (lexer2 == null) {
                    Intrinsics.throwNpe();
                }
                if (lexer2.getTokenType() != null) {
                    return;
                }
            }
            catch (Error error) {
                Logger logger = Logger.getInstance(VueLexer.class);
                Lexer lexer3 = this.interpolationLexer;
                if (lexer3 == null) {
                    Intrinsics.throwNpe();
                }
                logger.error((Object)lexer3.getBufferSequence());
            }
            this.interpolationLexer = null;
            this.interpolationStart = -1;
            return;
        }
        super.advance();
        IElementType originalType = super.getTokenType();
        if (originalType == XmlTokenType.XML_DATA_CHARACTERS || originalType == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN) {
            IElementType iElementType = originalType;
            if (iElementType == null) {
                Intrinsics.throwNpe();
            }
            IElementType type = iElementType;
            this.interpolationStart = super.getTokenStart();
            StringBuilder text = new StringBuilder();
            while (type == XmlTokenType.XML_DATA_CHARACTERS || type == XmlTokenType.XML_REAL_WHITE_SPACE || type == XmlTokenType.XML_WHITE_SPACE || type == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN || type == XmlTokenType.XML_CHAR_ENTITY_REF || type == XmlTokenType.XML_ENTITY_REF_TOKEN) {
                text.append(super.getTokenText());
                super.advance();
                type = this.getTokenType();
            }
            VueInterpolationLexer lexer = new VueInterpolationLexer("{{", "}}", originalType);
            lexer.start(text);
            lexer.advance();
            this.interpolationLexer = (Lexer)lexer;
        }
    }

    public VueLexer() {
        this.registerHandler(XmlTokenType.XML_NAME, new VueLangAttributeHandler());
        this.registerHandler(XmlTokenType.XML_NAME, new VueTemplateTagHandler());
        this.registerHandler(XmlTokenType.XML_NAME, new VueAttributesHandler());
        this.registerHandler(XmlTokenType.XML_TAG_END, new VueTagClosedHandler());
        VueTemplateCleaner scriptCleaner = new VueTemplateCleaner();
        this.registerHandler(XmlTokenType.XML_END_TAG_START, scriptCleaner);
        this.registerHandler(XmlTokenType.XML_EMPTY_ELEMENT_END, scriptCleaner);
    }

    static {
        SEEN_INTERPOLATION = 4096;
    }

    @Override
    @Nullable
    public HtmlScriptContentProvider scriptContentViaLang() {
        return VueHandledLexer.DefaultImpls.scriptContentViaLang(this);
    }

    @Override
    public boolean languageMatches(@NotNull Language language) {
        Intrinsics.checkParameterIsNotNull((Object)language, (String)"language");
        return VueHandledLexer.DefaultImpls.languageMatches(this, language);
    }

    @Override
    @Nullable
    public Language styleViaLang(@Nullable Language language) {
        return VueHandledLexer.DefaultImpls.styleViaLang(this, language);
    }

    @Nullable
    public static final /* synthetic */ Language access$getOurDefaultStyleLanguage$p$s133750273() {
        return HtmlLexer.ourDefaultStyleLanguage;
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/vuejs/language/VueLexer$Companion;", "", "()V", "SEEN_INTERPOLATION", "", "getSEEN_INTERPOLATION", "()I", "vuejs"})
    public static final class Companion {
        public final int getSEEN_INTERPOLATION() {
            return SEEN_INTERPOLATION;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

