/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.node.NullNode;
import com.github.dockerjava.api.model.Link;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class Links {
    private final Link[] links;

    public Links(Link ... links) {
        this.links = links;
    }

    public Links(List<Link> links) {
        this.links = links.toArray(new Link[links.size()]);
    }

    public Link[] getLinks() {
        return this.links;
    }

    public static class Deserializer
    extends JsonDeserializer<Links> {
        public Links deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            ArrayList<Link> binds = new ArrayList<Link>();
            ObjectCodec oc = jsonParser.getCodec();
            JsonNode node = (JsonNode)oc.readTree(jsonParser);
            Iterator it = node.elements();
            while (it.hasNext()) {
                JsonNode element = (JsonNode)it.next();
                if (element.equals((Object)NullNode.getInstance())) continue;
                binds.add(Link.parse(element.asText()));
            }
            return new Links(binds.toArray(new Link[0]));
        }
    }

    public static class Serializer
    extends JsonSerializer<Links> {
        public void serialize(Links links, JsonGenerator jsonGen, SerializerProvider serProvider) throws IOException, JsonProcessingException {
            jsonGen.writeStartArray();
            for (Link link : links.getLinks()) {
                jsonGen.writeString(link.toString());
            }
            jsonGen.writeEndArray();
        }
    }
}

