/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerCloudType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractDockerProcessConnectionData {
    @NotNull
    protected final RemoteSdkAdditionalData myCommonCredentials;

    public AbstractDockerProcessConnectionData(@NotNull RemoteSdkAdditionalData commonCredentials) {
        if (commonCredentials == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commonCredentials", "com/intellij/docker/AbstractDockerProcessConnectionData", "<init>"));
        }
        this.myCommonCredentials = commonCredentials;
    }

    public String getInterpreterPath() {
        return this.myCommonCredentials.getInterpreterPath();
    }

    public String getSdkHomePath() {
        return this.myCommonCredentials.getSdkId();
    }

    public String getHelpersPath() {
        return this.myCommonCredentials.getHelpersPath();
    }

    @NotNull
    public abstract String getId();

    @NotNull
    public DockerCloudConfiguration getAccount() throws RemoteSdkException {
        DockerCloudConfiguration dockerCloudConfiguration = (DockerCloudConfiguration)this.getRemoteServer().getConfiguration();
        if (dockerCloudConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/AbstractDockerProcessConnectionData", "getAccount"));
        }
        return dockerCloudConfiguration;
    }

    @NotNull
    public RemoteServer<DockerCloudConfiguration> getRemoteServer() throws RemoteSdkException {
        String accountName = this.getDockerAccountName();
        if (StringUtil.isEmpty((String)accountName)) {
            throw new RemoteSdkException("Docker account not specified");
        }
        RemoteServer result = RemoteServersManager.getInstance().findByName(accountName, (ServerType)DockerCloudType.getInstance());
        if (result == null) {
            throw new RemoteSdkException("Docker account not found");
        }
        RemoteServer remoteServer = result;
        if (remoteServer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/AbstractDockerProcessConnectionData", "getRemoteServer"));
        }
        return remoteServer;
    }

    protected abstract String getDockerAccountName();
}

