/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker;

import com.intellij.docker.DockerCloudType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.impl.artifacts.PlainArtifactType;
import com.intellij.packaging.impl.elements.FileCopyPackagingElement;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.configuration.deployment.JavaDeploymentSourceUtil;
import com.intellij.remoteServer.runtime.deployment.DeploymentLogManager;
import com.intellij.remoteServer.runtime.deployment.DeploymentTask;
import com.intellij.remoteServer.util.CloudDeploymentNameConfiguration;
import com.intellij.remoteServer.util.CloudDeploymentRuntime;
import com.intellij.remoteServer.util.CloudDeploymentRuntimeProvider;
import com.intellij.remoteServer.util.CloudMultiSourceServerRuntimeInstance;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class DockerArtifactDeploymentRuntimeProvider
implements CloudDeploymentRuntimeProvider {
    public ServerType<?> getServerType() {
        return DockerCloudType.getInstance();
    }

    public Collection<DeploymentSource> getDeploymentSources(Project project) {
        List dockerArtifacts = ContainerUtil.filter((Object[])ArtifactManager.getInstance((Project)project).getArtifacts(), artifact -> {
            if (!artifact.getArtifactType().equals(PlainArtifactType.getInstance())) {
                return false;
            }
            for (PackagingElement element : artifact.getRootElement().getChildren()) {
                FileCopyPackagingElement fileElement;
                if (!(element instanceof FileCopyPackagingElement) || (fileElement = (FileCopyPackagingElement)element).isDirectory() || !StringUtil.equals((CharSequence)"Dockerfile", (CharSequence)fileElement.getOutputFileName())) continue;
                return true;
            }
            return false;
        });
        Collections.sort(dockerArtifacts, ArtifactManager.ARTIFACT_COMPARATOR);
        return JavaDeploymentSourceUtil.getInstance().createArtifactDeploymentSources(project, (Collection)dockerArtifacts);
    }

    public CloudDeploymentRuntime createDeploymentRuntime(DeploymentSource source, CloudMultiSourceServerRuntimeInstance serverRuntime, DeploymentTask<? extends CloudDeploymentNameConfiguration> deploymentTask, DeploymentLogManager logManager) throws ServerRuntimeException {
        throw new UnsupportedOperationException();
    }
}

