/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerCloudType;
import com.intellij.docker.DockerPathMappingEditor;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.machine.DockerConnectionInfo;
import com.intellij.docker.machine.DockerMachine;
import com.intellij.docker.machine.DockerMachineConfigurable;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.util.CloudConfigurableBase;
import com.intellij.remoteServer.util.CloudConfigurationBase;
import com.intellij.remoteServer.util.CloudNotifier;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerCloudConfigurable
extends CloudConfigurableBase<DockerCloudConfiguration> {
    private JTextField myEmailTextField;
    private JPasswordField myPasswordField;
    private JPanel myMainPanel;
    private JTextField myApiUrlTextField;
    private TextFieldWithBrowseButton myCertificatesPathTextField;
    private TextFieldWithBrowseButton myDockerComposePath;
    private JComboBox myMachineComboBox;
    private JPanel myMachinePanelPlaceholder;
    private JCheckBox myMachineCheckBox;
    private JPanel myMachinePanel;
    private JPanel myMappingPanel;
    private JPanel myPathMappingPlaceHolder;
    private DockerMachineConfigurable myMachineExecConfigurable;
    private String myStoredMachine;
    private CollectionComboBoxModel<MachineItem> myMachineComboBoxModel;
    private DockerPathMappingEditor myPathMappingEditor;

    public DockerCloudConfigurable(DockerCloudConfiguration configuration) {
        super((ServerType)DockerCloudType.getInstance(), (CloudConfigurationBase)configuration);
        this.$$$setupUI$$$();
        this.myCertificatesPathTextField.addBrowseFolderListener(DockerBundle.getText("DockerCloudConfigurable.chooser.certificates.title", new Object[0]), null, null, FileChooserDescriptorFactory.createSingleFolderDescriptor(), TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
        FileChooserDescriptor composeChooserDescriptor = new FileChooserDescriptor(true, false, false, false, false, false);
        composeChooserDescriptor.withFileFilter(file -> StringUtil.startsWith((CharSequence)file.getName(), (CharSequence)"docker-compose"));
        this.myDockerComposePath.addBrowseFolderListener(DockerBundle.getText("DockerCloudConfigurable.chooser.compose.title", new Object[0]), null, null, composeChooserDescriptor);
        this.myMachineExecConfigurable = new DockerMachineConfigurable(){

            @Override
            protected void onSuccess(String stdout) {
                super.onSuccess(stdout);
                DockerCloudConfigurable.this.loadMachines();
            }

            @Override
            protected void onError(String errorMessage) {
                super.onError(errorMessage);
                DockerCloudConfigurable.this.clearMachines();
            }
        };
        this.myMachinePanelPlaceholder.add(this.myMachineExecConfigurable.createComponent());
        this.myMachineComboBoxModel = new CollectionComboBoxModel();
        this.myMachineComboBox.setModel(this.myMachineComboBoxModel);
        this.myMachineComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DockerCloudConfigurable.this.loadMachineSettings();
            }
        });
        this.myMachineCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DockerCloudConfigurable.this.myStoredMachine = null;
                DockerCloudConfigurable.this.updateMachinePanelAvailability();
                DockerCloudConfigurable.this.loadMachineSettings();
            }
        });
        this.myMappingPanel.setVisible(!SystemInfo.isLinux);
        this.myPathMappingEditor = new DockerPathMappingEditor();
        this.myPathMappingPlaceHolder.add(this.myPathMappingEditor.getPanel());
    }

    private void updateMachinePanelAvailability() {
        UIUtil.setEnabled((Component)this.myMachinePanel, (boolean)this.myMachineCheckBox.isSelected(), (boolean)true);
    }

    private void clearMachines() {
        this.myMachineComboBoxModel.removeAll();
    }

    private void loadMachines() {
        this.myMachineComboBoxModel.removeAll();
        try {
            this.myMachineExecConfigurable.apply();
        }
        catch (ConfigurationException e) {
            return;
        }
        final DockerMachine machine = DockerMachine.currentDockerMachine();
        new TaskWithResult<List<MachineItem>>("Loading machines"){

            @Override
            protected List<MachineItem> doPerform() {
                return machine.ls().stream().map(name -> new MachineItem((String)name, machine.statusFor((String)name))).filter(MachineItem::hasKnownState).collect(Collectors.toList());
            }

            @Override
            protected void processResult(List<MachineItem> items) {
                DockerCloudConfigurable.this.myMachineComboBoxModel.add(items);
                DockerCloudConfigurable.this.selectMachine();
            }
        }.queue();
    }

    private void loadMachineSettings() {
        if (!this.myMachineCheckBox.isSelected()) {
            return;
        }
        MachineItem item = (MachineItem)this.myMachineComboBoxModel.getSelected();
        if (item != null) {
            item.loadSettings();
        }
    }

    protected JComponent getMainPanel() {
        return this.myMainPanel;
    }

    protected JTextField getEmailTextField() {
        return this.myEmailTextField;
    }

    protected JPasswordField getPasswordField() {
        return this.myPasswordField;
    }

    public boolean isModified() {
        String selectedMachine = null;
        if (this.myMachineCheckBox.isSelected()) {
            MachineItem selectedMachineItem = (MachineItem)this.myMachineComboBoxModel.getSelected();
            selectedMachine = selectedMachineItem != null ? selectedMachineItem.getName() : this.myStoredMachine;
        }
        return this.myMachineExecConfigurable.isModified() || !StringUtil.equals((CharSequence)this.myApiUrlTextField.getText(), (CharSequence)((DockerCloudConfiguration)this.myConfiguration).getApiUrl()) || !StringUtil.equals((CharSequence)this.myCertificatesPathTextField.getText(), (CharSequence)((DockerCloudConfiguration)this.myConfiguration).getCertificatesPath()) || !StringUtil.equals((CharSequence)this.myDockerComposePath.getText(), (CharSequence)((DockerCloudConfiguration)this.myConfiguration).getComposeExecPath()) || !StringUtil.equals((CharSequence)selectedMachine, (CharSequence)((DockerCloudConfiguration)this.myConfiguration).getMachine()) || !ContainerUtil.equalsIdentity(this.myPathMappingEditor.getItems(), ((DockerCloudConfiguration)this.myConfiguration).getPathMappings());
    }

    public void reset() {
        this.myMachineExecConfigurable.reset();
        this.myApiUrlTextField.setText(((DockerCloudConfiguration)this.myConfiguration).getApiUrl());
        this.myCertificatesPathTextField.setText(((DockerCloudConfiguration)this.myConfiguration).getCertificatesPath());
        this.myDockerComposePath.setText(((DockerCloudConfiguration)this.myConfiguration).getComposeExecPath());
        this.myStoredMachine = ((DockerCloudConfiguration)this.myConfiguration).getMachine();
        this.myMachineCheckBox.setSelected(this.myStoredMachine != null);
        this.updateMachinePanelAvailability();
        this.selectMachine();
        this.myPathMappingEditor.setItems(((DockerCloudConfiguration)this.myConfiguration).getPathMappings());
    }

    private void selectMachine() {
        if (this.myMachineComboBoxModel.isEmpty()) {
            return;
        }
        MachineItem selectedItem = (MachineItem)this.myMachineComboBoxModel.getSelected();
        for (MachineItem item : this.myMachineComboBoxModel.getItems()) {
            if (selectedItem != null && !StringUtil.equals((CharSequence)this.myStoredMachine, (CharSequence)item.getName())) continue;
            selectedItem = item;
        }
        this.myMachineComboBoxModel.setSelectedItem((Object)selectedItem);
        this.myStoredMachine = null;
        this.loadMachineSettings();
    }

    protected void applyCoreTo(DockerCloudConfiguration configuration) throws ConfigurationException {
        MachineItem machineItem;
        String apiUrl = this.myApiUrlTextField.getText();
        if (StringUtil.isEmpty((String)apiUrl)) {
            throw new RuntimeConfigurationError(DockerBundle.getText("DockerCloudConfigurable.error.apiUrlRequired", new Object[0]));
        }
        String certificatesPath = this.myCertificatesPathTextField.getText();
        if (!StringUtil.isEmpty((String)certificatesPath) && !new File(certificatesPath).exists()) {
            throw new RuntimeConfigurationError(DockerBundle.getText("DockerCloudConfigurable.error.certificatesFolder.missing", certificatesPath));
        }
        configuration.setApiUrl(apiUrl);
        configuration.setCertificatesPath(this.myCertificatesPathTextField.getText());
        configuration.setComposeExecPath(this.myDockerComposePath.getText());
        String machine = null;
        if (this.myMachineCheckBox.isSelected() && (machineItem = (MachineItem)this.myMachineComboBoxModel.getSelected()) != null) {
            machine = machineItem.getName();
        }
        configuration.setMachine(machine);
        configuration.setPathMappings(this.myPathMappingEditor.getItems());
    }

    public void apply() throws ConfigurationException {
        this.myMachineExecConfigurable.apply();
        super.apply();
    }

    protected boolean isCoreConfigEqual(DockerCloudConfiguration configuration1, DockerCloudConfiguration configuration2) {
        return super.isCoreConfigEqual((CloudConfigurationBase)configuration1, (CloudConfigurationBase)configuration2) && Comparing.equal((String)configuration1.getApiUrl(), (String)configuration2.getApiUrl()) && Comparing.equal((String)configuration1.getCertificatesPath(), (String)configuration2.getCertificatesPath()) && Comparing.equal((String)configuration1.getComposeExecPath(), (String)configuration2.getComposeExecPath()) && Comparing.haveEqualElements(configuration1.getPathMappings(), configuration2.getPathMappings());
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JComboBox jComboBox;
        JPanel jPanel3;
        JPanel jPanel4;
        JCheckBox jCheckBox;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JTextField jTextField;
        JPasswordField jPasswordField;
        JTextField jTextField2;
        JPanel jPanel5;
        this.myMainPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(10, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.setName("");
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new GridConstraints(9, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("API URL:");
        jPanel5.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Certificates folder:");
        jPanel5.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setVisible(false);
        jBLabel3.setText("Email:");
        jPanel5.add((Component)jBLabel3, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setVisible(false);
        jBLabel4.setText("Password:");
        jPanel5.add((Component)jBLabel4, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myEmailTextField = jTextField2 = new JTextField();
        ((Component)jTextField2).setVisible(false);
        jPanel5.add((Component)jTextField2, new GridConstraints(3, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myPasswordField = jPasswordField = new JPasswordField();
        ((Component)jPasswordField).setVisible(false);
        jPanel5.add((Component)jPasswordField, new GridConstraints(4, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myApiUrlTextField = jTextField = new JTextField();
        jPanel5.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myCertificatesPathTextField = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel5.add((Component)textFieldWithBrowseButton2, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myMachineCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Import credentials from Docker Machine");
        jPanel5.add((Component)jCheckBox, new GridConstraints(5, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myMachinePanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel4, new GridConstraints(6, 0, 1, 2, 0, 3, 3, 3, null, null, null, 3));
        this.myMachinePanelPlaceholder = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel3, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel5 = new JBLabel();
        jBLabel5.setText("Machine:");
        jPanel4.add((Component)jBLabel5, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myMachineComboBox = jComboBox = new JComboBox();
        jPanel4.add(jComboBox, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JBLabel jBLabel6 = new JBLabel();
        jBLabel6.setText("Docker Compose executable:");
        jPanel5.add((Component)jBLabel6, new GridConstraints(2, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myDockerComposePath = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel5.add((Component)textFieldWithBrowseButton, new GridConstraints(2, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myMappingPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel2, new GridConstraints(8, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myPathMappingPlaceHolder = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        TitledSeparator titledSeparator = new TitledSeparator();
        titledSeparator.setText("VirtualBox shared folders");
        jPanel2.add((Component)titledSeparator, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        jBLabel.setLabelFor(jTextField);
        jBLabel2.setLabelFor((Component)textFieldWithBrowseButton2);
        jBLabel3.setLabelFor(jTextField2);
        jBLabel4.setLabelFor(jPasswordField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private static abstract class TaskWithResult<T>
    extends Task.Backgroundable {
        public TaskWithResult(@NotNull String title) {
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/docker/DockerCloudConfigurable$TaskWithResult", "<init>"));
            }
            super(null, title, false);
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/docker/DockerCloudConfigurable$TaskWithResult", "run"));
            }
            indicator.setIndeterminate(true);
            try {
                T result = this.doPerform();
                UIUtil.invokeLaterIfNeeded(() -> this.processResult(result));
            }
            catch (RuntimeException e) {
                new CloudNotifier(DockerCloudType.getInstance().getPresentableName()).showMessage(e.getMessage(), MessageType.ERROR);
            }
        }

        protected abstract T doPerform();

        protected abstract void processResult(T var1);
    }

    private class MachineItem {
        private final String myName;
        private final String myState;

        public MachineItem(@Nullable String name, String state) {
            this.myName = name;
            this.myState = state;
        }

        public String getName() {
            return this.myName;
        }

        @Nullable
        public String getState() {
            return this.myState;
        }

        public boolean hasKnownState() {
            return this.myState != null;
        }

        public String toString() {
            return this.myName + " (" + (this.myState == null ? "Unknown/Error" : this.myState) + ")";
        }

        public void loadSettings() {
            final DockerMachine machine = DockerMachine.currentDockerMachine();
            new TaskWithResult<DockerConnectionInfo>(DockerBundle.getText("DockerCloudConfigurable.task.loading.machines.title", new Object[0])){

                @Override
                protected DockerConnectionInfo doPerform() {
                    return machine.getDockerConnectionInfo(MachineItem.this.myName);
                }

                @Override
                protected void processResult(DockerConnectionInfo connectionInfo) {
                    DockerCloudConfigurable.this.myApiUrlTextField.setText(connectionInfo.getApiUrl());
                    DockerCloudConfigurable.this.myCertificatesPathTextField.setText(connectionInfo.getCertificatesPath());
                }
            }.queue();
        }
    }
}

