/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.agent.settings.DockerEnvVarImpl;
import com.intellij.docker.agent.settings.DockerLinkImpl;
import com.intellij.docker.agent.settings.DockerPortBindingImpl;
import com.intellij.docker.agent.settings.DockerVolumeBindingImpl;
import com.intellij.docker.deploymentSource.DockerImageDeploymentSource;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.ide.browsers.StartBrowserSettings;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonElementGenerator;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfigurationBase;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Transient;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class DockerDeploymentConfiguration
extends DeploymentConfigurationBase<DockerDeploymentConfiguration> {
    private static final Logger LOG = Logger.getInstance((String)("#" + DockerDeploymentConfiguration.class.getName()));
    @NonNls
    private static final String HOST_CONFIG_PROPERTY = "HostConfig";
    @NonNls
    private static final String PORT_BINDINGS_PROPERTY = "PortBindings";
    @NonNls
    private static final String HOST_PORT_PROPERTY = "HostPort";
    private String myImageTag;
    private String myContainerName;
    private String myJSONFilePath;
    private StartBrowserSettings myStartBrowserSettings;
    private Integer myDebugPort;
    private String myEntrypoint;
    private String myCommand;
    private List<DockerPortBindingImpl> myPortBindings = new ArrayList<DockerPortBindingImpl>();
    private boolean myPublishAllPorts;
    private List<DockerLinkImpl> myLinks = new ArrayList<DockerLinkImpl>();
    private List<DockerVolumeBindingImpl> myVolumeBindings = new ArrayList<DockerVolumeBindingImpl>();
    private List<DockerEnvVarImpl> myEnvVars = new ArrayList<DockerEnvVarImpl>();
    private boolean myLinksExpanded = false;
    private boolean myVolumeBindingsExpanded = false;
    private boolean myEnvVarsExpanded = false;
    private boolean myPortBindingsExpanded = false;

    public DockerDeploymentConfiguration() {
        this.myStartBrowserSettings = new StartBrowserSettings();
        String url = Optional.ofNullable(DockerCloudConfiguration.getDefaultBrowserHost()).map(host -> "http://" + host).orElse("http://127.0.0.1");
        this.myStartBrowserSettings.setUrl(url);
    }

    public String getImageTag() {
        return this.myImageTag;
    }

    public void setImageTag(String imageTag) {
        this.myImageTag = imageTag;
    }

    public String getContainerName() {
        return this.myContainerName;
    }

    public void setContainerName(String containerName) {
        this.myContainerName = containerName;
    }

    public String getJSONFilePath() {
        return this.myJSONFilePath;
    }

    public void setJSONFilePath(String JSONFilePath) {
        this.myJSONFilePath = JSONFilePath;
    }

    @Transient
    public String getSystemDependentJSONFilePath() {
        return FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)this.getJSONFilePath()));
    }

    @Transient
    public void setSystemDependentJSONFilePath(String JSONFilePath) {
        this.setJSONFilePath(FileUtil.toSystemIndependentName((String)JSONFilePath));
    }

    public StartBrowserSettings getStartBrowserSettings() {
        return this.myStartBrowserSettings;
    }

    public void setStartBrowserSettings(StartBrowserSettings startBrowserSettings) {
        this.myStartBrowserSettings = startBrowserSettings;
    }

    public Integer getDebugPort() {
        return this.myDebugPort;
    }

    public void setDebugPort(Integer debugPort) {
        this.myDebugPort = debugPort;
    }

    public void checkConfiguration(RemoteServer<?> server, DeploymentSource deploymentSource, Project project) throws RuntimeConfigurationException {
        if (deploymentSource instanceof DockerImageDeploymentSource && StringUtil.isEmpty((String)this.myImageTag)) {
            throw new RuntimeConfigurationError("Image ID required");
        }
        if (this.myDebugPort != null && !this.hasDebugPortForwarding(project)) {
            throw new RuntimeConfigurationWarning("Debug port forwarding not found", () -> this.addDebugPortForwarding(project));
        }
    }

    private boolean hasDebugPortForwarding(Project project) {
        return this.getRemoteDebugPort(project) != null;
    }

    public String getRemoteDebugPort(Project project) {
        if (StringUtil.isEmpty((String)this.myJSONFilePath)) {
            return null;
        }
        try {
            JsonObject root = this.loadContainerConfig(project);
            JsonProperty property = new DebugConfigChecker(){

                @Override
                protected JsonProperty createProperty(JsonObject parent, String propertyName) throws CheckException {
                    throw new CheckException("Property not found: " + propertyName);
                }

                @Override
                protected JsonProperty createPortBinding(JsonObject parent, String port) throws CheckException {
                    throw new CheckException("Port binding not found");
                }
            }.check(root);
            return (String)StringUtil.split((String)property.getName(), (String)"/").get(0);
        }
        catch (CheckException e) {
            LOG.debug((Throwable)e);
            return null;
        }
    }

    private void addDebugPortForwarding(final Project project) {
        try {
            if (StringUtil.isEmpty((String)this.myJSONFilePath)) {
                FileSaverDescriptor descriptor = new FileSaverDescriptor("Save container settings", "Select path to save container settings with debug port forwarding.", new String[]{"json"});
                FileSaverDialog saverDialog = FileChooserFactory.getInstance().createSaveFileDialog(descriptor, project);
                VirtualFileWrapper fileWrapper = saverDialog.save(project.getBaseDir(), "container_settings.json");
                if (fileWrapper == null) {
                    return;
                }
                File file = fileWrapper.getFile();
                DockerDeploymentConfiguration.createJSONFile(file);
                this.setSystemDependentJSONFilePath(file.getAbsolutePath());
            }
            new WriteCommandAction(project, new PsiFile[0]){

                protected void run(@NotNull Result result) throws Throwable {
                    if (result == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/docker/DockerDeploymentConfiguration$2", "run"));
                    }
                    try {
                        JsonObject root;
                        try {
                            root = DockerDeploymentConfiguration.this.loadContainerConfig(project);
                        }
                        catch (CheckException e) {
                            DockerDeploymentConfiguration.createJSONFile(new File(DockerDeploymentConfiguration.this.getSystemDependentJSONFilePath()));
                            root = DockerDeploymentConfiguration.this.loadContainerConfig(project);
                        }
                        new DebugConfigChecker(){

                            @Override
                            protected JsonProperty createProperty(JsonObject parent, String propertyName) throws CheckException {
                                return DockerDeploymentConfiguration.addProperty(project, parent, propertyName, "{}");
                            }

                            @Override
                            protected JsonProperty createPortBinding(JsonObject parent, String port) throws CheckException {
                                return DockerDeploymentConfiguration.addProperty(project, parent, port + "/tcp", "[{ \"HostIp\": \"0.0.0.0\", \"HostPort\": \"" + port + "\" }]");
                            }
                        }.check(root);
                    }
                    catch (CheckException e) {
                        LOG.warn(e.getMessage());
                    }
                    catch (IOException e) {
                        LOG.warn((Throwable)e);
                    }
                }
            }.execute();
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    private static JsonProperty addProperty(Project project, JsonObject parent, String propertyName, String propertyValue) throws CheckException {
        JsonElementGenerator generator = new JsonElementGenerator(project);
        JsonProperty property = generator.createProperty(propertyName, propertyValue);
        List list = parent.getPropertyList();
        if (list.isEmpty()) {
            JsonProperty result = (parent = (JsonObject)parent.replace((PsiElement)generator.createObject(property.getText()))).findProperty(propertyName);
            if (result == null) {
                throw new CheckException("Created property not found: " + propertyName);
            }
            return result;
        }
        JsonProperty anchor = (JsonProperty)list.get(list.size() - 1);
        PsiElement comma = parent.addAfter(generator.createComma(), (PsiElement)anchor);
        return (JsonProperty)parent.addAfter((PsiElement)property, comma);
    }

    private static void createJSONFile(File file) throws IOException {
        FileUtil.writeToFile((File)file, (String)"{}");
    }

    private JsonObject loadContainerConfig(Project project) throws CheckException {
        JsonObject result = this.doLoadContainerConfig(project);
        if (result == null) {
            throw new CheckException("Unable to load container settings");
        }
        return result;
    }

    private JsonObject doLoadContainerConfig(Project project) {
        VirtualFile virtualJSONFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(this.getSystemDependentJSONFilePath());
        if (virtualJSONFile == null) {
            return null;
        }
        PsiFile psiJSONFile = PsiManager.getInstance((Project)project).findFile(virtualJSONFile);
        if (psiJSONFile == null) {
            return null;
        }
        return (JsonObject)ContainerUtil.getFirstItem((List)PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)psiJSONFile, JsonObject.class));
    }

    public String getEntrypoint() {
        return this.myEntrypoint;
    }

    public void setEntrypoint(String entrypoint) {
        this.myEntrypoint = entrypoint;
    }

    public String getCommand() {
        return this.myCommand;
    }

    public void setCommand(String command) {
        this.myCommand = command;
    }

    @AbstractCollection
    public List<DockerPortBindingImpl> getPortBindings() {
        if (this.myPortBindings == null) {
            this.myPortBindings = new ArrayList<DockerPortBindingImpl>();
        }
        return this.myPortBindings;
    }

    public void setPortBindings(List<DockerPortBindingImpl> portBindings) {
        this.myPortBindings = portBindings;
    }

    public void setPublishAllPorts(boolean publishAllPorts) {
        this.myPublishAllPorts = publishAllPorts;
    }

    public boolean isPublishAllPorts() {
        return this.myPublishAllPorts;
    }

    @AbstractCollection
    public List<DockerLinkImpl> getLinks() {
        if (this.myLinks == null) {
            this.myLinks = new ArrayList<DockerLinkImpl>();
        }
        return this.myLinks;
    }

    public void setLinks(List<DockerLinkImpl> links) {
        this.myLinks = links;
    }

    @AbstractCollection
    public List<DockerVolumeBindingImpl> getVolumeBindings() {
        if (this.myVolumeBindings == null) {
            this.myVolumeBindings = new ArrayList<DockerVolumeBindingImpl>();
        }
        return this.myVolumeBindings;
    }

    public void setVolumeBindings(List<DockerVolumeBindingImpl> volumeBindings) {
        this.myVolumeBindings = volumeBindings;
    }

    @AbstractCollection
    public List<DockerEnvVarImpl> getEnvVars() {
        if (this.myEnvVars == null) {
            this.myEnvVars = new ArrayList<DockerEnvVarImpl>();
        }
        return this.myEnvVars;
    }

    public void setEnvVars(List<DockerEnvVarImpl> envVars) {
        this.myEnvVars = envVars;
    }

    public boolean isLinksExpanded() {
        return this.myLinksExpanded;
    }

    public void setLinksExpanded(boolean linksExpanded) {
        this.myLinksExpanded = linksExpanded;
    }

    public boolean isVolumeBindingsExpanded() {
        return this.myVolumeBindingsExpanded;
    }

    public void setVolumeBindingsExpanded(boolean volumeBindingsExpanded) {
        this.myVolumeBindingsExpanded = volumeBindingsExpanded;
    }

    public boolean isEnvVarsExpanded() {
        return this.myEnvVarsExpanded;
    }

    public void setEnvVarsExpanded(boolean envVarsExpanded) {
        this.myEnvVarsExpanded = envVarsExpanded;
    }

    public boolean isPortBindingsExpanded() {
        return this.myPortBindingsExpanded;
    }

    public void setPortBindingsExpanded(boolean portBindingsExpanded) {
        this.myPortBindingsExpanded = portBindingsExpanded;
    }

    private static class CheckException
    extends Exception {
        private final String myMessage;

        public CheckException(String message) {
            this.myMessage = message;
        }

        @Override
        public String getMessage() {
            return this.myMessage;
        }
    }

    private abstract class DebugConfigChecker {
        private DebugConfigChecker() {
        }

        public JsonProperty check(JsonObject root) throws CheckException {
            String port = String.valueOf(DockerDeploymentConfiguration.this.myDebugPort);
            JsonObject hostConfigValue = this.getPropertyValue(root, DockerDeploymentConfiguration.HOST_CONFIG_PROPERTY);
            JsonObject portBindingsValue = this.getPropertyValue(hostConfigValue, DockerDeploymentConfiguration.PORT_BINDINGS_PROPERTY);
            for (JsonProperty property : portBindingsValue.getPropertyList()) {
                JsonArray array = (JsonArray)ObjectUtils.tryCast((Object)property.getValue(), JsonArray.class);
                if (array == null) continue;
                for (JsonValue portBindingsArrayValue : array.getValueList()) {
                    JsonStringLiteral hostPortValue;
                    JsonProperty hostPort;
                    if (!(portBindingsArrayValue instanceof JsonObject) || (hostPort = ((JsonObject)portBindingsArrayValue).findProperty(DockerDeploymentConfiguration.HOST_PORT_PROPERTY)) == null || (hostPortValue = (JsonStringLiteral)ObjectUtils.tryCast((Object)hostPort.getValue(), JsonStringLiteral.class)) == null || !StringUtil.equals((CharSequence)port, (CharSequence)hostPortValue.getValue())) continue;
                    return property;
                }
            }
            this.createPortBinding(portBindingsValue, port);
            return null;
        }

        private JsonObject getPropertyValue(JsonObject parent, String propertyName) throws CheckException {
            JsonObject result;
            JsonProperty property = parent.findProperty(propertyName);
            if (property == null) {
                property = this.createProperty(parent, propertyName);
            }
            if ((result = (JsonObject)ObjectUtils.tryCast((Object)property.getValue(), JsonObject.class)) == null) {
                throw new CheckException("Property value is expected to be an Object: " + propertyName);
            }
            return result;
        }

        protected abstract JsonProperty createProperty(JsonObject var1, String var2) throws CheckException;

        protected abstract JsonProperty createPortBinding(JsonObject var1, String var2) throws CheckException;
    }
}

