/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker;

import com.intellij.docker.DockerCloudType;
import com.intellij.docker.deploymentSource.DockerComposeDeploymentSource;
import com.intellij.docker.deploymentSource.DockerImageDeploymentSourceType;
import com.intellij.docker.deploymentSource.DockerfileDeploymentSource;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.runtime.deployment.DeploymentLogManager;
import com.intellij.remoteServer.runtime.deployment.DeploymentTask;
import com.intellij.remoteServer.util.CloudDeploymentNameConfiguration;
import com.intellij.remoteServer.util.CloudDeploymentRuntime;
import com.intellij.remoteServer.util.CloudDeploymentRuntimeProvider;
import com.intellij.remoteServer.util.CloudMultiSourceServerRuntimeInstance;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NonNls;

public class DockerDeploymentRuntimeProvider
implements CloudDeploymentRuntimeProvider {
    @NonNls
    public static final String DOCKERFILE = "Dockerfile";

    public ServerType<?> getServerType() {
        return DockerCloudType.getInstance();
    }

    public Collection<DeploymentSource> getDeploymentSources(Project project) {
        ArrayList<DeploymentSource> result = new ArrayList<DeploymentSource>();
        result.addAll(ContainerUtil.map(DockerDeploymentRuntimeProvider.getDockerFiles(project), virtualFile -> new DockerfileDeploymentSource(project, (VirtualFile)virtualFile)));
        Collection virtualFiles = (Collection)ApplicationManager.getApplication().runReadAction(DockerDeploymentRuntimeProvider.findFilesByName(project, "docker-compose.yml", true));
        result.addAll(ContainerUtil.map((Collection)virtualFiles, virtualFile -> new DockerComposeDeploymentSource(project, (VirtualFile)virtualFile)));
        result.add(DockerImageDeploymentSourceType.getInstance().getDeploymentSource());
        return result;
    }

    public CloudDeploymentRuntime createDeploymentRuntime(DeploymentSource source, CloudMultiSourceServerRuntimeInstance serverRuntime, DeploymentTask<? extends CloudDeploymentNameConfiguration> deploymentTask, DeploymentLogManager logManager) throws ServerRuntimeException {
        throw new UnsupportedOperationException();
    }

    public static Collection<VirtualFile> getDockerFiles(Project project) {
        return DockerDeploymentRuntimeProvider.getDockerFiles(project, true);
    }

    public static Collection<VirtualFile> getDockerFiles(Project project, boolean includeLibraries) {
        return (Collection)ApplicationManager.getApplication().runReadAction(DockerDeploymentRuntimeProvider.findFilesByName(project, DOCKERFILE, includeLibraries));
    }

    private static Computable<Collection<VirtualFile>> findFilesByName(Project project, String fileName, boolean includeLibraries) {
        return () -> {
            if (project.isDisposed()) {
                return Collections.emptyList();
            }
            GlobalSearchScope scope = includeLibraries ? GlobalSearchScope.allScope((Project)project) : GlobalSearchScope.projectScope((Project)project);
            return FilenameIndex.getVirtualFilesByName((Project)project, (String)fileName, (GlobalSearchScope)scope);
        };
    }
}

