/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker;

import com.intellij.docker.DockerCloudType;
import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.DockerDeploymentRuntimeProvider;
import com.intellij.docker.DockerRunConfigurationCreator;
import com.intellij.docker.deploymentSource.DockerfileDeploymentSource;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationsConfiguration;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerConfigurationTypesRegistrar;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerRunConfiguration;
import com.intellij.remoteServer.util.CloudNotifier;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerFileDetector
extends AbstractProjectComponent {
    private final DockerCloudType myCloudType = DockerCloudType.getInstance();
    private final RunManagerEx myRunManager;
    private final CloudNotifier myNotifier;
    private final Map<VirtualFile, Notifier> myDockerFile2Notifier;
    private static final String DOCKER_GROUP_ID = "Docker: Dockerfile detection";

    public DockerFileDetector(Project project, RunManager runManager) {
        super(project);
        this.myRunManager = (RunManagerEx)runManager;
        this.myNotifier = new CloudNotifier(DOCKER_GROUP_ID);
        this.myDockerFile2Notifier = new HashMap();
    }

    public void projectOpened() {
        DumbService.getInstance((Project)this.myProject).runWhenSmart(() -> ApplicationManager.getApplication().executeOnPooledThread(this::initNotifiers));
        this.myRunManager.addRunManagerListener(new RunManagerListener(){

            public void runConfigurationAdded(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/docker/DockerFileDetector$1", "runConfigurationAdded"));
                }
                DockerFileDetector.this.onRunConfigurationAddedOrChanged(settings);
            }

            public void runConfigurationChanged(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/docker/DockerFileDetector$1", "runConfigurationChanged"));
                }
                DockerFileDetector.this.onRunConfigurationAddedOrChanged(settings);
            }
        });
        this.myProject.getMessageBus().connect().subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener.Adapter(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/docker/DockerFileDetector$2", "after"));
                }
                DockerFileDetector.this.onVfsChange(events);
            }
        });
    }

    private void initNotifiers() {
        LinkedHashSet<VirtualFile> dockerFiles = new LinkedHashSet<VirtualFile>();
        dockerFiles.addAll(DockerDeploymentRuntimeProvider.getDockerFiles(this.myProject, false));
        List runConfigurations = this.myRunManager.getConfigurationsList((ConfigurationType)DeployToServerConfigurationTypesRegistrar.getDeployConfigurationType((ServerType)this.myCloudType));
        for (RunConfiguration runConfiguration : runConfigurations) {
            VirtualFile usedDockerFile = DockerFileDetector.getDockerFile(runConfiguration);
            if (usedDockerFile == null) continue;
            dockerFiles.remove(usedDockerFile);
        }
        if (!dockerFiles.isEmpty()) {
            ApplicationManager.getApplication().invokeLater(() -> {
                Notifier notifier = new Notifier(new ArrayList<VirtualFile>(dockerFiles));
                for (VirtualFile dockerFile : dockerFiles) {
                    this.myDockerFile2Notifier.put(dockerFile, notifier);
                }
            });
        }
    }

    private void onRunConfigurationAddedOrChanged(RunnerAndConfigurationSettings settings) {
        VirtualFile usedDockerFile = DockerFileDetector.getDockerFile(settings.getConfiguration());
        if (usedDockerFile == null) {
            return;
        }
        this.forget(usedDockerFile);
    }

    private void forget(VirtualFile dockerFile) {
        Notifier notifier = this.myDockerFile2Notifier.remove(dockerFile);
        if (notifier != null) {
            notifier.expire();
        }
    }

    private void onVfsChange(List<? extends VFileEvent> events) {
        for (VFileEvent vFileEvent : events) {
            VirtualFile file = DockerFileDetector.getAffectedFile(vFileEvent);
            if (file == null) continue;
            if (StringUtil.equals((CharSequence)file.getName(), (CharSequence)"Dockerfile")) {
                this.dockerFileChanged(file, vFileEvent);
                continue;
            }
            this.forget(file);
        }
    }

    @Nullable
    private static VirtualFile getAffectedFile(@NotNull VFileEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/docker/DockerFileDetector", "getAffectedFile"));
        }
        if (event instanceof VFileCreateEvent || event instanceof VFileDeleteEvent || event instanceof VFileMoveEvent || DockerFileDetector.isRename(event)) {
            return event.getFile();
        }
        if (event instanceof VFileCopyEvent) {
            VFileCopyEvent copyEvent = (VFileCopyEvent)event;
            return copyEvent.getNewParent().findChild(copyEvent.getNewChildName());
        }
        return null;
    }

    private static boolean isRename(@NotNull VFileEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/docker/DockerFileDetector", "isRename"));
        }
        return event instanceof VFilePropertyChangeEvent && ((VFilePropertyChangeEvent)event).getPropertyName().equals("name");
    }

    private void dockerFileChanged(VirtualFile dockerFile, VFileEvent event) {
        if (event instanceof VFileDeleteEvent) {
            this.forget(dockerFile);
        } else if (!this.myDockerFile2Notifier.containsKey(dockerFile)) {
            this.myDockerFile2Notifier.put(dockerFile, new Notifier(Collections.singletonList(dockerFile)));
        }
    }

    private static VirtualFile getDockerFile(RunConfiguration runConfiguration) {
        if (!(runConfiguration instanceof DeployToServerRunConfiguration)) {
            return null;
        }
        DeployToServerRunConfiguration deployRunConfiguration = (DeployToServerRunConfiguration)runConfiguration;
        DeploymentSource deploymentSource = deployRunConfiguration.getDeploymentSource();
        if (!(deploymentSource instanceof DockerfileDeploymentSource)) {
            return null;
        }
        File file = deploymentSource.getFile();
        return file == null ? null : VfsUtil.findFileByIoFile((File)file, (boolean)true);
    }

    private class Notifier {
        private static final String DISABLE_DOCKER_HREF = "disable";
        private final Notification myNotification;
        private final Collection<VirtualFile> myDockerFiles;

        public Notifier(Collection<VirtualFile> dockerFiles) {
            this.myDockerFiles = dockerFiles;
            StringBuilder content = new StringBuilder(DockerBundle.getText("dockerfile.detected.title", new Object[0]));
            for (VirtualFile virtualFile : dockerFiles) {
                content.append(DockerBundle.getText("dockerfile.detected.file", FileUtil.toSystemDependentName((String)virtualFile.getPath())));
            }
            content.append(DockerBundle.getText("dockerfile.disable.detection", DISABLE_DOCKER_HREF));
            this.myNotification = DockerFileDetector.this.myNotifier.showMessage(content.toString(), MessageType.INFO, new NotificationListener(){

                public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                    if (notification == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/docker/DockerFileDetector$Notifier$1", "hyperlinkUpdate"));
                    }
                    if (event == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/docker/DockerFileDetector$Notifier$1", "hyperlinkUpdate"));
                    }
                    String eventDescription = event.getDescription();
                    if (eventDescription.equals(Notifier.DISABLE_DOCKER_HREF)) {
                        Notifier.this.disableNotifications();
                    } else {
                        Notifier.this.setupRunConfiguration(eventDescription);
                    }
                }
            });
        }

        public void expire() {
            if (this.myDockerFiles.size() == 1) {
                this.myNotification.expire();
            }
        }

        public void setupRunConfiguration(String dockerFilePath) {
            VirtualFile dockerFile = LocalFileSystem.getInstance().findFileByPath(dockerFilePath);
            if (dockerFile == null) {
                return;
            }
            DockerfileDeploymentSource deploymentSource = new DockerfileDeploymentSource(DockerFileDetector.this.myProject, dockerFile);
            DockerDeploymentConfiguration deploymentConfiguration = (DockerDeploymentConfiguration)DockerFileDetector.this.myCloudType.createDeploymentConfigurator(DockerFileDetector.this.myProject).createDefaultConfiguration((DeploymentSource)deploymentSource);
            RemoteServer server = (RemoteServer)ContainerUtil.getFirstItem((List)RemoteServersManager.getInstance().getServers((ServerType)DockerFileDetector.this.myCloudType));
            new DockerRunConfigurationCreator(DockerFileDetector.this.myProject).createRunConfiguration(deploymentSource, deploymentConfiguration, server, null);
        }

        public void disableNotifications() {
            NotificationGroup group = NotificationGroup.findRegisteredGroup((String)this.myNotification.getGroupId());
            NotificationsConfiguration notificationsConfiguration = NotificationsConfiguration.getNotificationsConfiguration();
            if (group != null) {
                notificationsConfiguration.changeSettings(group.getDisplayId(), NotificationDisplayType.NONE, false, false);
            }
            this.myNotification.expire();
        }
    }
}

