/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.action;

import com.intellij.docker.DockerApplicationRuntime;
import com.intellij.docker.action.ImageActionBase;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.remoteServer.impl.runtime.ui.ServersToolWindowContent;
import com.intellij.remoteServer.impl.runtime.ui.tree.DeploymentNode;
import icons.DockerIcons;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class DeleteImageAction
extends ImageActionBase {
    public DeleteImageAction() {
        super("Delete image", "Delete the selected image(s)", DockerIcons.DeleteImage);
    }

    protected boolean isMultiSelectionAllowed() {
        return true;
    }

    protected void doActionPerformed(@NotNull ServersToolWindowContent content, AnActionEvent e, List<DeploymentNode> nodes) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/docker/action/DeleteImageAction", "doActionPerformed"));
        }
        if (Messages.showYesNoDialog((Project)null, (String)"Are you sure to delete image(s)?", (String)"Delete Image", (Icon)Messages.getWarningIcon()) != 0) {
            return;
        }
        super.doActionPerformed(content, e, nodes);
    }

    protected void doActionPerformed(DeploymentNode node) {
        DockerApplicationRuntime applicationRuntime = (DockerApplicationRuntime)this.getApplicationRuntime(node);
        if (applicationRuntime != null) {
            applicationRuntime.deleteImage();
        }
    }
}

