/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.action;

import com.intellij.docker.DockerServerRuntimeInstance;
import com.intellij.docker.action.FilterActionTreeDelegate;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class FilterActionBase
extends ToggleAction {
    private FilterActionTreeDelegate myTreeDelegate;
    private final String myInitialText;
    private final String mySelectedText;

    public FilterActionBase(String initialText, String selectedText, String actionDescription, Icon icon, Class<? extends DockerServerRuntimeInstance.ApplicationGroupRuntime> groupRuntimeClass) {
        super(initialText, actionDescription, icon);
        this.mySelectedText = selectedText;
        this.myInitialText = initialText;
        this.myTreeDelegate = new FilterActionTreeDelegate(groupRuntimeClass);
    }

    public void setSelected(AnActionEvent e, boolean state) {
        this.myTreeDelegate.actionPerformed(e);
        this.doSetSelected(state);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/docker/action/FilterActionBase", "update"));
        }
        super.update(e);
        this.myTreeDelegate.update(e);
        if (!this.mySelectedText.equals(this.myInitialText)) {
            Presentation presentation = e.getPresentation();
            boolean selected = presentation.getClientProperty("selected") == Boolean.TRUE;
            presentation.setText(selected ? this.mySelectedText : this.myInitialText);
        }
    }

    public abstract void doSetSelected(boolean var1);
}

