/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.dockerFile.highlighting.highlight;

import com.intellij.docker.dockerFile.highlighting.highlight.DockerSyntaxHighlighterColors;
import com.intellij.docker.dockerFile.parser.psi.DockerPsiNameDeclaration;
import com.intellij.docker.dockerFile.parser.psi.DockerPsiNameReference;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

public class DockerColorAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/docker/dockerFile/highlighting/highlight/DockerColorAnnotator", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/docker/dockerFile/highlighting/highlight/DockerColorAnnotator", "annotate"));
        }
        if (element instanceof DockerPsiNameReference) {
            DockerColorAnnotator.annotatePsiNameReference((DockerPsiNameReference)element, holder);
        } else if (element instanceof DockerPsiNameDeclaration) {
            DockerColorAnnotator.annotatePsiNameDeclaration((DockerPsiNameDeclaration)element, holder);
        }
    }

    private static void annotatePsiNameReference(@NotNull DockerPsiNameReference reference, @NotNull AnnotationHolder holder) {
        Annotation annotation;
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/docker/dockerFile/highlighting/highlight/DockerColorAnnotator", "annotatePsiNameReference"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/docker/dockerFile/highlighting/highlight/DockerColorAnnotator", "annotatePsiNameReference"));
        }
        PsiElement referencedName = reference.getReferencedName();
        if (referencedName == null) {
            return;
        }
        if (reference.resolve() == null) {
            String warning = DockerBundle.getText("DockerColorAnnotator.unresolvedRef", referencedName.getText());
            annotation = holder.createWeakWarningAnnotation(referencedName, warning);
        } else {
            annotation = holder.createInfoAnnotation(referencedName.getTextRange(), null);
        }
        annotation.setTextAttributes(DockerSyntaxHighlighterColors.VARIABLE);
    }

    private static void annotatePsiNameDeclaration(@NotNull DockerPsiNameDeclaration declaration, @NotNull AnnotationHolder holder) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/intellij/docker/dockerFile/highlighting/highlight/DockerColorAnnotator", "annotatePsiNameDeclaration"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/docker/dockerFile/highlighting/highlight/DockerColorAnnotator", "annotatePsiNameDeclaration"));
        }
        holder.createInfoAnnotation(declaration.getDeclaredName(), null).setTextAttributes(DockerSyntaxHighlighterColors.VARIABLE);
    }
}

