/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.machine;

import com.intellij.docker.machine.DockerConnectionInfo;
import com.intellij.docker.machine.DockerMachineCommandException;
import com.intellij.docker.machine.DockerMachineException;
import com.intellij.docker.machine.DockerMachineNotStartedException;
import com.intellij.docker.machine.DockerMachineSettings;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerMachine {
    private static final Logger LOG = Logger.getInstance(DockerMachine.class);
    private static final Pattern EXPORT_ENV_PATTERN = Pattern.compile("\\s*export\\s+([^=]+)=\"(.*)\"");
    private static final String DOCKER_TLS_VERIFY = "DOCKER_TLS_VERIFY";
    private static final String DOCKER_HOST = "DOCKER_HOST";
    private static final String DOCKER_CERT_PATH = "DOCKER_CERT_PATH";
    private static final Set<String> DOCKER_OTHER_ENV_VARIABLES = Collections.singleton("DOCKER_MACHINE_NAME");
    private static final String PROTOCOL_QUALIFIER = "://";
    private static final String UNIX_FILE_SOCKET_PROTOCOL = "unix";
    private static final String ENV_COMMAND = "env";
    private static final String ENV_OPTION_SHELL = "--shell";
    public static final String BASH = "bash";
    private static final String LS_COMMAND = "ls";
    private static final String LS_OPTION_QUIET = "--quiet";
    private static final String IP_COMMAND = "ip";
    private static final String STATUS_COMMAND = "status";
    private static final String START_COMMAND = "start";
    private static final String VERSION_COMMAND = "--version";
    private static final int DEFAULT_TIMEOUT_IN_MILLIS_FOR_DOCKER_MACHINE = 30000;
    private static final int TIMEOUT_IN_MILLIS_FOR_START_COMMAND = 60000;
    private static final int TIMEOUT_IN_MILLIS_FOR_VERSION_COMMAND = 500;
    @NotNull
    private final String myDockerMachinePath;

    public static boolean hasDockerMachine() {
        return true;
    }

    public DockerMachine(@NotNull String dockerMachinePath) {
        if (dockerMachinePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dockerMachinePath", "com/intellij/docker/machine/DockerMachine", "<init>"));
        }
        this.myDockerMachinePath = dockerMachinePath;
    }

    @NotNull
    public static DockerMachine getDockerMachine(@NotNull String dockerMachinePath) {
        if (dockerMachinePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dockerMachinePath", "com/intellij/docker/machine/DockerMachine", "getDockerMachine"));
        }
        DockerMachine dockerMachine = new DockerMachine(dockerMachinePath);
        if (dockerMachine == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/machine/DockerMachine", "getDockerMachine"));
        }
        return dockerMachine;
    }

    @NotNull
    public static DockerMachine currentDockerMachine() {
        if (!DockerMachine.hasDockerMachine()) {
            throw new IllegalStateException();
        }
        DockerMachine dockerMachine = DockerMachine.getDockerMachine(DockerMachineSettings.getInstance().getDockerMachinePath());
        if (dockerMachine == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/machine/DockerMachine", "currentDockerMachine"));
        }
        return dockerMachine;
    }

    @NotNull
    public String getDockerMachinePath() {
        String string = this.myDockerMachinePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/machine/DockerMachine", "getDockerMachinePath"));
        }
        return string;
    }

    @NotNull
    private ProcessOutput exec(@Nullable String machineName, @NotNull String[] command) throws DockerMachineException {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/docker/machine/DockerMachine", "exec"));
        }
        ProcessOutput processOutput = this.exec(machineName, command, 30000, false);
        if (processOutput == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/machine/DockerMachine", "exec"));
        }
        return processOutput;
    }

    @NotNull
    private ProcessOutput exec(@Nullable String machineName, @NotNull String[] command, int timeoutInMillis, boolean cancellable) throws DockerMachineException {
        ProcessOutput processOutput;
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/docker/machine/DockerMachine", "exec"));
        }
        GeneralCommandLine commandLine = new GeneralCommandLine((String[])ArrayUtil.prepend((Object)this.myDockerMachinePath, (Object[])command));
        try {
            CapturingProcessHandler handler = new CapturingProcessHandler(commandLine);
            ProcessOutput output = cancellable && ProgressManager.getInstance().hasProgressIndicator() ? handler.runProcessWithProgressIndicator(ProgressManager.getInstance().getProgressIndicator()) : handler.runProcess(timeoutInMillis);
            if (output.isTimeout()) {
                throw new DockerMachineException("Timeout exceeded");
            }
            if (output.getExitCode() != 0) {
                if (machineName != null && DockerMachine.isDockerMachineNotStartedReason(output)) {
                    throw new DockerMachineNotStartedException(machineName, output.getExitCode(), output.getStderr());
                }
                throw new DockerMachineCommandException(output.getExitCode(), output.getStderr());
            }
            processOutput = output;
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new DockerMachineException(e.getMessage(), e);
        }
        if (processOutput == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/machine/DockerMachine", "exec"));
        }
        return processOutput;
    }

    private static boolean isDockerMachineNotStartedReason(@NotNull ProcessOutput output) {
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "output", "com/intellij/docker/machine/DockerMachine", "isDockerMachineNotStartedReason"));
        }
        return output.getStderr().contains(" is not running");
    }

    @NotNull
    public static DockerConnectionInfo parseStdout(@NotNull String stdout) {
        String urlProtocol;
        if (stdout == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stdout", "com/intellij/docker/machine/DockerMachine", "parseStdout"));
        }
        Scanner scanner = new Scanner(stdout);
        Boolean tls = null;
        String dockerHost = null;
        String dockerCertPath = null;
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine().trim();
            Pair<String, String> nameValue = DockerMachine.getExport(line);
            if (nameValue == null) continue;
            String name = (String)nameValue.first;
            String value = (String)nameValue.second;
            if (DOCKER_TLS_VERIFY.equals(name)) {
                tls = "1".equals(value);
                continue;
            }
            if (DOCKER_CERT_PATH.equals(name)) {
                dockerCertPath = value;
                continue;
            }
            if (DOCKER_HOST.equals(name)) {
                dockerHost = value;
                continue;
            }
            if (DOCKER_OTHER_ENV_VARIABLES.contains(name)) continue;
            LOG.debug("Docker Machine returned unknown environment variable: " + name + "=" + value);
        }
        if (dockerHost == null) {
            throw new IllegalStateException("DOCKER_HOST is not specified");
        }
        Pair<String, String> protocolAndHost = DockerMachine.splitToProtocolAndHost(dockerHost);
        String urlHost = (String)protocolAndHost.second;
        if (UNIX_FILE_SOCKET_PROTOCOL.equals(protocolAndHost.first)) {
            urlProtocol = UNIX_FILE_SOCKET_PROTOCOL;
            dockerCertPath = null;
        } else if (tls != null) {
            urlProtocol = tls != false ? "https" : "http";
        } else if (dockerCertPath == null) {
            LOG.info("Both DOCKER_TLS_VERIFY and DOCKER_CERT_PATH are not specified, TLS verification disabled");
            urlProtocol = "http";
        } else {
            LOG.info("DOCKER_TLS_VERIFY is not specified, TLS verification enabled");
            urlProtocol = "https";
        }
        String url = urlProtocol + PROTOCOL_QUALIFIER + urlHost;
        DockerConnectionInfo dockerConnectionInfo = new DockerConnectionInfo(url, dockerCertPath);
        if (dockerConnectionInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/machine/DockerMachine", "parseStdout"));
        }
        return dockerConnectionInfo;
    }

    @NotNull
    private static Pair<String, String> splitToProtocolAndHost(@NotNull String dockerHost) {
        if (dockerHost == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dockerHost", "com/intellij/docker/machine/DockerMachine", "splitToProtocolAndHost"));
        }
        int i = dockerHost.indexOf(PROTOCOL_QUALIFIER);
        if (i != -1) {
            String protocol = dockerHost.substring(0, i);
            String host = dockerHost.substring(i + PROTOCOL_QUALIFIER.length());
            Pair pair = Pair.create((Object)protocol, (Object)host);
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/machine/DockerMachine", "splitToProtocolAndHost"));
            }
            return pair;
        }
        LOG.info("DOCKER_HOST is expected to contain protocol prefix but has nothing: " + dockerHost);
        Pair pair = Pair.create(null, (Object)dockerHost);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/machine/DockerMachine", "splitToProtocolAndHost"));
        }
        return pair;
    }

    @Nullable
    private static Pair<String, String> getExport(@NotNull String line) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/docker/machine/DockerMachine", "getExport"));
        }
        Matcher matcher = EXPORT_ENV_PATTERN.matcher(line);
        if (matcher.matches()) {
            return Pair.create((Object)matcher.group(1), (Object)matcher.group(2));
        }
        return null;
    }

    @NotNull
    public List<String> ls() throws DockerMachineException {
        List list = this.exec(null, new String[]{LS_COMMAND, LS_OPTION_QUIET}).getStdoutLines();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/machine/DockerMachine", LS_COMMAND));
        }
        return list;
    }

    @NotNull
    public DockerConnectionInfo env(@NotNull String shell, @NotNull String machineName) throws DockerMachineException {
        if (shell == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shell", "com/intellij/docker/machine/DockerMachine", ENV_COMMAND));
        }
        if (machineName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "machineName", "com/intellij/docker/machine/DockerMachine", ENV_COMMAND));
        }
        DockerConnectionInfo dockerConnectionInfo = DockerMachine.parseStdout(this.exec(machineName, new String[]{ENV_COMMAND, ENV_OPTION_SHELL, shell, machineName}).getStdout());
        if (dockerConnectionInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/machine/DockerMachine", ENV_COMMAND));
        }
        return dockerConnectionInfo;
    }

    @NotNull
    public String getMachineIp(@NotNull String machineName) {
        if (machineName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "machineName", "com/intellij/docker/machine/DockerMachine", "getMachineIp"));
        }
        ProcessOutput output = this.exec(machineName, new String[]{IP_COMMAND, machineName});
        String string = output.getStdout().trim();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/machine/DockerMachine", "getMachineIp"));
        }
        return string;
    }

    @NotNull
    public DockerConnectionInfo getDockerConnectionInfo(@NotNull String machineName) {
        if (machineName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "machineName", "com/intellij/docker/machine/DockerMachine", "getDockerConnectionInfo"));
        }
        if (StringUtil.isEmpty((String)machineName)) {
            throw new IllegalArgumentException("Docker machine name must be provided");
        }
        DockerConnectionInfo dockerConnectionInfo = this.env(BASH, machineName);
        if (dockerConnectionInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/machine/DockerMachine", "getDockerConnectionInfo"));
        }
        return dockerConnectionInfo;
    }

    @Nullable
    public String statusFor(@NotNull String machineName) {
        if (machineName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "machineName", "com/intellij/docker/machine/DockerMachine", "statusFor"));
        }
        String status = this.exec(machineName, new String[]{STATUS_COMMAND, machineName}).getStdout().trim();
        return StringUtil.nullize((String)status);
    }

    @NotNull
    public String version() {
        String string = this.exec(null, new String[]{VERSION_COMMAND}, 500, false).getStdout();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/machine/DockerMachine", "version"));
        }
        return string;
    }

    public void start(@NotNull String machineName) {
        if (machineName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "machineName", "com/intellij/docker/machine/DockerMachine", START_COMMAND));
        }
        this.exec(machineName, new String[]{START_COMMAND, machineName}, 60000, true);
    }
}

