/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.machine;

import com.intellij.docker.machine.DockerMachineCommandException;
import com.intellij.docker.machine.DockerMachineUtil;
import com.intellij.remote.ExceptionFix;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerMachineNotStartedException
extends DockerMachineCommandException
implements ExceptionFix {
    @NotNull
    private final String myMachineName;

    public DockerMachineNotStartedException(@NotNull String machineName, int exitCode, @Nullable String stderr) {
        if (machineName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "machineName", "com/intellij/docker/machine/DockerMachineNotStartedException", "<init>"));
        }
        super(exitCode, stderr);
        this.myMachineName = machineName;
    }

    @NotNull
    public String getMachineName() {
        String string = this.myMachineName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/machine/DockerMachineNotStartedException", "getMachineName"));
        }
        return string;
    }

    public void apply() {
        DockerMachineUtil.startMachineWithProgressIndicator(null, this.myMachineName);
    }

    public String getNotificationMessage(String message) {
        return message + "\n<a href=\"#\">Start Docker Machine '" + this.myMachineName + "' and refresh skeletons</a>";
    }
}

