/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.machine;

import com.intellij.docker.machine.DockerMachineUtil;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="DockerSettings", storages={@Storage(value="docker.xml")})
public class DockerMachineSettings
implements PersistentStateComponent<DockerMachineSettings> {
    private String myDockerMachinePath;

    @NotNull
    public static DockerMachineSettings getInstance() {
        DockerMachineSettings dockerMachineSettings = (DockerMachineSettings)ServiceManager.getService(DockerMachineSettings.class);
        if (dockerMachineSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/machine/DockerMachineSettings", "getInstance"));
        }
        return dockerMachineSettings;
    }

    @Nullable
    public DockerMachineSettings getState() {
        return this;
    }

    public void loadState(DockerMachineSettings state) {
        if (!StringUtil.isEmpty((String)state.getDockerMachinePath())) {
            this.setDockerMachinePath(state.getDockerMachinePath());
        }
    }

    public String getDockerMachinePath() {
        if (this.myDockerMachinePath == null) {
            this.myDockerMachinePath = (String)DockerMachineUtil.tryFindDockerMachineExecutable().or((Object)DockerMachineUtil.getDefaultDockerMachineExecutable());
        }
        return this.myDockerMachinePath;
    }

    public void setDockerMachinePath(String dockerMachinePath) {
        this.myDockerMachinePath = dockerMachinePath;
    }
}

